/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket.tls;

import java.lang.reflect.Constructor;
import java.util.function.BiFunction;
import org.mockserver.configuration.Configuration;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.KeyAndCertificateFactory;
import org.mockserver.socket.tls.bouncycastle.BCKeyAndCertificateFactory;

public class KeyAndCertificateFactoryFactory {
    private static BiFunction<MockServerLogger, Boolean, KeyAndCertificateFactory> customKeyAndCertificateFactorySupplier = null;
    private static final ClassLoader CLASS_LOADER = KeyAndCertificateFactoryFactory.class.getClassLoader();

    public static KeyAndCertificateFactory createKeyAndCertificateFactory(Configuration configuration, MockServerLogger mockServerLogger) {
        return KeyAndCertificateFactoryFactory.createKeyAndCertificateFactory(configuration, mockServerLogger, true);
    }

    public static KeyAndCertificateFactory createKeyAndCertificateFactory(Configuration configuration, MockServerLogger mockServerLogger, boolean forServer) {
        if (customKeyAndCertificateFactorySupplier != null) {
            return customKeyAndCertificateFactorySupplier.apply(mockServerLogger, forServer);
        }
        return new BCKeyAndCertificateFactory(configuration, mockServerLogger);
    }

    private static boolean canNotLoadSunSecurityPackages() {
        Object derValue = null;
        Object x500Name = null;
        try {
            Class<?> derValueClass = CLASS_LOADER.loadClass("sun.security.util.DerValue");
            Constructor<?> derValueConstructor = derValueClass.getDeclaredConstructor(Byte.TYPE, String.class);
            derValue = derValueConstructor.newInstance((byte)22, "www.mockserver.com");
            Class<?> x500NameClass = CLASS_LOADER.loadClass("sun.security.x509.X500Name");
            Constructor<?> x500NameConstructor = x500NameClass.getDeclaredConstructor(String.class);
            x500Name = x500NameConstructor.newInstance("C=UK, ST=England, L=London, O=MockServer, CN=www.mockserver.com");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return derValue == null || x500Name == null;
    }

    private static boolean canNotLoadBouncyCastleClasses() {
        Class<?> bouncyCastleProvider = null;
        Class<?> bouncyCastleX509Holder = null;
        try {
            bouncyCastleProvider = CLASS_LOADER.loadClass("org.bouncycastle.jce.provider.BouncyCastleProvider");
            bouncyCastleX509Holder = CLASS_LOADER.loadClass("org.bouncycastle.cert.X509CertificateHolder");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bouncyCastleProvider == null || bouncyCastleX509Holder == null;
    }

    public static BiFunction<MockServerLogger, Boolean, KeyAndCertificateFactory> getCustomKeyAndCertificateFactorySupplier() {
        return customKeyAndCertificateFactorySupplier;
    }

    public static void setCustomKeyAndCertificateFactorySupplier(BiFunction<MockServerLogger, Boolean, KeyAndCertificateFactory> customKeyAndCertificateFactorySupplier) {
        KeyAndCertificateFactoryFactory.customKeyAndCertificateFactorySupplier = customKeyAndCertificateFactorySupplier;
    }
}

