/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.serializers.request;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.serialization.model.HttpRequestDTO;

public class HttpRequestDTOSerializer
extends StdSerializer<HttpRequestDTO> {
    public HttpRequestDTOSerializer() {
        super(HttpRequestDTO.class);
    }

    public void serialize(HttpRequestDTO httpRequest, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (httpRequest.getNot() != null && httpRequest.getNot().booleanValue()) {
            jgen.writeBooleanField("not", httpRequest.getNot().booleanValue());
        }
        if (httpRequest.getMethod() != null && StringUtils.isNotBlank((CharSequence)httpRequest.getMethod().getValue())) {
            jgen.writeObjectField("method", (Object)httpRequest.getMethod());
        }
        if (httpRequest.getPath() != null && StringUtils.isNotBlank((CharSequence)httpRequest.getPath().getValue())) {
            jgen.writeObjectField("path", (Object)httpRequest.getPath());
        }
        if (httpRequest.getPathParameters() != null && !httpRequest.getPathParameters().isEmpty()) {
            jgen.writeObjectField("pathParameters", (Object)httpRequest.getPathParameters());
        }
        if (httpRequest.getQueryStringParameters() != null && !httpRequest.getQueryStringParameters().isEmpty()) {
            jgen.writeObjectField("queryStringParameters", (Object)httpRequest.getQueryStringParameters());
        }
        if (httpRequest.getHeaders() != null && !httpRequest.getHeaders().isEmpty()) {
            jgen.writeObjectField("headers", (Object)httpRequest.getHeaders());
        }
        if (httpRequest.getCookies() != null && !httpRequest.getCookies().isEmpty()) {
            jgen.writeObjectField("cookies", (Object)httpRequest.getCookies());
        }
        if (httpRequest.getKeepAlive() != null) {
            jgen.writeBooleanField("keepAlive", httpRequest.getKeepAlive().booleanValue());
        }
        if (httpRequest.getSecure() != null) {
            jgen.writeBooleanField("secure", httpRequest.getSecure().booleanValue());
        }
        if (httpRequest.getClientCertificateChain() != null && !httpRequest.getClientCertificateChain().isEmpty()) {
            jgen.writeObjectField("clientCertificateChain", httpRequest.getClientCertificateChain());
        }
        if (httpRequest.getSocketAddress() != null) {
            jgen.writeObjectField("socketAddress", (Object)httpRequest.getSocketAddress());
        }
        if (StringUtils.isNotBlank((CharSequence)httpRequest.getLocalAddress())) {
            jgen.writeObjectField("localAddress", (Object)httpRequest.getLocalAddress());
        }
        if (StringUtils.isNotBlank((CharSequence)httpRequest.getRemoteAddress())) {
            jgen.writeObjectField("remoteAddress", (Object)httpRequest.getRemoteAddress());
        }
        if (httpRequest.getBody() != null) {
            jgen.writeObjectField("body", (Object)httpRequest.getBody());
        }
        jgen.writeEndObject();
    }
}

