/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.configuration;

import com.google.common.collect.Sets;
import com.google.common.net.InetAddresses;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.socket.tls.ForwardProxyTLSX509CertificatesTrustManager;
import org.slf4j.event.Level;

public class Configuration {
    private Level logLevel;
    private Boolean disableSystemOut;
    private Boolean disableLogging;
    private Boolean detailedMatchFailures;
    private Boolean launchUIForLogLevelDebug;
    private Boolean metricsEnabled;
    private Integer maxExpectations;
    private Integer maxLogEntries;
    private Integer maxWebSocketExpectations;
    private Boolean outputMemoryUsageCsv;
    private String memoryUsageCsvDirectory;
    private Integer nioEventLoopThreadCount;
    private Integer actionHandlerThreadCount;
    private Integer clientNioEventLoopThreadCount;
    private Integer webSocketClientEventLoopThreadCount;
    private Long maxFutureTimeoutInMillis;
    private Boolean matchersFailFast;
    private Long maxSocketTimeoutInMillis;
    private Long socketConnectionTimeoutInMillis;
    private Boolean alwaysCloseSocketConnections;
    private String localBoundIP;
    private Integer maxInitialLineLength;
    private Integer maxHeaderSize;
    private Integer maxChunkSize;
    private Boolean useSemicolonAsQueryParameterSeparator;
    private Boolean assumeAllRequestsAreHttp;
    private Boolean enableCORSForAPI;
    private Boolean enableCORSForAllResponses;
    private String corsAllowOrigin;
    private String corsAllowMethods;
    private String corsAllowHeaders;
    private Boolean corsAllowCredentials;
    private Integer corsMaxAgeInSeconds;
    private String initializationClass;
    private String initializationJsonPath;
    private Boolean watchInitializationJson;
    private Boolean persistExpectations;
    private String persistedExpectationsPath;
    private Integer maximumNumberOfRequestToReturnInVerificationFailure;
    private Boolean attemptToProxyIfNoMatchingExpectation;
    private InetSocketAddress forwardHttpProxy;
    private InetSocketAddress forwardHttpsProxy;
    private InetSocketAddress forwardSocksProxy;
    private String forwardProxyAuthenticationUsername;
    private String forwardProxyAuthenticationPassword;
    private String proxyAuthenticationRealm;
    private String proxyAuthenticationUsername;
    private String proxyAuthenticationPassword;
    private String livenessHttpGetPath;
    private Boolean controlPlaneTLSMutualAuthenticationRequired;
    private String controlPlaneTLSMutualAuthenticationCAChain;
    private String controlPlanePrivateKeyPath;
    private String controlPlaneX509CertificatePath;
    private Boolean controlPlaneJWTAuthenticationRequired;
    private String controlPlaneJWTAuthenticationJWKSource;
    private String controlPlaneJWTAuthenticationExpectedAudience;
    private Map<String, String> controlPlaneJWTAuthenticationMatchingClaims;
    private Set<String> controlPlaneJWTAuthenticationRequiredClaims;
    private Boolean proactivelyInitialiseTLS;
    private boolean rebuildTLSContext;
    private boolean rebuildServerTLSContext;
    private Boolean dynamicallyCreateCertificateAuthorityCertificate;
    private String directoryToSaveDynamicSSLCertificate;
    private Boolean preventCertificateDynamicUpdate;
    private String sslCertificateDomainName;
    private Set<String> sslSubjectAlternativeNameDomains;
    private Set<String> sslSubjectAlternativeNameIps;
    private String certificateAuthorityPrivateKey;
    private String certificateAuthorityCertificate;
    private String privateKeyPath;
    private String x509CertificatePath;
    private Boolean tlsMutualAuthenticationRequired;
    private String tlsMutualAuthenticationCertificateChain;
    private ForwardProxyTLSX509CertificatesTrustManager forwardProxyTLSX509CertificatesTrustManagerType;
    private String forwardProxyTLSCustomTrustX509Certificates;
    private String forwardProxyPrivateKey;
    private String forwardProxyCertificateChain;

    public static Configuration configuration() {
        return new Configuration();
    }

    public Level logLevel() {
        if (this.logLevel == null) {
            return ConfigurationProperties.logLevel();
        }
        return this.logLevel;
    }

    public Configuration logLevel(Level level) {
        this.logLevel = level;
        ConfigurationProperties.logLevel(this.logLevel.name());
        return this;
    }

    public Configuration logLevel(String level) {
        this.logLevel = Level.valueOf((String)level);
        ConfigurationProperties.logLevel(this.logLevel.name());
        return this;
    }

    public Boolean disableSystemOut() {
        if (this.disableSystemOut == null) {
            return ConfigurationProperties.disableSystemOut();
        }
        return this.disableSystemOut;
    }

    public Configuration disableSystemOut(Boolean disableSystemOut) {
        this.disableSystemOut = disableSystemOut;
        return this;
    }

    public Boolean disableLogging() {
        if (this.disableLogging == null) {
            return ConfigurationProperties.disableLogging();
        }
        return this.disableLogging;
    }

    public Configuration disableLogging(Boolean disableLogging) {
        this.disableLogging = disableLogging;
        return this;
    }

    public Boolean detailedMatchFailures() {
        if (this.detailedMatchFailures == null) {
            return ConfigurationProperties.detailedMatchFailures();
        }
        return this.detailedMatchFailures;
    }

    public Configuration detailedMatchFailures(Boolean detailedMatchFailures) {
        this.detailedMatchFailures = detailedMatchFailures;
        return this;
    }

    public Boolean launchUIForLogLevelDebug() {
        if (this.launchUIForLogLevelDebug == null) {
            return ConfigurationProperties.launchUIForLogLevelDebug();
        }
        return this.launchUIForLogLevelDebug;
    }

    public Configuration launchUIForLogLevelDebug(Boolean launchUIForLogLevelDebug) {
        this.launchUIForLogLevelDebug = launchUIForLogLevelDebug;
        return this;
    }

    public Boolean metricsEnabled() {
        if (this.metricsEnabled == null) {
            return ConfigurationProperties.metricsEnabled();
        }
        return this.metricsEnabled;
    }

    public Configuration metricsEnabled(Boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
        return this;
    }

    public Integer maxExpectations() {
        if (this.maxExpectations == null) {
            return ConfigurationProperties.maxExpectations();
        }
        return this.maxExpectations;
    }

    public Configuration maxExpectations(Integer maxExpectations) {
        this.maxExpectations = maxExpectations;
        return this;
    }

    public Integer maxLogEntries() {
        if (this.maxLogEntries == null) {
            return ConfigurationProperties.maxLogEntries();
        }
        return this.maxLogEntries;
    }

    public Configuration maxLogEntries(Integer maxLogEntries) {
        this.maxLogEntries = maxLogEntries;
        return this;
    }

    public Integer maxWebSocketExpectations() {
        if (this.maxWebSocketExpectations == null) {
            return ConfigurationProperties.maxWebSocketExpectations();
        }
        return this.maxWebSocketExpectations;
    }

    public Configuration maxWebSocketExpectations(Integer maxWebSocketExpectations) {
        this.maxWebSocketExpectations = maxWebSocketExpectations;
        return this;
    }

    public Boolean outputMemoryUsageCsv() {
        if (this.outputMemoryUsageCsv == null) {
            return ConfigurationProperties.outputMemoryUsageCsv();
        }
        return this.outputMemoryUsageCsv;
    }

    public Configuration outputMemoryUsageCsv(Boolean outputMemoryUsageCsv) {
        this.outputMemoryUsageCsv = outputMemoryUsageCsv;
        return this;
    }

    public String memoryUsageCsvDirectory() {
        if (this.memoryUsageCsvDirectory == null) {
            return ConfigurationProperties.memoryUsageCsvDirectory();
        }
        return this.memoryUsageCsvDirectory;
    }

    public Configuration memoryUsageCsvDirectory(String memoryUsageCsvDirectory) {
        this.memoryUsageCsvDirectory = memoryUsageCsvDirectory;
        return this;
    }

    public Integer nioEventLoopThreadCount() {
        if (this.nioEventLoopThreadCount == null) {
            return ConfigurationProperties.nioEventLoopThreadCount();
        }
        return this.nioEventLoopThreadCount;
    }

    public Configuration nioEventLoopThreadCount(Integer nioEventLoopThreadCount) {
        this.nioEventLoopThreadCount = nioEventLoopThreadCount;
        return this;
    }

    public Integer actionHandlerThreadCount() {
        if (this.actionHandlerThreadCount == null) {
            return ConfigurationProperties.actionHandlerThreadCount();
        }
        return this.actionHandlerThreadCount;
    }

    public Configuration actionHandlerThreadCount(Integer actionHandlerThreadCount) {
        this.actionHandlerThreadCount = actionHandlerThreadCount;
        return this;
    }

    public Integer clientNioEventLoopThreadCount() {
        if (this.clientNioEventLoopThreadCount == null) {
            return ConfigurationProperties.clientNioEventLoopThreadCount();
        }
        return this.clientNioEventLoopThreadCount;
    }

    public Configuration clientNioEventLoopThreadCount(Integer clientNioEventLoopThreadCount) {
        this.clientNioEventLoopThreadCount = clientNioEventLoopThreadCount;
        return this;
    }

    public Integer webSocketClientEventLoopThreadCount() {
        if (this.webSocketClientEventLoopThreadCount == null) {
            return ConfigurationProperties.webSocketClientEventLoopThreadCount();
        }
        return this.webSocketClientEventLoopThreadCount;
    }

    public Configuration webSocketClientEventLoopThreadCount(Integer webSocketClientEventLoopThreadCount) {
        this.webSocketClientEventLoopThreadCount = webSocketClientEventLoopThreadCount;
        return this;
    }

    public Long maxFutureTimeoutInMillis() {
        if (this.maxFutureTimeoutInMillis == null) {
            return ConfigurationProperties.maxFutureTimeout();
        }
        return this.maxFutureTimeoutInMillis;
    }

    public Configuration maxFutureTimeoutInMillis(Long maxFutureTimeoutInMillis) {
        this.maxFutureTimeoutInMillis = maxFutureTimeoutInMillis;
        return this;
    }

    public Boolean matchersFailFast() {
        if (this.matchersFailFast == null) {
            return ConfigurationProperties.matchersFailFast();
        }
        return this.matchersFailFast;
    }

    public Configuration matchersFailFast(Boolean matchersFailFast) {
        this.matchersFailFast = matchersFailFast;
        return this;
    }

    public Long maxSocketTimeoutInMillis() {
        if (this.maxSocketTimeoutInMillis == null) {
            return ConfigurationProperties.maxSocketTimeout();
        }
        return this.maxSocketTimeoutInMillis;
    }

    public Configuration maxSocketTimeoutInMillis(Long maxSocketTimeoutInMillis) {
        this.maxSocketTimeoutInMillis = maxSocketTimeoutInMillis;
        return this;
    }

    public Long socketConnectionTimeoutInMillis() {
        if (this.socketConnectionTimeoutInMillis == null) {
            return ConfigurationProperties.socketConnectionTimeout();
        }
        return this.socketConnectionTimeoutInMillis;
    }

    public Configuration socketConnectionTimeoutInMillis(Long socketConnectionTimeoutInMillis) {
        this.socketConnectionTimeoutInMillis = socketConnectionTimeoutInMillis;
        return this;
    }

    public Boolean alwaysCloseSocketConnections() {
        if (this.alwaysCloseSocketConnections == null) {
            return ConfigurationProperties.alwaysCloseSocketConnections();
        }
        return this.alwaysCloseSocketConnections;
    }

    public Configuration alwaysCloseSocketConnections(Boolean alwaysCloseSocketConnections) {
        this.alwaysCloseSocketConnections = alwaysCloseSocketConnections;
        return this;
    }

    public String localBoundIP() {
        if (this.localBoundIP == null) {
            return ConfigurationProperties.localBoundIP();
        }
        return this.localBoundIP;
    }

    public Configuration localBoundIP(String localBoundIP) {
        this.localBoundIP = localBoundIP;
        return this;
    }

    public Integer maxInitialLineLength() {
        if (this.maxInitialLineLength == null) {
            return ConfigurationProperties.maxInitialLineLength();
        }
        return this.maxInitialLineLength;
    }

    public Configuration maxInitialLineLength(Integer maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
        return this;
    }

    public Integer maxHeaderSize() {
        if (this.maxHeaderSize == null) {
            return ConfigurationProperties.maxHeaderSize();
        }
        return this.maxHeaderSize;
    }

    public Configuration maxHeaderSize(Integer maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
        return this;
    }

    public Integer maxChunkSize() {
        if (this.maxChunkSize == null) {
            return ConfigurationProperties.maxChunkSize();
        }
        return this.maxChunkSize;
    }

    public Configuration maxChunkSize(Integer maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
        return this;
    }

    public Boolean useSemicolonAsQueryParameterSeparator() {
        if (this.useSemicolonAsQueryParameterSeparator == null) {
            return ConfigurationProperties.useSemicolonAsQueryParameterSeparator();
        }
        return this.useSemicolonAsQueryParameterSeparator;
    }

    public Configuration useSemicolonAsQueryParameterSeparator(Boolean useSemicolonAsQueryParameterSeparator) {
        this.useSemicolonAsQueryParameterSeparator = useSemicolonAsQueryParameterSeparator;
        return this;
    }

    public Boolean assumeAllRequestsAreHttp() {
        if (this.assumeAllRequestsAreHttp == null) {
            return ConfigurationProperties.assumeAllRequestsAreHttp();
        }
        return this.assumeAllRequestsAreHttp;
    }

    public Configuration assumeAllRequestsAreHttp(Boolean assumeAllRequestsAreHttp) {
        this.assumeAllRequestsAreHttp = assumeAllRequestsAreHttp;
        return this;
    }

    public Boolean enableCORSForAPI() {
        if (this.enableCORSForAPI == null) {
            return ConfigurationProperties.enableCORSForAPI();
        }
        return this.enableCORSForAPI;
    }

    public Configuration enableCORSForAPI(Boolean enableCORSForAPI) {
        this.enableCORSForAPI = enableCORSForAPI;
        return this;
    }

    public Boolean enableCORSForAllResponses() {
        if (this.enableCORSForAllResponses == null) {
            return ConfigurationProperties.enableCORSForAllResponses();
        }
        return this.enableCORSForAllResponses;
    }

    public Configuration enableCORSForAllResponses(Boolean enableCORSForAllResponses) {
        this.enableCORSForAllResponses = enableCORSForAllResponses;
        return this;
    }

    public String corsAllowOrigin() {
        if (this.corsAllowOrigin == null) {
            return ConfigurationProperties.corsAllowOrigin();
        }
        return this.corsAllowOrigin;
    }

    public Configuration corsAllowOrigin(String corsAllowOrigin) {
        this.corsAllowOrigin = corsAllowOrigin;
        return this;
    }

    public String corsAllowMethods() {
        if (this.corsAllowMethods == null) {
            return ConfigurationProperties.corsAllowMethods();
        }
        return this.corsAllowMethods;
    }

    public Configuration corsAllowMethods(String corsAllowMethods) {
        this.corsAllowMethods = corsAllowMethods;
        return this;
    }

    public String corsAllowHeaders() {
        if (this.corsAllowHeaders == null) {
            return ConfigurationProperties.corsAllowHeaders();
        }
        return this.corsAllowHeaders;
    }

    public Configuration corsAllowHeaders(String corsAllowHeaders) {
        this.corsAllowHeaders = corsAllowHeaders;
        return this;
    }

    public Boolean corsAllowCredentials() {
        if (this.corsAllowCredentials == null) {
            return ConfigurationProperties.corsAllowCredentials();
        }
        return this.corsAllowCredentials;
    }

    public Configuration corsAllowCredentials(Boolean corsAllowCredentials) {
        this.corsAllowCredentials = corsAllowCredentials;
        return this;
    }

    public Integer corsMaxAgeInSeconds() {
        if (this.corsMaxAgeInSeconds == null) {
            return ConfigurationProperties.corsMaxAgeInSeconds();
        }
        return this.corsMaxAgeInSeconds;
    }

    public Configuration corsMaxAgeInSeconds(Integer corsMaxAgeInSeconds) {
        this.corsMaxAgeInSeconds = corsMaxAgeInSeconds;
        return this;
    }

    public String initializationClass() {
        if (this.initializationClass == null) {
            return ConfigurationProperties.initializationClass();
        }
        return this.initializationClass;
    }

    public Configuration initializationClass(String initializationClass) {
        this.initializationClass = initializationClass;
        return this;
    }

    public String initializationJsonPath() {
        if (this.initializationJsonPath == null) {
            return ConfigurationProperties.initializationJsonPath();
        }
        return this.initializationJsonPath;
    }

    public Configuration initializationJsonPath(String initializationJsonPath) {
        this.initializationJsonPath = initializationJsonPath;
        return this;
    }

    public Boolean watchInitializationJson() {
        if (this.watchInitializationJson == null) {
            return ConfigurationProperties.watchInitializationJson();
        }
        return this.watchInitializationJson;
    }

    public Configuration watchInitializationJson(Boolean watchInitializationJson) {
        this.watchInitializationJson = watchInitializationJson;
        return this;
    }

    public Boolean persistExpectations() {
        if (this.persistExpectations == null) {
            return ConfigurationProperties.persistExpectations();
        }
        return this.persistExpectations;
    }

    public Configuration persistExpectations(Boolean persistExpectations) {
        this.persistExpectations = persistExpectations;
        return this;
    }

    public String persistedExpectationsPath() {
        if (this.persistedExpectationsPath == null) {
            return ConfigurationProperties.persistedExpectationsPath();
        }
        return this.persistedExpectationsPath;
    }

    public Configuration persistedExpectationsPath(String persistedExpectationsPath) {
        this.persistedExpectationsPath = persistedExpectationsPath;
        return this;
    }

    public Integer maximumNumberOfRequestToReturnInVerificationFailure() {
        if (this.maximumNumberOfRequestToReturnInVerificationFailure == null) {
            return ConfigurationProperties.maximumNumberOfRequestToReturnInVerificationFailure();
        }
        return this.maximumNumberOfRequestToReturnInVerificationFailure;
    }

    public Configuration maximumNumberOfRequestToReturnInVerificationFailure(Integer maximumNumberOfRequestToReturnInVerificationFailure) {
        this.maximumNumberOfRequestToReturnInVerificationFailure = maximumNumberOfRequestToReturnInVerificationFailure;
        return this;
    }

    public Boolean attemptToProxyIfNoMatchingExpectation() {
        if (this.attemptToProxyIfNoMatchingExpectation == null) {
            return ConfigurationProperties.attemptToProxyIfNoMatchingExpectation();
        }
        return this.attemptToProxyIfNoMatchingExpectation;
    }

    public Configuration attemptToProxyIfNoMatchingExpectation(Boolean attemptToProxyIfNoMatchingExpectation) {
        this.attemptToProxyIfNoMatchingExpectation = attemptToProxyIfNoMatchingExpectation;
        return this;
    }

    public InetSocketAddress forwardHttpProxy() {
        if (this.forwardHttpProxy == null) {
            return ConfigurationProperties.forwardHttpProxy();
        }
        return this.forwardHttpProxy;
    }

    public Configuration forwardHttpProxy(InetSocketAddress forwardHttpProxy) {
        this.forwardHttpProxy = forwardHttpProxy;
        return this;
    }

    public InetSocketAddress forwardHttpsProxy() {
        if (this.forwardHttpsProxy == null) {
            return ConfigurationProperties.forwardHttpsProxy();
        }
        return this.forwardHttpsProxy;
    }

    public Configuration forwardHttpsProxy(InetSocketAddress forwardHttpsProxy) {
        this.forwardHttpsProxy = forwardHttpsProxy;
        return this;
    }

    public InetSocketAddress forwardSocksProxy() {
        if (this.forwardSocksProxy == null) {
            return ConfigurationProperties.forwardSocksProxy();
        }
        return this.forwardSocksProxy;
    }

    public Configuration forwardSocksProxy(InetSocketAddress forwardSocksProxy) {
        this.forwardSocksProxy = forwardSocksProxy;
        return this;
    }

    public String forwardProxyAuthenticationUsername() {
        if (this.forwardProxyAuthenticationUsername == null) {
            return ConfigurationProperties.forwardProxyAuthenticationUsername();
        }
        return this.forwardProxyAuthenticationUsername;
    }

    public Configuration forwardProxyAuthenticationUsername(String forwardProxyAuthenticationUsername) {
        this.forwardProxyAuthenticationUsername = forwardProxyAuthenticationUsername;
        return this;
    }

    public String forwardProxyAuthenticationPassword() {
        if (this.forwardProxyAuthenticationPassword == null) {
            return ConfigurationProperties.forwardProxyAuthenticationPassword();
        }
        return this.forwardProxyAuthenticationPassword;
    }

    public Configuration forwardProxyAuthenticationPassword(String forwardProxyAuthenticationPassword) {
        this.forwardProxyAuthenticationPassword = forwardProxyAuthenticationPassword;
        return this;
    }

    public String proxyAuthenticationRealm() {
        if (this.proxyAuthenticationRealm == null) {
            return ConfigurationProperties.proxyAuthenticationRealm();
        }
        return this.proxyAuthenticationRealm;
    }

    public Configuration proxyAuthenticationRealm(String proxyAuthenticationRealm) {
        this.proxyAuthenticationRealm = proxyAuthenticationRealm;
        return this;
    }

    public String proxyAuthenticationUsername() {
        if (this.proxyAuthenticationUsername == null) {
            return ConfigurationProperties.proxyAuthenticationUsername();
        }
        return this.proxyAuthenticationUsername;
    }

    public Configuration proxyAuthenticationUsername(String proxyAuthenticationUsername) {
        this.proxyAuthenticationUsername = proxyAuthenticationUsername;
        return this;
    }

    public String proxyAuthenticationPassword() {
        if (this.proxyAuthenticationPassword == null) {
            return ConfigurationProperties.proxyAuthenticationPassword();
        }
        return this.proxyAuthenticationPassword;
    }

    public Configuration proxyAuthenticationPassword(String proxyAuthenticationPassword) {
        this.proxyAuthenticationPassword = proxyAuthenticationPassword;
        return this;
    }

    public String livenessHttpGetPath() {
        if (this.livenessHttpGetPath == null) {
            return ConfigurationProperties.livenessHttpGetPath();
        }
        return this.livenessHttpGetPath;
    }

    public Configuration livenessHttpGetPath(String livenessHttpGetPath) {
        this.livenessHttpGetPath = livenessHttpGetPath;
        return this;
    }

    public Boolean controlPlaneTLSMutualAuthenticationRequired() {
        if (this.controlPlaneTLSMutualAuthenticationRequired == null) {
            return ConfigurationProperties.controlPlaneTLSMutualAuthenticationRequired();
        }
        return this.controlPlaneTLSMutualAuthenticationRequired;
    }

    public Configuration controlPlaneTLSMutualAuthenticationRequired(Boolean controlPlaneTLSMutualAuthenticationRequired) {
        this.controlPlaneTLSMutualAuthenticationRequired = controlPlaneTLSMutualAuthenticationRequired;
        return this;
    }

    public String controlPlaneTLSMutualAuthenticationCAChain() {
        if (this.controlPlaneTLSMutualAuthenticationCAChain == null) {
            return ConfigurationProperties.controlPlaneTLSMutualAuthenticationCAChain();
        }
        return this.controlPlaneTLSMutualAuthenticationCAChain;
    }

    public Configuration controlPlaneTLSMutualAuthenticationCAChain(String controlPlaneTLSMutualAuthenticationCAChain) {
        ConfigurationProperties.fileExists(controlPlaneTLSMutualAuthenticationCAChain);
        this.controlPlaneTLSMutualAuthenticationCAChain = controlPlaneTLSMutualAuthenticationCAChain;
        return this;
    }

    public String controlPlanePrivateKeyPath() {
        if (this.controlPlanePrivateKeyPath == null) {
            return ConfigurationProperties.controlPlanePrivateKeyPath();
        }
        return this.controlPlanePrivateKeyPath;
    }

    public Configuration controlPlanePrivateKeyPath(String controlPlanePrivateKeyPath) {
        ConfigurationProperties.fileExists(controlPlanePrivateKeyPath);
        this.controlPlanePrivateKeyPath = controlPlanePrivateKeyPath;
        return this;
    }

    public String controlPlaneX509CertificatePath() {
        if (this.controlPlaneX509CertificatePath == null) {
            return ConfigurationProperties.controlPlaneX509CertificatePath();
        }
        return this.controlPlaneX509CertificatePath;
    }

    public Configuration controlPlaneX509CertificatePath(String controlPlaneX509CertificatePath) {
        ConfigurationProperties.fileExists(controlPlaneX509CertificatePath);
        this.controlPlaneX509CertificatePath = controlPlaneX509CertificatePath;
        return this;
    }

    public Boolean controlPlaneJWTAuthenticationRequired() {
        if (this.controlPlaneJWTAuthenticationRequired == null) {
            return ConfigurationProperties.controlPlaneJWTAuthenticationRequired();
        }
        return this.controlPlaneJWTAuthenticationRequired;
    }

    public Configuration controlPlaneJWTAuthenticationRequired(Boolean controlPlaneJWTAuthenticationRequired) {
        this.controlPlaneJWTAuthenticationRequired = controlPlaneJWTAuthenticationRequired;
        return this;
    }

    public String controlPlaneJWTAuthenticationJWKSource() {
        if (this.controlPlaneJWTAuthenticationJWKSource == null) {
            return ConfigurationProperties.controlPlaneJWTAuthenticationJWKSource();
        }
        return this.controlPlaneJWTAuthenticationJWKSource;
    }

    public Configuration controlPlaneJWTAuthenticationJWKSource(String controlPlaneJWTAuthenticationJWKSource) {
        this.controlPlaneJWTAuthenticationJWKSource = controlPlaneJWTAuthenticationJWKSource;
        return this;
    }

    public String controlPlaneJWTAuthenticationExpectedAudience() {
        if (this.controlPlaneJWTAuthenticationExpectedAudience == null) {
            return ConfigurationProperties.controlPlaneJWTAuthenticationExpectedAudience();
        }
        return this.controlPlaneJWTAuthenticationExpectedAudience;
    }

    public Configuration controlPlaneJWTAuthenticationExpectedAudience(String controlPlaneJWTAuthenticationExpectedAudience) {
        this.controlPlaneJWTAuthenticationExpectedAudience = controlPlaneJWTAuthenticationExpectedAudience;
        return this;
    }

    public Map<String, String> controlPlaneJWTAuthenticationMatchingClaims() {
        if (this.controlPlaneJWTAuthenticationMatchingClaims == null) {
            return ConfigurationProperties.controlPlaneJWTAuthenticationMatchingClaims();
        }
        return this.controlPlaneJWTAuthenticationMatchingClaims;
    }

    public Configuration controlPlaneJWTAuthenticationMatchingClaims(Map<String, String> controlPlaneJWTAuthenticationMatchingClaims) {
        this.controlPlaneJWTAuthenticationMatchingClaims = controlPlaneJWTAuthenticationMatchingClaims;
        return this;
    }

    public Set<String> controlPlaneJWTAuthenticationRequiredClaims() {
        if (this.controlPlaneJWTAuthenticationRequiredClaims == null) {
            return ConfigurationProperties.controlPlaneJWTAuthenticationRequiredClaims();
        }
        return this.controlPlaneJWTAuthenticationRequiredClaims;
    }

    public Configuration controlPlaneJWTAuthenticationRequiredClaims(Set<String> controlPlaneJWTAuthenticationRequiredClaims) {
        this.controlPlaneJWTAuthenticationRequiredClaims = controlPlaneJWTAuthenticationRequiredClaims;
        return this;
    }

    public Boolean proactivelyInitialiseTLS() {
        if (this.proactivelyInitialiseTLS == null) {
            return ConfigurationProperties.proactivelyInitialiseTLS();
        }
        return this.proactivelyInitialiseTLS;
    }

    public Configuration proactivelyInitialiseTLS(Boolean proactivelyInitialiseTLS) {
        this.proactivelyInitialiseTLS = proactivelyInitialiseTLS;
        return this;
    }

    public boolean rebuildTLSContext() {
        return this.rebuildTLSContext;
    }

    public Configuration rebuildTLSContext(boolean rebuildTLSContext) {
        this.rebuildTLSContext = rebuildTLSContext;
        return this;
    }

    public boolean rebuildServerTLSContext() {
        return this.rebuildServerTLSContext;
    }

    public Configuration rebuildServerTLSContext(boolean rebuildServerTLSContext) {
        this.rebuildServerTLSContext = rebuildServerTLSContext;
        return this;
    }

    public Boolean dynamicallyCreateCertificateAuthorityCertificate() {
        if (this.dynamicallyCreateCertificateAuthorityCertificate == null) {
            return ConfigurationProperties.dynamicallyCreateCertificateAuthorityCertificate();
        }
        return this.dynamicallyCreateCertificateAuthorityCertificate;
    }

    public Configuration dynamicallyCreateCertificateAuthorityCertificate(Boolean dynamicallyCreateCertificateAuthorityCertificate) {
        this.dynamicallyCreateCertificateAuthorityCertificate = dynamicallyCreateCertificateAuthorityCertificate;
        return this;
    }

    public String directoryToSaveDynamicSSLCertificate() {
        if (this.directoryToSaveDynamicSSLCertificate == null) {
            return ConfigurationProperties.directoryToSaveDynamicSSLCertificate();
        }
        return this.directoryToSaveDynamicSSLCertificate;
    }

    public Configuration directoryToSaveDynamicSSLCertificate(String directoryToSaveDynamicSSLCertificate) {
        this.directoryToSaveDynamicSSLCertificate = directoryToSaveDynamicSSLCertificate;
        return this;
    }

    public Boolean preventCertificateDynamicUpdate() {
        if (this.preventCertificateDynamicUpdate == null) {
            return ConfigurationProperties.preventCertificateDynamicUpdate();
        }
        return this.preventCertificateDynamicUpdate;
    }

    public Configuration preventCertificateDynamicUpdate(Boolean preventCertificateDynamicUpdate) {
        this.preventCertificateDynamicUpdate = preventCertificateDynamicUpdate;
        return this;
    }

    public String sslCertificateDomainName() {
        if (this.sslCertificateDomainName == null) {
            return ConfigurationProperties.sslCertificateDomainName();
        }
        return this.sslCertificateDomainName;
    }

    public Configuration sslCertificateDomainName(String sslCertificateDomainName) {
        this.sslCertificateDomainName = sslCertificateDomainName;
        return this;
    }

    public Set<String> sslSubjectAlternativeNameDomains() {
        if (this.sslSubjectAlternativeNameDomains == null) {
            return ConfigurationProperties.sslSubjectAlternativeNameDomains();
        }
        return this.sslSubjectAlternativeNameDomains;
    }

    public Configuration sslSubjectAlternativeNameDomains(String ... sslSubjectAlternativeNameDomains) {
        this.sslSubjectAlternativeNameDomains = Sets.newConcurrentHashSet(Arrays.asList(sslSubjectAlternativeNameDomains));
        return this;
    }

    public Configuration sslSubjectAlternativeNameDomains(Set<String> sslSubjectAlternativeNameDomains) {
        this.sslSubjectAlternativeNameDomains = sslSubjectAlternativeNameDomains;
        return this;
    }

    public Set<String> sslSubjectAlternativeNameIps() {
        if (this.sslSubjectAlternativeNameIps == null) {
            return ConfigurationProperties.sslSubjectAlternativeNameIps();
        }
        return this.sslSubjectAlternativeNameIps;
    }

    public Configuration sslSubjectAlternativeNameIps(String ... sslSubjectAlternativeNameIps) {
        this.sslSubjectAlternativeNameIps(Sets.newConcurrentHashSet(Arrays.asList(sslSubjectAlternativeNameIps)));
        return this;
    }

    public Configuration sslSubjectAlternativeNameIps(Set<String> sslSubjectAlternativeNameIps) {
        this.sslSubjectAlternativeNameIps = sslSubjectAlternativeNameIps;
        return this;
    }

    public String certificateAuthorityPrivateKey() {
        if (this.certificateAuthorityPrivateKey == null) {
            return ConfigurationProperties.certificateAuthorityPrivateKey();
        }
        return this.certificateAuthorityPrivateKey;
    }

    public Configuration certificateAuthorityPrivateKey(String certificateAuthorityPrivateKey) {
        ConfigurationProperties.fileExists(certificateAuthorityPrivateKey);
        this.certificateAuthorityPrivateKey = certificateAuthorityPrivateKey;
        return this;
    }

    public String certificateAuthorityCertificate() {
        if (this.certificateAuthorityCertificate == null) {
            return ConfigurationProperties.certificateAuthorityCertificate();
        }
        return this.certificateAuthorityCertificate;
    }

    public Configuration certificateAuthorityCertificate(String certificateAuthorityCertificate) {
        ConfigurationProperties.fileExists(certificateAuthorityCertificate);
        this.certificateAuthorityCertificate = certificateAuthorityCertificate;
        return this;
    }

    public String privateKeyPath() {
        if (this.privateKeyPath == null) {
            return ConfigurationProperties.privateKeyPath();
        }
        return this.privateKeyPath;
    }

    public Configuration privateKeyPath(String privateKeyPath) {
        ConfigurationProperties.fileExists(privateKeyPath);
        this.privateKeyPath = privateKeyPath;
        return this;
    }

    public String x509CertificatePath() {
        if (this.x509CertificatePath == null) {
            return ConfigurationProperties.x509CertificatePath();
        }
        return this.x509CertificatePath;
    }

    public Configuration x509CertificatePath(String x509CertificatePath) {
        ConfigurationProperties.fileExists(x509CertificatePath);
        this.x509CertificatePath = x509CertificatePath;
        return this;
    }

    public Boolean tlsMutualAuthenticationRequired() {
        if (this.tlsMutualAuthenticationRequired == null) {
            return ConfigurationProperties.tlsMutualAuthenticationRequired();
        }
        return this.tlsMutualAuthenticationRequired;
    }

    public Configuration tlsMutualAuthenticationRequired(Boolean tlsMutualAuthenticationRequired) {
        this.tlsMutualAuthenticationRequired = tlsMutualAuthenticationRequired;
        return this;
    }

    public String tlsMutualAuthenticationCertificateChain() {
        if (this.tlsMutualAuthenticationCertificateChain == null) {
            return ConfigurationProperties.tlsMutualAuthenticationCertificateChain();
        }
        return this.tlsMutualAuthenticationCertificateChain;
    }

    public Configuration tlsMutualAuthenticationCertificateChain(String tlsMutualAuthenticationCertificateChain) {
        ConfigurationProperties.fileExists(tlsMutualAuthenticationCertificateChain);
        this.tlsMutualAuthenticationCertificateChain = tlsMutualAuthenticationCertificateChain;
        return this;
    }

    public ForwardProxyTLSX509CertificatesTrustManager forwardProxyTLSX509CertificatesTrustManagerType() {
        if (this.forwardProxyTLSX509CertificatesTrustManagerType == null) {
            return ConfigurationProperties.forwardProxyTLSX509CertificatesTrustManagerType();
        }
        return this.forwardProxyTLSX509CertificatesTrustManagerType;
    }

    public Configuration forwardProxyTLSX509CertificatesTrustManagerType(ForwardProxyTLSX509CertificatesTrustManager forwardProxyTLSX509CertificatesTrustManagerType) {
        this.forwardProxyTLSX509CertificatesTrustManagerType = forwardProxyTLSX509CertificatesTrustManagerType;
        return this;
    }

    public String forwardProxyTLSCustomTrustX509Certificates() {
        if (this.forwardProxyTLSCustomTrustX509Certificates == null) {
            return ConfigurationProperties.forwardProxyTLSCustomTrustX509Certificates();
        }
        return this.forwardProxyTLSCustomTrustX509Certificates;
    }

    public Configuration forwardProxyTLSCustomTrustX509Certificates(String forwardProxyTLSCustomTrustX509Certificates) {
        ConfigurationProperties.fileExists(forwardProxyTLSCustomTrustX509Certificates);
        this.forwardProxyTLSCustomTrustX509Certificates = forwardProxyTLSCustomTrustX509Certificates;
        return this;
    }

    public String forwardProxyPrivateKey() {
        if (this.forwardProxyPrivateKey == null) {
            return ConfigurationProperties.forwardProxyPrivateKey();
        }
        return this.forwardProxyPrivateKey;
    }

    public Configuration forwardProxyPrivateKey(String forwardProxyPrivateKey) {
        ConfigurationProperties.fileExists(forwardProxyPrivateKey);
        this.forwardProxyPrivateKey = forwardProxyPrivateKey;
        return this;
    }

    public String forwardProxyCertificateChain() {
        if (this.forwardProxyCertificateChain == null) {
            return ConfigurationProperties.forwardProxyCertificateChain();
        }
        return this.forwardProxyCertificateChain;
    }

    public Configuration forwardProxyCertificateChain(String forwardProxyCertificateChain) {
        ConfigurationProperties.fileExists(forwardProxyCertificateChain);
        this.forwardProxyCertificateChain = forwardProxyCertificateChain;
        return this;
    }

    public void addSubjectAlternativeName(String host) {
        String hostWithoutPort;
        if (StringUtils.isNotBlank((CharSequence)host) && StringUtils.isNotBlank((CharSequence)(hostWithoutPort = StringUtils.substringBefore((String)host, (String)":")))) {
            if (InetAddresses.isInetAddress((String)hostWithoutPort)) {
                this.addSslSubjectAlternativeNameIps(hostWithoutPort);
            } else {
                this.addSslSubjectAlternativeNameDomains(hostWithoutPort);
            }
        }
    }

    public void addSslSubjectAlternativeNameIps(String ... additionalSubjectAlternativeNameIps) {
        boolean subjectAlternativeIpsModified = false;
        Set<String> sslSubjectAlternativeNameIps = this.sslSubjectAlternativeNameIps();
        for (String subjectAlternativeIp : additionalSubjectAlternativeNameIps) {
            if (!sslSubjectAlternativeNameIps.add(subjectAlternativeIp.trim())) continue;
            subjectAlternativeIpsModified = true;
        }
        if (subjectAlternativeIpsModified) {
            this.rebuildServerTLSContext(true);
            this.sslSubjectAlternativeNameIps(sslSubjectAlternativeNameIps);
        }
    }

    public void clearSslSubjectAlternativeNameIps() {
        this.sslSubjectAlternativeNameIps.clear();
        this.rebuildServerTLSContext(true);
    }

    public void addSslSubjectAlternativeNameDomains(String ... additionalSubjectAlternativeNameDomains) {
        boolean subjectAlternativeDomainsModified = false;
        Set<String> sslSubjectAlternativeNameDomains = this.sslSubjectAlternativeNameDomains();
        for (String subjectAlternativeDomain : additionalSubjectAlternativeNameDomains) {
            if (!sslSubjectAlternativeNameDomains.add(subjectAlternativeDomain.trim())) continue;
            subjectAlternativeDomainsModified = true;
        }
        if (subjectAlternativeDomainsModified) {
            this.rebuildServerTLSContext(true);
            this.sslSubjectAlternativeNameDomains(sslSubjectAlternativeNameDomains);
        }
    }

    public void clearSslSubjectAlternativeNameDomains() {
        this.sslSubjectAlternativeNameDomains.clear();
        this.rebuildServerTLSContext(true);
    }

    public int ringBufferSize() {
        return this.nextPowerOfTwo(this.maxLogEntries());
    }

    private int nextPowerOfTwo(int value) {
        for (int i = 0; i < 16; ++i) {
            double powOfTwo = Math.pow(2.0, i);
            if (!(powOfTwo > (double)value)) continue;
            return (int)powOfTwo;
        }
        return (int)Math.pow(2.0, 16.0);
    }
}

