/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.iterative;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import org.minidns.AbstractDnsClient;
import org.minidns.DnsCache;
import org.minidns.constants.DnsRootServer;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.iterative.IterativeClientException;
import org.minidns.iterative.ResolutionState;
import org.minidns.record.A;
import org.minidns.record.AAAA;
import org.minidns.record.InternetAddressRR;
import org.minidns.record.NS;
import org.minidns.record.RRWithTarget;
import org.minidns.record.Record;
import org.minidns.util.MultipleIoException;

public class IterativeDnsClient
extends AbstractDnsClient {
    int maxSteps = 128;

    public IterativeDnsClient() {
    }

    public IterativeDnsClient(DnsCache cache) {
        super(cache);
    }

    protected DnsQueryResult query(DnsMessage.Builder queryBuilder) throws IOException {
        DnsMessage q = queryBuilder.build();
        ResolutionState resolutionState = new ResolutionState(this);
        DnsQueryResult result = this.queryRecursive(resolutionState, q);
        return result;
    }

    private static InetAddress[] getTargets(Collection<? extends InternetAddressRR<? extends InetAddress>> primaryTargets, Collection<? extends InternetAddressRR<? extends InetAddress>> secondaryTargets) {
        InetAddress[] res = new InetAddress[2];
        for (InternetAddressRR<? extends InetAddress> internetAddressRR : primaryTargets) {
            if (res[0] == null) {
                res[0] = internetAddressRR.getInetAddress();
                if (secondaryTargets.isEmpty()) continue;
            }
            if (res[1] != null) break;
            res[1] = internetAddressRR.getInetAddress();
            break;
        }
        for (InternetAddressRR<? extends InetAddress> internetAddressRR : secondaryTargets) {
            if (res[0] == null) {
                res[0] = internetAddressRR.getInetAddress();
                continue;
            }
            if (res[1] != null) break;
            res[1] = internetAddressRR.getInetAddress();
            break;
        }
        return res;
    }

    private DnsQueryResult queryRecursive(ResolutionState resolutionState, DnsMessage q) throws IOException {
        InetAddress primaryTarget = null;
        InetAddress secondaryTarget = null;
        Question question = q.getQuestion();
        DnsName parent = question.name.getParent();
        block2 : switch (this.ipVersionSetting) {
            case v4only: {
                for (A a : this.getCachedIPv4NameserverAddressesFor(parent)) {
                    if (primaryTarget == null) {
                        primaryTarget = a.getInetAddress();
                        continue;
                    }
                    secondaryTarget = a.getInetAddress();
                    break block2;
                }
                break;
            }
            case v6only: {
                for (AAAA aaaa : this.getCachedIPv6NameserverAddressesFor(parent)) {
                    if (primaryTarget == null) {
                        primaryTarget = aaaa.getInetAddress();
                        continue;
                    }
                    secondaryTarget = aaaa.getInetAddress();
                    break block2;
                }
                break;
            }
            case v4v6: {
                InetAddress[] v4v6targets = IterativeDnsClient.getTargets(this.getCachedIPv4NameserverAddressesFor(parent), this.getCachedIPv6NameserverAddressesFor(parent));
                primaryTarget = v4v6targets[0];
                secondaryTarget = v4v6targets[1];
                break;
            }
            case v6v4: {
                InetAddress[] v6v4targets = IterativeDnsClient.getTargets(this.getCachedIPv6NameserverAddressesFor(parent), this.getCachedIPv4NameserverAddressesFor(parent));
                primaryTarget = v6v4targets[0];
                secondaryTarget = v6v4targets[1];
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        DnsName authoritativeZone = parent;
        if (primaryTarget == null) {
            authoritativeZone = DnsName.ROOT;
            switch (this.ipVersionSetting) {
                case v4only: {
                    primaryTarget = DnsRootServer.getRandomIpv4RootServer((Random)this.insecureRandom);
                    break;
                }
                case v6only: {
                    primaryTarget = DnsRootServer.getRandomIpv6RootServer((Random)this.insecureRandom);
                    break;
                }
                case v4v6: {
                    primaryTarget = DnsRootServer.getRandomIpv4RootServer((Random)this.insecureRandom);
                    secondaryTarget = DnsRootServer.getRandomIpv6RootServer((Random)this.insecureRandom);
                    break;
                }
                case v6v4: {
                    primaryTarget = DnsRootServer.getRandomIpv6RootServer((Random)this.insecureRandom);
                    secondaryTarget = DnsRootServer.getRandomIpv4RootServer((Random)this.insecureRandom);
                }
            }
        }
        LinkedList<IOException> ioExceptions = new LinkedList<IOException>();
        try {
            return this.queryRecursive(resolutionState, q, primaryTarget, authoritativeZone);
        }
        catch (IOException ioException) {
            IterativeDnsClient.abortIfFatal(ioException);
            ioExceptions.add(ioException);
            if (secondaryTarget != null) {
                try {
                    return this.queryRecursive(resolutionState, q, secondaryTarget, authoritativeZone);
                }
                catch (IOException ioException2) {
                    ioExceptions.add(ioException2);
                }
            }
            MultipleIoException.throwIfRequired(ioExceptions);
            return null;
        }
    }

    private DnsQueryResult queryRecursive(ResolutionState resolutionState, DnsMessage q, InetAddress address, DnsName authoritativeZone) throws IOException {
        resolutionState.recurse(address, q);
        DnsQueryResult dnsQueryResult = this.query(q, address);
        DnsMessage resMessage = dnsQueryResult.response;
        if (resMessage.authoritativeAnswer) {
            return dnsQueryResult;
        }
        if (this.cache != null) {
            this.cache.offer(q, dnsQueryResult, authoritativeZone);
        }
        List authorities = resMessage.copyAuthority();
        LinkedList<IOException> ioExceptions = new LinkedList<IOException>();
        Iterator iterator = authorities.iterator();
        while (iterator.hasNext()) {
            Record record = ((Record)iterator.next()).ifPossibleAs(NS.class);
            if (record == null) {
                iterator.remove();
                continue;
            }
            DnsName name = ((NS)record.payloadData).target;
            IpResultSet gluedNs = this.searchAdditional(resMessage, name);
            Iterator<InetAddress> addressIterator = gluedNs.addresses.iterator();
            while (addressIterator.hasNext()) {
                InetAddress target = addressIterator.next();
                DnsQueryResult recursive = null;
                try {
                    recursive = this.queryRecursive(resolutionState, q, target, record.name);
                }
                catch (IOException e) {
                    IterativeDnsClient.abortIfFatal(e);
                    LOGGER.log(Level.FINER, "Exception while recursing", e);
                    resolutionState.decrementSteps();
                    ioExceptions.add(e);
                    if (addressIterator.hasNext()) continue;
                    iterator.remove();
                    continue;
                }
                return recursive;
            }
        }
        for (Record record : authorities) {
            Question question = q.getQuestion();
            DnsName name = ((NS)record.payloadData).target;
            if (question.name.equals((Object)name) && (question.type == Record.TYPE.A || question.type == Record.TYPE.AAAA)) continue;
            IpResultSet res = null;
            try {
                res = this.resolveIpRecursive(resolutionState, name);
            }
            catch (IOException e) {
                resolutionState.decrementSteps();
                ioExceptions.add(e);
            }
            if (res == null) continue;
            for (InetAddress target : res.addresses) {
                DnsQueryResult recursive = null;
                try {
                    recursive = this.queryRecursive(resolutionState, q, target, record.name);
                }
                catch (IOException e) {
                    resolutionState.decrementSteps();
                    ioExceptions.add(e);
                    continue;
                }
                return recursive;
            }
        }
        MultipleIoException.throwIfRequired(ioExceptions);
        throw new IterativeClientException.NotAuthoritativeNorGlueRrFound(q, dnsQueryResult, authoritativeZone);
    }

    private IpResultSet resolveIpRecursive(ResolutionState resolutionState, DnsName name) throws IOException {
        InetAddress inetAddress;
        DnsMessage aMessage;
        DnsQueryResult aDnsQueryResult;
        DnsMessage query;
        Question question;
        IpResultSet.Builder res = this.newIpResultSetBuilder();
        if (this.ipVersionSetting.v4) {
            question = new Question(name, Record.TYPE.A);
            query = this.getQueryFor(question);
            aDnsQueryResult = this.queryRecursive(resolutionState, query);
            DnsMessage dnsMessage = aMessage = aDnsQueryResult != null ? aDnsQueryResult.response : null;
            if (aMessage != null) {
                for (Record answer : aMessage.answerSection) {
                    if (answer.isAnswer(question)) {
                        inetAddress = IterativeDnsClient.inetAddressFromRecord(name.ace, (A)answer.payloadData);
                        res.ipv4Addresses.add(inetAddress);
                        continue;
                    }
                    if (answer.type != Record.TYPE.CNAME || !answer.name.equals((Object)name)) continue;
                    return this.resolveIpRecursive(resolutionState, ((RRWithTarget)answer.payloadData).target);
                }
            }
        }
        if (this.ipVersionSetting.v6) {
            question = new Question(name, Record.TYPE.AAAA);
            query = this.getQueryFor(question);
            aDnsQueryResult = this.queryRecursive(resolutionState, query);
            DnsMessage dnsMessage = aMessage = aDnsQueryResult != null ? aDnsQueryResult.response : null;
            if (aMessage != null) {
                for (Record answer : aMessage.answerSection) {
                    if (answer.isAnswer(question)) {
                        inetAddress = IterativeDnsClient.inetAddressFromRecord(name.ace, (AAAA)answer.payloadData);
                        res.ipv6Addresses.add(inetAddress);
                        continue;
                    }
                    if (answer.type != Record.TYPE.CNAME || !answer.name.equals((Object)name)) continue;
                    return this.resolveIpRecursive(resolutionState, ((RRWithTarget)answer.payloadData).target);
                }
            }
        }
        return res.build();
    }

    private IpResultSet searchAdditional(DnsMessage message, DnsName name) {
        IpResultSet.Builder res = this.newIpResultSetBuilder();
        for (Record record : message.additionalSection) {
            if (!record.name.equals((Object)name)) continue;
            switch (record.type) {
                case A: {
                    res.ipv4Addresses.add(IterativeDnsClient.inetAddressFromRecord(name.ace, (A)record.payloadData));
                    break;
                }
                case AAAA: {
                    res.ipv6Addresses.add(IterativeDnsClient.inetAddressFromRecord(name.ace, (AAAA)record.payloadData));
                    break;
                }
            }
        }
        return res.build();
    }

    private static InetAddress inetAddressFromRecord(String name, A recordPayload) {
        try {
            return InetAddress.getByAddress(name, recordPayload.getIp());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private static InetAddress inetAddressFromRecord(String name, AAAA recordPayload) {
        try {
            return InetAddress.getByAddress(name, recordPayload.getIp());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<InetAddress> getRootServer(char rootServerId) {
        return IterativeDnsClient.getRootServer(rootServerId, DEFAULT_IP_VERSION_SETTING);
    }

    public static List<InetAddress> getRootServer(char rootServerId, AbstractDnsClient.IpVersionSetting setting) {
        Inet4Address ipv4Root = DnsRootServer.getIpv4RootServerById((char)rootServerId);
        Inet6Address ipv6Root = DnsRootServer.getIpv6RootServerById((char)rootServerId);
        ArrayList<InetAddress> res = new ArrayList<InetAddress>(2);
        switch (setting) {
            case v4only: {
                if (ipv4Root == null) break;
                res.add(ipv4Root);
                break;
            }
            case v6only: {
                if (ipv6Root == null) break;
                res.add(ipv6Root);
                break;
            }
            case v4v6: {
                if (ipv4Root != null) {
                    res.add(ipv4Root);
                }
                if (ipv6Root == null) break;
                res.add(ipv6Root);
                break;
            }
            case v6v4: {
                if (ipv6Root != null) {
                    res.add(ipv6Root);
                }
                if (ipv4Root == null) break;
                res.add(ipv4Root);
            }
        }
        return res;
    }

    protected boolean isResponseCacheable(Question q, DnsQueryResult result) {
        return result.response.authoritativeAnswer;
    }

    protected DnsMessage.Builder newQuestion(DnsMessage.Builder message) {
        message.setRecursionDesired(false);
        message.getEdnsBuilder().setUdpPayloadSize(this.dataSource.getUdpPayloadSize());
        return message;
    }

    private IpResultSet.Builder newIpResultSetBuilder() {
        return new IpResultSet.Builder(this.insecureRandom);
    }

    protected static void abortIfFatal(IOException ioException) throws IOException {
        if (ioException instanceof IterativeClientException.LoopDetected) {
            throw ioException;
        }
    }

    private static final class IpResultSet {
        final List<InetAddress> addresses;

        private IpResultSet(List<InetAddress> ipv4Addresses, List<InetAddress> ipv6Addresses, Random random) {
            int size;
            switch (DEFAULT_IP_VERSION_SETTING) {
                case v4only: {
                    size = ipv4Addresses.size();
                    break;
                }
                case v6only: {
                    size = ipv6Addresses.size();
                    break;
                }
                default: {
                    size = ipv4Addresses.size() + ipv6Addresses.size();
                }
            }
            if (size == 0) {
                this.addresses = Collections.emptyList();
            } else {
                if (DEFAULT_IP_VERSION_SETTING.v4) {
                    Collections.shuffle(ipv4Addresses, random);
                }
                if (DEFAULT_IP_VERSION_SETTING.v6) {
                    Collections.shuffle(ipv6Addresses, random);
                }
                ArrayList<InetAddress> addresses = new ArrayList<InetAddress>(size);
                switch (DEFAULT_IP_VERSION_SETTING) {
                    case v4only: {
                        addresses.addAll(ipv4Addresses);
                        break;
                    }
                    case v6only: {
                        addresses.addAll(ipv6Addresses);
                        break;
                    }
                    case v4v6: {
                        addresses.addAll(ipv4Addresses);
                        addresses.addAll(ipv6Addresses);
                        break;
                    }
                    case v6v4: {
                        addresses.addAll(ipv6Addresses);
                        addresses.addAll(ipv4Addresses);
                    }
                }
                this.addresses = Collections.unmodifiableList(addresses);
            }
        }

        private static final class Builder {
            private final Random random;
            private final List<InetAddress> ipv4Addresses = new ArrayList<InetAddress>(8);
            private final List<InetAddress> ipv6Addresses = new ArrayList<InetAddress>(8);

            private Builder(Random random) {
                this.random = random;
            }

            public IpResultSet build() {
                return new IpResultSet(this.ipv4Addresses, this.ipv6Addresses, this.random);
            }
        }
    }
}

