/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.iterative;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import org.minidns.AbstractDnsClient;
import org.minidns.DnsCache;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.iterative.IterativeClientException;
import org.minidns.iterative.ResolutionState;
import org.minidns.record.A;
import org.minidns.record.AAAA;
import org.minidns.record.InternetAddressRR;
import org.minidns.record.NS;
import org.minidns.record.RRWithTarget;
import org.minidns.record.Record;
import org.minidns.util.MultipleIoException;

public class IterativeDnsClient
extends AbstractDnsClient {
    private static final Map<Character, InetAddress> IPV4_ROOT_SERVER_MAP = new HashMap<Character, InetAddress>();
    private static final Map<Character, InetAddress> IPV6_ROOT_SERVER_MAP = new HashMap<Character, InetAddress>();
    protected static final Inet4Address[] IPV4_ROOT_SERVERS = new Inet4Address[]{IterativeDnsClient.rootServerInet4Address('a', 198, 41, 0, 4), IterativeDnsClient.rootServerInet4Address('b', 192, 228, 79, 201), IterativeDnsClient.rootServerInet4Address('c', 192, 33, 4, 12), IterativeDnsClient.rootServerInet4Address('d', 199, 7, 91, 13), IterativeDnsClient.rootServerInet4Address('e', 192, 203, 230, 10), IterativeDnsClient.rootServerInet4Address('f', 192, 5, 5, 241), IterativeDnsClient.rootServerInet4Address('g', 192, 112, 36, 4), IterativeDnsClient.rootServerInet4Address('h', 198, 97, 190, 53), IterativeDnsClient.rootServerInet4Address('i', 192, 36, 148, 17), IterativeDnsClient.rootServerInet4Address('j', 192, 58, 128, 30), IterativeDnsClient.rootServerInet4Address('k', 193, 0, 14, 129), IterativeDnsClient.rootServerInet4Address('l', 199, 7, 83, 42), IterativeDnsClient.rootServerInet4Address('m', 202, 12, 27, 33)};
    protected static final Inet6Address[] IPV6_ROOT_SERVERS = new Inet6Address[]{IterativeDnsClient.rootServerInet6Address('a', 8193, 1283, 47678, 0, 0, 0, 2, 48), IterativeDnsClient.rootServerInet6Address('b', 8193, 1280, 132, 0, 0, 0, 0, 11), IterativeDnsClient.rootServerInet6Address('c', 8193, 1280, 2, 0, 0, 0, 0, 12), IterativeDnsClient.rootServerInet6Address('d', 8193, 1280, 45, 0, 0, 0, 0, 13), IterativeDnsClient.rootServerInet6Address('f', 8193, 1280, 47, 0, 0, 0, 0, 15), IterativeDnsClient.rootServerInet6Address('h', 8193, 1280, 1, 0, 0, 0, 0, 83), IterativeDnsClient.rootServerInet6Address('i', 8193, 2046, 0, 0, 0, 0, 0, 83), IterativeDnsClient.rootServerInet6Address('j', 8193, 1283, 3111, 0, 0, 0, 2, 48), IterativeDnsClient.rootServerInet6Address('l', 8193, 1280, 3, 0, 0, 0, 0, 66), IterativeDnsClient.rootServerInet6Address('m', 8193, 3523, 0, 0, 0, 0, 0, 53)};
    int maxSteps = 128;

    public IterativeDnsClient() {
    }

    public IterativeDnsClient(DnsCache cache) {
        super(cache);
    }

    protected DnsMessage query(DnsMessage.Builder queryBuilder) throws IOException {
        DnsMessage q = queryBuilder.build();
        ResolutionState resolutionState = new ResolutionState(this);
        DnsMessage message = this.queryRecursive(resolutionState, q);
        return message;
    }

    private Inet4Address getRandomIpv4RootServer() {
        return IPV4_ROOT_SERVERS[this.insecureRandom.nextInt(IPV4_ROOT_SERVERS.length)];
    }

    private Inet6Address getRandomIpv6RootServer() {
        return IPV6_ROOT_SERVERS[this.insecureRandom.nextInt(IPV6_ROOT_SERVERS.length)];
    }

    private static InetAddress[] getTargets(Collection<? extends InternetAddressRR> primaryTargets, Collection<? extends InternetAddressRR> secondaryTargets) {
        InetAddress[] res = new InetAddress[2];
        for (InternetAddressRR internetAddressRR : primaryTargets) {
            if (res[0] == null) {
                res[0] = internetAddressRR.getInetAddress();
                if (secondaryTargets.isEmpty()) continue;
            }
            if (res[1] != null) break;
            res[1] = internetAddressRR.getInetAddress();
            break;
        }
        for (InternetAddressRR internetAddressRR : secondaryTargets) {
            if (res[0] == null) {
                res[0] = internetAddressRR.getInetAddress();
                continue;
            }
            if (res[1] != null) break;
            res[1] = internetAddressRR.getInetAddress();
            break;
        }
        return res;
    }

    private DnsMessage queryRecursive(ResolutionState resolutionState, DnsMessage q) throws IOException {
        InetAddress primaryTarget = null;
        InetAddress secondaryTarget = null;
        Question question = q.getQuestion();
        DnsName parent = question.name.getParent();
        block2 : switch (this.ipVersionSetting) {
            case v4only: {
                for (A a : this.getCachedIPv4NameserverAddressesFor(parent)) {
                    if (primaryTarget == null) {
                        primaryTarget = a.getInetAddress();
                        continue;
                    }
                    secondaryTarget = a.getInetAddress();
                    break block2;
                }
                break;
            }
            case v6only: {
                for (AAAA aaaa : this.getCachedIPv6NameserverAddressesFor(parent)) {
                    if (primaryTarget == null) {
                        primaryTarget = aaaa.getInetAddress();
                        continue;
                    }
                    secondaryTarget = aaaa.getInetAddress();
                    break block2;
                }
                break;
            }
            case v4v6: {
                InetAddress[] v4v6targets = IterativeDnsClient.getTargets(this.getCachedIPv4NameserverAddressesFor(parent), this.getCachedIPv6NameserverAddressesFor(parent));
                primaryTarget = v4v6targets[0];
                secondaryTarget = v4v6targets[1];
                break;
            }
            case v6v4: {
                InetAddress[] v6v4targets = IterativeDnsClient.getTargets(this.getCachedIPv6NameserverAddressesFor(parent), this.getCachedIPv4NameserverAddressesFor(parent));
                primaryTarget = v6v4targets[0];
                secondaryTarget = v6v4targets[1];
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        DnsName authoritativeZone = parent;
        if (primaryTarget == null) {
            authoritativeZone = DnsName.ROOT;
            switch (this.ipVersionSetting) {
                case v4only: {
                    primaryTarget = this.getRandomIpv4RootServer();
                    break;
                }
                case v6only: {
                    primaryTarget = this.getRandomIpv6RootServer();
                    break;
                }
                case v4v6: {
                    primaryTarget = this.getRandomIpv4RootServer();
                    secondaryTarget = this.getRandomIpv6RootServer();
                    break;
                }
                case v6v4: {
                    primaryTarget = this.getRandomIpv6RootServer();
                    secondaryTarget = this.getRandomIpv4RootServer();
                }
            }
        }
        LinkedList<IOException> ioExceptions = new LinkedList<IOException>();
        try {
            return this.queryRecursive(resolutionState, q, primaryTarget, authoritativeZone);
        }
        catch (IOException ioException) {
            IterativeDnsClient.abortIfFatal(ioException);
            ioExceptions.add(ioException);
            if (secondaryTarget != null) {
                try {
                    return this.queryRecursive(resolutionState, q, secondaryTarget, authoritativeZone);
                }
                catch (IOException ioException2) {
                    ioExceptions.add(ioException2);
                }
            }
            MultipleIoException.throwIfRequired(ioExceptions);
            return null;
        }
    }

    private DnsMessage queryRecursive(ResolutionState resolutionState, DnsMessage q, InetAddress address, DnsName authoritativeZone) throws IOException {
        resolutionState.recurse(address, q);
        DnsMessage resMessage = this.query(q, address);
        if (resMessage == null) {
            return null;
        }
        if (resMessage.authoritativeAnswer) {
            return resMessage;
        }
        if (this.cache != null) {
            this.cache.offer(q, resMessage, authoritativeZone);
        }
        List authorities = resMessage.copyAuthority();
        LinkedList<IOException> ioExceptions = new LinkedList<IOException>();
        Iterator iterator = authorities.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.type != Record.TYPE.NS) {
                iterator.remove();
                continue;
            }
            DnsName name = ((NS)record.payloadData).target;
            IpResultSet gluedNs = this.searchAdditional(resMessage, name);
            Iterator<InetAddress> addressIterator = gluedNs.addresses.iterator();
            while (addressIterator.hasNext()) {
                InetAddress target = addressIterator.next();
                DnsMessage recursive = null;
                try {
                    recursive = this.queryRecursive(resolutionState, q, target, record.name);
                }
                catch (IOException e) {
                    IterativeDnsClient.abortIfFatal(e);
                    LOGGER.log(Level.FINER, "Exception while recursing", e);
                    resolutionState.decrementSteps();
                    ioExceptions.add(e);
                    if (addressIterator.hasNext()) continue;
                    iterator.remove();
                    continue;
                }
                return recursive;
            }
        }
        for (Record record : authorities) {
            Question question = q.getQuestion();
            DnsName name = ((NS)record.payloadData).target;
            if (question.name.equals((Object)name) && (question.type == Record.TYPE.A || question.type == Record.TYPE.AAAA)) continue;
            IpResultSet res = null;
            try {
                res = this.resolveIpRecursive(resolutionState, name);
            }
            catch (IOException e) {
                resolutionState.decrementSteps();
                ioExceptions.add(e);
            }
            if (res == null) continue;
            for (InetAddress target : res.addresses) {
                DnsMessage recursive = null;
                try {
                    recursive = this.queryRecursive(resolutionState, q, target, record.name);
                }
                catch (IOException e) {
                    resolutionState.decrementSteps();
                    ioExceptions.add(e);
                    continue;
                }
                return recursive;
            }
        }
        MultipleIoException.throwIfRequired(ioExceptions);
        return null;
    }

    private IpResultSet resolveIpRecursive(ResolutionState resolutionState, DnsName name) throws IOException {
        InetAddress inetAddress;
        Question question;
        DnsMessage query;
        DnsMessage aMessage;
        IpResultSet.Builder res = this.newIpResultSetBuilder();
        if (this.ipVersionSetting.v4 && (aMessage = this.queryRecursive(resolutionState, query = this.getQueryFor(question = new Question(name, Record.TYPE.A)))) != null) {
            for (Record answer : aMessage.answerSection) {
                if (answer.isAnswer(question)) {
                    inetAddress = IterativeDnsClient.inetAddressFromRecord(name.ace, (A)answer.payloadData);
                    res.ipv4Addresses.add(inetAddress);
                    continue;
                }
                if (answer.type != Record.TYPE.CNAME || !answer.name.equals((Object)name)) continue;
                return this.resolveIpRecursive(resolutionState, ((RRWithTarget)answer.payloadData).target);
            }
        }
        if (this.ipVersionSetting.v6 && (aMessage = this.queryRecursive(resolutionState, query = this.getQueryFor(question = new Question(name, Record.TYPE.AAAA)))) != null) {
            for (Record answer : aMessage.answerSection) {
                if (answer.isAnswer(question)) {
                    inetAddress = IterativeDnsClient.inetAddressFromRecord(name.ace, (AAAA)answer.payloadData);
                    res.ipv6Addresses.add(inetAddress);
                    continue;
                }
                if (answer.type != Record.TYPE.CNAME || !answer.name.equals((Object)name)) continue;
                return this.resolveIpRecursive(resolutionState, ((RRWithTarget)answer.payloadData).target);
            }
        }
        return res.build();
    }

    private IpResultSet searchAdditional(DnsMessage message, DnsName name) {
        IpResultSet.Builder res = this.newIpResultSetBuilder();
        for (Record record : message.additionalSection) {
            if (!record.name.equals((Object)name)) continue;
            switch (record.type) {
                case A: {
                    res.ipv4Addresses.add(IterativeDnsClient.inetAddressFromRecord(name.ace, (A)record.payloadData));
                    break;
                }
                case AAAA: {
                    res.ipv6Addresses.add(IterativeDnsClient.inetAddressFromRecord(name.ace, (AAAA)record.payloadData));
                }
            }
        }
        return res.build();
    }

    private static InetAddress inetAddressFromRecord(String name, A recordPayload) {
        try {
            return InetAddress.getByAddress(name, recordPayload.getIp());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private static InetAddress inetAddressFromRecord(String name, AAAA recordPayload) {
        try {
            return InetAddress.getByAddress(name, recordPayload.getIp());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<InetAddress> getRootServer(char rootServerId) {
        return IterativeDnsClient.getRootServer(rootServerId, DEFAULT_IP_VERSION_SETTING);
    }

    public static List<InetAddress> getRootServer(char rootServerId, AbstractDnsClient.IpVersionSetting setting) {
        InetAddress ipv4Root = IPV4_ROOT_SERVER_MAP.get(Character.valueOf(rootServerId));
        InetAddress ipv6Root = IPV6_ROOT_SERVER_MAP.get(Character.valueOf(rootServerId));
        ArrayList<InetAddress> res = new ArrayList<InetAddress>(2);
        switch (setting) {
            case v4only: {
                if (ipv4Root == null) break;
                res.add(ipv4Root);
                break;
            }
            case v6only: {
                if (ipv6Root == null) break;
                res.add(ipv6Root);
                break;
            }
            case v4v6: {
                if (ipv4Root != null) {
                    res.add(ipv4Root);
                }
                if (ipv6Root == null) break;
                res.add(ipv6Root);
                break;
            }
            case v6v4: {
                if (ipv6Root != null) {
                    res.add(ipv6Root);
                }
                if (ipv4Root == null) break;
                res.add(ipv4Root);
            }
        }
        return res;
    }

    private static Inet4Address rootServerInet4Address(char rootServerId, int addr0, int addr1, int addr2, int addr3) {
        Inet4Address inetAddress;
        String name = rootServerId + ".root-servers.net";
        try {
            inetAddress = (Inet4Address)InetAddress.getByAddress(name, new byte[]{(byte)addr0, (byte)addr1, (byte)addr2, (byte)addr3});
            IPV4_ROOT_SERVER_MAP.put(Character.valueOf(rootServerId), inetAddress);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return inetAddress;
    }

    private static Inet6Address rootServerInet6Address(char rootServerId, int addr0, int addr1, int addr2, int addr3, int addr4, int addr5, int addr6, int addr7) {
        Inet6Address inetAddress;
        String name = rootServerId + ".root-servers.net";
        try {
            inetAddress = (Inet6Address)InetAddress.getByAddress(name, new byte[]{(byte)(addr0 >> 8), (byte)addr0, (byte)(addr1 >> 8), (byte)addr1, (byte)(addr2 >> 8), (byte)addr2, (byte)(addr3 >> 8), (byte)addr3, (byte)(addr4 >> 8), (byte)addr4, (byte)(addr5 >> 8), (byte)addr5, (byte)(addr6 >> 8), (byte)addr6, (byte)(addr7 >> 8), (byte)addr7});
            IPV6_ROOT_SERVER_MAP.put(Character.valueOf(rootServerId), inetAddress);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return inetAddress;
    }

    protected boolean isResponseCacheable(Question q, DnsMessage dnsMessage) {
        return dnsMessage.authoritativeAnswer;
    }

    protected DnsMessage.Builder newQuestion(DnsMessage.Builder message) {
        message.setRecursionDesired(false);
        message.getEdnsBuilder().setUdpPayloadSize(this.dataSource.getUdpPayloadSize());
        return message;
    }

    private IpResultSet.Builder newIpResultSetBuilder() {
        return new IpResultSet.Builder(this.insecureRandom);
    }

    protected static void abortIfFatal(IOException ioException) throws IOException {
        if (ioException instanceof IterativeClientException.LoopDetected) {
            throw ioException;
        }
    }

    private static class IpResultSet {
        final List<InetAddress> addresses;

        private IpResultSet(List<InetAddress> ipv4Addresses, List<InetAddress> ipv6Addresses, Random random) {
            int size;
            switch (DEFAULT_IP_VERSION_SETTING) {
                case v4only: {
                    size = ipv4Addresses.size();
                    break;
                }
                case v6only: {
                    size = ipv6Addresses.size();
                    break;
                }
                default: {
                    size = ipv4Addresses.size() + ipv6Addresses.size();
                }
            }
            if (size == 0) {
                this.addresses = Collections.emptyList();
            } else {
                if (DEFAULT_IP_VERSION_SETTING.v4) {
                    Collections.shuffle(ipv4Addresses, random);
                }
                if (DEFAULT_IP_VERSION_SETTING.v6) {
                    Collections.shuffle(ipv6Addresses, random);
                }
                ArrayList<InetAddress> addresses = new ArrayList<InetAddress>(size);
                switch (DEFAULT_IP_VERSION_SETTING) {
                    case v4only: {
                        addresses.addAll(ipv4Addresses);
                        break;
                    }
                    case v6only: {
                        addresses.addAll(ipv6Addresses);
                        break;
                    }
                    case v4v6: {
                        addresses.addAll(ipv4Addresses);
                        addresses.addAll(ipv6Addresses);
                        break;
                    }
                    case v6v4: {
                        addresses.addAll(ipv6Addresses);
                        addresses.addAll(ipv4Addresses);
                    }
                }
                this.addresses = Collections.unmodifiableList(addresses);
            }
        }

        private static class Builder {
            private final Random random;
            private final List<InetAddress> ipv4Addresses = new ArrayList<InetAddress>(8);
            private final List<InetAddress> ipv6Addresses = new ArrayList<InetAddress>(8);

            private Builder(Random random) {
                this.random = random;
            }

            public IpResultSet build() {
                return new IpResultSet(this.ipv4Addresses, this.ipv6Addresses, this.random);
            }
        }
    }
}

