/*
 * Decompiled with CFR 0.152.
 */
package org.mineskin;

import com.google.gson.Gson;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import org.mineskin.MineSkinClient;
import org.mineskin.MineSkinClientImpl;
import org.mineskin.RequestExecutors;
import org.mineskin.request.RequestHandler;
import org.mineskin.request.RequestHandlerConstructor;

public class ClientBuilder {
    private String userAgent = "MineSkinClient";
    private String apiKey = null;
    private int timeout = 10000;
    private Gson gson = new Gson();
    private Executor getExecutor = null;
    private Executor generateExecutor = null;
    private ScheduledExecutorService generateRequestScheduler = null;
    private ScheduledExecutorService getRequestScheduler = null;
    private ScheduledExecutorService jobCheckScheduler = null;
    private RequestHandlerConstructor requestHandlerConstructor = null;

    private ClientBuilder() {
    }

    public static ClientBuilder create() {
        return new ClientBuilder();
    }

    public ClientBuilder userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public ClientBuilder apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public ClientBuilder timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public ClientBuilder gson(Gson gson) {
        this.gson = gson;
        return this;
    }

    public ClientBuilder getExecutor(Executor getExecutor) {
        this.getExecutor = getExecutor;
        return this;
    }

    public ClientBuilder generateExecutor(Executor generateExecutor) {
        this.generateExecutor = generateExecutor;
        return this;
    }

    public ClientBuilder generateRequestScheduler(ScheduledExecutorService scheduledExecutor) {
        this.generateRequestScheduler = scheduledExecutor;
        return this;
    }

    public ClientBuilder getRequestScheduler(ScheduledExecutorService scheduledExecutor) {
        this.getRequestScheduler = scheduledExecutor;
        return this;
    }

    public ClientBuilder jobCheckScheduler(ScheduledExecutorService scheduledExecutor) {
        this.jobCheckScheduler = scheduledExecutor;
        return this;
    }

    public ClientBuilder requestHandler(RequestHandlerConstructor requestHandlerConstructor) {
        this.requestHandlerConstructor = requestHandlerConstructor;
        return this;
    }

    public MineSkinClient build() {
        if (this.requestHandlerConstructor == null) {
            throw new IllegalStateException("RequestHandlerConstructor is not set");
        }
        if ("MineSkinClient".equals(this.userAgent)) {
            MineSkinClientImpl.LOGGER.log(Level.WARNING, "Using default User-Agent: MineSkinClient - Please set a custom User-Agent");
        }
        if (this.apiKey == null) {
            MineSkinClientImpl.LOGGER.log(Level.WARNING, "Creating MineSkinClient without API key");
        }
        if (this.getExecutor == null) {
            this.getExecutor = Executors.newSingleThreadExecutor(r -> {
                Thread thread = new Thread(r);
                thread.setName("MineSkinClient/get");
                return thread;
            });
        }
        if (this.generateExecutor == null) {
            this.generateExecutor = Executors.newSingleThreadExecutor(r -> {
                Thread thread = new Thread(r);
                thread.setName("MineSkinClient/generate");
                return thread;
            });
        }
        if (this.generateRequestScheduler == null) {
            this.generateRequestScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread thread = new Thread(r);
                thread.setName("MineSkinClient/scheduler");
                return thread;
            });
        }
        if (this.getRequestScheduler == null) {
            this.getRequestScheduler = this.generateRequestScheduler;
        }
        if (this.jobCheckScheduler == null) {
            this.jobCheckScheduler = this.generateRequestScheduler;
        }
        RequestHandler requestHandler = this.requestHandlerConstructor.construct(this.userAgent, this.apiKey, this.timeout, this.gson);
        RequestExecutors executors = new RequestExecutors(this.getExecutor, this.generateExecutor, this.generateRequestScheduler, this.getRequestScheduler, this.jobCheckScheduler);
        return new MineSkinClientImpl(requestHandler, executors);
    }
}

