/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message.client;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.mariadb.jdbc.ServerPreparedStatement;
import org.mariadb.jdbc.client.context.Context;
import org.mariadb.jdbc.client.socket.PacketWriter;
import org.mariadb.jdbc.codec.Parameter;
import org.mariadb.jdbc.message.client.RedoableWithPrepareClientMessage;
import org.mariadb.jdbc.message.server.PrepareResultPacket;
import org.mariadb.jdbc.util.ParameterList;

public final class BulkExecutePacket
implements RedoableWithPrepareClientMessage {
    private List<ParameterList> batchParameterList;
    private final String command;
    private final ServerPreparedStatement prep;
    private PrepareResultPacket prepareResult;

    public BulkExecutePacket(PrepareResultPacket prepareResult, List<ParameterList> batchParameterList, String command, ServerPreparedStatement prep) {
        this.batchParameterList = batchParameterList;
        this.prepareResult = prepareResult;
        this.command = command;
        this.prep = prep;
    }

    @Override
    public void saveParameters() {
        ArrayList<ParameterList> savedList = new ArrayList<ParameterList>(this.batchParameterList.size());
        for (int i = 0; i < this.batchParameterList.size(); ++i) {
            savedList.add(this.batchParameterList.get(i).clone());
        }
        this.batchParameterList = savedList;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int encode(PacketWriter writer, Context context, PrepareResultPacket newPrepareResult) throws IOException, SQLException {
        statementId = newPrepareResult != null && newPrepareResult.getStatementId() != -1 ? newPrepareResult.getStatementId() : (this.prepareResult != null ? this.prepareResult.getStatementId() : -1);
        paramIterator = this.batchParameterList.iterator();
        parameters = paramIterator.next();
        parameterCount = parameters.size();
        parameterHeaderType = new Parameter[parameterCount];
        for (i = 0; i < parameterCount; ++i) {
            parameterHeaderType[i] = parameters.get(i);
        }
        lastCmdData = null;
        bulkPacketNo = 0;
        block1: while (true) {
            ++bulkPacketNo;
            writer.initPacket();
            writer.writeByte(250);
            writer.writeInt(statementId);
            writer.writeShort((short)128);
            for (i = 0; i < parameterCount; ++i) {
                writer.writeShort((short)parameterHeaderType[i].getBinaryEncodeType());
            }
            if (lastCmdData != null) {
                writer.checkMaxAllowedLength(lastCmdData.length);
                writer.writeBytes(lastCmdData);
                writer.mark();
                lastCmdData = null;
                if (!paramIterator.hasNext()) break;
                parameters = paramIterator.next();
            }
            while (true) {
                for (i = 0; i < parameterCount; ++i) {
                    param = parameters.get(i);
                    if (param.isNull()) {
                        writer.writeByte(1);
                        continue;
                    }
                    writer.writeByte(0);
                    param.encodeBinary(writer);
                }
                if (!writer.isMarked() && writer.hasFlushed()) {
                    writer.flush();
                    if (!paramIterator.hasNext()) break block1;
                    parameters = paramIterator.next();
                    j = 0;
                    while (true) {
                        if (j >= parameterCount) continue block1;
                        parameterHeaderType[j] = parameters.get(j);
                        ++j;
                    }
                }
                writer.mark();
                if (writer.bufIsDataAfterMark()) {
                    lastCmdData = writer.resetMark();
                    continue block1;
                }
                if (!paramIterator.hasNext()) break block1;
                parameters = paramIterator.next();
                i = 0;
                while (true) {
                    if (i >= parameterCount) ** continue;
                    if (parameterHeaderType[i].getBinaryEncodeType() != parameters.get(i).getBinaryEncodeType()) {
                        writer.flush();
                        j = 0;
                        while (true) {
                            if (j < parameterCount) ** break;
                            continue block1;
                            parameterHeaderType[j] = parameters.get(j);
                            ++j;
                        }
                    }
                    ++i;
                }
                break;
            }
            break;
        }
        writer.flush();
        return bulkPacketNo;
    }

    @Override
    public int batchUpdateLength() {
        return this.batchParameterList.size();
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public ServerPreparedStatement prep() {
        return this.prep;
    }

    @Override
    public boolean binaryProtocol() {
        return true;
    }

    @Override
    public String description() {
        return this.command;
    }

    @Override
    public void setPrepareResult(PrepareResultPacket prepareResult) {
        this.prepareResult = prepareResult;
    }
}

