/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.failover.FailoverProxy;
import org.mariadb.jdbc.internal.failover.impl.AuroraListener;
import org.mariadb.jdbc.internal.failover.impl.MastersFailoverListener;
import org.mariadb.jdbc.internal.failover.impl.MastersSlavesListener;
import org.mariadb.jdbc.internal.io.LruTraceCache;
import org.mariadb.jdbc.internal.io.socket.SocketHandlerFunction;
import org.mariadb.jdbc.internal.io.socket.SocketUtility;
import org.mariadb.jdbc.internal.logging.ProtocolLoggingProxy;
import org.mariadb.jdbc.internal.protocol.AuroraProtocol;
import org.mariadb.jdbc.internal.protocol.MasterProtocol;
import org.mariadb.jdbc.internal.protocol.MastersSlavesProtocol;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.pool.GlobalStateInfo;
import org.mariadb.jdbc.util.ConfigurableSocketFactory;
import org.mariadb.jdbc.util.Options;

public class Utils {
    private static final char[] hexArray;
    private static final Pattern IP_V4;
    private static final Pattern IP_V6;
    private static final Pattern IP_V6_COMPRESSED;
    private static final SocketHandlerFunction socketHandler;

    public static Socket standardSocket(Options options, String host) throws IOException {
        String socketFactoryName = options.socketFactory;
        if (socketFactoryName != null) {
            try {
                Class<?> socketFactoryClass = Class.forName(socketFactoryName);
                if (socketFactoryClass != null) {
                    Constructor<?> constructor = socketFactoryClass.getConstructor(new Class[0]);
                    SocketFactory socketFactory = (SocketFactory)constructor.newInstance(new Object[0]);
                    if (ConfigurableSocketFactory.class.isInstance(socketFactory)) {
                        ((ConfigurableSocketFactory)socketFactory).setConfiguration(options, host);
                    }
                    return socketFactory.createSocket();
                }
            }
            catch (Exception exp) {
                throw new IOException("Socket factory failed to initialized with option \"socketFactory\" set to \"" + options.socketFactory + "\"", exp);
            }
        }
        SocketFactory socketFactory = SocketFactory.getDefault();
        return socketFactory.createSocket();
    }

    public static String escapeString(String value, boolean noBackslashEscapes) {
        if (!value.contains("'")) {
            if (noBackslashEscapes) {
                return value;
            }
            if (!value.contains("\\")) {
                return value;
            }
        }
        String escaped = value.replace("'", "''");
        if (noBackslashEscapes) {
            return escaped;
        }
        return escaped.replace("\\", "\\\\");
    }

    public static byte[] encryptPassword(String password, byte[] seed, String passwordCharacterEncoding) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (password == null || password.isEmpty()) {
            return new byte[0];
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] bytePwd = passwordCharacterEncoding != null && !passwordCharacterEncoding.isEmpty() ? password.getBytes(passwordCharacterEncoding) : password.getBytes();
        byte[] stage1 = messageDigest.digest(bytePwd);
        messageDigest.reset();
        byte[] stage2 = messageDigest.digest(stage1);
        messageDigest.reset();
        messageDigest.update(seed);
        messageDigest.update(stage2);
        byte[] digest = messageDigest.digest();
        byte[] returnBytes = new byte[digest.length];
        for (int i = 0; i < digest.length; ++i) {
            returnBytes[i] = (byte)(stage1[i] ^ digest[i]);
        }
        return returnBytes;
    }

    public static byte[] copyWithLength(byte[] orig, int length) {
        byte[] result = new byte[length];
        int howMuchToCopy = length < orig.length ? length : orig.length;
        System.arraycopy(orig, 0, result, 0, howMuchToCopy);
        return result;
    }

    public static byte[] copyRange(byte[] orig, int from, int to) {
        int length = to - from;
        byte[] result = new byte[length];
        int howMuchToCopy = orig.length - from < length ? orig.length - from : length;
        System.arraycopy(orig, from, result, 0, howMuchToCopy);
        return result;
    }

    private static String replaceFunctionParameter(String functionString, Protocol protocol) {
        String func;
        int index;
        char[] input = functionString.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (index = 0; index < input.length && input[index] == ' '; ++index) {
        }
        while ((input[index] >= 'a' && input[index] <= 'z' || input[index] >= 'A' && input[index] <= 'Z') && index < input.length) {
            sb.append(input[index]);
            ++index;
        }
        switch (func = sb.toString().toLowerCase(Locale.ROOT)) {
            case "convert": {
                int endParam;
                int lastCommaIndex = functionString.lastIndexOf(44);
                int firstParentheses = functionString.indexOf(40);
                String value = functionString.substring(firstParentheses + 1, lastCommaIndex);
                for (index = lastCommaIndex + 1; index < input.length && Character.isWhitespace(input[index]); ++index) {
                }
                for (endParam = index + 1; endParam < input.length && (input[endParam] >= 'a' && input[endParam] <= 'z' || input[endParam] >= 'A' && input[endParam] <= 'Z' || input[endParam] == '_'); ++endParam) {
                }
                String typeParam = new String(input, index, endParam - index).toUpperCase(Locale.ROOT);
                if (typeParam.startsWith("SQL_")) {
                    typeParam = typeParam.substring(4);
                }
                switch (typeParam) {
                    case "BOOLEAN": {
                        return "1=" + value;
                    }
                    case "BIGINT": 
                    case "SMALLINT": 
                    case "TINYINT": {
                        typeParam = "SIGNED INTEGER";
                        break;
                    }
                    case "BIT": {
                        typeParam = "UNSIGNED INTEGER";
                        break;
                    }
                    case "BLOB": 
                    case "VARBINARY": 
                    case "LONGVARBINARY": 
                    case "ROWID": {
                        typeParam = "BINARY";
                        break;
                    }
                    case "NCHAR": 
                    case "CLOB": 
                    case "NCLOB": 
                    case "DATALINK": 
                    case "VARCHAR": 
                    case "NVARCHAR": 
                    case "LONGVARCHAR": 
                    case "LONGNVARCHAR": 
                    case "SQLXML": 
                    case "LONGNCHAR": {
                        typeParam = "CHAR";
                        break;
                    }
                    case "DOUBLE": 
                    case "FLOAT": {
                        if (protocol.isServerMariaDb() || protocol.versionGreaterOrEqual(8, 0, 17)) {
                            typeParam = "DOUBLE";
                            break;
                        }
                        return "0.0+" + value;
                    }
                    case "REAL": 
                    case "NUMERIC": {
                        typeParam = "DECIMAL";
                        break;
                    }
                    case "TIMESTAMP": {
                        typeParam = "DATETIME";
                        break;
                    }
                }
                return new String(input, 0, index) + typeParam + new String(input, endParam, input.length - endParam);
            }
            case "timestampdiff": 
            case "timestampadd": {
                String paramPrefix;
                while (index < input.length && (Character.isWhitespace(input[index]) || input[index] == '(')) {
                    ++index;
                }
                if (index < input.length - 8 && "SQL_TSI_".equals(paramPrefix = new String(input, index, 8))) {
                    return new String(input, 0, index) + new String(input, index + 8, input.length - (index + 8));
                }
                return functionString;
            }
        }
        return functionString;
    }

    private static String resolveEscapes(String escaped, Protocol protocol) throws SQLException {
        block15: {
            block14: {
                if (escaped.charAt(0) != '{' || escaped.charAt(escaped.length() - 1) != '}') {
                    throw new SQLException("unexpected escaped string");
                }
                int endIndex = escaped.length() - 1;
                String escapedLower = escaped.toLowerCase(Locale.ROOT);
                if (escaped.startsWith("{fn ")) {
                    String resolvedParams = Utils.replaceFunctionParameter(escaped.substring(4, endIndex), protocol);
                    return Utils.nativeSql(resolvedParams, protocol);
                }
                if (escapedLower.startsWith("{oj ")) {
                    return Utils.nativeSql(escaped.substring(4, endIndex), protocol);
                }
                if (escaped.startsWith("{d ")) {
                    return escaped.substring(3, endIndex);
                }
                if (escaped.startsWith("{t ")) {
                    return escaped.substring(3, endIndex);
                }
                if (escaped.startsWith("{ts ")) {
                    return escaped.substring(4, endIndex);
                }
                if (escaped.startsWith("{d'")) {
                    return escaped.substring(2, endIndex);
                }
                if (escaped.startsWith("{t'")) {
                    return escaped.substring(2, endIndex);
                }
                if (escaped.startsWith("{ts'")) {
                    return escaped.substring(3, endIndex);
                }
                if (escaped.startsWith("{call ") || escaped.startsWith("{CALL ")) {
                    return Utils.nativeSql(escaped.substring(1, endIndex), protocol);
                }
                if (escaped.startsWith("{escape ")) {
                    return escaped.substring(1, endIndex);
                }
                if (escaped.startsWith("{?")) {
                    return Utils.nativeSql(escaped.substring(1, endIndex), protocol);
                }
                if (!escaped.startsWith("{ ") && !escaped.startsWith("{\n")) break block14;
                for (int i = 2; i < escaped.length(); ++i) {
                    if (Character.isWhitespace(escaped.charAt(i))) continue;
                    return Utils.resolveEscapes("{" + escaped.substring(i), protocol);
                }
                break block15;
            }
            if (!escaped.startsWith("{\r\n")) break block15;
            for (int i = 3; i < escaped.length(); ++i) {
                if (Character.isWhitespace(escaped.charAt(i))) continue;
                return Utils.resolveEscapes("{" + escaped.substring(i), protocol);
            }
        }
        throw new SQLException("unknown escape sequence " + escaped);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String nativeSql(String sql, Protocol protocol) throws SQLException {
        if (!sql.contains("{")) {
            return sql;
        }
        StringBuilder escapeSequenceBuf = new StringBuilder();
        StringBuilder sqlBuffer = new StringBuilder();
        char[] charArray = sql.toCharArray();
        char lastChar = '\u0000';
        boolean inQuote = false;
        char quoteChar = '\u0000';
        boolean inComment = false;
        boolean isSlashSlashComment = false;
        int inEscapeSeq = 0;
        block8: for (int i = 0; i < charArray.length; ++i) {
            char car = charArray[i];
            if (lastChar == '\\' && !protocol.noBackslashEscapes()) {
                sqlBuffer.append(car);
                lastChar = ' ';
                continue;
            }
            switch (car) {
                case '\"': 
                case '\'': 
                case '`': {
                    if (inComment) break;
                    if (inQuote) {
                        if (quoteChar != car) break;
                        inQuote = false;
                        break;
                    }
                    inQuote = true;
                    quoteChar = car;
                    break;
                }
                case '*': {
                    if (inQuote || inComment || lastChar != 47) break;
                    inComment = true;
                    isSlashSlashComment = false;
                    break;
                }
                case '-': 
                case '/': {
                    if (inQuote) break;
                    if (inComment) {
                        if (lastChar == '*' && !isSlashSlashComment) {
                            inComment = false;
                            break;
                        }
                        if (lastChar != car || !isSlashSlashComment) break;
                        inComment = false;
                        break;
                    }
                    if (lastChar == car) {
                        inComment = true;
                        isSlashSlashComment = true;
                        break;
                    }
                    if (lastChar != 42) break;
                    inComment = true;
                    isSlashSlashComment = false;
                    break;
                }
                case '\n': {
                    if (!inComment || !isSlashSlashComment) break;
                    inComment = false;
                    break;
                }
                case '{': {
                    if (inQuote || inComment) break;
                    ++inEscapeSeq;
                    break;
                }
                case '}': {
                    if (inQuote || inComment || --inEscapeSeq != 0) break;
                    escapeSequenceBuf.append(car);
                    sqlBuffer.append(Utils.resolveEscapes(escapeSequenceBuf.toString(), protocol));
                    escapeSequenceBuf.setLength(0);
                    lastChar = car;
                    continue block8;
                }
            }
            lastChar = car;
            if (inEscapeSeq > 0) {
                escapeSequenceBuf.append(car);
                continue;
            }
            sqlBuffer.append(car);
        }
        if (inEscapeSeq > 0) {
            throw new SQLException("Invalid escape sequence , missing closing '}' character in '" + sqlBuffer);
        }
        return sqlBuffer.toString();
    }

    public static Protocol retrieveProxy(UrlParser urlParser, GlobalStateInfo globalInfo) throws SQLException {
        ReentrantLock lock = new ReentrantLock();
        LruTraceCache traceCache = urlParser.getOptions().enablePacketDebug ? new LruTraceCache() : null;
        switch (urlParser.getHaMode()) {
            case AURORA: {
                return Utils.getProxyLoggingIfNeeded(urlParser, (Protocol)Proxy.newProxyInstance(AuroraProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new AuroraListener(urlParser, globalInfo), lock, traceCache)));
            }
            case REPLICATION: {
                return Utils.getProxyLoggingIfNeeded(urlParser, (Protocol)Proxy.newProxyInstance(MastersSlavesProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new MastersSlavesListener(urlParser, globalInfo), lock, traceCache)));
            }
            case LOADBALANCE: 
            case SEQUENTIAL: {
                return Utils.getProxyLoggingIfNeeded(urlParser, (Protocol)Proxy.newProxyInstance(MasterProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new MastersFailoverListener(urlParser, globalInfo), lock, traceCache)));
            }
        }
        Protocol protocol = Utils.getProxyLoggingIfNeeded(urlParser, new MasterProtocol(urlParser, globalInfo, lock, traceCache));
        protocol.connectWithoutProxy();
        return protocol;
    }

    private static Protocol getProxyLoggingIfNeeded(UrlParser urlParser, Protocol protocol) {
        if (urlParser.getOptions().profileSql || urlParser.getOptions().slowQueryThresholdNanos != null) {
            return (Protocol)Proxy.newProxyInstance(MasterProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new ProtocolLoggingProxy(protocol, urlParser.getOptions()));
        }
        return protocol;
    }

    public static TimeZone getTimeZone(String id) throws SQLException {
        TimeZone tz = TimeZone.getTimeZone(id);
        if ("GMT".equals(tz.getID()) && !"GMT".equals(id)) {
            throw new SQLException("invalid timezone id '" + id + "'");
        }
        return tz;
    }

    public static Socket createSocket(Options options, String host) throws IOException {
        return socketHandler.apply(options, host);
    }

    public static String hexdump(byte[] ... bytes) {
        return Utils.hexdump(Integer.MAX_VALUE, 0, Integer.MAX_VALUE, bytes);
    }

    public static String hexdump(int maxQuerySizeToLog, int offset, int length, byte[] ... byteArr) {
        byte[] concat;
        switch (byteArr.length) {
            case 0: {
                return "";
            }
            case 1: {
                byte[] bytes = byteArr[0];
                if (bytes.length <= offset) {
                    return "";
                }
                int dataLength = Math.min(maxQuerySizeToLog, Math.min(bytes.length - offset, length));
                StringBuilder outputBuilder = new StringBuilder(dataLength * 5);
                outputBuilder.append("\n");
                Utils.writeHex(bytes, offset, dataLength, outputBuilder);
                return outputBuilder.toString();
            }
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            outputStream.write(byteArr[0]);
            outputStream.write(byteArr[1], offset, Math.min(length, byteArr[1].length));
            for (int i = 2; i < byteArr.length; ++i) {
                outputStream.write(byteArr[i]);
            }
        }
        catch (IOException i) {
            // empty catch block
        }
        if ((concat = outputStream.toByteArray()).length <= offset) {
            return "";
        }
        int stlength = Math.min(maxQuerySizeToLog, outputStream.size());
        StringBuilder out = new StringBuilder(stlength * 3 + 80);
        out.append("\n");
        Utils.writeHex(outputStream.toByteArray(), 0, outputStream.size(), out);
        return out.toString();
    }

    private static void writeHex(byte[] bytes, int offset, int dataLength, StringBuilder outputBuilder) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        char[] hexaValue = new char[16];
        hexaValue[8] = 32;
        int posHexa = 0;
        outputBuilder.append("+--------------------------------------------------+\n|  0  1  2  3  4  5  6  7   8  9  a  b  c  d  e  f |\n+--------------------------------------------------+------------------+\n| ");
        for (int pos = offset; pos < dataLength + offset; ++pos) {
            int byteValue = bytes[pos] & 0xFF;
            outputBuilder.append(hexArray[byteValue >>> 4]).append(hexArray[byteValue & 0xF]).append(" ");
            int n = hexaValue[posHexa++] = byteValue > 31 && byteValue < 127 ? (int)byteValue : 46;
            if (posHexa == 8) {
                outputBuilder.append(" ");
            }
            if (posHexa != 16) continue;
            outputBuilder.append("| ").append(hexaValue).append(" |\n");
            if (pos + 1 != dataLength + offset) {
                outputBuilder.append("| ");
            }
            posHexa = 0;
        }
        int remaining = posHexa;
        if (remaining > 0) {
            if (remaining < 8) {
                while (remaining < 8) {
                    outputBuilder.append("   ");
                    ++remaining;
                }
                outputBuilder.append(" ");
            }
            while (remaining < 16) {
                outputBuilder.append("   ");
                ++remaining;
            }
            while (posHexa < 16) {
                hexaValue[posHexa] = 32;
                ++posHexa;
            }
            outputBuilder.append("| ").append(hexaValue).append(" |\n");
        }
        outputBuilder.append("+--------------------------------------------------+------------------+\n");
    }

    private static String getHex(byte[] raw) {
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(hexArray[(b & 0xF0) >> 4]).append(hexArray[b & 0xF]);
        }
        return hex.toString();
    }

    public static String byteArrayToHexString(byte[] bytes) {
        return bytes != null ? Utils.getHex(bytes) : "";
    }

    public static String intToHexString(int value) {
        StringBuilder hex = new StringBuilder(8);
        boolean nullEnd = false;
        for (int offset = 24; offset >= 0; offset -= 8) {
            byte b = (byte)(value >> offset);
            if (b == 0 && !nullEnd) continue;
            nullEnd = true;
            hex.append(hexArray[(b & 0xF0) >> 4]).append(hexArray[b & 0xF]);
        }
        return hex.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String parseSessionVariables(String sessionVariable) {
        char[] chars;
        StringBuilder out = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        Parse state = Parse.Normal;
        boolean iskey = true;
        boolean singleQuotes = true;
        boolean first = true;
        String key = null;
        block7: for (char car : chars = sessionVariable.toCharArray()) {
            if (state == Parse.Escape) {
                sb.append(car);
                state = singleQuotes ? Parse.Quote : Parse.String;
                continue;
            }
            switch (car) {
                case '\"': {
                    if (state == Parse.Normal) {
                        state = Parse.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state != Parse.String || singleQuotes) break;
                    state = Parse.Normal;
                    break;
                }
                case '\'': {
                    if (state == Parse.Normal) {
                        state = Parse.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state != Parse.String || !singleQuotes) break;
                    state = Parse.Normal;
                    break;
                }
                case '\\': {
                    if (state != Parse.String) break;
                    state = Parse.Escape;
                    break;
                }
                case ',': 
                case ';': {
                    if (state != Parse.Normal) break;
                    if (!iskey) {
                        if (!first) {
                            out.append(",");
                        }
                        out.append(key);
                        out.append(sb.toString());
                        first = false;
                    } else {
                        key = sb.toString().trim();
                        if (!key.isEmpty()) {
                            if (!first) {
                                out.append(",");
                            }
                            out.append(key);
                            first = false;
                        }
                    }
                    iskey = true;
                    key = null;
                    sb = new StringBuilder();
                    continue block7;
                }
                case '=': {
                    if (state != Parse.Normal || !iskey) break;
                    key = sb.toString().trim();
                    iskey = false;
                    sb = new StringBuilder();
                }
            }
            sb.append(car);
        }
        if (!iskey) {
            if (!first) {
                out.append(",");
            }
            out.append(key);
            out.append(sb.toString());
            return out.toString();
        }
        String tmpkey = sb.toString().trim();
        if (!tmpkey.isEmpty() && !first) {
            out.append(",");
        }
        out.append(tmpkey);
        return out.toString();
    }

    public static boolean isIPv4(String ip) {
        return IP_V4.matcher(ip).matches();
    }

    public static boolean isIPv6(String ip) {
        return IP_V6.matcher(ip).matches() || IP_V6_COMPRESSED.matcher(ip).matches();
    }

    public static int transactionFromString(String txIsolation) throws SQLException {
        switch (txIsolation) {
            case "READ-UNCOMMITTED": {
                return 1;
            }
            case "READ-COMMITTED": {
                return 2;
            }
            case "REPEATABLE-READ": {
                return 4;
            }
            case "SERIALIZABLE": {
                return 8;
            }
        }
        throw new SQLException("unknown transaction isolation level");
    }

    public static boolean validateFileName(String sql, ParameterHolder[] parameters, String fileName) {
        Pattern pattern = Pattern.compile("^(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*LOAD\\s+DATA\\s+((LOW_PRIORITY|CONCURRENT)\\s+)?LOCAL\\s+INFILE\\s+'" + fileName + "'", 2);
        if (pattern.matcher(sql).find()) {
            return true;
        }
        if (parameters != null && (pattern = Pattern.compile("^(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*LOAD\\s+DATA\\s+((LOW_PRIORITY|CONCURRENT)\\s+)?LOCAL\\s+INFILE\\s+\\?", 2)).matcher(sql).find() && parameters.length > 0) {
            return parameters[0].toString().toLowerCase().equals("'" + fileName.toLowerCase() + "'");
        }
        return false;
    }

    static {
        SocketHandlerFunction init;
        hexArray = "0123456789ABCDEF".toCharArray();
        IP_V4 = Pattern.compile("^(([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){1}(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){2}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
        IP_V6 = Pattern.compile("^[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){7}$");
        IP_V6_COMPRESSED = Pattern.compile("^(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)::(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)$");
        try {
            init = SocketUtility.getSocketHandler();
        }
        catch (Throwable t) {
            SocketHandlerFunction defaultSocketHandler;
            init = defaultSocketHandler = (options, host) -> Utils.standardSocket(options, host);
        }
        socketHandler = init;
    }

    private static enum Parse {
        Normal,
        String,
        Quote,
        Escape;

    }
}

