/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLX12;
import org.lwjgl.opengl.GLXCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.linux.XVisualInfo;

public class GLX13
extends GLX12 {
    public static final int GLX_WINDOW_BIT = 1;
    public static final int GLX_PIXMAP_BIT = 2;
    public static final int GLX_PBUFFER_BIT = 4;
    public static final int GLX_RGBA_BIT = 1;
    public static final int GLX_COLOR_INDEX_BIT = 2;
    public static final int GLX_PBUFFER_CLOBBER_MASK = 0x8000000;
    public static final int GLX_FRONT_LEFT_BUFFER_BIT = 1;
    public static final int GLX_FRONT_RIGHT_BUFFER_BIT = 2;
    public static final int GLX_BACK_LEFT_BUFFER_BIT = 4;
    public static final int GLX_BACK_RIGHT_BUFFER_BIT = 8;
    public static final int GLX_AUX_BUFFERS_BIT = 16;
    public static final int GLX_DEPTH_BUFFER_BIT = 32;
    public static final int GLX_STENCIL_BUFFER_BIT = 64;
    public static final int GLX_ACCUM_BUFFER_BIT = 128;
    public static final int GLX_CONFIG_CAVEAT = 32;
    public static final int GLX_X_VISUAL_TYPE = 34;
    public static final int GLX_TRANSPARENT_TYPE = 35;
    public static final int GLX_TRANSPARENT_INDEX_VALUE = 36;
    public static final int GLX_TRANSPARENT_RED_VALUE = 37;
    public static final int GLX_TRANSPARENT_GREEN_VALUE = 38;
    public static final int GLX_TRANSPARENT_BLUE_VALUE = 39;
    public static final int GLX_TRANSPARENT_ALPHA_VALUE = 40;
    public static final int GLX_DONT_CARE = -1;
    public static final int GLX_NONE = 32768;
    public static final int GLX_SLOW_CONFIG = 32769;
    public static final int GLX_TRUE_COLOR = 32770;
    public static final int GLX_DIRECT_COLOR = 32771;
    public static final int GLX_PSEUDO_COLOR = 32772;
    public static final int GLX_STATIC_COLOR = 32773;
    public static final int GLX_GRAY_SCALE = 32774;
    public static final int GLX_STATIC_GRAY = 32775;
    public static final int GLX_TRANSPARENT_RGB = 32776;
    public static final int GLX_TRANSPARENT_INDEX = 32777;
    public static final int GLX_VISUAL_ID = 32779;
    public static final int GLX_SCREEN = 32780;
    public static final int GLX_NON_CONFORMANT_CONFIG = 32781;
    public static final int GLX_DRAWABLE_TYPE = 32784;
    public static final int GLX_RENDER_TYPE = 32785;
    public static final int GLX_X_RENDERABLE = 32786;
    public static final int GLX_FBCONFIG_ID = 32787;
    public static final int GLX_RGBA_TYPE = 32788;
    public static final int GLX_COLOR_INDEX_TYPE = 32789;
    public static final int GLX_MAX_PBUFFER_WIDTH = 32790;
    public static final int GLX_MAX_PBUFFER_HEIGHT = 32791;
    public static final int GLX_MAX_PBUFFER_PIXELS = 32792;
    public static final int GLX_PRESERVED_CONTENTS = 32795;
    public static final int GLX_LARGEST_PBUFFER = 32796;
    public static final int GLX_WIDTH = 32797;
    public static final int GLX_HEIGHT = 32798;
    public static final int GLX_EVENT_MASK = 32799;
    public static final int GLX_DAMAGED = 32800;
    public static final int GLX_SAVED = 32801;
    public static final int GLX_WINDOW = 32802;
    public static final int GLX_PBUFFER = 32803;
    public static final int GLX_PBUFFER_HEIGHT = 32832;
    public static final int GLX_PBUFFER_WIDTH = 32833;

    protected GLX13() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLXCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glXGetFBConfigs, caps.glXChooseFBConfig, caps.glXGetFBConfigAttrib, caps.glXGetVisualFromFBConfig, caps.glXCreateWindow, caps.glXCreatePixmap, caps.glXDestroyPixmap, caps.glXCreatePbuffer, caps.glXDestroyPbuffer, caps.glXQueryDrawable, caps.glXCreateNewContext, caps.glXMakeContextCurrent, caps.glXGetCurrentReadDrawable, caps.glXQueryContext, caps.glXSelectEvent, caps.glXGetSelectedEvent});
    }

    public static long nglXGetFBConfigs(long display, int screen, long nelements) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetFBConfigs;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
        }
        return JNI.callPPP((long)__functionAddress, (long)display, (int)screen, (long)nelements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="GLXFBConfig *")
    public static PointerBuffer glXGetFBConfigs(@NativeType(value="Display *") long display, int screen) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer nelements = stack.callocInt(1);
        try {
            long __result = GLX13.nglXGetFBConfigs(display, screen, MemoryUtil.memAddress((IntBuffer)nelements));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe((long)__result, (int)nelements.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nglXChooseFBConfig(long display, int screen, long attrib_list, long nelements) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXChooseFBConfig;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
        }
        return JNI.callPPPP((long)__functionAddress, (long)display, (int)screen, (long)attrib_list, (long)nelements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="GLXFBConfig *")
    public static PointerBuffer glXChooseFBConfig(@NativeType(value="Display *") long display, int screen, @Nullable @NativeType(value="int const *") IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((IntBuffer)attrib_list);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer nelements = stack.callocInt(1);
        try {
            long __result = GLX13.nglXChooseFBConfig(display, screen, MemoryUtil.memAddressSafe((IntBuffer)attrib_list), MemoryUtil.memAddress((IntBuffer)nelements));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe((long)__result, (int)nelements.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nglXGetFBConfigAttrib(long display, long config, int attribute, long value) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetFBConfigAttrib;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)config);
        }
        return JNI.callPPPI((long)__functionAddress, (long)display, (long)config, (int)attribute, (long)value);
    }

    public static int glXGetFBConfigAttrib(@NativeType(value="Display *") long display, @NativeType(value="GLXFBConfig") long config, int attribute, @NativeType(value="int *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, (int)1);
        }
        return GLX13.nglXGetFBConfigAttrib(display, config, attribute, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static long nglXGetVisualFromFBConfig(long display, long config) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetVisualFromFBConfig;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)config);
        }
        return JNI.callPPP((long)__functionAddress, (long)display, (long)config);
    }

    @Nullable
    @NativeType(value="XVisualInfo *")
    public static XVisualInfo glXGetVisualFromFBConfig(@NativeType(value="Display *") long display, @NativeType(value="GLXFBConfig") long config) {
        long __result = GLX13.nglXGetVisualFromFBConfig(display, config);
        return XVisualInfo.createSafe((long)__result);
    }

    public static long nglXCreateWindow(long display, long config, long win, long attrib_list) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXCreateWindow;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)config);
        }
        return JNI.callPPPPP((long)__functionAddress, (long)display, (long)config, (long)win, (long)attrib_list);
    }

    @NativeType(value="GLXWindow")
    public static long glXCreateWindow(@NativeType(value="Display *") long display, @NativeType(value="GLXFBConfig") long config, @NativeType(value="Window") long win, @Nullable @NativeType(value="int const *") IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((IntBuffer)attrib_list);
        }
        return GLX13.nglXCreateWindow(display, config, win, MemoryUtil.memAddressSafe((IntBuffer)attrib_list));
    }

    public static long nglXCreatePixmap(long display, long config, long pixmap, long attrib_list) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXCreatePixmap;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)config);
        }
        return JNI.callPPPPP((long)__functionAddress, (long)display, (long)config, (long)pixmap, (long)attrib_list);
    }

    @NativeType(value="GLXPixmap")
    public static long glXCreatePixmap(@NativeType(value="Display *") long display, @NativeType(value="GLXFBConfig") long config, @NativeType(value="Pixmap") long pixmap, @Nullable @NativeType(value="int const *") IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((IntBuffer)attrib_list);
        }
        return GLX13.nglXCreatePixmap(display, config, pixmap, MemoryUtil.memAddressSafe((IntBuffer)attrib_list));
    }

    public static void glXDestroyPixmap(@NativeType(value="Display *") long display, @NativeType(value="GLXPixmap") long pixmap) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXDestroyPixmap;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)pixmap);
        }
        JNI.callPPV((long)__functionAddress, (long)display, (long)pixmap);
    }

    public static long nglXCreatePbuffer(long display, long config, long attrib_list) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXCreatePbuffer;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)config);
        }
        return JNI.callPPPP((long)__functionAddress, (long)display, (long)config, (long)attrib_list);
    }

    @NativeType(value="GLXPbuffer")
    public static long glXCreatePbuffer(@NativeType(value="Display *") long display, @NativeType(value="GLXFBConfig") long config, @Nullable @NativeType(value="int const *") IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((IntBuffer)attrib_list);
        }
        return GLX13.nglXCreatePbuffer(display, config, MemoryUtil.memAddressSafe((IntBuffer)attrib_list));
    }

    public static void glXDestroyPbuffer(@NativeType(value="Display *") long display, @NativeType(value="GLXPbuffer") long pbuf) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXDestroyPbuffer;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)pbuf);
        }
        JNI.callPPV((long)__functionAddress, (long)display, (long)pbuf);
    }

    public static void nglXQueryDrawable(long display, long draw, int attribute, long value) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryDrawable;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)draw);
        }
        JNI.callPPPV((long)__functionAddress, (long)display, (long)draw, (int)attribute, (long)value);
    }

    public static void glXQueryDrawable(@NativeType(value="Display *") long display, @NativeType(value="GLXDrawable") long draw, int attribute, @NativeType(value="unsigned int *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, (int)1);
        }
        GLX13.nglXQueryDrawable(display, draw, attribute, MemoryUtil.memAddress((IntBuffer)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glXQueryDrawable(@NativeType(value="Display *") long display, @NativeType(value="GLXDrawable") long draw, int attribute) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer value = stack.callocInt(1);
            GLX13.nglXQueryDrawable(display, draw, attribute, MemoryUtil.memAddress((IntBuffer)value));
            int n = value.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="GLXContext")
    public static long glXCreateNewContext(@NativeType(value="Display *") long display, @NativeType(value="GLXFBConfig") long config, int render_type, @NativeType(value="GLXContext") long share_list, @NativeType(value="Bool") boolean direct) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXCreateNewContext;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)config);
        }
        return JNI.callPPPP((long)__functionAddress, (long)display, (long)config, (int)render_type, (long)share_list, (int)(direct ? 1 : 0));
    }

    @NativeType(value="Bool")
    public static boolean glXMakeContextCurrent(@NativeType(value="Display *") long display, @NativeType(value="GLXDrawable") long draw, @NativeType(value="GLXDrawable") long read, @NativeType(value="GLXContext") long ctx) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXMakeContextCurrent;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
        }
        return JNI.callPPPPI((long)__functionAddress, (long)display, (long)draw, (long)read, (long)ctx) != 0;
    }

    @NativeType(value="GLXDrawable")
    public static long glXGetCurrentReadDrawable() {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetCurrentReadDrawable;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callP((long)__functionAddress);
    }

    public static int nglXQueryContext(long display, long ctx, int attribute, long value) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryContext;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)ctx);
        }
        return JNI.callPPPI((long)__functionAddress, (long)display, (long)ctx, (int)attribute, (long)value);
    }

    public static int glXQueryContext(@NativeType(value="Display *") long display, @NativeType(value="GLXContext") long ctx, int attribute, @NativeType(value="int *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, (int)1);
        }
        return GLX13.nglXQueryContext(display, ctx, attribute, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void glXSelectEvent(@NativeType(value="Display *") long display, @NativeType(value="GLXDrawable") long draw, @NativeType(value="unsigned long") long event_mask) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXSelectEvent;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)draw);
        }
        JNI.callPPPV((long)__functionAddress, (long)display, (long)draw, (long)event_mask);
    }

    public static void nglXGetSelectedEvent(long display, long draw, long event_mask) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetSelectedEvent;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)draw);
        }
        JNI.callPPPV((long)__functionAddress, (long)display, (long)draw, (long)event_mask);
    }

    public static void glXGetSelectedEvent(@NativeType(value="Display *") long display, @NativeType(value="GLXDrawable") long draw, @NativeType(value="unsigned long *") PointerBuffer event_mask) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)event_mask, (int)1);
        }
        GLX13.nglXGetSelectedEvent(display, draw, MemoryUtil.memAddress((CustomBuffer)event_mask));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="GLXFBConfig *")
    public static PointerBuffer glXChooseFBConfig(@NativeType(value="Display *") long display, int screen, @Nullable @NativeType(value="int const *") int[] attrib_list) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXChooseFBConfig;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.checkNTSafe((int[])attrib_list);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer nelements = stack.callocInt(1);
        try {
            long __result = JNI.callPPPP((long)__functionAddress, (long)display, (int)screen, (int[])attrib_list, (long)MemoryUtil.memAddress((IntBuffer)nelements));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe((long)__result, (int)nelements.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int glXGetFBConfigAttrib(@NativeType(value="Display *") long display, @NativeType(value="GLXFBConfig") long config, int attribute, @NativeType(value="int *") int[] value) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetFBConfigAttrib;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)config);
            Checks.check((int[])value, (int)1);
        }
        return JNI.callPPPI((long)__functionAddress, (long)display, (long)config, (int)attribute, (int[])value);
    }

    @NativeType(value="GLXWindow")
    public static long glXCreateWindow(@NativeType(value="Display *") long display, @NativeType(value="GLXFBConfig") long config, @NativeType(value="Window") long win, @Nullable @NativeType(value="int const *") int[] attrib_list) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXCreateWindow;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)config);
            Checks.checkNTSafe((int[])attrib_list);
        }
        return JNI.callPPPPP((long)__functionAddress, (long)display, (long)config, (long)win, (int[])attrib_list);
    }

    @NativeType(value="GLXPixmap")
    public static long glXCreatePixmap(@NativeType(value="Display *") long display, @NativeType(value="GLXFBConfig") long config, @NativeType(value="Pixmap") long pixmap, @Nullable @NativeType(value="int const *") int[] attrib_list) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXCreatePixmap;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)config);
            Checks.checkNTSafe((int[])attrib_list);
        }
        return JNI.callPPPPP((long)__functionAddress, (long)display, (long)config, (long)pixmap, (int[])attrib_list);
    }

    @NativeType(value="GLXPbuffer")
    public static long glXCreatePbuffer(@NativeType(value="Display *") long display, @NativeType(value="GLXFBConfig") long config, @Nullable @NativeType(value="int const *") int[] attrib_list) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXCreatePbuffer;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)config);
            Checks.checkNTSafe((int[])attrib_list);
        }
        return JNI.callPPPP((long)__functionAddress, (long)display, (long)config, (int[])attrib_list);
    }

    public static void glXQueryDrawable(@NativeType(value="Display *") long display, @NativeType(value="GLXDrawable") long draw, int attribute, @NativeType(value="unsigned int *") int[] value) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryDrawable;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)draw);
            Checks.check((int[])value, (int)1);
        }
        JNI.callPPPV((long)__functionAddress, (long)display, (long)draw, (int)attribute, (int[])value);
    }

    public static int glXQueryContext(@NativeType(value="Display *") long display, @NativeType(value="GLXContext") long ctx, int attribute, @NativeType(value="int *") int[] value) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryContext;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)ctx);
            Checks.check((int[])value, (int)1);
        }
        return JNI.callPPPI((long)__functionAddress, (long)display, (long)ctx, (int)attribute, (int[])value);
    }
}

