/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class NVGPUMulticast {
    public static final int GL_PER_GPU_STORAGE_BIT_NV = 2048;
    public static final int GL_MULTICAST_GPUS_NV = 37562;
    public static final int GL_RENDER_GPU_MASK_NV = 38232;
    public static final int GL_PER_GPU_STORAGE_NV = 38216;
    public static final int GL_MULTICAST_PROGRAMMABLE_SAMPLE_LOCATION_NV = 38217;

    protected NVGPUMulticast() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glRenderGpuMaskNV, caps.glMulticastBufferSubDataNV, caps.glMulticastCopyBufferSubDataNV, caps.glMulticastCopyImageSubDataNV, caps.glMulticastBlitFramebufferNV, caps.glMulticastFramebufferSampleLocationsfvNV, caps.glMulticastBarrierNV, caps.glMulticastWaitSyncNV, caps.glMulticastGetQueryObjectivNV, caps.glMulticastGetQueryObjectuivNV, caps.glMulticastGetQueryObjecti64vNV, caps.glMulticastGetQueryObjectui64vNV});
    }

    public static void glRenderGpuMaskNV(int mask) {
        long __functionAddress = GL.getCapabilities().glRenderGpuMaskNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)mask);
    }

    public static void nglMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, long size, long data) {
        long __functionAddress = GL.getCapabilities().glMulticastBufferSubDataNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)gpuMask, (int)buffer, (long)offset, (long)size, (long)data);
    }

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, ByteBuffer data) {
        NVGPUMulticast.nglMulticastBufferSubDataNV(gpuMask, buffer, offset, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, ShortBuffer data) {
        NVGPUMulticast.nglMulticastBufferSubDataNV(gpuMask, buffer, offset, data.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)data));
    }

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, IntBuffer data) {
        NVGPUMulticast.nglMulticastBufferSubDataNV(gpuMask, buffer, offset, data.remaining() << 2, MemoryUtil.memAddress((IntBuffer)data));
    }

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, FloatBuffer data) {
        NVGPUMulticast.nglMulticastBufferSubDataNV(gpuMask, buffer, offset, data.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, DoubleBuffer data) {
        NVGPUMulticast.nglMulticastBufferSubDataNV(gpuMask, buffer, offset, data.remaining() << 3, MemoryUtil.memAddress((DoubleBuffer)data));
    }

    public static void glMulticastCopyBufferSubDataNV(int readGpu, int writeGpuMask, int readBuffer, int writeBuffer, long readOffset, long writeOffset, long size) {
        long __functionAddress = GL.getCapabilities().glMulticastCopyBufferSubDataNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)readGpu, (int)writeGpuMask, (int)readBuffer, (int)writeBuffer, (long)readOffset, (long)writeOffset, (long)size);
    }

    public static void glMulticastCopyImageSubDataNV(int srcGpu, int dstGpuMask, int srcName, int srcTarget, int srcLevel, int srcX, int srxY, int srcZ, int dstName, int dstTarget, int dstLevel, int dstX, int dstY, int dstZ, int srcWidth, int srcHeight, int srcDepth) {
        long __functionAddress = GL.getCapabilities().glMulticastCopyImageSubDataNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)srcGpu, (int)dstGpuMask, (int)srcName, (int)srcTarget, (int)srcLevel, (int)srcX, (int)srxY, (int)srcZ, (int)dstName, (int)dstTarget, (int)dstLevel, (int)dstX, (int)dstY, (int)dstZ, (int)srcWidth, (int)srcHeight, (int)srcDepth);
    }

    public static void glMulticastBlitFramebufferNV(int srcGpu, int dstGpu, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        long __functionAddress = GL.getCapabilities().glMulticastBlitFramebufferNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)srcGpu, (int)dstGpu, (int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)filter);
    }

    public static void nglMulticastFramebufferSampleLocationsfvNV(int gpu, int framebuffer, int start, int count, long v) {
        long __functionAddress = GL.getCapabilities().glMulticastFramebufferSampleLocationsfvNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)gpu, (int)framebuffer, (int)start, (int)count, (long)v);
    }

    public static void glMulticastFramebufferSampleLocationsfvNV(int gpu, int framebuffer, int start, FloatBuffer v) {
        NVGPUMulticast.nglMulticastFramebufferSampleLocationsfvNV(gpu, framebuffer, start, v.remaining() >> 1, MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static void glMulticastBarrierNV() {
        long __functionAddress = GL.getCapabilities().glMulticastBarrierNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static void glMulticastWaitSyncNV(int signalGpu, int waitGpuMask) {
        long __functionAddress = GL.getCapabilities().glMulticastWaitSyncNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)signalGpu, (int)waitGpuMask);
    }

    public static void nglMulticastGetQueryObjectivNV(int gpu, int id, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glMulticastGetQueryObjectivNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)gpu, (int)id, (int)pname, (long)params);
    }

    public static void glMulticastGetQueryObjectivNV(int gpu, int id, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        NVGPUMulticast.nglMulticastGetQueryObjectivNV(gpu, id, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glMulticastGetQueryObjectiNV(int gpu, int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            NVGPUMulticast.nglMulticastGetQueryObjectivNV(gpu, id, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglMulticastGetQueryObjectuivNV(int gpu, int id, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glMulticastGetQueryObjectuivNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)gpu, (int)id, (int)pname, (long)params);
    }

    public static void glMulticastGetQueryObjectuivNV(int gpu, int id, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        NVGPUMulticast.nglMulticastGetQueryObjectuivNV(gpu, id, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glMulticastGetQueryObjectuiNV(int gpu, int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            NVGPUMulticast.nglMulticastGetQueryObjectuivNV(gpu, id, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglMulticastGetQueryObjecti64vNV(int gpu, int id, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glMulticastGetQueryObjecti64vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)gpu, (int)id, (int)pname, (long)params);
    }

    public static void glMulticastGetQueryObjecti64vNV(int gpu, int id, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        NVGPUMulticast.nglMulticastGetQueryObjecti64vNV(gpu, id, pname, MemoryUtil.memAddress((LongBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glMulticastGetQueryObjecti64NV(int gpu, int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            NVGPUMulticast.nglMulticastGetQueryObjecti64vNV(gpu, id, pname, MemoryUtil.memAddress((LongBuffer)params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglMulticastGetQueryObjectui64vNV(int gpu, int id, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glMulticastGetQueryObjectui64vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)gpu, (int)id, (int)pname, (long)params);
    }

    public static void glMulticastGetQueryObjectui64vNV(int gpu, int id, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        NVGPUMulticast.nglMulticastGetQueryObjectui64vNV(gpu, id, pname, MemoryUtil.memAddress((LongBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glMulticastGetQueryObjectui64NV(int gpu, int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            NVGPUMulticast.nglMulticastGetQueryObjectui64vNV(gpu, id, pname, MemoryUtil.memAddress((LongBuffer)params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, short[] data) {
        long __functionAddress = GL.getCapabilities().glMulticastBufferSubDataNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)gpuMask, (int)buffer, (long)offset, (long)(data.length << 1), (short[])data);
    }

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, int[] data) {
        long __functionAddress = GL.getCapabilities().glMulticastBufferSubDataNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)gpuMask, (int)buffer, (long)offset, (long)(data.length << 2), (int[])data);
    }

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, float[] data) {
        long __functionAddress = GL.getCapabilities().glMulticastBufferSubDataNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)gpuMask, (int)buffer, (long)offset, (long)(data.length << 2), (float[])data);
    }

    public static void glMulticastBufferSubDataNV(int gpuMask, int buffer, long offset, double[] data) {
        long __functionAddress = GL.getCapabilities().glMulticastBufferSubDataNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)gpuMask, (int)buffer, (long)offset, (long)(data.length << 3), (double[])data);
    }

    public static void glMulticastFramebufferSampleLocationsfvNV(int gpu, int framebuffer, int start, float[] v) {
        long __functionAddress = GL.getCapabilities().glMulticastFramebufferSampleLocationsfvNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)gpu, (int)framebuffer, (int)start, (int)(v.length >> 1), (float[])v);
    }

    public static void glMulticastGetQueryObjectivNV(int gpu, int id, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glMulticastGetQueryObjectivNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)gpu, (int)id, (int)pname, (int[])params);
    }

    public static void glMulticastGetQueryObjectuivNV(int gpu, int id, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glMulticastGetQueryObjectuivNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)gpu, (int)id, (int)pname, (int[])params);
    }

    public static void glMulticastGetQueryObjecti64vNV(int gpu, int id, int pname, long[] params) {
        long __functionAddress = GL.getCapabilities().glMulticastGetQueryObjecti64vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((long[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)gpu, (int)id, (int)pname, (long[])params);
    }

    public static void glMulticastGetQueryObjectui64vNV(int gpu, int id, int pname, long[] params) {
        long __functionAddress = GL.getCapabilities().glMulticastGetQueryObjectui64vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((long[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)gpu, (int)id, (int)pname, (long[])params);
    }
}

