/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class NVFence {
    public static final int GL_ALL_COMPLETED_NV = 34034;
    public static final int GL_FENCE_STATUS_NV = 34035;
    public static final int GL_FENCE_CONDITION_NV = 34036;

    protected NVFence() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glDeleteFencesNV, caps.glGenFencesNV, caps.glIsFenceNV, caps.glTestFenceNV, caps.glGetFenceivNV, caps.glFinishFenceNV, caps.glSetFenceNV});
    }

    public static void nglDeleteFencesNV(int n, long fences) {
        long __functionAddress = GL.getCapabilities().glDeleteFencesNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)fences);
    }

    public static void glDeleteFencesNV(IntBuffer fences) {
        NVFence.nglDeleteFencesNV(fences.remaining(), MemoryUtil.memAddress((IntBuffer)fences));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteFencesNV(int fence) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer fences = stack.ints(fence);
            NVFence.nglDeleteFencesNV(1, MemoryUtil.memAddress((IntBuffer)fences));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGenFencesNV(int n, long fences) {
        long __functionAddress = GL.getCapabilities().glGenFencesNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)fences);
    }

    public static void glGenFencesNV(IntBuffer fences) {
        NVFence.nglGenFencesNV(fences.remaining(), MemoryUtil.memAddress((IntBuffer)fences));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenFencesNV() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer fences = stack.callocInt(1);
            NVFence.nglGenFencesNV(1, MemoryUtil.memAddress((IntBuffer)fences));
            int n = fences.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean glIsFenceNV(int fence) {
        long __functionAddress = GL.getCapabilities().glIsFenceNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress, (int)fence);
    }

    public static boolean glTestFenceNV(int fence) {
        long __functionAddress = GL.getCapabilities().glTestFenceNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress, (int)fence);
    }

    public static void nglGetFenceivNV(int fence, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetFenceivNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)fence, (int)pname, (long)params);
    }

    public static void glGetFenceivNV(int fence, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        NVFence.nglGetFenceivNV(fence, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetFenceiNV(int fence, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            NVFence.nglGetFenceivNV(fence, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glFinishFenceNV(int fence) {
        long __functionAddress = GL.getCapabilities().glFinishFenceNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)fence);
    }

    public static void glSetFenceNV(int fence, int condition) {
        long __functionAddress = GL.getCapabilities().glSetFenceNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)fence, (int)condition);
    }

    public static void glDeleteFencesNV(int[] fences) {
        long __functionAddress = GL.getCapabilities().glDeleteFencesNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)fences.length, (int[])fences);
    }

    public static void glGenFencesNV(int[] fences) {
        long __functionAddress = GL.getCapabilities().glGenFencesNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)fences.length, (int[])fences);
    }

    public static void glGetFenceivNV(int fence, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetFenceivNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)fence, (int)pname, (int[])params);
    }
}

