/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class NVDrawVulkanImage {
    protected NVDrawVulkanImage() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glDrawVkImageNV, caps.glGetVkProcAddrNV, caps.glWaitVkSemaphoreNV, caps.glSignalVkSemaphoreNV, caps.glSignalVkFenceNV});
    }

    public static void glDrawVkImageNV(long vkImage, int sampler, float x0, float y0, float x1, float y1, float z, float s0, float t0, float s1, float t1) {
        long __functionAddress = GL.getCapabilities().glDrawVkImageNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callJV((long)__functionAddress, (long)vkImage, (int)sampler, (float)x0, (float)y0, (float)x1, (float)y1, (float)z, (float)s0, (float)t0, (float)s1, (float)t1);
    }

    public static long nglGetVkProcAddrNV(long name) {
        long __functionAddress = GL.getCapabilities().glGetVkProcAddrNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callPP((long)__functionAddress, (long)name);
    }

    public static long glGetVkProcAddrNV(ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return NVDrawVulkanImage.nglGetVkProcAddrNV(MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetVkProcAddrNV(CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            long l = NVDrawVulkanImage.nglGetVkProcAddrNV(MemoryUtil.memAddress((ByteBuffer)nameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glWaitVkSemaphoreNV(long vkSemaphore) {
        long __functionAddress = GL.getCapabilities().glWaitVkSemaphoreNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callJV((long)__functionAddress, (long)vkSemaphore);
    }

    public static void glSignalVkSemaphoreNV(long vkSemaphore) {
        long __functionAddress = GL.getCapabilities().glSignalVkSemaphoreNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callJV((long)__functionAddress, (long)vkSemaphore);
    }

    public static void glSignalVkFenceNV(long vkFence) {
        long __functionAddress = GL.getCapabilities().glSignalVkFenceNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callJV((long)__functionAddress, (long)vkFence);
    }
}

