/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class NVCommandList {
    public static final int GL_TERMINATE_SEQUENCE_COMMAND_NV = 0;
    public static final int GL_NOP_COMMAND_NV = 1;
    public static final int GL_DRAW_ELEMENTS_COMMAND_NV = 2;
    public static final int GL_DRAW_ARRAYS_COMMAND_NV = 3;
    public static final int GL_DRAW_ELEMENTS_STRIP_COMMAND_NV = 4;
    public static final int GL_DRAW_ARRAYS_STRIP_COMMAND_NV = 5;
    public static final int GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV = 6;
    public static final int GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV = 7;
    public static final int GL_ELEMENT_ADDRESS_COMMAND_NV = 8;
    public static final int GL_ATTRIBUTE_ADDRESS_COMMAND_NV = 9;
    public static final int GL_UNIFORM_ADDRESS_COMMAND_NV = 10;
    public static final int GL_BLEND_COLOR_COMMAND_NV = 11;
    public static final int GL_STENCIL_REF_COMMAND_NV = 12;
    public static final int GL_LINE_WIDTH_COMMAND_NV = 13;
    public static final int GL_POLYGON_OFFSET_COMMAND_NV = 14;
    public static final int GL_ALPHA_REF_COMMAND_NV = 15;
    public static final int GL_VIEWPORT_COMMAND_NV = 16;
    public static final int GL_SCISSOR_COMMAND_NV = 17;
    public static final int GL_FRONT_FACE_COMMAND_NV = 18;

    protected NVCommandList() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glCreateStatesNV, caps.glDeleteStatesNV, caps.glIsStateNV, caps.glStateCaptureNV, caps.glGetCommandHeaderNV, caps.glGetStageIndexNV, caps.glDrawCommandsNV, caps.glDrawCommandsAddressNV, caps.glDrawCommandsStatesNV, caps.glDrawCommandsStatesAddressNV, caps.glCreateCommandListsNV, caps.glDeleteCommandListsNV, caps.glIsCommandListNV, caps.glListDrawCommandsStatesClientNV, caps.glCommandListSegmentsNV, caps.glCompileCommandListNV, caps.glCallCommandListNV});
    }

    public static void nglCreateStatesNV(int n, long states) {
        long __functionAddress = GL.getCapabilities().glCreateStatesNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)states);
    }

    public static void glCreateStatesNV(IntBuffer states) {
        NVCommandList.nglCreateStatesNV(states.remaining(), MemoryUtil.memAddress((IntBuffer)states));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateStatesNV() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer states = stack.callocInt(1);
            NVCommandList.nglCreateStatesNV(1, MemoryUtil.memAddress((IntBuffer)states));
            int n = states.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDeleteStatesNV(int n, long states) {
        long __functionAddress = GL.getCapabilities().glDeleteStatesNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)states);
    }

    public static void glDeleteStatesNV(IntBuffer states) {
        NVCommandList.nglDeleteStatesNV(states.remaining(), MemoryUtil.memAddress((IntBuffer)states));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteStatesNV(int state) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer states = stack.ints(state);
            NVCommandList.nglDeleteStatesNV(1, MemoryUtil.memAddress((IntBuffer)states));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean glIsStateNV(int state) {
        long __functionAddress = GL.getCapabilities().glIsStateNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress, (int)state);
    }

    public static void glStateCaptureNV(int state, int mode) {
        long __functionAddress = GL.getCapabilities().glStateCaptureNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)state, (int)mode);
    }

    public static int glGetCommandHeaderNV(int tokenID, int size) {
        long __functionAddress = GL.getCapabilities().glGetCommandHeaderNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callI((long)__functionAddress, (int)tokenID, (int)size);
    }

    public static short glGetStageIndexNV(int shadertype) {
        long __functionAddress = GL.getCapabilities().glGetStageIndexNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callS((long)__functionAddress, (int)shadertype);
    }

    public static void nglDrawCommandsNV(int primitiveMode, int buffer, long indirects, long sizes, int count) {
        long __functionAddress = GL.getCapabilities().glDrawCommandsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)primitiveMode, (int)buffer, (long)indirects, (long)sizes, (int)count);
    }

    public static void glDrawCommandsNV(int primitiveMode, int buffer, PointerBuffer indirects, IntBuffer sizes) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)sizes, (int)indirects.remaining());
        }
        NVCommandList.nglDrawCommandsNV(primitiveMode, buffer, MemoryUtil.memAddress((CustomBuffer)indirects), MemoryUtil.memAddress((IntBuffer)sizes), indirects.remaining());
    }

    public static void nglDrawCommandsAddressNV(int primitiveMode, long indirects, long sizes, int count) {
        long __functionAddress = GL.getCapabilities().glDrawCommandsAddressNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)primitiveMode, (long)indirects, (long)sizes, (int)count);
    }

    public static void glDrawCommandsAddressNV(int primitiveMode, LongBuffer indirects, IntBuffer sizes) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)sizes, (int)indirects.remaining());
        }
        NVCommandList.nglDrawCommandsAddressNV(primitiveMode, MemoryUtil.memAddress((LongBuffer)indirects), MemoryUtil.memAddress((IntBuffer)sizes), indirects.remaining());
    }

    public static void nglDrawCommandsStatesNV(int buffer, long indirects, long sizes, long states, long fbos, int count) {
        long __functionAddress = GL.getCapabilities().glDrawCommandsStatesNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPPV((long)__functionAddress, (int)buffer, (long)indirects, (long)sizes, (long)states, (long)fbos, (int)count);
    }

    public static void glDrawCommandsStatesNV(int buffer, PointerBuffer indirects, IntBuffer sizes, IntBuffer states, IntBuffer fbos) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)sizes, (int)indirects.remaining());
            Checks.checkBuffer((Buffer)states, (int)indirects.remaining());
            Checks.checkBuffer((Buffer)fbos, (int)indirects.remaining());
        }
        NVCommandList.nglDrawCommandsStatesNV(buffer, MemoryUtil.memAddress((CustomBuffer)indirects), MemoryUtil.memAddress((IntBuffer)sizes), MemoryUtil.memAddress((IntBuffer)states), MemoryUtil.memAddress((IntBuffer)fbos), indirects.remaining());
    }

    public static void nglDrawCommandsStatesAddressNV(long indirects, long sizes, long states, long fbos, int count) {
        long __functionAddress = GL.getCapabilities().glDrawCommandsStatesAddressNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPPV((long)__functionAddress, (long)indirects, (long)sizes, (long)states, (long)fbos, (int)count);
    }

    public static void glDrawCommandsStatesAddressNV(LongBuffer indirects, IntBuffer sizes, IntBuffer states, IntBuffer fbos) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)sizes, (int)indirects.remaining());
            Checks.checkBuffer((Buffer)states, (int)indirects.remaining());
            Checks.checkBuffer((Buffer)fbos, (int)indirects.remaining());
        }
        NVCommandList.nglDrawCommandsStatesAddressNV(MemoryUtil.memAddress((LongBuffer)indirects), MemoryUtil.memAddress((IntBuffer)sizes), MemoryUtil.memAddress((IntBuffer)states), MemoryUtil.memAddress((IntBuffer)fbos), indirects.remaining());
    }

    public static void nglCreateCommandListsNV(int n, long lists) {
        long __functionAddress = GL.getCapabilities().glCreateCommandListsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)lists);
    }

    public static void glCreateCommandListsNV(IntBuffer lists) {
        NVCommandList.nglCreateCommandListsNV(lists.remaining(), MemoryUtil.memAddress((IntBuffer)lists));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateCommandListsNV() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer lists = stack.callocInt(1);
            NVCommandList.nglCreateCommandListsNV(1, MemoryUtil.memAddress((IntBuffer)lists));
            int n = lists.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDeleteCommandListsNV(int n, long lists) {
        long __functionAddress = GL.getCapabilities().glDeleteCommandListsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)lists);
    }

    public static void glDeleteCommandListsNV(IntBuffer lists) {
        NVCommandList.nglDeleteCommandListsNV(lists.remaining(), MemoryUtil.memAddress((IntBuffer)lists));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteCommandListsNV(int list) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer lists = stack.ints(list);
            NVCommandList.nglDeleteCommandListsNV(1, MemoryUtil.memAddress((IntBuffer)lists));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean glIsCommandListNV(int list) {
        long __functionAddress = GL.getCapabilities().glIsCommandListNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress, (int)list);
    }

    public static void nglListDrawCommandsStatesClientNV(int list, int segment, long indirects, long sizes, long states, long fbos, int count) {
        long __functionAddress = GL.getCapabilities().glListDrawCommandsStatesClientNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPPV((long)__functionAddress, (int)list, (int)segment, (long)indirects, (long)sizes, (long)states, (long)fbos, (int)count);
    }

    public static void glListDrawCommandsStatesClientNV(int list, int segment, PointerBuffer indirects, PointerBuffer sizes, IntBuffer states, IntBuffer fbos) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((CustomBuffer)sizes, (int)indirects.remaining());
            Checks.checkBuffer((Buffer)states, (int)indirects.remaining());
            Checks.checkBuffer((Buffer)fbos, (int)indirects.remaining());
        }
        NVCommandList.nglListDrawCommandsStatesClientNV(list, segment, MemoryUtil.memAddress((CustomBuffer)indirects), MemoryUtil.memAddress((CustomBuffer)sizes), MemoryUtil.memAddress((IntBuffer)states), MemoryUtil.memAddress((IntBuffer)fbos), indirects.remaining());
    }

    public static void glCommandListSegmentsNV(int list, int segments) {
        long __functionAddress = GL.getCapabilities().glCommandListSegmentsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)list, (int)segments);
    }

    public static void glCompileCommandListNV(int list) {
        long __functionAddress = GL.getCapabilities().glCompileCommandListNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)list);
    }

    public static void glCallCommandListNV(int list) {
        long __functionAddress = GL.getCapabilities().glCallCommandListNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)list);
    }

    public static void glCreateStatesNV(int[] states) {
        long __functionAddress = GL.getCapabilities().glCreateStatesNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)states.length, (int[])states);
    }

    public static void glDeleteStatesNV(int[] states) {
        long __functionAddress = GL.getCapabilities().glDeleteStatesNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)states.length, (int[])states);
    }

    public static void glDrawCommandsNV(int primitiveMode, int buffer, PointerBuffer indirects, int[] sizes) {
        long __functionAddress = GL.getCapabilities().glDrawCommandsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])sizes, (int)indirects.remaining());
        }
        JNI.callPPV((long)__functionAddress, (int)primitiveMode, (int)buffer, (long)MemoryUtil.memAddress((CustomBuffer)indirects), (int[])sizes, (int)indirects.remaining());
    }

    public static void glDrawCommandsAddressNV(int primitiveMode, long[] indirects, int[] sizes) {
        long __functionAddress = GL.getCapabilities().glDrawCommandsAddressNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])sizes, (int)indirects.length);
        }
        JNI.callPPV((long)__functionAddress, (int)primitiveMode, (long[])indirects, (int[])sizes, (int)indirects.length);
    }

    public static void glDrawCommandsStatesNV(int buffer, PointerBuffer indirects, int[] sizes, int[] states, int[] fbos) {
        long __functionAddress = GL.getCapabilities().glDrawCommandsStatesNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])sizes, (int)indirects.remaining());
            Checks.checkBuffer((int[])states, (int)indirects.remaining());
            Checks.checkBuffer((int[])fbos, (int)indirects.remaining());
        }
        JNI.callPPPPV((long)__functionAddress, (int)buffer, (long)MemoryUtil.memAddress((CustomBuffer)indirects), (int[])sizes, (int[])states, (int[])fbos, (int)indirects.remaining());
    }

    public static void glDrawCommandsStatesAddressNV(long[] indirects, int[] sizes, int[] states, int[] fbos) {
        long __functionAddress = GL.getCapabilities().glDrawCommandsStatesAddressNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])sizes, (int)indirects.length);
            Checks.checkBuffer((int[])states, (int)indirects.length);
            Checks.checkBuffer((int[])fbos, (int)indirects.length);
        }
        JNI.callPPPPV((long)__functionAddress, (long[])indirects, (int[])sizes, (int[])states, (int[])fbos, (int)indirects.length);
    }

    public static void glCreateCommandListsNV(int[] lists) {
        long __functionAddress = GL.getCapabilities().glCreateCommandListsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)lists.length, (int[])lists);
    }

    public static void glDeleteCommandListsNV(int[] lists) {
        long __functionAddress = GL.getCapabilities().glDeleteCommandListsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)lists.length, (int[])lists);
    }

    public static void glListDrawCommandsStatesClientNV(int list, int segment, PointerBuffer indirects, PointerBuffer sizes, int[] states, int[] fbos) {
        long __functionAddress = GL.getCapabilities().glListDrawCommandsStatesClientNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((CustomBuffer)sizes, (int)indirects.remaining());
            Checks.checkBuffer((int[])states, (int)indirects.remaining());
            Checks.checkBuffer((int[])fbos, (int)indirects.remaining());
        }
        JNI.callPPPPV((long)__functionAddress, (int)list, (int)segment, (long)MemoryUtil.memAddress((CustomBuffer)indirects), (long)MemoryUtil.memAddress((CustomBuffer)sizes), (int[])states, (int[])fbos, (int)indirects.remaining());
    }
}

