/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class INTELPerformanceQuery {
    public static final int GL_PERFQUERY_SINGLE_CONTEXT_INTEL = 0;
    public static final int GL_PERFQUERY_GLOBAL_CONTEXT_INTEL = 1;
    public static final int GL_PERFQUERY_WAIT_INTEL = 33787;
    public static final int GL_PERFQUERY_FLUSH_INTEL = 33786;
    public static final int GL_PERFQUERY_DONOT_FLUSH_INTEL = 33785;
    public static final int GL_PERFQUERY_COUNTER_EVENT_INTEL = 38128;
    public static final int GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL = 38129;
    public static final int GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL = 38130;
    public static final int GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL = 38131;
    public static final int GL_PERFQUERY_COUNTER_RAW_INTEL = 38132;
    public static final int GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL = 38133;
    public static final int GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL = 38136;
    public static final int GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL = 38137;
    public static final int GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL = 38138;
    public static final int GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL = 38139;
    public static final int GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL = 38140;
    public static final int GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL = 38141;
    public static final int GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL = 38142;
    public static final int GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL = 38143;
    public static final int GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL = 38144;

    protected INTELPerformanceQuery() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glBeginPerfQueryINTEL, caps.glCreatePerfQueryINTEL, caps.glDeletePerfQueryINTEL, caps.glEndPerfQueryINTEL, caps.glGetFirstPerfQueryIdINTEL, caps.glGetNextPerfQueryIdINTEL, caps.glGetPerfCounterInfoINTEL, caps.glGetPerfQueryDataINTEL, caps.glGetPerfQueryIdByNameINTEL, caps.glGetPerfQueryInfoINTEL});
    }

    public static void glBeginPerfQueryINTEL(int queryHandle) {
        long __functionAddress = GL.getCapabilities().glBeginPerfQueryINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)queryHandle);
    }

    public static void nglCreatePerfQueryINTEL(int queryId, long queryHandle) {
        long __functionAddress = GL.getCapabilities().glCreatePerfQueryINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)queryId, (long)queryHandle);
    }

    public static void glCreatePerfQueryINTEL(int queryId, IntBuffer queryHandle) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)queryHandle, (int)1);
        }
        INTELPerformanceQuery.nglCreatePerfQueryINTEL(queryId, MemoryUtil.memAddress((IntBuffer)queryHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreatePerfQueryINTEL(int queryId) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer queryHandle = stack.callocInt(1);
            INTELPerformanceQuery.nglCreatePerfQueryINTEL(queryId, MemoryUtil.memAddress((IntBuffer)queryHandle));
            int n = queryHandle.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDeletePerfQueryINTEL(int queryHandle) {
        long __functionAddress = GL.getCapabilities().glDeletePerfQueryINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)queryHandle);
    }

    public static void glEndPerfQueryINTEL(int queryHandle) {
        long __functionAddress = GL.getCapabilities().glEndPerfQueryINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)queryHandle);
    }

    public static void nglGetFirstPerfQueryIdINTEL(long queryId) {
        long __functionAddress = GL.getCapabilities().glGetFirstPerfQueryIdINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)queryId);
    }

    public static void glGetFirstPerfQueryIdINTEL(IntBuffer queryId) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)queryId, (int)1);
        }
        INTELPerformanceQuery.nglGetFirstPerfQueryIdINTEL(MemoryUtil.memAddress((IntBuffer)queryId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetFirstPerfQueryIdINTEL() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer queryId = stack.callocInt(1);
            INTELPerformanceQuery.nglGetFirstPerfQueryIdINTEL(MemoryUtil.memAddress((IntBuffer)queryId));
            int n = queryId.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetNextPerfQueryIdINTEL(int queryId, long nextQueryId) {
        long __functionAddress = GL.getCapabilities().glGetNextPerfQueryIdINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)queryId, (long)nextQueryId);
    }

    public static void glGetNextPerfQueryIdINTEL(int queryId, IntBuffer nextQueryId) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)nextQueryId, (int)1);
        }
        INTELPerformanceQuery.nglGetNextPerfQueryIdINTEL(queryId, MemoryUtil.memAddress((IntBuffer)nextQueryId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetNextPerfQueryIdINTEL(int queryId) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer nextQueryId = stack.callocInt(1);
            INTELPerformanceQuery.nglGetNextPerfQueryIdINTEL(queryId, MemoryUtil.memAddress((IntBuffer)nextQueryId));
            int n = nextQueryId.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetPerfCounterInfoINTEL(int queryId, int counterId, int counterNameLength, long counterName, int counterDescLength, long counterDesc, long counterOffset, long counterDataSize, long counterTypeEnum, long counterDataTypeEnum, long rawCounterMaxValue) {
        long __functionAddress = GL.getCapabilities().glGetPerfCounterInfoINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPPPPPV((long)__functionAddress, (int)queryId, (int)counterId, (int)counterNameLength, (long)counterName, (int)counterDescLength, (long)counterDesc, (long)counterOffset, (long)counterDataSize, (long)counterTypeEnum, (long)counterDataTypeEnum, (long)rawCounterMaxValue);
    }

    public static void glGetPerfCounterInfoINTEL(int queryId, int counterId, ByteBuffer counterName, ByteBuffer counterDesc, IntBuffer counterOffset, IntBuffer counterDataSize, IntBuffer counterTypeEnum, IntBuffer counterDataTypeEnum, LongBuffer rawCounterMaxValue) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)counterOffset, (int)1);
            Checks.checkBuffer((Buffer)counterDataSize, (int)1);
            Checks.checkBuffer((Buffer)counterTypeEnum, (int)1);
            Checks.checkBuffer((Buffer)counterDataTypeEnum, (int)1);
            Checks.checkBuffer((Buffer)rawCounterMaxValue, (int)1);
        }
        INTELPerformanceQuery.nglGetPerfCounterInfoINTEL(queryId, counterId, counterName.remaining(), MemoryUtil.memAddress((ByteBuffer)counterName), counterDesc.remaining(), MemoryUtil.memAddress((ByteBuffer)counterDesc), MemoryUtil.memAddress((IntBuffer)counterOffset), MemoryUtil.memAddress((IntBuffer)counterDataSize), MemoryUtil.memAddress((IntBuffer)counterTypeEnum), MemoryUtil.memAddress((IntBuffer)counterDataTypeEnum), MemoryUtil.memAddress((LongBuffer)rawCounterMaxValue));
    }

    public static void nglGetPerfQueryDataINTEL(int queryHandle, int flags, int dataSize, long data, long bytesWritten) {
        long __functionAddress = GL.getCapabilities().glGetPerfQueryDataINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)queryHandle, (int)flags, (int)dataSize, (long)data, (long)bytesWritten);
    }

    public static void glGetPerfQueryDataINTEL(int queryHandle, int flags, ByteBuffer data, IntBuffer bytesWritten) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)bytesWritten, (int)1);
        }
        INTELPerformanceQuery.nglGetPerfQueryDataINTEL(queryHandle, flags, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data), MemoryUtil.memAddress((IntBuffer)bytesWritten));
    }

    public static void nglGetPerfQueryIdByNameINTEL(long queryName, long queryId) {
        long __functionAddress = GL.getCapabilities().glGetPerfQueryIdByNameINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (long)queryName, (long)queryId);
    }

    public static void glGetPerfQueryIdByNameINTEL(ByteBuffer queryName, IntBuffer queryId) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)queryName);
            Checks.checkBuffer((Buffer)queryId, (int)1);
        }
        INTELPerformanceQuery.nglGetPerfQueryIdByNameINTEL(MemoryUtil.memAddress((ByteBuffer)queryName), MemoryUtil.memAddress((IntBuffer)queryId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glGetPerfQueryIdByNameINTEL(CharSequence queryName, IntBuffer queryId) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)queryId, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer queryNameEncoded = stack.ASCII(queryName);
            INTELPerformanceQuery.nglGetPerfQueryIdByNameINTEL(MemoryUtil.memAddress((ByteBuffer)queryNameEncoded), MemoryUtil.memAddress((IntBuffer)queryId));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetPerfQueryIdByNameINTEL(CharSequence queryName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer queryNameEncoded = stack.ASCII(queryName);
            IntBuffer queryId = stack.callocInt(1);
            INTELPerformanceQuery.nglGetPerfQueryIdByNameINTEL(MemoryUtil.memAddress((ByteBuffer)queryNameEncoded), MemoryUtil.memAddress((IntBuffer)queryId));
            int n = queryId.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetPerfQueryInfoINTEL(int queryId, int queryNameLength, long queryName, long dataSize, long noCounters, long noInstances, long capsMask) {
        long __functionAddress = GL.getCapabilities().glGetPerfQueryInfoINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPPPV((long)__functionAddress, (int)queryId, (int)queryNameLength, (long)queryName, (long)dataSize, (long)noCounters, (long)noInstances, (long)capsMask);
    }

    public static void glGetPerfQueryInfoINTEL(int queryId, ByteBuffer queryName, IntBuffer dataSize, IntBuffer noCounters, IntBuffer noInstances, IntBuffer capsMask) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)dataSize, (int)1);
            Checks.checkBuffer((Buffer)noCounters, (int)1);
            Checks.checkBuffer((Buffer)noInstances, (int)1);
            Checks.checkBuffer((Buffer)capsMask, (int)1);
        }
        INTELPerformanceQuery.nglGetPerfQueryInfoINTEL(queryId, queryName.remaining(), MemoryUtil.memAddress((ByteBuffer)queryName), MemoryUtil.memAddress((IntBuffer)dataSize), MemoryUtil.memAddress((IntBuffer)noCounters), MemoryUtil.memAddress((IntBuffer)noInstances), MemoryUtil.memAddress((IntBuffer)capsMask));
    }

    public static void glCreatePerfQueryINTEL(int queryId, int[] queryHandle) {
        long __functionAddress = GL.getCapabilities().glCreatePerfQueryINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])queryHandle, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)queryId, (int[])queryHandle);
    }

    public static void glGetFirstPerfQueryIdINTEL(int[] queryId) {
        long __functionAddress = GL.getCapabilities().glGetFirstPerfQueryIdINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])queryId, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int[])queryId);
    }

    public static void glGetNextPerfQueryIdINTEL(int queryId, int[] nextQueryId) {
        long __functionAddress = GL.getCapabilities().glGetNextPerfQueryIdINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])nextQueryId, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)queryId, (int[])nextQueryId);
    }

    public static void glGetPerfCounterInfoINTEL(int queryId, int counterId, ByteBuffer counterName, ByteBuffer counterDesc, int[] counterOffset, int[] counterDataSize, int[] counterTypeEnum, int[] counterDataTypeEnum, long[] rawCounterMaxValue) {
        long __functionAddress = GL.getCapabilities().glGetPerfCounterInfoINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])counterOffset, (int)1);
            Checks.checkBuffer((int[])counterDataSize, (int)1);
            Checks.checkBuffer((int[])counterTypeEnum, (int)1);
            Checks.checkBuffer((int[])counterDataTypeEnum, (int)1);
            Checks.checkBuffer((long[])rawCounterMaxValue, (int)1);
        }
        JNI.callPPPPPPPV((long)__functionAddress, (int)queryId, (int)counterId, (int)counterName.remaining(), (long)MemoryUtil.memAddress((ByteBuffer)counterName), (int)counterDesc.remaining(), (long)MemoryUtil.memAddress((ByteBuffer)counterDesc), (int[])counterOffset, (int[])counterDataSize, (int[])counterTypeEnum, (int[])counterDataTypeEnum, (long[])rawCounterMaxValue);
    }

    public static void glGetPerfQueryDataINTEL(int queryHandle, int flags, ByteBuffer data, int[] bytesWritten) {
        long __functionAddress = GL.getCapabilities().glGetPerfQueryDataINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])bytesWritten, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)queryHandle, (int)flags, (int)data.remaining(), (long)MemoryUtil.memAddress((ByteBuffer)data), (int[])bytesWritten);
    }

    public static void glGetPerfQueryIdByNameINTEL(ByteBuffer queryName, int[] queryId) {
        long __functionAddress = GL.getCapabilities().glGetPerfQueryIdByNameINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkNT1((ByteBuffer)queryName);
            Checks.checkBuffer((int[])queryId, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (long)MemoryUtil.memAddress((ByteBuffer)queryName), (int[])queryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glGetPerfQueryIdByNameINTEL(CharSequence queryName, int[] queryId) {
        long __functionAddress = GL.getCapabilities().glGetPerfQueryIdByNameINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])queryId, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer queryNameEncoded = stack.ASCII(queryName);
            JNI.callPPV((long)__functionAddress, (long)MemoryUtil.memAddress((ByteBuffer)queryNameEncoded), (int[])queryId);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGetPerfQueryInfoINTEL(int queryId, ByteBuffer queryName, int[] dataSize, int[] noCounters, int[] noInstances, int[] capsMask) {
        long __functionAddress = GL.getCapabilities().glGetPerfQueryInfoINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])dataSize, (int)1);
            Checks.checkBuffer((int[])noCounters, (int)1);
            Checks.checkBuffer((int[])noInstances, (int)1);
            Checks.checkBuffer((int[])capsMask, (int)1);
        }
        JNI.callPPPPPV((long)__functionAddress, (int)queryId, (int)queryName.remaining(), (long)MemoryUtil.memAddress((ByteBuffer)queryName), (int[])dataSize, (int[])noCounters, (int[])noInstances, (int[])capsMask);
    }
}

