/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class INTELMapTexture {
    public static final int GL_TEXTURE_MEMORY_LAYOUT_INTEL = 33791;
    public static final int GL_LAYOUT_DEFAULT_INTEL = 0;
    public static final int GL_LAYOUT_LINEAR_INTEL = 1;
    public static final int GL_LAYOUT_LINEAR_CPU_CACHED_INTEL = 2;

    protected INTELMapTexture() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glSyncTextureINTEL, caps.glUnmapTexture2DINTEL, caps.glMapTexture2DINTEL});
    }

    public static void glSyncTextureINTEL(int texture) {
        long __functionAddress = GL.getCapabilities().glSyncTextureINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)texture);
    }

    public static void glUnmapTexture2DINTEL(int texture, int level) {
        long __functionAddress = GL.getCapabilities().glUnmapTexture2DINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)texture, (int)level);
    }

    public static long nglMapTexture2DINTEL(int texture, int level, int access, long stride, long layout) {
        long __functionAddress = GL.getCapabilities().glMapTexture2DINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callPPP((long)__functionAddress, (int)texture, (int)level, (int)access, (long)stride, (long)layout);
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, IntBuffer stride, IntBuffer layout) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)stride, (int)1);
            Checks.checkBuffer((Buffer)layout, (int)1);
        }
        long __result = INTELMapTexture.nglMapTexture2DINTEL(texture, level, access, MemoryUtil.memAddress((IntBuffer)stride), MemoryUtil.memAddress((IntBuffer)layout));
        return MemoryUtil.memByteBuffer((long)__result, (int)(INTELMapTexture.getStride(stride) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097)));
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, IntBuffer stride, IntBuffer layout, ByteBuffer old_buffer) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)stride, (int)1);
            Checks.checkBuffer((Buffer)layout, (int)1);
        }
        long __result = INTELMapTexture.nglMapTexture2DINTEL(texture, level, access, MemoryUtil.memAddress((IntBuffer)stride), MemoryUtil.memAddress((IntBuffer)layout));
        int length = INTELMapTexture.getStride(stride) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097);
        return old_buffer == null ? MemoryUtil.memByteBuffer((long)__result, (int)length) : MemoryUtil.memSetupBuffer((ByteBuffer)old_buffer, (long)__result, (int)length);
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, IntBuffer stride, IntBuffer layout, long length, ByteBuffer old_buffer) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)stride, (int)1);
            Checks.checkBuffer((Buffer)layout, (int)1);
        }
        long __result = INTELMapTexture.nglMapTexture2DINTEL(texture, level, access, MemoryUtil.memAddress((IntBuffer)stride), MemoryUtil.memAddress((IntBuffer)layout));
        return old_buffer == null ? MemoryUtil.memByteBuffer((long)__result, (int)((int)length)) : MemoryUtil.memSetupBuffer((ByteBuffer)old_buffer, (long)__result, (int)((int)length));
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, int[] stride, int[] layout) {
        long __functionAddress = GL.getCapabilities().glMapTexture2DINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])stride, (int)1);
            Checks.checkBuffer((int[])layout, (int)1);
        }
        long __result = JNI.callPPP((long)__functionAddress, (int)texture, (int)level, (int)access, (int[])stride, (int[])layout);
        return MemoryUtil.memByteBuffer((long)__result, (int)(INTELMapTexture.getStride(stride) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097)));
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, int[] stride, int[] layout, ByteBuffer old_buffer) {
        long __functionAddress = GL.getCapabilities().glMapTexture2DINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])stride, (int)1);
            Checks.checkBuffer((int[])layout, (int)1);
        }
        long __result = JNI.callPPP((long)__functionAddress, (int)texture, (int)level, (int)access, (int[])stride, (int[])layout);
        int length = INTELMapTexture.getStride(stride) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097);
        return old_buffer == null ? MemoryUtil.memByteBuffer((long)__result, (int)length) : MemoryUtil.memSetupBuffer((ByteBuffer)old_buffer, (long)__result, (int)length);
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, int[] stride, int[] layout, long length, ByteBuffer old_buffer) {
        long __functionAddress = GL.getCapabilities().glMapTexture2DINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])stride, (int)1);
            Checks.checkBuffer((int[])layout, (int)1);
        }
        long __result = JNI.callPPP((long)__functionAddress, (int)texture, (int)level, (int)access, (int[])stride, (int[])layout);
        return old_buffer == null ? MemoryUtil.memByteBuffer((long)__result, (int)((int)length)) : MemoryUtil.memSetupBuffer((ByteBuffer)old_buffer, (long)__result, (int)((int)length));
    }

    private static int getStride(IntBuffer stride) {
        return stride.get(stride.position());
    }

    private static int getStride(int[] stride) {
        return stride[0];
    }
}

