/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GL15 {
    public static final int GL_FOG_COORD_SRC = 33872;
    public static final int GL_FOG_COORD = 33873;
    public static final int GL_CURRENT_FOG_COORD = 33875;
    public static final int GL_FOG_COORD_ARRAY_TYPE = 33876;
    public static final int GL_FOG_COORD_ARRAY_STRIDE = 33877;
    public static final int GL_FOG_COORD_ARRAY_POINTER = 33878;
    public static final int GL_FOG_COORD_ARRAY = 33879;
    public static final int GL_FOG_COORD_ARRAY_BUFFER_BINDING = 34973;
    public static final int GL_SRC0_RGB = 34176;
    public static final int GL_SRC1_RGB = 34177;
    public static final int GL_SRC2_RGB = 34178;
    public static final int GL_SRC0_ALPHA = 34184;
    public static final int GL_SRC1_ALPHA = 34185;
    public static final int GL_SRC2_ALPHA = 34186;
    public static final int GL_ARRAY_BUFFER = 34962;
    public static final int GL_ELEMENT_ARRAY_BUFFER = 34963;
    public static final int GL_ARRAY_BUFFER_BINDING = 34964;
    public static final int GL_ELEMENT_ARRAY_BUFFER_BINDING = 34965;
    public static final int GL_VERTEX_ARRAY_BUFFER_BINDING = 34966;
    public static final int GL_NORMAL_ARRAY_BUFFER_BINDING = 34967;
    public static final int GL_COLOR_ARRAY_BUFFER_BINDING = 34968;
    public static final int GL_INDEX_ARRAY_BUFFER_BINDING = 34969;
    public static final int GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING = 34970;
    public static final int GL_EDGE_FLAG_ARRAY_BUFFER_BINDING = 34971;
    public static final int GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING = 34972;
    public static final int GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING = 34973;
    public static final int GL_WEIGHT_ARRAY_BUFFER_BINDING = 34974;
    public static final int GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 34975;
    public static final int GL_STREAM_DRAW = 35040;
    public static final int GL_STREAM_READ = 35041;
    public static final int GL_STREAM_COPY = 35042;
    public static final int GL_STATIC_DRAW = 35044;
    public static final int GL_STATIC_READ = 35045;
    public static final int GL_STATIC_COPY = 35046;
    public static final int GL_DYNAMIC_DRAW = 35048;
    public static final int GL_DYNAMIC_READ = 35049;
    public static final int GL_DYNAMIC_COPY = 35050;
    public static final int GL_READ_ONLY = 35000;
    public static final int GL_WRITE_ONLY = 35001;
    public static final int GL_READ_WRITE = 35002;
    public static final int GL_BUFFER_SIZE = 34660;
    public static final int GL_BUFFER_USAGE = 34661;
    public static final int GL_BUFFER_ACCESS = 35003;
    public static final int GL_BUFFER_MAPPED = 35004;
    public static final int GL_BUFFER_MAP_POINTER = 35005;
    public static final int GL_SAMPLES_PASSED = 35092;
    public static final int GL_QUERY_COUNTER_BITS = 34916;
    public static final int GL_CURRENT_QUERY = 34917;
    public static final int GL_QUERY_RESULT = 34918;
    public static final int GL_QUERY_RESULT_AVAILABLE = 34919;

    protected GL15() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glBindBuffer, caps.glDeleteBuffers, caps.glGenBuffers, caps.glIsBuffer, caps.glBufferData, caps.glBufferSubData, caps.glGetBufferSubData, caps.glMapBuffer, caps.glUnmapBuffer, caps.glGetBufferParameteriv, caps.glGetBufferPointerv, caps.glGenQueries, caps.glDeleteQueries, caps.glIsQuery, caps.glBeginQuery, caps.glEndQuery, caps.glGetQueryiv, caps.glGetQueryObjectiv, caps.glGetQueryObjectuiv});
    }

    public static void glBindBuffer(int target, int buffer) {
        long __functionAddress = GL.getCapabilities().glBindBuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)target, (int)buffer);
    }

    public static void nglDeleteBuffers(int n, long buffers) {
        long __functionAddress = GL.getCapabilities().glDeleteBuffers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)buffers);
    }

    public static void glDeleteBuffers(IntBuffer buffers) {
        GL15.nglDeleteBuffers(buffers.remaining(), MemoryUtil.memAddress((IntBuffer)buffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteBuffers(int buffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer buffers = stack.ints(buffer);
            GL15.nglDeleteBuffers(1, MemoryUtil.memAddress((IntBuffer)buffers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGenBuffers(int n, long buffers) {
        long __functionAddress = GL.getCapabilities().glGenBuffers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)buffers);
    }

    public static void glGenBuffers(IntBuffer buffers) {
        GL15.nglGenBuffers(buffers.remaining(), MemoryUtil.memAddress((IntBuffer)buffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenBuffers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer buffers = stack.callocInt(1);
            GL15.nglGenBuffers(1, MemoryUtil.memAddress((IntBuffer)buffers));
            int n = buffers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean glIsBuffer(int buffer) {
        long __functionAddress = GL.getCapabilities().glIsBuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress, (int)buffer);
    }

    public static void nglBufferData(int target, long size, long data, int usage) {
        long __functionAddress = GL.getCapabilities().glBufferData;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)target, (long)size, (long)data, (int)usage);
    }

    public static void glBufferData(int target, long size, int usage) {
        GL15.nglBufferData(target, size, 0L, usage);
    }

    public static void glBufferData(int target, ByteBuffer data, int usage) {
        GL15.nglBufferData(target, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data), usage);
    }

    public static void glBufferData(int target, ShortBuffer data, int usage) {
        GL15.nglBufferData(target, data.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)data), usage);
    }

    public static void glBufferData(int target, IntBuffer data, int usage) {
        GL15.nglBufferData(target, data.remaining() << 2, MemoryUtil.memAddress((IntBuffer)data), usage);
    }

    public static void glBufferData(int target, FloatBuffer data, int usage) {
        GL15.nglBufferData(target, data.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)data), usage);
    }

    public static void glBufferData(int target, DoubleBuffer data, int usage) {
        GL15.nglBufferData(target, data.remaining() << 3, MemoryUtil.memAddress((DoubleBuffer)data), usage);
    }

    public static void nglBufferSubData(int target, long offset, long size, long data) {
        long __functionAddress = GL.getCapabilities().glBufferSubData;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)size, (long)data);
    }

    public static void glBufferSubData(int target, long offset, ByteBuffer data) {
        GL15.nglBufferSubData(target, offset, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static void glBufferSubData(int target, long offset, ShortBuffer data) {
        GL15.nglBufferSubData(target, offset, data.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)data));
    }

    public static void glBufferSubData(int target, long offset, IntBuffer data) {
        GL15.nglBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress((IntBuffer)data));
    }

    public static void glBufferSubData(int target, long offset, FloatBuffer data) {
        GL15.nglBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static void glBufferSubData(int target, long offset, DoubleBuffer data) {
        GL15.nglBufferSubData(target, offset, data.remaining() << 3, MemoryUtil.memAddress((DoubleBuffer)data));
    }

    public static void nglGetBufferSubData(int target, long offset, long size, long data) {
        long __functionAddress = GL.getCapabilities().glGetBufferSubData;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)size, (long)data);
    }

    public static void glGetBufferSubData(int target, long offset, ByteBuffer data) {
        GL15.nglGetBufferSubData(target, offset, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static void glGetBufferSubData(int target, long offset, ShortBuffer data) {
        GL15.nglGetBufferSubData(target, offset, data.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)data));
    }

    public static void glGetBufferSubData(int target, long offset, IntBuffer data) {
        GL15.nglGetBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress((IntBuffer)data));
    }

    public static void glGetBufferSubData(int target, long offset, FloatBuffer data) {
        GL15.nglGetBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static void glGetBufferSubData(int target, long offset, DoubleBuffer data) {
        GL15.nglGetBufferSubData(target, offset, data.remaining() << 3, MemoryUtil.memAddress((DoubleBuffer)data));
    }

    public static long nglMapBuffer(int target, int access) {
        long __functionAddress = GL.getCapabilities().glMapBuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callP((long)__functionAddress, (int)target, (int)access);
    }

    public static ByteBuffer glMapBuffer(int target, int access) {
        long __result = GL15.nglMapBuffer(target, access);
        return MemoryUtil.memByteBuffer((long)__result, (int)GL15.glGetBufferParameteri(target, 34660));
    }

    public static ByteBuffer glMapBuffer(int target, int access, ByteBuffer old_buffer) {
        long __result = GL15.nglMapBuffer(target, access);
        int length = GL15.glGetBufferParameteri(target, 34660);
        return old_buffer == null ? MemoryUtil.memByteBuffer((long)__result, (int)length) : MemoryUtil.memSetupBuffer((ByteBuffer)old_buffer, (long)__result, (int)length);
    }

    public static ByteBuffer glMapBuffer(int target, int access, long length, ByteBuffer old_buffer) {
        long __result = GL15.nglMapBuffer(target, access);
        return old_buffer == null ? MemoryUtil.memByteBuffer((long)__result, (int)((int)length)) : MemoryUtil.memSetupBuffer((ByteBuffer)old_buffer, (long)__result, (int)((int)length));
    }

    public static boolean glUnmapBuffer(int target) {
        long __functionAddress = GL.getCapabilities().glUnmapBuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress, (int)target);
    }

    public static void nglGetBufferParameteriv(int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetBufferParameteriv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (long)params);
    }

    public static void glGetBufferParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        GL15.nglGetBufferParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetBufferParameteri(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL15.nglGetBufferParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetBufferPointerv(int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetBufferPointerv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (long)params);
    }

    public static void glGetBufferPointerv(int target, int pname, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((CustomBuffer)params, (int)1);
        }
        GL15.nglGetBufferPointerv(target, pname, MemoryUtil.memAddress((CustomBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetBufferPointer(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer params = stack.callocPointer(1);
            GL15.nglGetBufferPointerv(target, pname, MemoryUtil.memAddress((CustomBuffer)params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGenQueries(int n, long ids) {
        long __functionAddress = GL.getCapabilities().glGenQueries;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)ids);
    }

    public static void glGenQueries(IntBuffer ids) {
        GL15.nglGenQueries(ids.remaining(), MemoryUtil.memAddress((IntBuffer)ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenQueries() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.callocInt(1);
            GL15.nglGenQueries(1, MemoryUtil.memAddress((IntBuffer)ids));
            int n = ids.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDeleteQueries(int n, long ids) {
        long __functionAddress = GL.getCapabilities().glDeleteQueries;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)ids);
    }

    public static void glDeleteQueries(IntBuffer ids) {
        GL15.nglDeleteQueries(ids.remaining(), MemoryUtil.memAddress((IntBuffer)ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteQueries(int id) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.ints(id);
            GL15.nglDeleteQueries(1, MemoryUtil.memAddress((IntBuffer)ids));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean glIsQuery(int id) {
        long __functionAddress = GL.getCapabilities().glIsQuery;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress, (int)id);
    }

    public static void glBeginQuery(int target, int id) {
        long __functionAddress = GL.getCapabilities().glBeginQuery;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)target, (int)id);
    }

    public static void glEndQuery(int target) {
        long __functionAddress = GL.getCapabilities().glEndQuery;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)target);
    }

    public static void nglGetQueryiv(int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetQueryiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (long)params);
    }

    public static void glGetQueryiv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        GL15.nglGetQueryiv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetQueryi(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL15.nglGetQueryiv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetQueryObjectiv(int id, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetQueryObjectiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)id, (int)pname, (long)params);
    }

    public static void glGetQueryObjectiv(int id, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        GL15.nglGetQueryObjectiv(id, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetQueryObjecti(int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL15.nglGetQueryObjectiv(id, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetQueryObjectuiv(int id, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetQueryObjectuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)id, (int)pname, (long)params);
    }

    public static void glGetQueryObjectuiv(int id, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        GL15.nglGetQueryObjectuiv(id, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetQueryObjectui(int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL15.nglGetQueryObjectuiv(id, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDeleteBuffers(int[] buffers) {
        long __functionAddress = GL.getCapabilities().glDeleteBuffers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)buffers.length, (int[])buffers);
    }

    public static void glGenBuffers(int[] buffers) {
        long __functionAddress = GL.getCapabilities().glGenBuffers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)buffers.length, (int[])buffers);
    }

    public static void glBufferData(int target, short[] data, int usage) {
        long __functionAddress = GL.getCapabilities().glBufferData;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)target, (long)(data.length << 1), (short[])data, (int)usage);
    }

    public static void glBufferData(int target, int[] data, int usage) {
        long __functionAddress = GL.getCapabilities().glBufferData;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)target, (long)(data.length << 2), (int[])data, (int)usage);
    }

    public static void glBufferData(int target, float[] data, int usage) {
        long __functionAddress = GL.getCapabilities().glBufferData;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)target, (long)(data.length << 2), (float[])data, (int)usage);
    }

    public static void glBufferData(int target, double[] data, int usage) {
        long __functionAddress = GL.getCapabilities().glBufferData;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)target, (long)(data.length << 3), (double[])data, (int)usage);
    }

    public static void glBufferSubData(int target, long offset, short[] data) {
        long __functionAddress = GL.getCapabilities().glBufferSubData;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 1), (short[])data);
    }

    public static void glBufferSubData(int target, long offset, int[] data) {
        long __functionAddress = GL.getCapabilities().glBufferSubData;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 2), (int[])data);
    }

    public static void glBufferSubData(int target, long offset, float[] data) {
        long __functionAddress = GL.getCapabilities().glBufferSubData;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 2), (float[])data);
    }

    public static void glBufferSubData(int target, long offset, double[] data) {
        long __functionAddress = GL.getCapabilities().glBufferSubData;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 3), (double[])data);
    }

    public static void glGetBufferSubData(int target, long offset, short[] data) {
        long __functionAddress = GL.getCapabilities().glGetBufferSubData;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 1), (short[])data);
    }

    public static void glGetBufferSubData(int target, long offset, int[] data) {
        long __functionAddress = GL.getCapabilities().glGetBufferSubData;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 2), (int[])data);
    }

    public static void glGetBufferSubData(int target, long offset, float[] data) {
        long __functionAddress = GL.getCapabilities().glGetBufferSubData;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 2), (float[])data);
    }

    public static void glGetBufferSubData(int target, long offset, double[] data) {
        long __functionAddress = GL.getCapabilities().glGetBufferSubData;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 3), (double[])data);
    }

    public static void glGetBufferParameteriv(int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetBufferParameteriv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (int[])params);
    }

    public static void glGenQueries(int[] ids) {
        long __functionAddress = GL.getCapabilities().glGenQueries;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)ids.length, (int[])ids);
    }

    public static void glDeleteQueries(int[] ids) {
        long __functionAddress = GL.getCapabilities().glDeleteQueries;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)ids.length, (int[])ids);
    }

    public static void glGetQueryiv(int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetQueryiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (int[])params);
    }

    public static void glGetQueryObjectiv(int id, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetQueryObjectiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)id, (int)pname, (int[])params);
    }

    public static void glGetQueryObjectuiv(int id, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetQueryObjectuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)id, (int)pname, (int[])params);
    }
}

