/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GL11 {
    public static final int GL_ACCUM = 256;
    public static final int GL_LOAD = 257;
    public static final int GL_RETURN = 258;
    public static final int GL_MULT = 259;
    public static final int GL_ADD = 260;
    public static final int GL_NEVER = 512;
    public static final int GL_LESS = 513;
    public static final int GL_EQUAL = 514;
    public static final int GL_LEQUAL = 515;
    public static final int GL_GREATER = 516;
    public static final int GL_NOTEQUAL = 517;
    public static final int GL_GEQUAL = 518;
    public static final int GL_ALWAYS = 519;
    public static final int GL_CURRENT_BIT = 1;
    public static final int GL_POINT_BIT = 2;
    public static final int GL_LINE_BIT = 4;
    public static final int GL_POLYGON_BIT = 8;
    public static final int GL_POLYGON_STIPPLE_BIT = 16;
    public static final int GL_PIXEL_MODE_BIT = 32;
    public static final int GL_LIGHTING_BIT = 64;
    public static final int GL_FOG_BIT = 128;
    public static final int GL_DEPTH_BUFFER_BIT = 256;
    public static final int GL_ACCUM_BUFFER_BIT = 512;
    public static final int GL_STENCIL_BUFFER_BIT = 1024;
    public static final int GL_VIEWPORT_BIT = 2048;
    public static final int GL_TRANSFORM_BIT = 4096;
    public static final int GL_ENABLE_BIT = 8192;
    public static final int GL_COLOR_BUFFER_BIT = 16384;
    public static final int GL_HINT_BIT = 32768;
    public static final int GL_EVAL_BIT = 65536;
    public static final int GL_LIST_BIT = 131072;
    public static final int GL_TEXTURE_BIT = 262144;
    public static final int GL_SCISSOR_BIT = 524288;
    public static final int GL_ALL_ATTRIB_BITS = 1048575;
    public static final int GL_POINTS = 0;
    public static final int GL_LINES = 1;
    public static final int GL_LINE_LOOP = 2;
    public static final int GL_LINE_STRIP = 3;
    public static final int GL_TRIANGLES = 4;
    public static final int GL_TRIANGLE_STRIP = 5;
    public static final int GL_TRIANGLE_FAN = 6;
    public static final int GL_QUADS = 7;
    public static final int GL_QUAD_STRIP = 8;
    public static final int GL_POLYGON = 9;
    public static final int GL_ZERO = 0;
    public static final int GL_ONE = 1;
    public static final int GL_SRC_COLOR = 768;
    public static final int GL_ONE_MINUS_SRC_COLOR = 769;
    public static final int GL_SRC_ALPHA = 770;
    public static final int GL_ONE_MINUS_SRC_ALPHA = 771;
    public static final int GL_DST_ALPHA = 772;
    public static final int GL_ONE_MINUS_DST_ALPHA = 773;
    public static final int GL_DST_COLOR = 774;
    public static final int GL_ONE_MINUS_DST_COLOR = 775;
    public static final int GL_SRC_ALPHA_SATURATE = 776;
    public static final int GL_TRUE = 1;
    public static final int GL_FALSE = 0;
    public static final int GL_CLIP_PLANE0 = 12288;
    public static final int GL_CLIP_PLANE1 = 12289;
    public static final int GL_CLIP_PLANE2 = 12290;
    public static final int GL_CLIP_PLANE3 = 12291;
    public static final int GL_CLIP_PLANE4 = 12292;
    public static final int GL_CLIP_PLANE5 = 12293;
    public static final int GL_BYTE = 5120;
    public static final int GL_UNSIGNED_BYTE = 5121;
    public static final int GL_SHORT = 5122;
    public static final int GL_UNSIGNED_SHORT = 5123;
    public static final int GL_INT = 5124;
    public static final int GL_UNSIGNED_INT = 5125;
    public static final int GL_FLOAT = 5126;
    public static final int GL_2_BYTES = 5127;
    public static final int GL_3_BYTES = 5128;
    public static final int GL_4_BYTES = 5129;
    public static final int GL_DOUBLE = 5130;
    public static final int GL_NONE = 0;
    public static final int GL_FRONT_LEFT = 1024;
    public static final int GL_FRONT_RIGHT = 1025;
    public static final int GL_BACK_LEFT = 1026;
    public static final int GL_BACK_RIGHT = 1027;
    public static final int GL_FRONT = 1028;
    public static final int GL_BACK = 1029;
    public static final int GL_LEFT = 1030;
    public static final int GL_RIGHT = 1031;
    public static final int GL_FRONT_AND_BACK = 1032;
    public static final int GL_AUX0 = 1033;
    public static final int GL_AUX1 = 1034;
    public static final int GL_AUX2 = 1035;
    public static final int GL_AUX3 = 1036;
    public static final int GL_NO_ERROR = 0;
    public static final int GL_INVALID_ENUM = 1280;
    public static final int GL_INVALID_VALUE = 1281;
    public static final int GL_INVALID_OPERATION = 1282;
    public static final int GL_STACK_OVERFLOW = 1283;
    public static final int GL_STACK_UNDERFLOW = 1284;
    public static final int GL_OUT_OF_MEMORY = 1285;
    public static final int GL_2D = 1536;
    public static final int GL_3D = 1537;
    public static final int GL_3D_COLOR = 1538;
    public static final int GL_3D_COLOR_TEXTURE = 1539;
    public static final int GL_4D_COLOR_TEXTURE = 1540;
    public static final int GL_PASS_THROUGH_TOKEN = 1792;
    public static final int GL_POINT_TOKEN = 1793;
    public static final int GL_LINE_TOKEN = 1794;
    public static final int GL_POLYGON_TOKEN = 1795;
    public static final int GL_BITMAP_TOKEN = 1796;
    public static final int GL_DRAW_PIXEL_TOKEN = 1797;
    public static final int GL_COPY_PIXEL_TOKEN = 1798;
    public static final int GL_LINE_RESET_TOKEN = 1799;
    public static final int GL_EXP = 2048;
    public static final int GL_EXP2 = 2049;
    public static final int GL_CW = 2304;
    public static final int GL_CCW = 2305;
    public static final int GL_COEFF = 2560;
    public static final int GL_ORDER = 2561;
    public static final int GL_DOMAIN = 2562;
    public static final int GL_CURRENT_COLOR = 2816;
    public static final int GL_CURRENT_INDEX = 2817;
    public static final int GL_CURRENT_NORMAL = 2818;
    public static final int GL_CURRENT_TEXTURE_COORDS = 2819;
    public static final int GL_CURRENT_RASTER_COLOR = 2820;
    public static final int GL_CURRENT_RASTER_INDEX = 2821;
    public static final int GL_CURRENT_RASTER_TEXTURE_COORDS = 2822;
    public static final int GL_CURRENT_RASTER_POSITION = 2823;
    public static final int GL_CURRENT_RASTER_POSITION_VALID = 2824;
    public static final int GL_CURRENT_RASTER_DISTANCE = 2825;
    public static final int GL_POINT_SMOOTH = 2832;
    public static final int GL_POINT_SIZE = 2833;
    public static final int GL_POINT_SIZE_RANGE = 2834;
    public static final int GL_POINT_SIZE_GRANULARITY = 2835;
    public static final int GL_LINE_SMOOTH = 2848;
    public static final int GL_LINE_WIDTH = 2849;
    public static final int GL_LINE_WIDTH_RANGE = 2850;
    public static final int GL_LINE_WIDTH_GRANULARITY = 2851;
    public static final int GL_LINE_STIPPLE = 2852;
    public static final int GL_LINE_STIPPLE_PATTERN = 2853;
    public static final int GL_LINE_STIPPLE_REPEAT = 2854;
    public static final int GL_LIST_MODE = 2864;
    public static final int GL_MAX_LIST_NESTING = 2865;
    public static final int GL_LIST_BASE = 2866;
    public static final int GL_LIST_INDEX = 2867;
    public static final int GL_POLYGON_MODE = 2880;
    public static final int GL_POLYGON_SMOOTH = 2881;
    public static final int GL_POLYGON_STIPPLE = 2882;
    public static final int GL_EDGE_FLAG = 2883;
    public static final int GL_CULL_FACE = 2884;
    public static final int GL_CULL_FACE_MODE = 2885;
    public static final int GL_FRONT_FACE = 2886;
    public static final int GL_LIGHTING = 2896;
    public static final int GL_LIGHT_MODEL_LOCAL_VIEWER = 2897;
    public static final int GL_LIGHT_MODEL_TWO_SIDE = 2898;
    public static final int GL_LIGHT_MODEL_AMBIENT = 2899;
    public static final int GL_SHADE_MODEL = 2900;
    public static final int GL_COLOR_MATERIAL_FACE = 2901;
    public static final int GL_COLOR_MATERIAL_PARAMETER = 2902;
    public static final int GL_COLOR_MATERIAL = 2903;
    public static final int GL_FOG = 2912;
    public static final int GL_FOG_INDEX = 2913;
    public static final int GL_FOG_DENSITY = 2914;
    public static final int GL_FOG_START = 2915;
    public static final int GL_FOG_END = 2916;
    public static final int GL_FOG_MODE = 2917;
    public static final int GL_FOG_COLOR = 2918;
    public static final int GL_DEPTH_RANGE = 2928;
    public static final int GL_DEPTH_TEST = 2929;
    public static final int GL_DEPTH_WRITEMASK = 2930;
    public static final int GL_DEPTH_CLEAR_VALUE = 2931;
    public static final int GL_DEPTH_FUNC = 2932;
    public static final int GL_ACCUM_CLEAR_VALUE = 2944;
    public static final int GL_STENCIL_TEST = 2960;
    public static final int GL_STENCIL_CLEAR_VALUE = 2961;
    public static final int GL_STENCIL_FUNC = 2962;
    public static final int GL_STENCIL_VALUE_MASK = 2963;
    public static final int GL_STENCIL_FAIL = 2964;
    public static final int GL_STENCIL_PASS_DEPTH_FAIL = 2965;
    public static final int GL_STENCIL_PASS_DEPTH_PASS = 2966;
    public static final int GL_STENCIL_REF = 2967;
    public static final int GL_STENCIL_WRITEMASK = 2968;
    public static final int GL_MATRIX_MODE = 2976;
    public static final int GL_NORMALIZE = 2977;
    public static final int GL_VIEWPORT = 2978;
    public static final int GL_MODELVIEW_STACK_DEPTH = 2979;
    public static final int GL_PROJECTION_STACK_DEPTH = 2980;
    public static final int GL_TEXTURE_STACK_DEPTH = 2981;
    public static final int GL_MODELVIEW_MATRIX = 2982;
    public static final int GL_PROJECTION_MATRIX = 2983;
    public static final int GL_TEXTURE_MATRIX = 2984;
    public static final int GL_ATTRIB_STACK_DEPTH = 2992;
    public static final int GL_CLIENT_ATTRIB_STACK_DEPTH = 2993;
    public static final int GL_ALPHA_TEST = 3008;
    public static final int GL_ALPHA_TEST_FUNC = 3009;
    public static final int GL_ALPHA_TEST_REF = 3010;
    public static final int GL_DITHER = 3024;
    public static final int GL_BLEND_DST = 3040;
    public static final int GL_BLEND_SRC = 3041;
    public static final int GL_BLEND = 3042;
    public static final int GL_LOGIC_OP_MODE = 3056;
    public static final int GL_INDEX_LOGIC_OP = 3057;
    public static final int GL_LOGIC_OP = 3057;
    public static final int GL_COLOR_LOGIC_OP = 3058;
    public static final int GL_AUX_BUFFERS = 3072;
    public static final int GL_DRAW_BUFFER = 3073;
    public static final int GL_READ_BUFFER = 3074;
    public static final int GL_SCISSOR_BOX = 3088;
    public static final int GL_SCISSOR_TEST = 3089;
    public static final int GL_INDEX_CLEAR_VALUE = 3104;
    public static final int GL_INDEX_WRITEMASK = 3105;
    public static final int GL_COLOR_CLEAR_VALUE = 3106;
    public static final int GL_COLOR_WRITEMASK = 3107;
    public static final int GL_INDEX_MODE = 3120;
    public static final int GL_RGBA_MODE = 3121;
    public static final int GL_DOUBLEBUFFER = 3122;
    public static final int GL_STEREO = 3123;
    public static final int GL_RENDER_MODE = 3136;
    public static final int GL_PERSPECTIVE_CORRECTION_HINT = 3152;
    public static final int GL_POINT_SMOOTH_HINT = 3153;
    public static final int GL_LINE_SMOOTH_HINT = 3154;
    public static final int GL_POLYGON_SMOOTH_HINT = 3155;
    public static final int GL_FOG_HINT = 3156;
    public static final int GL_TEXTURE_GEN_S = 3168;
    public static final int GL_TEXTURE_GEN_T = 3169;
    public static final int GL_TEXTURE_GEN_R = 3170;
    public static final int GL_TEXTURE_GEN_Q = 3171;
    public static final int GL_PIXEL_MAP_I_TO_I = 3184;
    public static final int GL_PIXEL_MAP_S_TO_S = 3185;
    public static final int GL_PIXEL_MAP_I_TO_R = 3186;
    public static final int GL_PIXEL_MAP_I_TO_G = 3187;
    public static final int GL_PIXEL_MAP_I_TO_B = 3188;
    public static final int GL_PIXEL_MAP_I_TO_A = 3189;
    public static final int GL_PIXEL_MAP_R_TO_R = 3190;
    public static final int GL_PIXEL_MAP_G_TO_G = 3191;
    public static final int GL_PIXEL_MAP_B_TO_B = 3192;
    public static final int GL_PIXEL_MAP_A_TO_A = 3193;
    public static final int GL_PIXEL_MAP_I_TO_I_SIZE = 3248;
    public static final int GL_PIXEL_MAP_S_TO_S_SIZE = 3249;
    public static final int GL_PIXEL_MAP_I_TO_R_SIZE = 3250;
    public static final int GL_PIXEL_MAP_I_TO_G_SIZE = 3251;
    public static final int GL_PIXEL_MAP_I_TO_B_SIZE = 3252;
    public static final int GL_PIXEL_MAP_I_TO_A_SIZE = 3253;
    public static final int GL_PIXEL_MAP_R_TO_R_SIZE = 3254;
    public static final int GL_PIXEL_MAP_G_TO_G_SIZE = 3255;
    public static final int GL_PIXEL_MAP_B_TO_B_SIZE = 3256;
    public static final int GL_PIXEL_MAP_A_TO_A_SIZE = 3257;
    public static final int GL_UNPACK_SWAP_BYTES = 3312;
    public static final int GL_UNPACK_LSB_FIRST = 3313;
    public static final int GL_UNPACK_ROW_LENGTH = 3314;
    public static final int GL_UNPACK_SKIP_ROWS = 3315;
    public static final int GL_UNPACK_SKIP_PIXELS = 3316;
    public static final int GL_UNPACK_ALIGNMENT = 3317;
    public static final int GL_PACK_SWAP_BYTES = 3328;
    public static final int GL_PACK_LSB_FIRST = 3329;
    public static final int GL_PACK_ROW_LENGTH = 3330;
    public static final int GL_PACK_SKIP_ROWS = 3331;
    public static final int GL_PACK_SKIP_PIXELS = 3332;
    public static final int GL_PACK_ALIGNMENT = 3333;
    public static final int GL_MAP_COLOR = 3344;
    public static final int GL_MAP_STENCIL = 3345;
    public static final int GL_INDEX_SHIFT = 3346;
    public static final int GL_INDEX_OFFSET = 3347;
    public static final int GL_RED_SCALE = 3348;
    public static final int GL_RED_BIAS = 3349;
    public static final int GL_ZOOM_X = 3350;
    public static final int GL_ZOOM_Y = 3351;
    public static final int GL_GREEN_SCALE = 3352;
    public static final int GL_GREEN_BIAS = 3353;
    public static final int GL_BLUE_SCALE = 3354;
    public static final int GL_BLUE_BIAS = 3355;
    public static final int GL_ALPHA_SCALE = 3356;
    public static final int GL_ALPHA_BIAS = 3357;
    public static final int GL_DEPTH_SCALE = 3358;
    public static final int GL_DEPTH_BIAS = 3359;
    public static final int GL_MAX_EVAL_ORDER = 3376;
    public static final int GL_MAX_LIGHTS = 3377;
    public static final int GL_MAX_CLIP_PLANES = 3378;
    public static final int GL_MAX_TEXTURE_SIZE = 3379;
    public static final int GL_MAX_PIXEL_MAP_TABLE = 3380;
    public static final int GL_MAX_ATTRIB_STACK_DEPTH = 3381;
    public static final int GL_MAX_MODELVIEW_STACK_DEPTH = 3382;
    public static final int GL_MAX_NAME_STACK_DEPTH = 3383;
    public static final int GL_MAX_PROJECTION_STACK_DEPTH = 3384;
    public static final int GL_MAX_TEXTURE_STACK_DEPTH = 3385;
    public static final int GL_MAX_VIEWPORT_DIMS = 3386;
    public static final int GL_MAX_CLIENT_ATTRIB_STACK_DEPTH = 3387;
    public static final int GL_SUBPIXEL_BITS = 3408;
    public static final int GL_INDEX_BITS = 3409;
    public static final int GL_RED_BITS = 3410;
    public static final int GL_GREEN_BITS = 3411;
    public static final int GL_BLUE_BITS = 3412;
    public static final int GL_ALPHA_BITS = 3413;
    public static final int GL_DEPTH_BITS = 3414;
    public static final int GL_STENCIL_BITS = 3415;
    public static final int GL_ACCUM_RED_BITS = 3416;
    public static final int GL_ACCUM_GREEN_BITS = 3417;
    public static final int GL_ACCUM_BLUE_BITS = 3418;
    public static final int GL_ACCUM_ALPHA_BITS = 3419;
    public static final int GL_NAME_STACK_DEPTH = 3440;
    public static final int GL_AUTO_NORMAL = 3456;
    public static final int GL_MAP1_COLOR_4 = 3472;
    public static final int GL_MAP1_INDEX = 3473;
    public static final int GL_MAP1_NORMAL = 3474;
    public static final int GL_MAP1_TEXTURE_COORD_1 = 3475;
    public static final int GL_MAP1_TEXTURE_COORD_2 = 3476;
    public static final int GL_MAP1_TEXTURE_COORD_3 = 3477;
    public static final int GL_MAP1_TEXTURE_COORD_4 = 3478;
    public static final int GL_MAP1_VERTEX_3 = 3479;
    public static final int GL_MAP1_VERTEX_4 = 3480;
    public static final int GL_MAP2_COLOR_4 = 3504;
    public static final int GL_MAP2_INDEX = 3505;
    public static final int GL_MAP2_NORMAL = 3506;
    public static final int GL_MAP2_TEXTURE_COORD_1 = 3507;
    public static final int GL_MAP2_TEXTURE_COORD_2 = 3508;
    public static final int GL_MAP2_TEXTURE_COORD_3 = 3509;
    public static final int GL_MAP2_TEXTURE_COORD_4 = 3510;
    public static final int GL_MAP2_VERTEX_3 = 3511;
    public static final int GL_MAP2_VERTEX_4 = 3512;
    public static final int GL_MAP1_GRID_DOMAIN = 3536;
    public static final int GL_MAP1_GRID_SEGMENTS = 3537;
    public static final int GL_MAP2_GRID_DOMAIN = 3538;
    public static final int GL_MAP2_GRID_SEGMENTS = 3539;
    public static final int GL_TEXTURE_1D = 3552;
    public static final int GL_TEXTURE_2D = 3553;
    public static final int GL_FEEDBACK_BUFFER_POINTER = 3568;
    public static final int GL_FEEDBACK_BUFFER_SIZE = 3569;
    public static final int GL_FEEDBACK_BUFFER_TYPE = 3570;
    public static final int GL_SELECTION_BUFFER_POINTER = 3571;
    public static final int GL_SELECTION_BUFFER_SIZE = 3572;
    public static final int GL_TEXTURE_WIDTH = 4096;
    public static final int GL_TEXTURE_HEIGHT = 4097;
    public static final int GL_TEXTURE_INTERNAL_FORMAT = 4099;
    public static final int GL_TEXTURE_COMPONENTS = 4099;
    public static final int GL_TEXTURE_BORDER_COLOR = 4100;
    public static final int GL_TEXTURE_BORDER = 4101;
    public static final int GL_DONT_CARE = 4352;
    public static final int GL_FASTEST = 4353;
    public static final int GL_NICEST = 4354;
    public static final int GL_LIGHT0 = 16384;
    public static final int GL_LIGHT1 = 16385;
    public static final int GL_LIGHT2 = 16386;
    public static final int GL_LIGHT3 = 16387;
    public static final int GL_LIGHT4 = 16388;
    public static final int GL_LIGHT5 = 16389;
    public static final int GL_LIGHT6 = 16390;
    public static final int GL_LIGHT7 = 16391;
    public static final int GL_AMBIENT = 4608;
    public static final int GL_DIFFUSE = 4609;
    public static final int GL_SPECULAR = 4610;
    public static final int GL_POSITION = 4611;
    public static final int GL_SPOT_DIRECTION = 4612;
    public static final int GL_SPOT_EXPONENT = 4613;
    public static final int GL_SPOT_CUTOFF = 4614;
    public static final int GL_CONSTANT_ATTENUATION = 4615;
    public static final int GL_LINEAR_ATTENUATION = 4616;
    public static final int GL_QUADRATIC_ATTENUATION = 4617;
    public static final int GL_COMPILE = 4864;
    public static final int GL_COMPILE_AND_EXECUTE = 4865;
    public static final int GL_CLEAR = 5376;
    public static final int GL_AND = 5377;
    public static final int GL_AND_REVERSE = 5378;
    public static final int GL_COPY = 5379;
    public static final int GL_AND_INVERTED = 5380;
    public static final int GL_NOOP = 5381;
    public static final int GL_XOR = 5382;
    public static final int GL_OR = 5383;
    public static final int GL_NOR = 5384;
    public static final int GL_EQUIV = 5385;
    public static final int GL_INVERT = 5386;
    public static final int GL_OR_REVERSE = 5387;
    public static final int GL_COPY_INVERTED = 5388;
    public static final int GL_OR_INVERTED = 5389;
    public static final int GL_NAND = 5390;
    public static final int GL_SET = 5391;
    public static final int GL_EMISSION = 5632;
    public static final int GL_SHININESS = 5633;
    public static final int GL_AMBIENT_AND_DIFFUSE = 5634;
    public static final int GL_COLOR_INDEXES = 5635;
    public static final int GL_MODELVIEW = 5888;
    public static final int GL_PROJECTION = 5889;
    public static final int GL_TEXTURE = 5890;
    public static final int GL_COLOR = 6144;
    public static final int GL_DEPTH = 6145;
    public static final int GL_STENCIL = 6146;
    public static final int GL_COLOR_INDEX = 6400;
    public static final int GL_STENCIL_INDEX = 6401;
    public static final int GL_DEPTH_COMPONENT = 6402;
    public static final int GL_RED = 6403;
    public static final int GL_GREEN = 6404;
    public static final int GL_BLUE = 6405;
    public static final int GL_ALPHA = 6406;
    public static final int GL_RGB = 6407;
    public static final int GL_RGBA = 6408;
    public static final int GL_LUMINANCE = 6409;
    public static final int GL_LUMINANCE_ALPHA = 6410;
    public static final int GL_BITMAP = 6656;
    public static final int GL_POINT = 6912;
    public static final int GL_LINE = 6913;
    public static final int GL_FILL = 6914;
    public static final int GL_RENDER = 7168;
    public static final int GL_FEEDBACK = 7169;
    public static final int GL_SELECT = 7170;
    public static final int GL_FLAT = 7424;
    public static final int GL_SMOOTH = 7425;
    public static final int GL_KEEP = 7680;
    public static final int GL_REPLACE = 7681;
    public static final int GL_INCR = 7682;
    public static final int GL_DECR = 7683;
    public static final int GL_VENDOR = 7936;
    public static final int GL_RENDERER = 7937;
    public static final int GL_VERSION = 7938;
    public static final int GL_EXTENSIONS = 7939;
    public static final int GL_S = 8192;
    public static final int GL_T = 8193;
    public static final int GL_R = 8194;
    public static final int GL_Q = 8195;
    public static final int GL_MODULATE = 8448;
    public static final int GL_DECAL = 8449;
    public static final int GL_TEXTURE_ENV_MODE = 8704;
    public static final int GL_TEXTURE_ENV_COLOR = 8705;
    public static final int GL_TEXTURE_ENV = 8960;
    public static final int GL_EYE_LINEAR = 9216;
    public static final int GL_OBJECT_LINEAR = 9217;
    public static final int GL_SPHERE_MAP = 9218;
    public static final int GL_TEXTURE_GEN_MODE = 9472;
    public static final int GL_OBJECT_PLANE = 9473;
    public static final int GL_EYE_PLANE = 9474;
    public static final int GL_NEAREST = 9728;
    public static final int GL_LINEAR = 9729;
    public static final int GL_NEAREST_MIPMAP_NEAREST = 9984;
    public static final int GL_LINEAR_MIPMAP_NEAREST = 9985;
    public static final int GL_NEAREST_MIPMAP_LINEAR = 9986;
    public static final int GL_LINEAR_MIPMAP_LINEAR = 9987;
    public static final int GL_TEXTURE_MAG_FILTER = 10240;
    public static final int GL_TEXTURE_MIN_FILTER = 10241;
    public static final int GL_TEXTURE_WRAP_S = 10242;
    public static final int GL_TEXTURE_WRAP_T = 10243;
    public static final int GL_CLAMP = 10496;
    public static final int GL_REPEAT = 10497;
    public static final int GL_CLIENT_PIXEL_STORE_BIT = 1;
    public static final int GL_CLIENT_VERTEX_ARRAY_BIT = 2;
    public static final int GL_CLIENT_ALL_ATTRIB_BITS = -1;
    public static final int GL_POLYGON_OFFSET_FACTOR = 32824;
    public static final int GL_POLYGON_OFFSET_UNITS = 10752;
    public static final int GL_POLYGON_OFFSET_POINT = 10753;
    public static final int GL_POLYGON_OFFSET_LINE = 10754;
    public static final int GL_POLYGON_OFFSET_FILL = 32823;
    public static final int GL_ALPHA4 = 32827;
    public static final int GL_ALPHA8 = 32828;
    public static final int GL_ALPHA12 = 32829;
    public static final int GL_ALPHA16 = 32830;
    public static final int GL_LUMINANCE4 = 32831;
    public static final int GL_LUMINANCE8 = 32832;
    public static final int GL_LUMINANCE12 = 32833;
    public static final int GL_LUMINANCE16 = 32834;
    public static final int GL_LUMINANCE4_ALPHA4 = 32835;
    public static final int GL_LUMINANCE6_ALPHA2 = 32836;
    public static final int GL_LUMINANCE8_ALPHA8 = 32837;
    public static final int GL_LUMINANCE12_ALPHA4 = 32838;
    public static final int GL_LUMINANCE12_ALPHA12 = 32839;
    public static final int GL_LUMINANCE16_ALPHA16 = 32840;
    public static final int GL_INTENSITY = 32841;
    public static final int GL_INTENSITY4 = 32842;
    public static final int GL_INTENSITY8 = 32843;
    public static final int GL_INTENSITY12 = 32844;
    public static final int GL_INTENSITY16 = 32845;
    public static final int GL_R3_G3_B2 = 10768;
    public static final int GL_RGB4 = 32847;
    public static final int GL_RGB5 = 32848;
    public static final int GL_RGB8 = 32849;
    public static final int GL_RGB10 = 32850;
    public static final int GL_RGB12 = 32851;
    public static final int GL_RGB16 = 32852;
    public static final int GL_RGBA2 = 32853;
    public static final int GL_RGBA4 = 32854;
    public static final int GL_RGB5_A1 = 32855;
    public static final int GL_RGBA8 = 32856;
    public static final int GL_RGB10_A2 = 32857;
    public static final int GL_RGBA12 = 32858;
    public static final int GL_RGBA16 = 32859;
    public static final int GL_TEXTURE_RED_SIZE = 32860;
    public static final int GL_TEXTURE_GREEN_SIZE = 32861;
    public static final int GL_TEXTURE_BLUE_SIZE = 32862;
    public static final int GL_TEXTURE_ALPHA_SIZE = 32863;
    public static final int GL_TEXTURE_LUMINANCE_SIZE = 32864;
    public static final int GL_TEXTURE_INTENSITY_SIZE = 32865;
    public static final int GL_PROXY_TEXTURE_1D = 32867;
    public static final int GL_PROXY_TEXTURE_2D = 32868;
    public static final int GL_TEXTURE_PRIORITY = 32870;
    public static final int GL_TEXTURE_RESIDENT = 32871;
    public static final int GL_TEXTURE_BINDING_1D = 32872;
    public static final int GL_TEXTURE_BINDING_2D = 32873;
    public static final int GL_VERTEX_ARRAY = 32884;
    public static final int GL_NORMAL_ARRAY = 32885;
    public static final int GL_COLOR_ARRAY = 32886;
    public static final int GL_INDEX_ARRAY = 32887;
    public static final int GL_TEXTURE_COORD_ARRAY = 32888;
    public static final int GL_EDGE_FLAG_ARRAY = 32889;
    public static final int GL_VERTEX_ARRAY_SIZE = 32890;
    public static final int GL_VERTEX_ARRAY_TYPE = 32891;
    public static final int GL_VERTEX_ARRAY_STRIDE = 32892;
    public static final int GL_NORMAL_ARRAY_TYPE = 32894;
    public static final int GL_NORMAL_ARRAY_STRIDE = 32895;
    public static final int GL_COLOR_ARRAY_SIZE = 32897;
    public static final int GL_COLOR_ARRAY_TYPE = 32898;
    public static final int GL_COLOR_ARRAY_STRIDE = 32899;
    public static final int GL_INDEX_ARRAY_TYPE = 32901;
    public static final int GL_INDEX_ARRAY_STRIDE = 32902;
    public static final int GL_TEXTURE_COORD_ARRAY_SIZE = 32904;
    public static final int GL_TEXTURE_COORD_ARRAY_TYPE = 32905;
    public static final int GL_TEXTURE_COORD_ARRAY_STRIDE = 32906;
    public static final int GL_EDGE_FLAG_ARRAY_STRIDE = 32908;
    public static final int GL_VERTEX_ARRAY_POINTER = 32910;
    public static final int GL_NORMAL_ARRAY_POINTER = 32911;
    public static final int GL_COLOR_ARRAY_POINTER = 32912;
    public static final int GL_INDEX_ARRAY_POINTER = 32913;
    public static final int GL_TEXTURE_COORD_ARRAY_POINTER = 32914;
    public static final int GL_EDGE_FLAG_ARRAY_POINTER = 32915;
    public static final int GL_V2F = 10784;
    public static final int GL_V3F = 10785;
    public static final int GL_C4UB_V2F = 10786;
    public static final int GL_C4UB_V3F = 10787;
    public static final int GL_C3F_V3F = 10788;
    public static final int GL_N3F_V3F = 10789;
    public static final int GL_C4F_N3F_V3F = 10790;
    public static final int GL_T2F_V3F = 10791;
    public static final int GL_T4F_V4F = 10792;
    public static final int GL_T2F_C4UB_V3F = 10793;
    public static final int GL_T2F_C3F_V3F = 10794;
    public static final int GL_T2F_N3F_V3F = 10795;
    public static final int GL_T2F_C4F_N3F_V3F = 10796;
    public static final int GL_T4F_C4F_N3F_V4F = 10797;

    protected GL11() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps, boolean fc) {
        return (fc || Checks.checkFunctions((long[])new long[]{caps.glAccum, caps.glAlphaFunc, caps.glAreTexturesResident, caps.glBegin, caps.glBitmap, caps.glCallList, caps.glCallLists, caps.glClearAccum, caps.glClearIndex, caps.glColor3b, caps.glColor3s, caps.glColor3i, caps.glColor3f, caps.glColor3d, caps.glColor3ub, caps.glColor3us, caps.glColor3ui, caps.glColor3bv, caps.glColor3sv, caps.glColor3iv, caps.glColor3fv, caps.glColor3dv, caps.glColor3ubv, caps.glColor3usv, caps.glColor3uiv, caps.glColor4b, caps.glColor4s, caps.glColor4i, caps.glColor4f, caps.glColor4d, caps.glColor4ub, caps.glColor4us, caps.glColor4ui, caps.glColor4bv, caps.glColor4sv, caps.glColor4iv, caps.glColor4fv, caps.glColor4dv, caps.glColor4ubv, caps.glColor4usv, caps.glColor4uiv, caps.glColorMaterial, caps.glColorPointer, caps.glDeleteLists, caps.glDisableClientState, caps.glDrawPixels, caps.glEdgeFlag, caps.glEdgeFlagv, caps.glEdgeFlagPointer, caps.glEnableClientState, caps.glEnd, caps.glEvalCoord1f, caps.glEvalCoord1fv, caps.glEvalCoord1d, caps.glEvalCoord1dv, caps.glEvalCoord2f, caps.glEvalCoord2fv, caps.glEvalCoord2d, caps.glEvalCoord2dv, caps.glEvalMesh1, caps.glEvalMesh2, caps.glEvalPoint1, caps.glEvalPoint2, caps.glFeedbackBuffer, caps.glFogi, caps.glFogiv, caps.glFogf, caps.glFogfv, caps.glGenLists, caps.glGetLightiv, caps.glGetLightfv, caps.glGetMapiv, caps.glGetMapfv, caps.glGetMapdv, caps.glGetMaterialiv, caps.glGetMaterialfv, caps.glGetPixelMapfv, caps.glGetPixelMapusv, caps.glGetPixelMapuiv, caps.glGetPolygonStipple, caps.glGetTexGeniv, caps.glGetTexGenfv, caps.glGetTexGendv, caps.glIndexi, caps.glIndexub, caps.glIndexs, caps.glIndexf, caps.glIndexd, caps.glIndexiv, caps.glIndexubv, caps.glIndexsv, caps.glIndexfv, caps.glIndexdv, caps.glIndexMask, caps.glIndexPointer, caps.glInitNames, caps.glIsList, caps.glLightModeli, caps.glLightModelf, caps.glLightModeliv, caps.glLightModelfv, caps.glLighti, caps.glLightf, caps.glLightiv, caps.glLightfv, caps.glLineStipple, caps.glListBase, caps.glLoadMatrixf, caps.glLoadMatrixd, caps.glLoadIdentity, caps.glLoadName, caps.glMap1f, caps.glMap1d, caps.glMap2f, caps.glMap2d, caps.glMapGrid1f, caps.glMapGrid1d, caps.glMapGrid2f, caps.glMapGrid2d, caps.glMateriali, caps.glMaterialf, caps.glMaterialiv, caps.glMaterialfv, caps.glMatrixMode, caps.glMultMatrixf, caps.glMultMatrixd, caps.glFrustum, caps.glNewList, caps.glEndList, caps.glNormal3f, caps.glNormal3b, caps.glNormal3s, caps.glNormal3i, caps.glNormal3d, caps.glNormal3fv, caps.glNormal3bv, caps.glNormal3sv, caps.glNormal3iv, caps.glNormal3dv, caps.glNormalPointer, caps.glOrtho, caps.glPassThrough, caps.glPixelMapfv, caps.glPixelMapusv, caps.glPixelMapuiv, caps.glPixelTransferi, caps.glPixelTransferf, caps.glPixelZoom, caps.glPolygonStipple, caps.glPushAttrib, caps.glPushClientAttrib, caps.glPopAttrib, caps.glPopClientAttrib, caps.glPopMatrix, caps.glPopName, caps.glPrioritizeTextures, caps.glPushMatrix, caps.glPushName, caps.glRasterPos2i, caps.glRasterPos2s, caps.glRasterPos2f, caps.glRasterPos2d, caps.glRasterPos2iv, caps.glRasterPos2sv, caps.glRasterPos2fv, caps.glRasterPos2dv, caps.glRasterPos3i, caps.glRasterPos3s, caps.glRasterPos3f, caps.glRasterPos3d, caps.glRasterPos3iv, caps.glRasterPos3sv, caps.glRasterPos3fv, caps.glRasterPos3dv, caps.glRasterPos4i, caps.glRasterPos4s, caps.glRasterPos4f, caps.glRasterPos4d, caps.glRasterPos4iv, caps.glRasterPos4sv, caps.glRasterPos4fv, caps.glRasterPos4dv, caps.glRecti, caps.glRects, caps.glRectf, caps.glRectd, caps.glRectiv, caps.glRectsv, caps.glRectfv, caps.glRectdv, caps.glRenderMode, caps.glRotatef, caps.glRotated, caps.glScalef, caps.glScaled, caps.glSelectBuffer, caps.glShadeModel, caps.glTexCoord1f, caps.glTexCoord1s, caps.glTexCoord1i, caps.glTexCoord1d, caps.glTexCoord1fv, caps.glTexCoord1sv, caps.glTexCoord1iv, caps.glTexCoord1dv, caps.glTexCoord2f, caps.glTexCoord2s, caps.glTexCoord2i, caps.glTexCoord2d, caps.glTexCoord2fv, caps.glTexCoord2sv, caps.glTexCoord2iv, caps.glTexCoord2dv, caps.glTexCoord3f, caps.glTexCoord3s, caps.glTexCoord3i, caps.glTexCoord3d, caps.glTexCoord3fv, caps.glTexCoord3sv, caps.glTexCoord3iv, caps.glTexCoord3dv, caps.glTexCoord4f, caps.glTexCoord4s, caps.glTexCoord4i, caps.glTexCoord4d, caps.glTexCoord4fv, caps.glTexCoord4sv, caps.glTexCoord4iv, caps.glTexCoord4dv, caps.glTexCoordPointer, caps.glTexGeni, caps.glTexGeniv, caps.glTexGenf, caps.glTexGenfv, caps.glTexGend, caps.glTexGendv, caps.glTranslatef, caps.glTranslated, caps.glVertex2f, caps.glVertex2s, caps.glVertex2i, caps.glVertex2d, caps.glVertex2fv, caps.glVertex2sv, caps.glVertex2iv, caps.glVertex2dv, caps.glVertex3f, caps.glVertex3s, caps.glVertex3i, caps.glVertex3d, caps.glVertex3fv, caps.glVertex3sv, caps.glVertex3iv, caps.glVertex3dv, caps.glVertex4f, caps.glVertex4s, caps.glVertex4i, caps.glVertex4d, caps.glVertex4fv, caps.glVertex4sv, caps.glVertex4iv, caps.glVertex4dv, caps.glVertexPointer})) && Checks.checkFunctions((long[])new long[]{caps.glEnable, caps.glDisable, caps.glArrayElement, caps.glBindTexture, caps.glBlendFunc, caps.glClear, caps.glClearColor, caps.glClearDepth, caps.glClearStencil, caps.glClipPlane, caps.glColorMask, caps.glCopyPixels, caps.glCullFace, caps.glDepthFunc, caps.glDepthMask, caps.glDepthRange, caps.glDrawArrays, caps.glDrawBuffer, caps.glDrawElements, caps.glFinish, caps.glFlush, caps.glFrontFace, caps.glGenTextures, caps.glDeleteTextures, caps.glGetClipPlane, caps.glGetBooleanv, caps.glGetFloatv, caps.glGetIntegerv, caps.glGetDoublev, caps.glGetError, caps.glGetPointerv, caps.glGetString, caps.glGetTexEnviv, caps.glGetTexEnvfv, caps.glGetTexImage, caps.glGetTexLevelParameteriv, caps.glGetTexLevelParameterfv, caps.glGetTexParameteriv, caps.glGetTexParameterfv, caps.glHint, caps.glInterleavedArrays, caps.glIsEnabled, caps.glIsTexture, caps.glLineWidth, caps.glLogicOp, caps.glPixelStorei, caps.glPixelStoref, caps.glPointSize, caps.glPolygonMode, caps.glPolygonOffset, caps.glReadBuffer, caps.glReadPixels, caps.glScissor, caps.glStencilFunc, caps.glStencilMask, caps.glStencilOp, caps.glTexEnvi, caps.glTexEnviv, caps.glTexEnvf, caps.glTexEnvfv, caps.glTexImage2D, caps.glTexImage1D, caps.glCopyTexImage2D, caps.glCopyTexImage1D, caps.glCopyTexSubImage1D, caps.glCopyTexSubImage2D, caps.glTexParameteri, caps.glTexParameteriv, caps.glTexParameterf, caps.glTexParameterfv, caps.glTexSubImage1D, caps.glTexSubImage2D, caps.glViewport});
    }

    public static void glEnable(int target) {
        long __functionAddress = GL.getCapabilities().glEnable;
        JNI.callV((long)__functionAddress, (int)target);
    }

    public static void glDisable(int target) {
        long __functionAddress = GL.getCapabilities().glDisable;
        JNI.callV((long)__functionAddress, (int)target);
    }

    public static void glAccum(int op, float value) {
        long __functionAddress = GL.getCapabilities().glAccum;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)op, (float)value);
    }

    public static void glAlphaFunc(int func, float ref) {
        long __functionAddress = GL.getCapabilities().glAlphaFunc;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)func, (float)ref);
    }

    public static boolean nglAreTexturesResident(int n, long textures, long residences) {
        long __functionAddress = GL.getCapabilities().glAreTexturesResident;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callPPZ((long)__functionAddress, (int)n, (long)textures, (long)residences);
    }

    public static boolean glAreTexturesResident(IntBuffer textures, ByteBuffer residences) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)residences, (int)textures.remaining());
        }
        return GL11.nglAreTexturesResident(textures.remaining(), MemoryUtil.memAddress((IntBuffer)textures), MemoryUtil.memAddress((ByteBuffer)residences));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean glAreTexturesResident(int texture, ByteBuffer residences) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)residences, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer textures = stack.ints(texture);
            boolean bl = GL11.nglAreTexturesResident(1, MemoryUtil.memAddress((IntBuffer)textures), MemoryUtil.memAddress((ByteBuffer)residences));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glArrayElement(int i) {
        long __functionAddress = GL.getCapabilities().glArrayElement;
        JNI.callV((long)__functionAddress, (int)i);
    }

    public static void glBegin(int mode) {
        long __functionAddress = GL.getCapabilities().glBegin;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)mode);
    }

    public static void glBindTexture(int target, int texture) {
        long __functionAddress = GL.getCapabilities().glBindTexture;
        JNI.callV((long)__functionAddress, (int)target, (int)texture);
    }

    public static void nglBitmap(int w, int h, float xOrig, float yOrig, float xInc, float yInc, long data) {
        long __functionAddress = GL.getCapabilities().glBitmap;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)w, (int)h, (float)xOrig, (float)yOrig, (float)xInc, (float)yInc, (long)data);
    }

    public static void glBitmap(int w, int h, float xOrig, float yOrig, float xInc, float yInc, ByteBuffer data) {
        GL11.nglBitmap(w, h, xOrig, yOrig, xInc, yInc, MemoryUtil.memAddressSafe((ByteBuffer)data));
    }

    public static void glBitmap(int w, int h, float xOrig, float yOrig, float xInc, float yInc, long data) {
        GL11.nglBitmap(w, h, xOrig, yOrig, xInc, yInc, data);
    }

    public static void glBlendFunc(int sfactor, int dfactor) {
        long __functionAddress = GL.getCapabilities().glBlendFunc;
        JNI.callV((long)__functionAddress, (int)sfactor, (int)dfactor);
    }

    public static void glCallList(int list) {
        long __functionAddress = GL.getCapabilities().glCallList;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)list);
    }

    public static void nglCallLists(int n, int type, long lists) {
        long __functionAddress = GL.getCapabilities().glCallLists;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (int)type, (long)lists);
    }

    public static void glCallLists(int type, ByteBuffer lists) {
        GL11.nglCallLists(lists.remaining() / GLChecks.typeToBytes(type), type, MemoryUtil.memAddress((ByteBuffer)lists));
    }

    public static void glCallLists(ByteBuffer lists) {
        GL11.nglCallLists(lists.remaining(), 5121, MemoryUtil.memAddress((ByteBuffer)lists));
    }

    public static void glCallLists(ShortBuffer lists) {
        GL11.nglCallLists(lists.remaining(), 5123, MemoryUtil.memAddress((ShortBuffer)lists));
    }

    public static void glCallLists(IntBuffer lists) {
        GL11.nglCallLists(lists.remaining(), 5125, MemoryUtil.memAddress((IntBuffer)lists));
    }

    public static void glClear(int mask) {
        long __functionAddress = GL.getCapabilities().glClear;
        JNI.callV((long)__functionAddress, (int)mask);
    }

    public static void glClearAccum(float red, float green, float blue, float alpha) {
        long __functionAddress = GL.getCapabilities().glClearAccum;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void glClearColor(float red, float green, float blue, float alpha) {
        long __functionAddress = GL.getCapabilities().glClearColor;
        JNI.callV((long)__functionAddress, (float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void glClearDepth(double depth) {
        long __functionAddress = GL.getCapabilities().glClearDepth;
        JNI.callV((long)__functionAddress, (double)depth);
    }

    public static void glClearIndex(float index) {
        long __functionAddress = GL.getCapabilities().glClearIndex;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)index);
    }

    public static void glClearStencil(int s) {
        long __functionAddress = GL.getCapabilities().glClearStencil;
        JNI.callV((long)__functionAddress, (int)s);
    }

    public static void nglClipPlane(int plane, long equation) {
        long __functionAddress = GL.getCapabilities().glClipPlane;
        JNI.callPV((long)__functionAddress, (int)plane, (long)equation);
    }

    public static void glClipPlane(int plane, DoubleBuffer equation) {
        GL11.nglClipPlane(plane, MemoryUtil.memAddress((DoubleBuffer)equation));
    }

    public static void glColor3b(byte red, byte green, byte blue) {
        long __functionAddress = GL.getCapabilities().glColor3b;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (byte)red, (byte)green, (byte)blue);
    }

    public static void glColor3s(short red, short green, short blue) {
        long __functionAddress = GL.getCapabilities().glColor3s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (short)red, (short)green, (short)blue);
    }

    public static void glColor3i(int red, int green, int blue) {
        long __functionAddress = GL.getCapabilities().glColor3i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)red, (int)green, (int)blue);
    }

    public static void glColor3f(float red, float green, float blue) {
        long __functionAddress = GL.getCapabilities().glColor3f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)red, (float)green, (float)blue);
    }

    public static void glColor3d(double red, double green, double blue) {
        long __functionAddress = GL.getCapabilities().glColor3d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)red, (double)green, (double)blue);
    }

    public static void glColor3ub(byte red, byte green, byte blue) {
        long __functionAddress = GL.getCapabilities().glColor3ub;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (byte)red, (byte)green, (byte)blue);
    }

    public static void glColor3us(short red, short green, short blue) {
        long __functionAddress = GL.getCapabilities().glColor3us;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (short)red, (short)green, (short)blue);
    }

    public static void glColor3ui(int red, int green, int blue) {
        long __functionAddress = GL.getCapabilities().glColor3ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)red, (int)green, (int)blue);
    }

    public static void nglColor3bv(long v) {
        long __functionAddress = GL.getCapabilities().glColor3bv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glColor3bv(ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)3);
        }
        GL11.nglColor3bv(MemoryUtil.memAddress((ByteBuffer)v));
    }

    public static void nglColor3sv(long v) {
        long __functionAddress = GL.getCapabilities().glColor3sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glColor3sv(ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)3);
        }
        GL11.nglColor3sv(MemoryUtil.memAddress((ShortBuffer)v));
    }

    public static void nglColor3iv(long v) {
        long __functionAddress = GL.getCapabilities().glColor3iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glColor3iv(IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)3);
        }
        GL11.nglColor3iv(MemoryUtil.memAddress((IntBuffer)v));
    }

    public static void nglColor3fv(long v) {
        long __functionAddress = GL.getCapabilities().glColor3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glColor3fv(FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)3);
        }
        GL11.nglColor3fv(MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static void nglColor3dv(long v) {
        long __functionAddress = GL.getCapabilities().glColor3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glColor3dv(DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)3);
        }
        GL11.nglColor3dv(MemoryUtil.memAddress((DoubleBuffer)v));
    }

    public static void nglColor3ubv(long v) {
        long __functionAddress = GL.getCapabilities().glColor3ubv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glColor3ubv(ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)3);
        }
        GL11.nglColor3ubv(MemoryUtil.memAddress((ByteBuffer)v));
    }

    public static void nglColor3usv(long v) {
        long __functionAddress = GL.getCapabilities().glColor3usv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glColor3usv(ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)3);
        }
        GL11.nglColor3usv(MemoryUtil.memAddress((ShortBuffer)v));
    }

    public static void nglColor3uiv(long v) {
        long __functionAddress = GL.getCapabilities().glColor3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glColor3uiv(IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)3);
        }
        GL11.nglColor3uiv(MemoryUtil.memAddress((IntBuffer)v));
    }

    public static void glColor4b(byte red, byte green, byte blue, byte alpha) {
        long __functionAddress = GL.getCapabilities().glColor4b;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (byte)red, (byte)green, (byte)blue, (byte)alpha);
    }

    public static void glColor4s(short red, short green, short blue, short alpha) {
        long __functionAddress = GL.getCapabilities().glColor4s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (short)red, (short)green, (short)blue, (short)alpha);
    }

    public static void glColor4i(int red, int green, int blue, int alpha) {
        long __functionAddress = GL.getCapabilities().glColor4i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)red, (int)green, (int)blue, (int)alpha);
    }

    public static void glColor4f(float red, float green, float blue, float alpha) {
        long __functionAddress = GL.getCapabilities().glColor4f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void glColor4d(double red, double green, double blue, double alpha) {
        long __functionAddress = GL.getCapabilities().glColor4d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)red, (double)green, (double)blue, (double)alpha);
    }

    public static void glColor4ub(byte red, byte green, byte blue, byte alpha) {
        long __functionAddress = GL.getCapabilities().glColor4ub;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (byte)red, (byte)green, (byte)blue, (byte)alpha);
    }

    public static void glColor4us(short red, short green, short blue, short alpha) {
        long __functionAddress = GL.getCapabilities().glColor4us;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (short)red, (short)green, (short)blue, (short)alpha);
    }

    public static void glColor4ui(int red, int green, int blue, int alpha) {
        long __functionAddress = GL.getCapabilities().glColor4ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)red, (int)green, (int)blue, (int)alpha);
    }

    public static void nglColor4bv(long v) {
        long __functionAddress = GL.getCapabilities().glColor4bv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glColor4bv(ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)4);
        }
        GL11.nglColor4bv(MemoryUtil.memAddress((ByteBuffer)v));
    }

    public static void nglColor4sv(long v) {
        long __functionAddress = GL.getCapabilities().glColor4sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glColor4sv(ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)4);
        }
        GL11.nglColor4sv(MemoryUtil.memAddress((ShortBuffer)v));
    }

    public static void nglColor4iv(long v) {
        long __functionAddress = GL.getCapabilities().glColor4iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glColor4iv(IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)4);
        }
        GL11.nglColor4iv(MemoryUtil.memAddress((IntBuffer)v));
    }

    public static void nglColor4fv(long v) {
        long __functionAddress = GL.getCapabilities().glColor4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glColor4fv(FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)4);
        }
        GL11.nglColor4fv(MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static void nglColor4dv(long v) {
        long __functionAddress = GL.getCapabilities().glColor4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glColor4dv(DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)4);
        }
        GL11.nglColor4dv(MemoryUtil.memAddress((DoubleBuffer)v));
    }

    public static void nglColor4ubv(long v) {
        long __functionAddress = GL.getCapabilities().glColor4ubv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glColor4ubv(ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)4);
        }
        GL11.nglColor4ubv(MemoryUtil.memAddress((ByteBuffer)v));
    }

    public static void nglColor4usv(long v) {
        long __functionAddress = GL.getCapabilities().glColor4usv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glColor4usv(ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)4);
        }
        GL11.nglColor4usv(MemoryUtil.memAddress((ShortBuffer)v));
    }

    public static void nglColor4uiv(long v) {
        long __functionAddress = GL.getCapabilities().glColor4uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glColor4uiv(IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)4);
        }
        GL11.nglColor4uiv(MemoryUtil.memAddress((IntBuffer)v));
    }

    public static void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        long __functionAddress = GL.getCapabilities().glColorMask;
        JNI.callV((long)__functionAddress, (boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
    }

    public static void glColorMaterial(int face, int mode) {
        long __functionAddress = GL.getCapabilities().glColorMaterial;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)face, (int)mode);
    }

    public static void nglColorPointer(int size, int type, int stride, long pointer) {
        long __functionAddress = GL.getCapabilities().glColorPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)size, (int)type, (int)stride, (long)pointer);
    }

    public static void glColorPointer(int size, int type, int stride, ByteBuffer pointer) {
        GL11.nglColorPointer(size, type, stride, MemoryUtil.memAddress((ByteBuffer)pointer));
    }

    public static void glColorPointer(int size, int type, int stride, long pointer) {
        GL11.nglColorPointer(size, type, stride, pointer);
    }

    public static void glColorPointer(int size, int type, int stride, ShortBuffer pointer) {
        GL11.nglColorPointer(size, type, stride, MemoryUtil.memAddress((ShortBuffer)pointer));
    }

    public static void glColorPointer(int size, int type, int stride, IntBuffer pointer) {
        GL11.nglColorPointer(size, type, stride, MemoryUtil.memAddress((IntBuffer)pointer));
    }

    public static void glColorPointer(int size, int type, int stride, FloatBuffer pointer) {
        GL11.nglColorPointer(size, type, stride, MemoryUtil.memAddress((FloatBuffer)pointer));
    }

    public static void glCopyPixels(int x, int y, int width, int height, int type) {
        long __functionAddress = GL.getCapabilities().glCopyPixels;
        JNI.callV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)type);
    }

    public static void glCullFace(int mode) {
        long __functionAddress = GL.getCapabilities().glCullFace;
        JNI.callV((long)__functionAddress, (int)mode);
    }

    public static void glDeleteLists(int list, int range) {
        long __functionAddress = GL.getCapabilities().glDeleteLists;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)list, (int)range);
    }

    public static void glDepthFunc(int func) {
        long __functionAddress = GL.getCapabilities().glDepthFunc;
        JNI.callV((long)__functionAddress, (int)func);
    }

    public static void glDepthMask(boolean flag) {
        long __functionAddress = GL.getCapabilities().glDepthMask;
        JNI.callV((long)__functionAddress, (boolean)flag);
    }

    public static void glDepthRange(double zNear, double zFar) {
        long __functionAddress = GL.getCapabilities().glDepthRange;
        JNI.callV((long)__functionAddress, (double)zNear, (double)zFar);
    }

    public static void glDisableClientState(int array) {
        long __functionAddress = GL.getCapabilities().glDisableClientState;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)array);
    }

    public static void glDrawArrays(int mode, int first, int count) {
        long __functionAddress = GL.getCapabilities().glDrawArrays;
        JNI.callV((long)__functionAddress, (int)mode, (int)first, (int)count);
    }

    public static void glDrawBuffer(int buf) {
        long __functionAddress = GL.getCapabilities().glDrawBuffer;
        JNI.callV((long)__functionAddress, (int)buf);
    }

    public static void nglDrawElements(int mode, int count, int type, long indices) {
        long __functionAddress = GL.getCapabilities().glDrawElements;
        JNI.callPV((long)__functionAddress, (int)mode, (int)count, (int)type, (long)indices);
    }

    public static void glDrawElements(int mode, int count, int type, long indices) {
        GL11.nglDrawElements(mode, count, type, indices);
    }

    public static void glDrawElements(int mode, int type, ByteBuffer indices) {
        GL11.nglDrawElements(mode, indices.remaining() >> GLChecks.typeToByteShift(type), type, MemoryUtil.memAddress((ByteBuffer)indices));
    }

    public static void glDrawElements(int mode, ByteBuffer indices) {
        GL11.nglDrawElements(mode, indices.remaining(), 5121, MemoryUtil.memAddress((ByteBuffer)indices));
    }

    public static void glDrawElements(int mode, ShortBuffer indices) {
        GL11.nglDrawElements(mode, indices.remaining(), 5123, MemoryUtil.memAddress((ShortBuffer)indices));
    }

    public static void glDrawElements(int mode, IntBuffer indices) {
        GL11.nglDrawElements(mode, indices.remaining(), 5125, MemoryUtil.memAddress((IntBuffer)indices));
    }

    public static void nglDrawPixels(int width, int height, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glDrawPixels;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)width, (int)height, (int)format, (int)type, (long)pixels);
    }

    public static void glDrawPixels(int width, int height, int format, int type, ByteBuffer pixels) {
        GL11.nglDrawPixels(width, height, format, type, MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glDrawPixels(int width, int height, int format, int type, long pixels) {
        GL11.nglDrawPixels(width, height, format, type, pixels);
    }

    public static void glDrawPixels(int width, int height, int format, int type, ShortBuffer pixels) {
        GL11.nglDrawPixels(width, height, format, type, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glDrawPixels(int width, int height, int format, int type, IntBuffer pixels) {
        GL11.nglDrawPixels(width, height, format, type, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glDrawPixels(int width, int height, int format, int type, FloatBuffer pixels) {
        GL11.nglDrawPixels(width, height, format, type, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static void glEdgeFlag(boolean flag) {
        long __functionAddress = GL.getCapabilities().glEdgeFlag;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (boolean)flag);
    }

    public static void nglEdgeFlagv(long flag) {
        long __functionAddress = GL.getCapabilities().glEdgeFlagv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)flag);
    }

    public static void glEdgeFlagv(ByteBuffer flag) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)flag, (int)1);
        }
        GL11.nglEdgeFlagv(MemoryUtil.memAddress((ByteBuffer)flag));
    }

    public static void nglEdgeFlagPointer(int stride, long pointer) {
        long __functionAddress = GL.getCapabilities().glEdgeFlagPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)stride, (long)pointer);
    }

    public static void glEdgeFlagPointer(int stride, ByteBuffer pointer) {
        GL11.nglEdgeFlagPointer(stride, MemoryUtil.memAddress((ByteBuffer)pointer));
    }

    public static void glEdgeFlagPointer(int stride, long pointer) {
        GL11.nglEdgeFlagPointer(stride, pointer);
    }

    public static void glEnableClientState(int array) {
        long __functionAddress = GL.getCapabilities().glEnableClientState;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)array);
    }

    public static void glEnd() {
        long __functionAddress = GL.getCapabilities().glEnd;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static void glEvalCoord1f(float u) {
        long __functionAddress = GL.getCapabilities().glEvalCoord1f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)u);
    }

    public static void nglEvalCoord1fv(long u) {
        long __functionAddress = GL.getCapabilities().glEvalCoord1fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)u);
    }

    public static void glEvalCoord1fv(FloatBuffer u) {
        GL11.nglEvalCoord1fv(MemoryUtil.memAddress((FloatBuffer)u));
    }

    public static void glEvalCoord1d(double u) {
        long __functionAddress = GL.getCapabilities().glEvalCoord1d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)u);
    }

    public static void nglEvalCoord1dv(long u) {
        long __functionAddress = GL.getCapabilities().glEvalCoord1dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)u);
    }

    public static void glEvalCoord1dv(DoubleBuffer u) {
        GL11.nglEvalCoord1dv(MemoryUtil.memAddress((DoubleBuffer)u));
    }

    public static void glEvalCoord2f(float u, float v) {
        long __functionAddress = GL.getCapabilities().glEvalCoord2f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)u, (float)v);
    }

    public static void nglEvalCoord2fv(long u) {
        long __functionAddress = GL.getCapabilities().glEvalCoord2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)u);
    }

    public static void glEvalCoord2fv(FloatBuffer u) {
        GL11.nglEvalCoord2fv(MemoryUtil.memAddress((FloatBuffer)u));
    }

    public static void glEvalCoord2d(double u, double v) {
        long __functionAddress = GL.getCapabilities().glEvalCoord2d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)u, (double)v);
    }

    public static void nglEvalCoord2dv(long u) {
        long __functionAddress = GL.getCapabilities().glEvalCoord2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)u);
    }

    public static void glEvalCoord2dv(DoubleBuffer u) {
        GL11.nglEvalCoord2dv(MemoryUtil.memAddress((DoubleBuffer)u));
    }

    public static void glEvalMesh1(int mode, int i1, int i2) {
        long __functionAddress = GL.getCapabilities().glEvalMesh1;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)mode, (int)i1, (int)i2);
    }

    public static void glEvalMesh2(int mode, int i1, int i2, int j1, int j2) {
        long __functionAddress = GL.getCapabilities().glEvalMesh2;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)mode, (int)i1, (int)i2, (int)j1, (int)j2);
    }

    public static void glEvalPoint1(int i) {
        long __functionAddress = GL.getCapabilities().glEvalPoint1;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)i);
    }

    public static void glEvalPoint2(int i, int j) {
        long __functionAddress = GL.getCapabilities().glEvalPoint2;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)i, (int)j);
    }

    public static void nglFeedbackBuffer(int size, int type, long buffer) {
        long __functionAddress = GL.getCapabilities().glFeedbackBuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)size, (int)type, (long)buffer);
    }

    public static void glFeedbackBuffer(int type, FloatBuffer buffer) {
        GL11.nglFeedbackBuffer(buffer.remaining(), type, MemoryUtil.memAddress((FloatBuffer)buffer));
    }

    public static void glFinish() {
        long __functionAddress = GL.getCapabilities().glFinish;
        JNI.callV((long)__functionAddress);
    }

    public static void glFlush() {
        long __functionAddress = GL.getCapabilities().glFlush;
        JNI.callV((long)__functionAddress);
    }

    public static void glFogi(int pname, int param) {
        long __functionAddress = GL.getCapabilities().glFogi;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)pname, (int)param);
    }

    public static void nglFogiv(int pname, long params) {
        long __functionAddress = GL.getCapabilities().glFogiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (long)params);
    }

    public static void glFogiv(int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        GL11.nglFogiv(pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    public static void glFogf(int pname, float param) {
        long __functionAddress = GL.getCapabilities().glFogf;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)pname, (float)param);
    }

    public static void nglFogfv(int pname, long params) {
        long __functionAddress = GL.getCapabilities().glFogfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (long)params);
    }

    public static void glFogfv(int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        GL11.nglFogfv(pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    public static void glFrontFace(int dir) {
        long __functionAddress = GL.getCapabilities().glFrontFace;
        JNI.callV((long)__functionAddress, (int)dir);
    }

    public static int glGenLists(int s) {
        long __functionAddress = GL.getCapabilities().glGenLists;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callI((long)__functionAddress, (int)s);
    }

    public static void nglGenTextures(int n, long textures) {
        long __functionAddress = GL.getCapabilities().glGenTextures;
        JNI.callPV((long)__functionAddress, (int)n, (long)textures);
    }

    public static void glGenTextures(IntBuffer textures) {
        GL11.nglGenTextures(textures.remaining(), MemoryUtil.memAddress((IntBuffer)textures));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenTextures() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer textures = stack.callocInt(1);
            GL11.nglGenTextures(1, MemoryUtil.memAddress((IntBuffer)textures));
            int n = textures.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDeleteTextures(int n, long textures) {
        long __functionAddress = GL.getCapabilities().glDeleteTextures;
        JNI.callPV((long)__functionAddress, (int)n, (long)textures);
    }

    public static void glDeleteTextures(IntBuffer textures) {
        GL11.nglDeleteTextures(textures.remaining(), MemoryUtil.memAddress((IntBuffer)textures));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteTextures(int texture) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer textures = stack.ints(texture);
            GL11.nglDeleteTextures(1, MemoryUtil.memAddress((IntBuffer)textures));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetClipPlane(int plane, long equation) {
        long __functionAddress = GL.getCapabilities().glGetClipPlane;
        JNI.callPV((long)__functionAddress, (int)plane, (long)equation);
    }

    public static void glGetClipPlane(int plane, DoubleBuffer equation) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)equation, (int)4);
        }
        GL11.nglGetClipPlane(plane, MemoryUtil.memAddress((DoubleBuffer)equation));
    }

    public static void nglGetBooleanv(int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetBooleanv;
        JNI.callPV((long)__functionAddress, (int)pname, (long)params);
    }

    public static void glGetBooleanv(int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        GL11.nglGetBooleanv(pname, MemoryUtil.memAddress((ByteBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean glGetBoolean(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer params = stack.calloc(1);
            GL11.nglGetBooleanv(pname, MemoryUtil.memAddress((ByteBuffer)params));
            boolean bl = params.get(0) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetFloatv(int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetFloatv;
        JNI.callPV((long)__functionAddress, (int)pname, (long)params);
    }

    public static void glGetFloatv(int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        GL11.nglGetFloatv(pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetFloat(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GL11.nglGetFloatv(pname, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetIntegerv(int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetIntegerv;
        JNI.callPV((long)__functionAddress, (int)pname, (long)params);
    }

    public static void glGetIntegerv(int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        GL11.nglGetIntegerv(pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetInteger(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL11.nglGetIntegerv(pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetDoublev(int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetDoublev;
        JNI.callPV((long)__functionAddress, (int)pname, (long)params);
    }

    public static void glGetDoublev(int pname, DoubleBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        GL11.nglGetDoublev(pname, MemoryUtil.memAddress((DoubleBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double glGetDouble(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer params = stack.callocDouble(1);
            GL11.nglGetDoublev(pname, MemoryUtil.memAddress((DoubleBuffer)params));
            double d = params.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int glGetError() {
        long __functionAddress = GL.getCapabilities().glGetError;
        return JNI.callI((long)__functionAddress);
    }

    public static void nglGetLightiv(int light, int pname, long data) {
        long __functionAddress = GL.getCapabilities().glGetLightiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)light, (int)pname, (long)data);
    }

    public static void glGetLightiv(int light, int pname, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)4);
        }
        GL11.nglGetLightiv(light, pname, MemoryUtil.memAddress((IntBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetLighti(int light, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer data = stack.callocInt(1);
            GL11.nglGetLightiv(light, pname, MemoryUtil.memAddress((IntBuffer)data));
            int n = data.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetLightfv(int light, int pname, long data) {
        long __functionAddress = GL.getCapabilities().glGetLightfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)light, (int)pname, (long)data);
    }

    public static void glGetLightfv(int light, int pname, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)4);
        }
        GL11.nglGetLightfv(light, pname, MemoryUtil.memAddress((FloatBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetLightf(int light, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer data = stack.callocFloat(1);
            GL11.nglGetLightfv(light, pname, MemoryUtil.memAddress((FloatBuffer)data));
            float f = data.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetMapiv(int target, int query, long data) {
        long __functionAddress = GL.getCapabilities().glGetMapiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)query, (long)data);
    }

    public static void glGetMapiv(int target, int query, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)4);
        }
        GL11.nglGetMapiv(target, query, MemoryUtil.memAddress((IntBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetMapi(int target, int query) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer data = stack.callocInt(1);
            GL11.nglGetMapiv(target, query, MemoryUtil.memAddress((IntBuffer)data));
            int n = data.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetMapfv(int target, int query, long data) {
        long __functionAddress = GL.getCapabilities().glGetMapfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)query, (long)data);
    }

    public static void glGetMapfv(int target, int query, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)4);
        }
        GL11.nglGetMapfv(target, query, MemoryUtil.memAddress((FloatBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetMapf(int target, int query) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer data = stack.callocFloat(1);
            GL11.nglGetMapfv(target, query, MemoryUtil.memAddress((FloatBuffer)data));
            float f = data.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetMapdv(int target, int query, long data) {
        long __functionAddress = GL.getCapabilities().glGetMapdv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)query, (long)data);
    }

    public static void glGetMapdv(int target, int query, DoubleBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)4);
        }
        GL11.nglGetMapdv(target, query, MemoryUtil.memAddress((DoubleBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double glGetMapd(int target, int query) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer data = stack.callocDouble(1);
            GL11.nglGetMapdv(target, query, MemoryUtil.memAddress((DoubleBuffer)data));
            double d = data.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetMaterialiv(int face, int pname, long data) {
        long __functionAddress = GL.getCapabilities().glGetMaterialiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)face, (int)pname, (long)data);
    }

    public static void glGetMaterialiv(int face, int pname, IntBuffer data) {
        GL11.nglGetMaterialiv(face, pname, MemoryUtil.memAddress((IntBuffer)data));
    }

    public static void nglGetMaterialfv(int face, int pname, long data) {
        long __functionAddress = GL.getCapabilities().glGetMaterialfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)face, (int)pname, (long)data);
    }

    public static void glGetMaterialfv(int face, int pname, FloatBuffer data) {
        GL11.nglGetMaterialfv(face, pname, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static void nglGetPixelMapfv(int map, long data) {
        long __functionAddress = GL.getCapabilities().glGetPixelMapfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)map, (long)data);
    }

    public static void glGetPixelMapfv(int map, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)32);
        }
        GL11.nglGetPixelMapfv(map, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static void glGetPixelMapfv(int map, long data) {
        GL11.nglGetPixelMapfv(map, data);
    }

    public static void nglGetPixelMapusv(int map, long data) {
        long __functionAddress = GL.getCapabilities().glGetPixelMapusv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)map, (long)data);
    }

    public static void glGetPixelMapusv(int map, ShortBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)32);
        }
        GL11.nglGetPixelMapusv(map, MemoryUtil.memAddress((ShortBuffer)data));
    }

    public static void glGetPixelMapusv(int map, long data) {
        GL11.nglGetPixelMapusv(map, data);
    }

    public static void nglGetPixelMapuiv(int map, long data) {
        long __functionAddress = GL.getCapabilities().glGetPixelMapuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)map, (long)data);
    }

    public static void glGetPixelMapuiv(int map, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)32);
        }
        GL11.nglGetPixelMapuiv(map, MemoryUtil.memAddress((IntBuffer)data));
    }

    public static void glGetPixelMapuiv(int map, long data) {
        GL11.nglGetPixelMapuiv(map, data);
    }

    public static void nglGetPointerv(int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetPointerv;
        JNI.callPV((long)__functionAddress, (int)pname, (long)params);
    }

    public static void glGetPointerv(int pname, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((CustomBuffer)params, (int)1);
        }
        GL11.nglGetPointerv(pname, MemoryUtil.memAddress((CustomBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetPointer(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer params = stack.callocPointer(1);
            GL11.nglGetPointerv(pname, MemoryUtil.memAddress((CustomBuffer)params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetPolygonStipple(long pattern) {
        long __functionAddress = GL.getCapabilities().glGetPolygonStipple;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)pattern);
    }

    public static void glGetPolygonStipple(ByteBuffer pattern) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pattern, (int)128);
        }
        GL11.nglGetPolygonStipple(MemoryUtil.memAddress((ByteBuffer)pattern));
    }

    public static void glGetPolygonStipple(long pattern) {
        GL11.nglGetPolygonStipple(pattern);
    }

    public static long nglGetString(int name) {
        long __functionAddress = GL.getCapabilities().glGetString;
        return JNI.callP((long)__functionAddress, (int)name);
    }

    public static String glGetString(int name) {
        long __result = GL11.nglGetString(name);
        return MemoryUtil.memUTF8((long)__result);
    }

    public static void nglGetTexEnviv(int env, int pname, long data) {
        long __functionAddress = GL.getCapabilities().glGetTexEnviv;
        JNI.callPV((long)__functionAddress, (int)env, (int)pname, (long)data);
    }

    public static void glGetTexEnviv(int env, int pname, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)1);
        }
        GL11.nglGetTexEnviv(env, pname, MemoryUtil.memAddress((IntBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTexEnvi(int env, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer data = stack.callocInt(1);
            GL11.nglGetTexEnviv(env, pname, MemoryUtil.memAddress((IntBuffer)data));
            int n = data.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetTexEnvfv(int env, int pname, long data) {
        long __functionAddress = GL.getCapabilities().glGetTexEnvfv;
        JNI.callPV((long)__functionAddress, (int)env, (int)pname, (long)data);
    }

    public static void glGetTexEnvfv(int env, int pname, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)1);
        }
        GL11.nglGetTexEnvfv(env, pname, MemoryUtil.memAddress((FloatBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetTexEnvf(int env, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer data = stack.callocFloat(1);
            GL11.nglGetTexEnvfv(env, pname, MemoryUtil.memAddress((FloatBuffer)data));
            float f = data.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetTexGeniv(int coord, int pname, long data) {
        long __functionAddress = GL.getCapabilities().glGetTexGeniv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)coord, (int)pname, (long)data);
    }

    public static void glGetTexGeniv(int coord, int pname, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)1);
        }
        GL11.nglGetTexGeniv(coord, pname, MemoryUtil.memAddress((IntBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTexGeni(int coord, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer data = stack.callocInt(1);
            GL11.nglGetTexGeniv(coord, pname, MemoryUtil.memAddress((IntBuffer)data));
            int n = data.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetTexGenfv(int coord, int pname, long data) {
        long __functionAddress = GL.getCapabilities().glGetTexGenfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)coord, (int)pname, (long)data);
    }

    public static void glGetTexGenfv(int coord, int pname, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)4);
        }
        GL11.nglGetTexGenfv(coord, pname, MemoryUtil.memAddress((FloatBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetTexGenf(int coord, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer data = stack.callocFloat(1);
            GL11.nglGetTexGenfv(coord, pname, MemoryUtil.memAddress((FloatBuffer)data));
            float f = data.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetTexGendv(int coord, int pname, long data) {
        long __functionAddress = GL.getCapabilities().glGetTexGendv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)coord, (int)pname, (long)data);
    }

    public static void glGetTexGendv(int coord, int pname, DoubleBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)4);
        }
        GL11.nglGetTexGendv(coord, pname, MemoryUtil.memAddress((DoubleBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double glGetTexGend(int coord, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer data = stack.callocDouble(1);
            GL11.nglGetTexGendv(coord, pname, MemoryUtil.memAddress((DoubleBuffer)data));
            double d = data.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetTexImage(int tex, int level, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glGetTexImage;
        JNI.callPV((long)__functionAddress, (int)tex, (int)level, (int)format, (int)type, (long)pixels);
    }

    public static void glGetTexImage(int tex, int level, int format, int type, ByteBuffer pixels) {
        GL11.nglGetTexImage(tex, level, format, type, MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glGetTexImage(int tex, int level, int format, int type, long pixels) {
        GL11.nglGetTexImage(tex, level, format, type, pixels);
    }

    public static void glGetTexImage(int tex, int level, int format, int type, ShortBuffer pixels) {
        GL11.nglGetTexImage(tex, level, format, type, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glGetTexImage(int tex, int level, int format, int type, IntBuffer pixels) {
        GL11.nglGetTexImage(tex, level, format, type, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glGetTexImage(int tex, int level, int format, int type, FloatBuffer pixels) {
        GL11.nglGetTexImage(tex, level, format, type, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static void glGetTexImage(int tex, int level, int format, int type, DoubleBuffer pixels) {
        GL11.nglGetTexImage(tex, level, format, type, MemoryUtil.memAddress((DoubleBuffer)pixels));
    }

    public static void nglGetTexLevelParameteriv(int target, int level, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetTexLevelParameteriv;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)pname, (long)params);
    }

    public static void glGetTexLevelParameteriv(int target, int level, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        GL11.nglGetTexLevelParameteriv(target, level, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTexLevelParameteri(int target, int level, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL11.nglGetTexLevelParameteriv(target, level, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetTexLevelParameterfv(int target, int level, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetTexLevelParameterfv;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)pname, (long)params);
    }

    public static void glGetTexLevelParameterfv(int target, int level, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        GL11.nglGetTexLevelParameterfv(target, level, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetTexLevelParameterf(int target, int level, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GL11.nglGetTexLevelParameterfv(target, level, pname, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetTexParameteriv(int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetTexParameteriv;
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (long)params);
    }

    public static void glGetTexParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        GL11.nglGetTexParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTexParameteri(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL11.nglGetTexParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetTexParameterfv(int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetTexParameterfv;
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (long)params);
    }

    public static void glGetTexParameterfv(int target, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        GL11.nglGetTexParameterfv(target, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetTexParameterf(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GL11.nglGetTexParameterfv(target, pname, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glHint(int target, int hint) {
        long __functionAddress = GL.getCapabilities().glHint;
        JNI.callV((long)__functionAddress, (int)target, (int)hint);
    }

    public static void glIndexi(int index) {
        long __functionAddress = GL.getCapabilities().glIndexi;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)index);
    }

    public static void glIndexub(byte index) {
        long __functionAddress = GL.getCapabilities().glIndexub;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (byte)index);
    }

    public static void glIndexs(short index) {
        long __functionAddress = GL.getCapabilities().glIndexs;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (short)index);
    }

    public static void glIndexf(float index) {
        long __functionAddress = GL.getCapabilities().glIndexf;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)index);
    }

    public static void glIndexd(double index) {
        long __functionAddress = GL.getCapabilities().glIndexd;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)index);
    }

    public static void nglIndexiv(long index) {
        long __functionAddress = GL.getCapabilities().glIndexiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)index);
    }

    public static void glIndexiv(IntBuffer index) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)index, (int)1);
        }
        GL11.nglIndexiv(MemoryUtil.memAddress((IntBuffer)index));
    }

    public static void nglIndexubv(long index) {
        long __functionAddress = GL.getCapabilities().glIndexubv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)index);
    }

    public static void glIndexubv(ByteBuffer index) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)index, (int)1);
        }
        GL11.nglIndexubv(MemoryUtil.memAddress((ByteBuffer)index));
    }

    public static void nglIndexsv(long index) {
        long __functionAddress = GL.getCapabilities().glIndexsv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)index);
    }

    public static void glIndexsv(ShortBuffer index) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)index, (int)1);
        }
        GL11.nglIndexsv(MemoryUtil.memAddress((ShortBuffer)index));
    }

    public static void nglIndexfv(long index) {
        long __functionAddress = GL.getCapabilities().glIndexfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)index);
    }

    public static void glIndexfv(FloatBuffer index) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)index, (int)1);
        }
        GL11.nglIndexfv(MemoryUtil.memAddress((FloatBuffer)index));
    }

    public static void nglIndexdv(long index) {
        long __functionAddress = GL.getCapabilities().glIndexdv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)index);
    }

    public static void glIndexdv(DoubleBuffer index) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)index, (int)1);
        }
        GL11.nglIndexdv(MemoryUtil.memAddress((DoubleBuffer)index));
    }

    public static void glIndexMask(int mask) {
        long __functionAddress = GL.getCapabilities().glIndexMask;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)mask);
    }

    public static void nglIndexPointer(int type, int stride, long pointer) {
        long __functionAddress = GL.getCapabilities().glIndexPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)type, (int)stride, (long)pointer);
    }

    public static void glIndexPointer(int type, int stride, ByteBuffer pointer) {
        GL11.nglIndexPointer(type, stride, MemoryUtil.memAddress((ByteBuffer)pointer));
    }

    public static void glIndexPointer(int type, int stride, long pointer) {
        GL11.nglIndexPointer(type, stride, pointer);
    }

    public static void glIndexPointer(int stride, ByteBuffer pointer) {
        GL11.nglIndexPointer(5121, stride, MemoryUtil.memAddress((ByteBuffer)pointer));
    }

    public static void glIndexPointer(int stride, ShortBuffer pointer) {
        GL11.nglIndexPointer(5122, stride, MemoryUtil.memAddress((ShortBuffer)pointer));
    }

    public static void glIndexPointer(int stride, IntBuffer pointer) {
        GL11.nglIndexPointer(5124, stride, MemoryUtil.memAddress((IntBuffer)pointer));
    }

    public static void glInitNames() {
        long __functionAddress = GL.getCapabilities().glInitNames;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static void nglInterleavedArrays(int format, int stride, long pointer) {
        long __functionAddress = GL.getCapabilities().glInterleavedArrays;
        JNI.callPV((long)__functionAddress, (int)format, (int)stride, (long)pointer);
    }

    public static void glInterleavedArrays(int format, int stride, ByteBuffer pointer) {
        GL11.nglInterleavedArrays(format, stride, MemoryUtil.memAddress((ByteBuffer)pointer));
    }

    public static void glInterleavedArrays(int format, int stride, long pointer) {
        GL11.nglInterleavedArrays(format, stride, pointer);
    }

    public static void glInterleavedArrays(int format, int stride, ShortBuffer pointer) {
        GL11.nglInterleavedArrays(format, stride, MemoryUtil.memAddress((ShortBuffer)pointer));
    }

    public static void glInterleavedArrays(int format, int stride, IntBuffer pointer) {
        GL11.nglInterleavedArrays(format, stride, MemoryUtil.memAddress((IntBuffer)pointer));
    }

    public static void glInterleavedArrays(int format, int stride, FloatBuffer pointer) {
        GL11.nglInterleavedArrays(format, stride, MemoryUtil.memAddress((FloatBuffer)pointer));
    }

    public static void glInterleavedArrays(int format, int stride, DoubleBuffer pointer) {
        GL11.nglInterleavedArrays(format, stride, MemoryUtil.memAddress((DoubleBuffer)pointer));
    }

    public static boolean glIsEnabled(int cap) {
        long __functionAddress = GL.getCapabilities().glIsEnabled;
        return JNI.callZ((long)__functionAddress, (int)cap);
    }

    public static boolean glIsList(int list) {
        long __functionAddress = GL.getCapabilities().glIsList;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress, (int)list);
    }

    public static boolean glIsTexture(int texture) {
        long __functionAddress = GL.getCapabilities().glIsTexture;
        return JNI.callZ((long)__functionAddress, (int)texture);
    }

    public static void glLightModeli(int pname, int param) {
        long __functionAddress = GL.getCapabilities().glLightModeli;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)pname, (int)param);
    }

    public static void glLightModelf(int pname, float param) {
        long __functionAddress = GL.getCapabilities().glLightModelf;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)pname, (float)param);
    }

    public static void nglLightModeliv(int pname, long params) {
        long __functionAddress = GL.getCapabilities().glLightModeliv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (long)params);
    }

    public static void glLightModeliv(int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)4);
        }
        GL11.nglLightModeliv(pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    public static void nglLightModelfv(int pname, long params) {
        long __functionAddress = GL.getCapabilities().glLightModelfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (long)params);
    }

    public static void glLightModelfv(int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)4);
        }
        GL11.nglLightModelfv(pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    public static void glLighti(int light, int pname, int param) {
        long __functionAddress = GL.getCapabilities().glLighti;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)light, (int)pname, (int)param);
    }

    public static void glLightf(int light, int pname, float param) {
        long __functionAddress = GL.getCapabilities().glLightf;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)light, (int)pname, (float)param);
    }

    public static void nglLightiv(int light, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glLightiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)light, (int)pname, (long)params);
    }

    public static void glLightiv(int light, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)4);
        }
        GL11.nglLightiv(light, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    public static void nglLightfv(int light, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glLightfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)light, (int)pname, (long)params);
    }

    public static void glLightfv(int light, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)4);
        }
        GL11.nglLightfv(light, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    public static void glLineStipple(int factor, short pattern) {
        long __functionAddress = GL.getCapabilities().glLineStipple;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)factor, (short)pattern);
    }

    public static void glLineWidth(float width) {
        long __functionAddress = GL.getCapabilities().glLineWidth;
        JNI.callV((long)__functionAddress, (float)width);
    }

    public static void glListBase(int base) {
        long __functionAddress = GL.getCapabilities().glListBase;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)base);
    }

    public static void nglLoadMatrixf(long m) {
        long __functionAddress = GL.getCapabilities().glLoadMatrixf;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)m);
    }

    public static void glLoadMatrixf(FloatBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, (int)16);
        }
        GL11.nglLoadMatrixf(MemoryUtil.memAddress((FloatBuffer)m));
    }

    public static void nglLoadMatrixd(long m) {
        long __functionAddress = GL.getCapabilities().glLoadMatrixd;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)m);
    }

    public static void glLoadMatrixd(DoubleBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, (int)16);
        }
        GL11.nglLoadMatrixd(MemoryUtil.memAddress((DoubleBuffer)m));
    }

    public static void glLoadIdentity() {
        long __functionAddress = GL.getCapabilities().glLoadIdentity;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static void glLoadName(int name) {
        long __functionAddress = GL.getCapabilities().glLoadName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)name);
    }

    public static void glLogicOp(int op) {
        long __functionAddress = GL.getCapabilities().glLogicOp;
        JNI.callV((long)__functionAddress, (int)op);
    }

    public static void nglMap1f(int target, float u1, float u2, int stride, int order, long points) {
        long __functionAddress = GL.getCapabilities().glMap1f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (float)u1, (float)u2, (int)stride, (int)order, (long)points);
    }

    public static void glMap1f(int target, float u1, float u2, int stride, int order, FloatBuffer points) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)points, (int)(order * stride));
        }
        GL11.nglMap1f(target, u1, u2, stride, order, MemoryUtil.memAddress((FloatBuffer)points));
    }

    public static void nglMap1d(int target, double u1, double u2, int stride, int order, long points) {
        long __functionAddress = GL.getCapabilities().glMap1d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (double)u1, (double)u2, (int)stride, (int)order, (long)points);
    }

    public static void glMap1d(int target, double u1, double u2, int stride, int order, DoubleBuffer points) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)points, (int)(stride * order));
        }
        GL11.nglMap1d(target, u1, u2, stride, order, MemoryUtil.memAddress((DoubleBuffer)points));
    }

    public static void nglMap2f(int target, float u1, float u2, int ustride, int uorder, float v1, float v2, int vstride, int vorder, long points) {
        long __functionAddress = GL.getCapabilities().glMap2f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (float)u1, (float)u2, (int)ustride, (int)uorder, (float)v1, (float)v2, (int)vstride, (int)vorder, (long)points);
    }

    public static void glMap2f(int target, float u1, float u2, int ustride, int uorder, float v1, float v2, int vstride, int vorder, FloatBuffer points) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)points, (int)(ustride * uorder * vstride * vorder));
        }
        GL11.nglMap2f(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, MemoryUtil.memAddress((FloatBuffer)points));
    }

    public static void nglMap2d(int target, double u1, double u2, int ustride, int uorder, double v1, double v2, int vstride, int vorder, long points) {
        long __functionAddress = GL.getCapabilities().glMap2d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (double)u1, (double)u2, (int)ustride, (int)uorder, (double)v1, (double)v2, (int)vstride, (int)vorder, (long)points);
    }

    public static void glMap2d(int target, double u1, double u2, int ustride, int uorder, double v1, double v2, int vstride, int vorder, DoubleBuffer points) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)points, (int)(ustride * uorder * vstride * vorder));
        }
        GL11.nglMap2d(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, MemoryUtil.memAddress((DoubleBuffer)points));
    }

    public static void glMapGrid1f(int n, float u1, float u2) {
        long __functionAddress = GL.getCapabilities().glMapGrid1f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)n, (float)u1, (float)u2);
    }

    public static void glMapGrid1d(int n, double u1, double u2) {
        long __functionAddress = GL.getCapabilities().glMapGrid1d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)n, (double)u1, (double)u2);
    }

    public static void glMapGrid2f(int un, float u1, float u2, int vn, float v1, float v2) {
        long __functionAddress = GL.getCapabilities().glMapGrid2f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)un, (float)u1, (float)u2, (int)vn, (float)v1, (float)v2);
    }

    public static void glMapGrid2d(int un, double u1, double u2, int vn, double v1, double v2) {
        long __functionAddress = GL.getCapabilities().glMapGrid2d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)un, (double)u1, (double)u2, (int)vn, (double)v1, (double)v2);
    }

    public static void glMateriali(int face, int pname, int param) {
        long __functionAddress = GL.getCapabilities().glMateriali;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)face, (int)pname, (int)param);
    }

    public static void glMaterialf(int face, int pname, float param) {
        long __functionAddress = GL.getCapabilities().glMaterialf;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)face, (int)pname, (float)param);
    }

    public static void nglMaterialiv(int face, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glMaterialiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)face, (int)pname, (long)params);
    }

    public static void glMaterialiv(int face, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)4);
        }
        GL11.nglMaterialiv(face, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    public static void nglMaterialfv(int face, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glMaterialfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)face, (int)pname, (long)params);
    }

    public static void glMaterialfv(int face, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)4);
        }
        GL11.nglMaterialfv(face, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    public static void glMatrixMode(int mode) {
        long __functionAddress = GL.getCapabilities().glMatrixMode;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)mode);
    }

    public static void nglMultMatrixf(long m) {
        long __functionAddress = GL.getCapabilities().glMultMatrixf;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)m);
    }

    public static void glMultMatrixf(FloatBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, (int)16);
        }
        GL11.nglMultMatrixf(MemoryUtil.memAddress((FloatBuffer)m));
    }

    public static void nglMultMatrixd(long m) {
        long __functionAddress = GL.getCapabilities().glMultMatrixd;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)m);
    }

    public static void glMultMatrixd(DoubleBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, (int)16);
        }
        GL11.nglMultMatrixd(MemoryUtil.memAddress((DoubleBuffer)m));
    }

    public static void glFrustum(double l, double r, double b, double t, double n, double f) {
        long __functionAddress = GL.getCapabilities().glFrustum;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)l, (double)r, (double)b, (double)t, (double)n, (double)f);
    }

    public static void glNewList(int n, int mode) {
        long __functionAddress = GL.getCapabilities().glNewList;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)n, (int)mode);
    }

    public static void glEndList() {
        long __functionAddress = GL.getCapabilities().glEndList;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static void glNormal3f(float nx, float ny, float nz) {
        long __functionAddress = GL.getCapabilities().glNormal3f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)nx, (float)ny, (float)nz);
    }

    public static void glNormal3b(byte nx, byte ny, byte nz) {
        long __functionAddress = GL.getCapabilities().glNormal3b;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (byte)nx, (byte)ny, (byte)nz);
    }

    public static void glNormal3s(short nx, short ny, short nz) {
        long __functionAddress = GL.getCapabilities().glNormal3s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (short)nx, (short)ny, (short)nz);
    }

    public static void glNormal3i(int nx, int ny, int nz) {
        long __functionAddress = GL.getCapabilities().glNormal3i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)nx, (int)ny, (int)nz);
    }

    public static void glNormal3d(double nx, double ny, double nz) {
        long __functionAddress = GL.getCapabilities().glNormal3d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)nx, (double)ny, (double)nz);
    }

    public static void nglNormal3fv(long v) {
        long __functionAddress = GL.getCapabilities().glNormal3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glNormal3fv(FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)3);
        }
        GL11.nglNormal3fv(MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static void nglNormal3bv(long v) {
        long __functionAddress = GL.getCapabilities().glNormal3bv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glNormal3bv(ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)3);
        }
        GL11.nglNormal3bv(MemoryUtil.memAddress((ByteBuffer)v));
    }

    public static void nglNormal3sv(long v) {
        long __functionAddress = GL.getCapabilities().glNormal3sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glNormal3sv(ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)3);
        }
        GL11.nglNormal3sv(MemoryUtil.memAddress((ShortBuffer)v));
    }

    public static void nglNormal3iv(long v) {
        long __functionAddress = GL.getCapabilities().glNormal3iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glNormal3iv(IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)3);
        }
        GL11.nglNormal3iv(MemoryUtil.memAddress((IntBuffer)v));
    }

    public static void nglNormal3dv(long v) {
        long __functionAddress = GL.getCapabilities().glNormal3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glNormal3dv(DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)3);
        }
        GL11.nglNormal3dv(MemoryUtil.memAddress((DoubleBuffer)v));
    }

    public static void nglNormalPointer(int type, int stride, long pointer) {
        long __functionAddress = GL.getCapabilities().glNormalPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)type, (int)stride, (long)pointer);
    }

    public static void glNormalPointer(int type, int stride, ByteBuffer pointer) {
        GL11.nglNormalPointer(type, stride, MemoryUtil.memAddress((ByteBuffer)pointer));
    }

    public static void glNormalPointer(int type, int stride, long pointer) {
        GL11.nglNormalPointer(type, stride, pointer);
    }

    public static void glNormalPointer(int type, int stride, ShortBuffer pointer) {
        GL11.nglNormalPointer(type, stride, MemoryUtil.memAddress((ShortBuffer)pointer));
    }

    public static void glNormalPointer(int type, int stride, IntBuffer pointer) {
        GL11.nglNormalPointer(type, stride, MemoryUtil.memAddress((IntBuffer)pointer));
    }

    public static void glNormalPointer(int type, int stride, FloatBuffer pointer) {
        GL11.nglNormalPointer(type, stride, MemoryUtil.memAddress((FloatBuffer)pointer));
    }

    public static void glOrtho(double l, double r, double b, double t, double n, double f) {
        long __functionAddress = GL.getCapabilities().glOrtho;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)l, (double)r, (double)b, (double)t, (double)n, (double)f);
    }

    public static void glPassThrough(float token) {
        long __functionAddress = GL.getCapabilities().glPassThrough;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)token);
    }

    public static void nglPixelMapfv(int map, int size, long values) {
        long __functionAddress = GL.getCapabilities().glPixelMapfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)map, (int)size, (long)values);
    }

    public static void glPixelMapfv(int map, int size, long values) {
        GL11.nglPixelMapfv(map, size, values);
    }

    public static void glPixelMapfv(int map, FloatBuffer values) {
        GL11.nglPixelMapfv(map, values.remaining(), MemoryUtil.memAddress((FloatBuffer)values));
    }

    public static void nglPixelMapusv(int map, int size, long values) {
        long __functionAddress = GL.getCapabilities().glPixelMapusv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)map, (int)size, (long)values);
    }

    public static void glPixelMapusv(int map, int size, long values) {
        GL11.nglPixelMapusv(map, size, values);
    }

    public static void glPixelMapusv(int map, ShortBuffer values) {
        GL11.nglPixelMapusv(map, values.remaining(), MemoryUtil.memAddress((ShortBuffer)values));
    }

    public static void nglPixelMapuiv(int map, int size, long values) {
        long __functionAddress = GL.getCapabilities().glPixelMapuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)map, (int)size, (long)values);
    }

    public static void glPixelMapuiv(int map, int size, long values) {
        GL11.nglPixelMapuiv(map, size, values);
    }

    public static void glPixelMapuiv(int map, IntBuffer values) {
        GL11.nglPixelMapuiv(map, values.remaining(), MemoryUtil.memAddress((IntBuffer)values));
    }

    public static void glPixelStorei(int pname, int param) {
        long __functionAddress = GL.getCapabilities().glPixelStorei;
        JNI.callV((long)__functionAddress, (int)pname, (int)param);
    }

    public static void glPixelStoref(int pname, int param) {
        long __functionAddress = GL.getCapabilities().glPixelStoref;
        JNI.callV((long)__functionAddress, (int)pname, (int)param);
    }

    public static void glPixelTransferi(int pname, int param) {
        long __functionAddress = GL.getCapabilities().glPixelTransferi;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)pname, (int)param);
    }

    public static void glPixelTransferf(int pname, float param) {
        long __functionAddress = GL.getCapabilities().glPixelTransferf;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)pname, (float)param);
    }

    public static void glPixelZoom(float xfactor, float yfactor) {
        long __functionAddress = GL.getCapabilities().glPixelZoom;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)xfactor, (float)yfactor);
    }

    public static void glPointSize(float size) {
        long __functionAddress = GL.getCapabilities().glPointSize;
        JNI.callV((long)__functionAddress, (float)size);
    }

    public static void glPolygonMode(int face, int mode) {
        long __functionAddress = GL.getCapabilities().glPolygonMode;
        JNI.callV((long)__functionAddress, (int)face, (int)mode);
    }

    public static void glPolygonOffset(float factor, float units) {
        long __functionAddress = GL.getCapabilities().glPolygonOffset;
        JNI.callV((long)__functionAddress, (float)factor, (float)units);
    }

    public static void nglPolygonStipple(long pattern) {
        long __functionAddress = GL.getCapabilities().glPolygonStipple;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)pattern);
    }

    public static void glPolygonStipple(ByteBuffer pattern) {
        GL11.nglPolygonStipple(MemoryUtil.memAddress((ByteBuffer)pattern));
    }

    public static void glPolygonStipple(long pattern) {
        GL11.nglPolygonStipple(pattern);
    }

    public static void glPushAttrib(int mask) {
        long __functionAddress = GL.getCapabilities().glPushAttrib;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)mask);
    }

    public static void glPushClientAttrib(int mask) {
        long __functionAddress = GL.getCapabilities().glPushClientAttrib;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)mask);
    }

    public static void glPopAttrib() {
        long __functionAddress = GL.getCapabilities().glPopAttrib;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static void glPopClientAttrib() {
        long __functionAddress = GL.getCapabilities().glPopClientAttrib;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static void glPopMatrix() {
        long __functionAddress = GL.getCapabilities().glPopMatrix;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static void glPopName() {
        long __functionAddress = GL.getCapabilities().glPopName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static void nglPrioritizeTextures(int n, long textures, long priorities) {
        long __functionAddress = GL.getCapabilities().glPrioritizeTextures;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)n, (long)textures, (long)priorities);
    }

    public static void glPrioritizeTextures(IntBuffer textures, FloatBuffer priorities) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)priorities, (int)textures.remaining());
        }
        GL11.nglPrioritizeTextures(textures.remaining(), MemoryUtil.memAddress((IntBuffer)textures), MemoryUtil.memAddress((FloatBuffer)priorities));
    }

    public static void glPushMatrix() {
        long __functionAddress = GL.getCapabilities().glPushMatrix;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static void glPushName(int name) {
        long __functionAddress = GL.getCapabilities().glPushName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)name);
    }

    public static void glRasterPos2i(int x, int y) {
        long __functionAddress = GL.getCapabilities().glRasterPos2i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)x, (int)y);
    }

    public static void glRasterPos2s(short x, short y) {
        long __functionAddress = GL.getCapabilities().glRasterPos2s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (short)x, (short)y);
    }

    public static void glRasterPos2f(float x, float y) {
        long __functionAddress = GL.getCapabilities().glRasterPos2f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)x, (float)y);
    }

    public static void glRasterPos2d(double x, double y) {
        long __functionAddress = GL.getCapabilities().glRasterPos2d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)x, (double)y);
    }

    public static void nglRasterPos2iv(long coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos2iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glRasterPos2iv(IntBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)2);
        }
        GL11.nglRasterPos2iv(MemoryUtil.memAddress((IntBuffer)coords));
    }

    public static void nglRasterPos2sv(long coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos2sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glRasterPos2sv(ShortBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)2);
        }
        GL11.nglRasterPos2sv(MemoryUtil.memAddress((ShortBuffer)coords));
    }

    public static void nglRasterPos2fv(long coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glRasterPos2fv(FloatBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)2);
        }
        GL11.nglRasterPos2fv(MemoryUtil.memAddress((FloatBuffer)coords));
    }

    public static void nglRasterPos2dv(long coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glRasterPos2dv(DoubleBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)2);
        }
        GL11.nglRasterPos2dv(MemoryUtil.memAddress((DoubleBuffer)coords));
    }

    public static void glRasterPos3i(int x, int y, int z) {
        long __functionAddress = GL.getCapabilities().glRasterPos3i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)x, (int)y, (int)z);
    }

    public static void glRasterPos3s(short x, short y, short z) {
        long __functionAddress = GL.getCapabilities().glRasterPos3s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (short)x, (short)y, (short)z);
    }

    public static void glRasterPos3f(float x, float y, float z) {
        long __functionAddress = GL.getCapabilities().glRasterPos3f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)x, (float)y, (float)z);
    }

    public static void glRasterPos3d(double x, double y, double z) {
        long __functionAddress = GL.getCapabilities().glRasterPos3d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)x, (double)y, (double)z);
    }

    public static void nglRasterPos3iv(long coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos3iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glRasterPos3iv(IntBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)3);
        }
        GL11.nglRasterPos3iv(MemoryUtil.memAddress((IntBuffer)coords));
    }

    public static void nglRasterPos3sv(long coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos3sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glRasterPos3sv(ShortBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)3);
        }
        GL11.nglRasterPos3sv(MemoryUtil.memAddress((ShortBuffer)coords));
    }

    public static void nglRasterPos3fv(long coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glRasterPos3fv(FloatBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)3);
        }
        GL11.nglRasterPos3fv(MemoryUtil.memAddress((FloatBuffer)coords));
    }

    public static void nglRasterPos3dv(long coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glRasterPos3dv(DoubleBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)3);
        }
        GL11.nglRasterPos3dv(MemoryUtil.memAddress((DoubleBuffer)coords));
    }

    public static void glRasterPos4i(int x, int y, int z, int w) {
        long __functionAddress = GL.getCapabilities().glRasterPos4i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)x, (int)y, (int)z, (int)w);
    }

    public static void glRasterPos4s(short x, short y, short z, short w) {
        long __functionAddress = GL.getCapabilities().glRasterPos4s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (short)x, (short)y, (short)z, (short)w);
    }

    public static void glRasterPos4f(float x, float y, float z, float w) {
        long __functionAddress = GL.getCapabilities().glRasterPos4f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)x, (float)y, (float)z, (float)w);
    }

    public static void glRasterPos4d(double x, double y, double z, double w) {
        long __functionAddress = GL.getCapabilities().glRasterPos4d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)x, (double)y, (double)z, (double)w);
    }

    public static void nglRasterPos4iv(long coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos4iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glRasterPos4iv(IntBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)4);
        }
        GL11.nglRasterPos4iv(MemoryUtil.memAddress((IntBuffer)coords));
    }

    public static void nglRasterPos4sv(long coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos4sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glRasterPos4sv(ShortBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)4);
        }
        GL11.nglRasterPos4sv(MemoryUtil.memAddress((ShortBuffer)coords));
    }

    public static void nglRasterPos4fv(long coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glRasterPos4fv(FloatBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)4);
        }
        GL11.nglRasterPos4fv(MemoryUtil.memAddress((FloatBuffer)coords));
    }

    public static void nglRasterPos4dv(long coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glRasterPos4dv(DoubleBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)4);
        }
        GL11.nglRasterPos4dv(MemoryUtil.memAddress((DoubleBuffer)coords));
    }

    public static void glReadBuffer(int src) {
        long __functionAddress = GL.getCapabilities().glReadBuffer;
        JNI.callV((long)__functionAddress, (int)src);
    }

    public static void nglReadPixels(int x, int y, int width, int height, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glReadPixels;
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (long)pixels);
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        GL11.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, long pixels) {
        GL11.nglReadPixels(x, y, width, height, format, type, pixels);
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, ShortBuffer pixels) {
        GL11.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, IntBuffer pixels) {
        GL11.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, FloatBuffer pixels) {
        GL11.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static void glRecti(int x1, int y1, int x2, int y2) {
        long __functionAddress = GL.getCapabilities().glRecti;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)x1, (int)y1, (int)x2, (int)y2);
    }

    public static void glRects(short x1, short y1, short x2, short y2) {
        long __functionAddress = GL.getCapabilities().glRects;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (short)x1, (short)y1, (short)x2, (short)y2);
    }

    public static void glRectf(float x1, float y1, float x2, float y2) {
        long __functionAddress = GL.getCapabilities().glRectf;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)x1, (float)y1, (float)x2, (float)y2);
    }

    public static void glRectd(double x1, double y1, double x2, double y2) {
        long __functionAddress = GL.getCapabilities().glRectd;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)x1, (double)y1, (double)x2, (double)y2);
    }

    public static void nglRectiv(long v1, long v2) {
        long __functionAddress = GL.getCapabilities().glRectiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (long)v1, (long)v2);
    }

    public static void glRectiv(IntBuffer v1, IntBuffer v2) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v1, (int)2);
            Checks.checkBuffer((Buffer)v2, (int)2);
        }
        GL11.nglRectiv(MemoryUtil.memAddress((IntBuffer)v1), MemoryUtil.memAddress((IntBuffer)v2));
    }

    public static void nglRectsv(long v1, long v2) {
        long __functionAddress = GL.getCapabilities().glRectsv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (long)v1, (long)v2);
    }

    public static void glRectsv(ShortBuffer v1, ShortBuffer v2) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v1, (int)2);
            Checks.checkBuffer((Buffer)v2, (int)2);
        }
        GL11.nglRectsv(MemoryUtil.memAddress((ShortBuffer)v1), MemoryUtil.memAddress((ShortBuffer)v2));
    }

    public static void nglRectfv(long v1, long v2) {
        long __functionAddress = GL.getCapabilities().glRectfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (long)v1, (long)v2);
    }

    public static void glRectfv(FloatBuffer v1, FloatBuffer v2) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v1, (int)2);
            Checks.checkBuffer((Buffer)v2, (int)2);
        }
        GL11.nglRectfv(MemoryUtil.memAddress((FloatBuffer)v1), MemoryUtil.memAddress((FloatBuffer)v2));
    }

    public static void nglRectdv(long v1, long v2) {
        long __functionAddress = GL.getCapabilities().glRectdv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (long)v1, (long)v2);
    }

    public static void glRectdv(DoubleBuffer v1, DoubleBuffer v2) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v1, (int)2);
            Checks.checkBuffer((Buffer)v2, (int)2);
        }
        GL11.nglRectdv(MemoryUtil.memAddress((DoubleBuffer)v1), MemoryUtil.memAddress((DoubleBuffer)v2));
    }

    public static int glRenderMode(int mode) {
        long __functionAddress = GL.getCapabilities().glRenderMode;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callI((long)__functionAddress, (int)mode);
    }

    public static void glRotatef(float angle, float x, float y, float z) {
        long __functionAddress = GL.getCapabilities().glRotatef;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)angle, (float)x, (float)y, (float)z);
    }

    public static void glRotated(double angle, double x, double y, double z) {
        long __functionAddress = GL.getCapabilities().glRotated;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)angle, (double)x, (double)y, (double)z);
    }

    public static void glScalef(float x, float y, float z) {
        long __functionAddress = GL.getCapabilities().glScalef;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)x, (float)y, (float)z);
    }

    public static void glScaled(double x, double y, double z) {
        long __functionAddress = GL.getCapabilities().glScaled;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)x, (double)y, (double)z);
    }

    public static void glScissor(int x, int y, int width, int height) {
        long __functionAddress = GL.getCapabilities().glScissor;
        JNI.callV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height);
    }

    public static void nglSelectBuffer(int size, long buffer) {
        long __functionAddress = GL.getCapabilities().glSelectBuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)size, (long)buffer);
    }

    public static void glSelectBuffer(IntBuffer buffer) {
        GL11.nglSelectBuffer(buffer.remaining(), MemoryUtil.memAddress((IntBuffer)buffer));
    }

    public static void glShadeModel(int mode) {
        long __functionAddress = GL.getCapabilities().glShadeModel;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)mode);
    }

    public static void glStencilFunc(int func, int ref, int mask) {
        long __functionAddress = GL.getCapabilities().glStencilFunc;
        JNI.callV((long)__functionAddress, (int)func, (int)ref, (int)mask);
    }

    public static void glStencilMask(int mask) {
        long __functionAddress = GL.getCapabilities().glStencilMask;
        JNI.callV((long)__functionAddress, (int)mask);
    }

    public static void glStencilOp(int sfail, int dpfail, int dppass) {
        long __functionAddress = GL.getCapabilities().glStencilOp;
        JNI.callV((long)__functionAddress, (int)sfail, (int)dpfail, (int)dppass);
    }

    public static void glTexCoord1f(float s) {
        long __functionAddress = GL.getCapabilities().glTexCoord1f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)s);
    }

    public static void glTexCoord1s(short s) {
        long __functionAddress = GL.getCapabilities().glTexCoord1s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (short)s);
    }

    public static void glTexCoord1i(int s) {
        long __functionAddress = GL.getCapabilities().glTexCoord1i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)s);
    }

    public static void glTexCoord1d(double s) {
        long __functionAddress = GL.getCapabilities().glTexCoord1d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)s);
    }

    public static void nglTexCoord1fv(long v) {
        long __functionAddress = GL.getCapabilities().glTexCoord1fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glTexCoord1fv(FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)1);
        }
        GL11.nglTexCoord1fv(MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static void nglTexCoord1sv(long v) {
        long __functionAddress = GL.getCapabilities().glTexCoord1sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glTexCoord1sv(ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)1);
        }
        GL11.nglTexCoord1sv(MemoryUtil.memAddress((ShortBuffer)v));
    }

    public static void nglTexCoord1iv(long v) {
        long __functionAddress = GL.getCapabilities().glTexCoord1iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glTexCoord1iv(IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)1);
        }
        GL11.nglTexCoord1iv(MemoryUtil.memAddress((IntBuffer)v));
    }

    public static void nglTexCoord1dv(long v) {
        long __functionAddress = GL.getCapabilities().glTexCoord1dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glTexCoord1dv(DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)1);
        }
        GL11.nglTexCoord1dv(MemoryUtil.memAddress((DoubleBuffer)v));
    }

    public static void glTexCoord2f(float s, float t) {
        long __functionAddress = GL.getCapabilities().glTexCoord2f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)s, (float)t);
    }

    public static void glTexCoord2s(short s, short t) {
        long __functionAddress = GL.getCapabilities().glTexCoord2s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (short)s, (short)t);
    }

    public static void glTexCoord2i(int s, int t) {
        long __functionAddress = GL.getCapabilities().glTexCoord2i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)s, (int)t);
    }

    public static void glTexCoord2d(double s, double t) {
        long __functionAddress = GL.getCapabilities().glTexCoord2d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)s, (double)t);
    }

    public static void nglTexCoord2fv(long v) {
        long __functionAddress = GL.getCapabilities().glTexCoord2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glTexCoord2fv(FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)2);
        }
        GL11.nglTexCoord2fv(MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static void nglTexCoord2sv(long v) {
        long __functionAddress = GL.getCapabilities().glTexCoord2sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glTexCoord2sv(ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)2);
        }
        GL11.nglTexCoord2sv(MemoryUtil.memAddress((ShortBuffer)v));
    }

    public static void nglTexCoord2iv(long v) {
        long __functionAddress = GL.getCapabilities().glTexCoord2iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glTexCoord2iv(IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)2);
        }
        GL11.nglTexCoord2iv(MemoryUtil.memAddress((IntBuffer)v));
    }

    public static void nglTexCoord2dv(long v) {
        long __functionAddress = GL.getCapabilities().glTexCoord2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glTexCoord2dv(DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)2);
        }
        GL11.nglTexCoord2dv(MemoryUtil.memAddress((DoubleBuffer)v));
    }

    public static void glTexCoord3f(float s, float t, float r) {
        long __functionAddress = GL.getCapabilities().glTexCoord3f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)s, (float)t, (float)r);
    }

    public static void glTexCoord3s(short s, short t, short r) {
        long __functionAddress = GL.getCapabilities().glTexCoord3s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (short)s, (short)t, (short)r);
    }

    public static void glTexCoord3i(int s, int t, int r) {
        long __functionAddress = GL.getCapabilities().glTexCoord3i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)s, (int)t, (int)r);
    }

    public static void glTexCoord3d(double s, double t, double r) {
        long __functionAddress = GL.getCapabilities().glTexCoord3d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)s, (double)t, (double)r);
    }

    public static void nglTexCoord3fv(long v) {
        long __functionAddress = GL.getCapabilities().glTexCoord3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glTexCoord3fv(FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)3);
        }
        GL11.nglTexCoord3fv(MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static void nglTexCoord3sv(long v) {
        long __functionAddress = GL.getCapabilities().glTexCoord3sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glTexCoord3sv(ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)3);
        }
        GL11.nglTexCoord3sv(MemoryUtil.memAddress((ShortBuffer)v));
    }

    public static void nglTexCoord3iv(long v) {
        long __functionAddress = GL.getCapabilities().glTexCoord3iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glTexCoord3iv(IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)3);
        }
        GL11.nglTexCoord3iv(MemoryUtil.memAddress((IntBuffer)v));
    }

    public static void nglTexCoord3dv(long v) {
        long __functionAddress = GL.getCapabilities().glTexCoord3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glTexCoord3dv(DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)3);
        }
        GL11.nglTexCoord3dv(MemoryUtil.memAddress((DoubleBuffer)v));
    }

    public static void glTexCoord4f(float s, float t, float r, float q) {
        long __functionAddress = GL.getCapabilities().glTexCoord4f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)s, (float)t, (float)r, (float)q);
    }

    public static void glTexCoord4s(short s, short t, short r, short q) {
        long __functionAddress = GL.getCapabilities().glTexCoord4s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (short)s, (short)t, (short)r, (short)q);
    }

    public static void glTexCoord4i(int s, int t, int r, int q) {
        long __functionAddress = GL.getCapabilities().glTexCoord4i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)s, (int)t, (int)r, (int)q);
    }

    public static void glTexCoord4d(double s, double t, double r, double q) {
        long __functionAddress = GL.getCapabilities().glTexCoord4d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)s, (double)t, (double)r, (double)q);
    }

    public static void nglTexCoord4fv(long v) {
        long __functionAddress = GL.getCapabilities().glTexCoord4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glTexCoord4fv(FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)4);
        }
        GL11.nglTexCoord4fv(MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static void nglTexCoord4sv(long v) {
        long __functionAddress = GL.getCapabilities().glTexCoord4sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glTexCoord4sv(ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)4);
        }
        GL11.nglTexCoord4sv(MemoryUtil.memAddress((ShortBuffer)v));
    }

    public static void nglTexCoord4iv(long v) {
        long __functionAddress = GL.getCapabilities().glTexCoord4iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glTexCoord4iv(IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)4);
        }
        GL11.nglTexCoord4iv(MemoryUtil.memAddress((IntBuffer)v));
    }

    public static void nglTexCoord4dv(long v) {
        long __functionAddress = GL.getCapabilities().glTexCoord4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)v);
    }

    public static void glTexCoord4dv(DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)4);
        }
        GL11.nglTexCoord4dv(MemoryUtil.memAddress((DoubleBuffer)v));
    }

    public static void nglTexCoordPointer(int size, int type, int stride, long pointer) {
        long __functionAddress = GL.getCapabilities().glTexCoordPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)size, (int)type, (int)stride, (long)pointer);
    }

    public static void glTexCoordPointer(int size, int type, int stride, ByteBuffer pointer) {
        GL11.nglTexCoordPointer(size, type, stride, MemoryUtil.memAddress((ByteBuffer)pointer));
    }

    public static void glTexCoordPointer(int size, int type, int stride, long pointer) {
        GL11.nglTexCoordPointer(size, type, stride, pointer);
    }

    public static void glTexCoordPointer(int size, int type, int stride, ShortBuffer pointer) {
        GL11.nglTexCoordPointer(size, type, stride, MemoryUtil.memAddress((ShortBuffer)pointer));
    }

    public static void glTexCoordPointer(int size, int type, int stride, IntBuffer pointer) {
        GL11.nglTexCoordPointer(size, type, stride, MemoryUtil.memAddress((IntBuffer)pointer));
    }

    public static void glTexCoordPointer(int size, int type, int stride, FloatBuffer pointer) {
        GL11.nglTexCoordPointer(size, type, stride, MemoryUtil.memAddress((FloatBuffer)pointer));
    }

    public static void glTexEnvi(int target, int pname, int param) {
        long __functionAddress = GL.getCapabilities().glTexEnvi;
        JNI.callV((long)__functionAddress, (int)target, (int)pname, (int)param);
    }

    public static void nglTexEnviv(int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glTexEnviv;
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (long)params);
    }

    public static void glTexEnviv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)4);
        }
        GL11.nglTexEnviv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    public static void glTexEnvf(int target, int pname, float param) {
        long __functionAddress = GL.getCapabilities().glTexEnvf;
        JNI.callV((long)__functionAddress, (int)target, (int)pname, (float)param);
    }

    public static void nglTexEnvfv(int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glTexEnvfv;
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (long)params);
    }

    public static void glTexEnvfv(int target, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)4);
        }
        GL11.nglTexEnvfv(target, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    public static void glTexGeni(int coord, int pname, int param) {
        long __functionAddress = GL.getCapabilities().glTexGeni;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)coord, (int)pname, (int)param);
    }

    public static void nglTexGeniv(int coord, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glTexGeniv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)coord, (int)pname, (long)params);
    }

    public static void glTexGeniv(int coord, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)4);
        }
        GL11.nglTexGeniv(coord, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    public static void glTexGenf(int coord, int pname, float param) {
        long __functionAddress = GL.getCapabilities().glTexGenf;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)coord, (int)pname, (float)param);
    }

    public static void nglTexGenfv(int coord, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glTexGenfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)coord, (int)pname, (long)params);
    }

    public static void glTexGenfv(int coord, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)4);
        }
        GL11.nglTexGenfv(coord, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    public static void glTexGend(int coord, int pname, double param) {
        long __functionAddress = GL.getCapabilities().glTexGend;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)coord, (int)pname, (double)param);
    }

    public static void nglTexGendv(int coord, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glTexGendv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)coord, (int)pname, (long)params);
    }

    public static void glTexGendv(int coord, int pname, DoubleBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)4);
        }
        GL11.nglTexGendv(coord, pname, MemoryUtil.memAddress((DoubleBuffer)params));
    }

    public static void nglTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glTexImage2D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (long)pixels);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, ByteBuffer pixels) {
        GL11.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe((ByteBuffer)pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, long pixels) {
        GL11.nglTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, ShortBuffer pixels) {
        GL11.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe((ShortBuffer)pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        GL11.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe((IntBuffer)pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, FloatBuffer pixels) {
        GL11.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe((FloatBuffer)pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, DoubleBuffer pixels) {
        GL11.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe((DoubleBuffer)pixels));
    }

    public static void nglTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glTexImage1D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)internalformat, (int)width, (int)border, (int)format, (int)type, (long)pixels);
    }

    public static void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, ByteBuffer pixels) {
        GL11.nglTexImage1D(target, level, internalformat, width, border, format, type, MemoryUtil.memAddressSafe((ByteBuffer)pixels));
    }

    public static void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, long pixels) {
        GL11.nglTexImage1D(target, level, internalformat, width, border, format, type, pixels);
    }

    public static void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, ShortBuffer pixels) {
        GL11.nglTexImage1D(target, level, internalformat, width, border, format, type, MemoryUtil.memAddressSafe((ShortBuffer)pixels));
    }

    public static void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, IntBuffer pixels) {
        GL11.nglTexImage1D(target, level, internalformat, width, border, format, type, MemoryUtil.memAddressSafe((IntBuffer)pixels));
    }

    public static void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, FloatBuffer pixels) {
        GL11.nglTexImage1D(target, level, internalformat, width, border, format, type, MemoryUtil.memAddressSafe((FloatBuffer)pixels));
    }

    public static void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, DoubleBuffer pixels) {
        GL11.nglTexImage1D(target, level, internalformat, width, border, format, type, MemoryUtil.memAddressSafe((DoubleBuffer)pixels));
    }

    public static void glCopyTexImage2D(int target, int level, int internalFormat, int x, int y, int width, int height, int border) {
        long __functionAddress = GL.getCapabilities().glCopyTexImage2D;
        JNI.callV((long)__functionAddress, (int)target, (int)level, (int)internalFormat, (int)x, (int)y, (int)width, (int)height, (int)border);
    }

    public static void glCopyTexImage1D(int target, int level, int internalFormat, int x, int y, int width, int border) {
        long __functionAddress = GL.getCapabilities().glCopyTexImage1D;
        JNI.callV((long)__functionAddress, (int)target, (int)level, (int)internalFormat, (int)x, (int)y, (int)width, (int)border);
    }

    public static void glCopyTexSubImage1D(int target, int level, int xoffset, int x, int y, int width) {
        long __functionAddress = GL.getCapabilities().glCopyTexSubImage1D;
        JNI.callV((long)__functionAddress, (int)target, (int)level, (int)xoffset, (int)x, (int)y, (int)width);
    }

    public static void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        long __functionAddress = GL.getCapabilities().glCopyTexSubImage2D;
        JNI.callV((long)__functionAddress, (int)target, (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height);
    }

    public static void glTexParameteri(int target, int pname, int param) {
        long __functionAddress = GL.getCapabilities().glTexParameteri;
        JNI.callV((long)__functionAddress, (int)target, (int)pname, (int)param);
    }

    public static void nglTexParameteriv(int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glTexParameteriv;
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (long)params);
    }

    public static void glTexParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)4);
        }
        GL11.nglTexParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    public static void glTexParameterf(int target, int pname, float param) {
        long __functionAddress = GL.getCapabilities().glTexParameterf;
        JNI.callV((long)__functionAddress, (int)target, (int)pname, (float)param);
    }

    public static void nglTexParameterfv(int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glTexParameterfv;
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (long)params);
    }

    public static void glTexParameterfv(int target, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)4);
        }
        GL11.nglTexParameterfv(target, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    public static void nglTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glTexSubImage1D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)xoffset, (int)width, (int)format, (int)type, (long)pixels);
    }

    public static void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, ByteBuffer pixels) {
        GL11.nglTexSubImage1D(target, level, xoffset, width, format, type, MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, long pixels) {
        GL11.nglTexSubImage1D(target, level, xoffset, width, format, type, pixels);
    }

    public static void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, ShortBuffer pixels) {
        GL11.nglTexSubImage1D(target, level, xoffset, width, format, type, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, IntBuffer pixels) {
        GL11.nglTexSubImage1D(target, level, xoffset, width, format, type, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, FloatBuffer pixels) {
        GL11.nglTexSubImage1D(target, level, xoffset, width, format, type, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, DoubleBuffer pixels) {
        GL11.nglTexSubImage1D(target, level, xoffset, width, format, type, MemoryUtil.memAddress((DoubleBuffer)pixels));
    }

    public static void nglTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glTexSubImage2D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (long)pixels);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer pixels) {
        GL11.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        GL11.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ShortBuffer pixels) {
        GL11.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        GL11.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, FloatBuffer pixels) {
        GL11.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, DoubleBuffer pixels) {
        GL11.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((DoubleBuffer)pixels));
    }

    public static void glTranslatef(float x, float y, float z) {
        long __functionAddress = GL.getCapabilities().glTranslatef;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)x, (float)y, (float)z);
    }

    public static void glTranslated(double x, double y, double z) {
        long __functionAddress = GL.getCapabilities().glTranslated;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)x, (double)y, (double)z);
    }

    public static void glVertex2f(float x, float y) {
        long __functionAddress = GL.getCapabilities().glVertex2f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)x, (float)y);
    }

    public static void glVertex2s(short x, short y) {
        long __functionAddress = GL.getCapabilities().glVertex2s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (short)x, (short)y);
    }

    public static void glVertex2i(int x, int y) {
        long __functionAddress = GL.getCapabilities().glVertex2i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)x, (int)y);
    }

    public static void glVertex2d(double x, double y) {
        long __functionAddress = GL.getCapabilities().glVertex2d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)x, (double)y);
    }

    public static void nglVertex2fv(long coords) {
        long __functionAddress = GL.getCapabilities().glVertex2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glVertex2fv(FloatBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)2);
        }
        GL11.nglVertex2fv(MemoryUtil.memAddress((FloatBuffer)coords));
    }

    public static void nglVertex2sv(long coords) {
        long __functionAddress = GL.getCapabilities().glVertex2sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glVertex2sv(ShortBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)2);
        }
        GL11.nglVertex2sv(MemoryUtil.memAddress((ShortBuffer)coords));
    }

    public static void nglVertex2iv(long coords) {
        long __functionAddress = GL.getCapabilities().glVertex2iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glVertex2iv(IntBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)2);
        }
        GL11.nglVertex2iv(MemoryUtil.memAddress((IntBuffer)coords));
    }

    public static void nglVertex2dv(long coords) {
        long __functionAddress = GL.getCapabilities().glVertex2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glVertex2dv(DoubleBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)2);
        }
        GL11.nglVertex2dv(MemoryUtil.memAddress((DoubleBuffer)coords));
    }

    public static void glVertex3f(float x, float y, float z) {
        long __functionAddress = GL.getCapabilities().glVertex3f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)x, (float)y, (float)z);
    }

    public static void glVertex3s(short x, short y, short z) {
        long __functionAddress = GL.getCapabilities().glVertex3s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (short)x, (short)y, (short)z);
    }

    public static void glVertex3i(int x, int y, int z) {
        long __functionAddress = GL.getCapabilities().glVertex3i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)x, (int)y, (int)z);
    }

    public static void glVertex3d(double x, double y, double z) {
        long __functionAddress = GL.getCapabilities().glVertex3d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)x, (double)y, (double)z);
    }

    public static void nglVertex3fv(long coords) {
        long __functionAddress = GL.getCapabilities().glVertex3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glVertex3fv(FloatBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)3);
        }
        GL11.nglVertex3fv(MemoryUtil.memAddress((FloatBuffer)coords));
    }

    public static void nglVertex3sv(long coords) {
        long __functionAddress = GL.getCapabilities().glVertex3sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glVertex3sv(ShortBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)3);
        }
        GL11.nglVertex3sv(MemoryUtil.memAddress((ShortBuffer)coords));
    }

    public static void nglVertex3iv(long coords) {
        long __functionAddress = GL.getCapabilities().glVertex3iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glVertex3iv(IntBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)3);
        }
        GL11.nglVertex3iv(MemoryUtil.memAddress((IntBuffer)coords));
    }

    public static void nglVertex3dv(long coords) {
        long __functionAddress = GL.getCapabilities().glVertex3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glVertex3dv(DoubleBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)3);
        }
        GL11.nglVertex3dv(MemoryUtil.memAddress((DoubleBuffer)coords));
    }

    public static void glVertex4f(float x, float y, float z, float w) {
        long __functionAddress = GL.getCapabilities().glVertex4f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)x, (float)y, (float)z, (float)w);
    }

    public static void glVertex4s(short x, short y, short z, short w) {
        long __functionAddress = GL.getCapabilities().glVertex4s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (short)x, (short)y, (short)z, (short)w);
    }

    public static void glVertex4i(int x, int y, int z, int w) {
        long __functionAddress = GL.getCapabilities().glVertex4i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)x, (int)y, (int)z, (int)w);
    }

    public static void glVertex4d(double x, double y, double z, double w) {
        long __functionAddress = GL.getCapabilities().glVertex4d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (double)x, (double)y, (double)z, (double)w);
    }

    public static void nglVertex4fv(long coords) {
        long __functionAddress = GL.getCapabilities().glVertex4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glVertex4fv(FloatBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)4);
        }
        GL11.nglVertex4fv(MemoryUtil.memAddress((FloatBuffer)coords));
    }

    public static void nglVertex4sv(long coords) {
        long __functionAddress = GL.getCapabilities().glVertex4sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glVertex4sv(ShortBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)4);
        }
        GL11.nglVertex4sv(MemoryUtil.memAddress((ShortBuffer)coords));
    }

    public static void nglVertex4iv(long coords) {
        long __functionAddress = GL.getCapabilities().glVertex4iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glVertex4iv(IntBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)4);
        }
        GL11.nglVertex4iv(MemoryUtil.memAddress((IntBuffer)coords));
    }

    public static void nglVertex4dv(long coords) {
        long __functionAddress = GL.getCapabilities().glVertex4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (long)coords);
    }

    public static void glVertex4dv(DoubleBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, (int)4);
        }
        GL11.nglVertex4dv(MemoryUtil.memAddress((DoubleBuffer)coords));
    }

    public static void nglVertexPointer(int size, int type, int stride, long pointer) {
        long __functionAddress = GL.getCapabilities().glVertexPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)size, (int)type, (int)stride, (long)pointer);
    }

    public static void glVertexPointer(int size, int type, int stride, ByteBuffer pointer) {
        GL11.nglVertexPointer(size, type, stride, MemoryUtil.memAddress((ByteBuffer)pointer));
    }

    public static void glVertexPointer(int size, int type, int stride, long pointer) {
        GL11.nglVertexPointer(size, type, stride, pointer);
    }

    public static void glVertexPointer(int size, int type, int stride, ShortBuffer pointer) {
        GL11.nglVertexPointer(size, type, stride, MemoryUtil.memAddress((ShortBuffer)pointer));
    }

    public static void glVertexPointer(int size, int type, int stride, IntBuffer pointer) {
        GL11.nglVertexPointer(size, type, stride, MemoryUtil.memAddress((IntBuffer)pointer));
    }

    public static void glVertexPointer(int size, int type, int stride, FloatBuffer pointer) {
        GL11.nglVertexPointer(size, type, stride, MemoryUtil.memAddress((FloatBuffer)pointer));
    }

    public static void glViewport(int x, int y, int w, int h) {
        long __functionAddress = GL.getCapabilities().glViewport;
        JNI.callV((long)__functionAddress, (int)x, (int)y, (int)w, (int)h);
    }

    public static boolean glAreTexturesResident(int[] textures, ByteBuffer residences) {
        long __functionAddress = GL.getCapabilities().glAreTexturesResident;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((Buffer)residences, (int)textures.length);
        }
        return JNI.callPPZ((long)__functionAddress, (int)textures.length, (int[])textures, (long)MemoryUtil.memAddress((ByteBuffer)residences));
    }

    public static void glClipPlane(int plane, double[] equation) {
        long __functionAddress = GL.getCapabilities().glClipPlane;
        JNI.callPV((long)__functionAddress, (int)plane, (double[])equation);
    }

    public static void glColor3sv(short[] v) {
        long __functionAddress = GL.getCapabilities().glColor3sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])v, (int)3);
        }
        JNI.callPV((long)__functionAddress, (short[])v);
    }

    public static void glColor3iv(int[] v) {
        long __functionAddress = GL.getCapabilities().glColor3iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])v, (int)3);
        }
        JNI.callPV((long)__functionAddress, (int[])v);
    }

    public static void glColor3fv(float[] v) {
        long __functionAddress = GL.getCapabilities().glColor3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])v, (int)3);
        }
        JNI.callPV((long)__functionAddress, (float[])v);
    }

    public static void glColor3dv(double[] v) {
        long __functionAddress = GL.getCapabilities().glColor3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])v, (int)3);
        }
        JNI.callPV((long)__functionAddress, (double[])v);
    }

    public static void glColor3usv(short[] v) {
        long __functionAddress = GL.getCapabilities().glColor3usv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])v, (int)3);
        }
        JNI.callPV((long)__functionAddress, (short[])v);
    }

    public static void glColor3uiv(int[] v) {
        long __functionAddress = GL.getCapabilities().glColor3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])v, (int)3);
        }
        JNI.callPV((long)__functionAddress, (int[])v);
    }

    public static void glColor4sv(short[] v) {
        long __functionAddress = GL.getCapabilities().glColor4sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])v, (int)4);
        }
        JNI.callPV((long)__functionAddress, (short[])v);
    }

    public static void glColor4iv(int[] v) {
        long __functionAddress = GL.getCapabilities().glColor4iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])v, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int[])v);
    }

    public static void glColor4fv(float[] v) {
        long __functionAddress = GL.getCapabilities().glColor4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])v, (int)4);
        }
        JNI.callPV((long)__functionAddress, (float[])v);
    }

    public static void glColor4dv(double[] v) {
        long __functionAddress = GL.getCapabilities().glColor4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])v, (int)4);
        }
        JNI.callPV((long)__functionAddress, (double[])v);
    }

    public static void glColor4usv(short[] v) {
        long __functionAddress = GL.getCapabilities().glColor4usv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])v, (int)4);
        }
        JNI.callPV((long)__functionAddress, (short[])v);
    }

    public static void glColor4uiv(int[] v) {
        long __functionAddress = GL.getCapabilities().glColor4uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])v, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int[])v);
    }

    public static void glColorPointer(int size, int type, int stride, short[] pointer) {
        long __functionAddress = GL.getCapabilities().glColorPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)size, (int)type, (int)stride, (short[])pointer);
    }

    public static void glColorPointer(int size, int type, int stride, int[] pointer) {
        long __functionAddress = GL.getCapabilities().glColorPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)size, (int)type, (int)stride, (int[])pointer);
    }

    public static void glColorPointer(int size, int type, int stride, float[] pointer) {
        long __functionAddress = GL.getCapabilities().glColorPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)size, (int)type, (int)stride, (float[])pointer);
    }

    public static void glDrawPixels(int width, int height, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glDrawPixels;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)width, (int)height, (int)format, (int)type, (short[])pixels);
    }

    public static void glDrawPixels(int width, int height, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glDrawPixels;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)width, (int)height, (int)format, (int)type, (int[])pixels);
    }

    public static void glDrawPixels(int width, int height, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glDrawPixels;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)width, (int)height, (int)format, (int)type, (float[])pixels);
    }

    public static void glEvalCoord1fv(float[] u) {
        long __functionAddress = GL.getCapabilities().glEvalCoord1fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (float[])u);
    }

    public static void glEvalCoord1dv(double[] u) {
        long __functionAddress = GL.getCapabilities().glEvalCoord1dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (double[])u);
    }

    public static void glEvalCoord2fv(float[] u) {
        long __functionAddress = GL.getCapabilities().glEvalCoord2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (float[])u);
    }

    public static void glEvalCoord2dv(double[] u) {
        long __functionAddress = GL.getCapabilities().glEvalCoord2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (double[])u);
    }

    public static void glFeedbackBuffer(int type, float[] buffer) {
        long __functionAddress = GL.getCapabilities().glFeedbackBuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)buffer.length, (int)type, (float[])buffer);
    }

    public static void glFogiv(int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glFogiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (int[])params);
    }

    public static void glFogfv(int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glFogfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (float[])params);
    }

    public static void glGenTextures(int[] textures) {
        long __functionAddress = GL.getCapabilities().glGenTextures;
        JNI.callPV((long)__functionAddress, (int)textures.length, (int[])textures);
    }

    public static void glDeleteTextures(int[] textures) {
        long __functionAddress = GL.getCapabilities().glDeleteTextures;
        JNI.callPV((long)__functionAddress, (int)textures.length, (int[])textures);
    }

    public static void glGetClipPlane(int plane, double[] equation) {
        long __functionAddress = GL.getCapabilities().glGetClipPlane;
        if (Checks.CHECKS) {
            Checks.checkBuffer((double[])equation, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)plane, (double[])equation);
    }

    public static void glGetFloatv(int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetFloatv;
        if (Checks.CHECKS) {
            Checks.checkBuffer((float[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (float[])params);
    }

    public static void glGetIntegerv(int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetIntegerv;
        if (Checks.CHECKS) {
            Checks.checkBuffer((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (int[])params);
    }

    public static void glGetDoublev(int pname, double[] params) {
        long __functionAddress = GL.getCapabilities().glGetDoublev;
        if (Checks.CHECKS) {
            Checks.checkBuffer((double[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (double[])params);
    }

    public static void glGetLightiv(int light, int pname, int[] data) {
        long __functionAddress = GL.getCapabilities().glGetLightiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])data, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)light, (int)pname, (int[])data);
    }

    public static void glGetLightfv(int light, int pname, float[] data) {
        long __functionAddress = GL.getCapabilities().glGetLightfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])data, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)light, (int)pname, (float[])data);
    }

    public static void glGetMapiv(int target, int query, int[] data) {
        long __functionAddress = GL.getCapabilities().glGetMapiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])data, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)query, (int[])data);
    }

    public static void glGetMapfv(int target, int query, float[] data) {
        long __functionAddress = GL.getCapabilities().glGetMapfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])data, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)query, (float[])data);
    }

    public static void glGetMapdv(int target, int query, double[] data) {
        long __functionAddress = GL.getCapabilities().glGetMapdv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])data, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)query, (double[])data);
    }

    public static void glGetMaterialiv(int face, int pname, int[] data) {
        long __functionAddress = GL.getCapabilities().glGetMaterialiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)face, (int)pname, (int[])data);
    }

    public static void glGetMaterialfv(int face, int pname, float[] data) {
        long __functionAddress = GL.getCapabilities().glGetMaterialfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)face, (int)pname, (float[])data);
    }

    public static void glGetPixelMapfv(int map, float[] data) {
        long __functionAddress = GL.getCapabilities().glGetPixelMapfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])data, (int)32);
        }
        JNI.callPV((long)__functionAddress, (int)map, (float[])data);
    }

    public static void glGetPixelMapusv(int map, short[] data) {
        long __functionAddress = GL.getCapabilities().glGetPixelMapusv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])data, (int)32);
        }
        JNI.callPV((long)__functionAddress, (int)map, (short[])data);
    }

    public static void glGetPixelMapuiv(int map, int[] data) {
        long __functionAddress = GL.getCapabilities().glGetPixelMapuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])data, (int)32);
        }
        JNI.callPV((long)__functionAddress, (int)map, (int[])data);
    }

    public static void glGetTexEnviv(int env, int pname, int[] data) {
        long __functionAddress = GL.getCapabilities().glGetTexEnviv;
        if (Checks.CHECKS) {
            Checks.checkBuffer((int[])data, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)env, (int)pname, (int[])data);
    }

    public static void glGetTexEnvfv(int env, int pname, float[] data) {
        long __functionAddress = GL.getCapabilities().glGetTexEnvfv;
        if (Checks.CHECKS) {
            Checks.checkBuffer((float[])data, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)env, (int)pname, (float[])data);
    }

    public static void glGetTexGeniv(int coord, int pname, int[] data) {
        long __functionAddress = GL.getCapabilities().glGetTexGeniv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])data, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)coord, (int)pname, (int[])data);
    }

    public static void glGetTexGenfv(int coord, int pname, float[] data) {
        long __functionAddress = GL.getCapabilities().glGetTexGenfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])data, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)coord, (int)pname, (float[])data);
    }

    public static void glGetTexGendv(int coord, int pname, double[] data) {
        long __functionAddress = GL.getCapabilities().glGetTexGendv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])data, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)coord, (int)pname, (double[])data);
    }

    public static void glGetTexImage(int tex, int level, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glGetTexImage;
        JNI.callPV((long)__functionAddress, (int)tex, (int)level, (int)format, (int)type, (short[])pixels);
    }

    public static void glGetTexImage(int tex, int level, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glGetTexImage;
        JNI.callPV((long)__functionAddress, (int)tex, (int)level, (int)format, (int)type, (int[])pixels);
    }

    public static void glGetTexImage(int tex, int level, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glGetTexImage;
        JNI.callPV((long)__functionAddress, (int)tex, (int)level, (int)format, (int)type, (float[])pixels);
    }

    public static void glGetTexImage(int tex, int level, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glGetTexImage;
        JNI.callPV((long)__functionAddress, (int)tex, (int)level, (int)format, (int)type, (double[])pixels);
    }

    public static void glGetTexLevelParameteriv(int target, int level, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetTexLevelParameteriv;
        if (Checks.CHECKS) {
            Checks.checkBuffer((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)pname, (int[])params);
    }

    public static void glGetTexLevelParameterfv(int target, int level, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetTexLevelParameterfv;
        if (Checks.CHECKS) {
            Checks.checkBuffer((float[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)pname, (float[])params);
    }

    public static void glGetTexParameteriv(int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetTexParameteriv;
        if (Checks.CHECKS) {
            Checks.checkBuffer((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (int[])params);
    }

    public static void glGetTexParameterfv(int target, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetTexParameterfv;
        if (Checks.CHECKS) {
            Checks.checkBuffer((float[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (float[])params);
    }

    public static void glIndexiv(int[] index) {
        long __functionAddress = GL.getCapabilities().glIndexiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])index, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int[])index);
    }

    public static void glIndexsv(short[] index) {
        long __functionAddress = GL.getCapabilities().glIndexsv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])index, (int)1);
        }
        JNI.callPV((long)__functionAddress, (short[])index);
    }

    public static void glIndexfv(float[] index) {
        long __functionAddress = GL.getCapabilities().glIndexfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])index, (int)1);
        }
        JNI.callPV((long)__functionAddress, (float[])index);
    }

    public static void glIndexdv(double[] index) {
        long __functionAddress = GL.getCapabilities().glIndexdv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])index, (int)1);
        }
        JNI.callPV((long)__functionAddress, (double[])index);
    }

    public static void glInterleavedArrays(int format, int stride, short[] pointer) {
        long __functionAddress = GL.getCapabilities().glInterleavedArrays;
        JNI.callPV((long)__functionAddress, (int)format, (int)stride, (short[])pointer);
    }

    public static void glInterleavedArrays(int format, int stride, int[] pointer) {
        long __functionAddress = GL.getCapabilities().glInterleavedArrays;
        JNI.callPV((long)__functionAddress, (int)format, (int)stride, (int[])pointer);
    }

    public static void glInterleavedArrays(int format, int stride, float[] pointer) {
        long __functionAddress = GL.getCapabilities().glInterleavedArrays;
        JNI.callPV((long)__functionAddress, (int)format, (int)stride, (float[])pointer);
    }

    public static void glInterleavedArrays(int format, int stride, double[] pointer) {
        long __functionAddress = GL.getCapabilities().glInterleavedArrays;
        JNI.callPV((long)__functionAddress, (int)format, (int)stride, (double[])pointer);
    }

    public static void glLightModeliv(int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glLightModeliv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (int[])params);
    }

    public static void glLightModelfv(int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glLightModelfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])params, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (float[])params);
    }

    public static void glLightiv(int light, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glLightiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)light, (int)pname, (int[])params);
    }

    public static void glLightfv(int light, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glLightfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])params, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)light, (int)pname, (float[])params);
    }

    public static void glLoadMatrixf(float[] m) {
        long __functionAddress = GL.getCapabilities().glLoadMatrixf;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])m, (int)16);
        }
        JNI.callPV((long)__functionAddress, (float[])m);
    }

    public static void glLoadMatrixd(double[] m) {
        long __functionAddress = GL.getCapabilities().glLoadMatrixd;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])m, (int)16);
        }
        JNI.callPV((long)__functionAddress, (double[])m);
    }

    public static void glMap1f(int target, float u1, float u2, int stride, int order, float[] points) {
        long __functionAddress = GL.getCapabilities().glMap1f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])points, (int)(order * stride));
        }
        JNI.callPV((long)__functionAddress, (int)target, (float)u1, (float)u2, (int)stride, (int)order, (float[])points);
    }

    public static void glMap1d(int target, double u1, double u2, int stride, int order, double[] points) {
        long __functionAddress = GL.getCapabilities().glMap1d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])points, (int)(stride * order));
        }
        JNI.callPV((long)__functionAddress, (int)target, (double)u1, (double)u2, (int)stride, (int)order, (double[])points);
    }

    public static void glMap2f(int target, float u1, float u2, int ustride, int uorder, float v1, float v2, int vstride, int vorder, float[] points) {
        long __functionAddress = GL.getCapabilities().glMap2f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])points, (int)(ustride * uorder * vstride * vorder));
        }
        JNI.callPV((long)__functionAddress, (int)target, (float)u1, (float)u2, (int)ustride, (int)uorder, (float)v1, (float)v2, (int)vstride, (int)vorder, (float[])points);
    }

    public static void glMap2d(int target, double u1, double u2, int ustride, int uorder, double v1, double v2, int vstride, int vorder, double[] points) {
        long __functionAddress = GL.getCapabilities().glMap2d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])points, (int)(ustride * uorder * vstride * vorder));
        }
        JNI.callPV((long)__functionAddress, (int)target, (double)u1, (double)u2, (int)ustride, (int)uorder, (double)v1, (double)v2, (int)vstride, (int)vorder, (double[])points);
    }

    public static void glMaterialiv(int face, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glMaterialiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)face, (int)pname, (int[])params);
    }

    public static void glMaterialfv(int face, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glMaterialfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])params, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)face, (int)pname, (float[])params);
    }

    public static void glMultMatrixf(float[] m) {
        long __functionAddress = GL.getCapabilities().glMultMatrixf;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])m, (int)16);
        }
        JNI.callPV((long)__functionAddress, (float[])m);
    }

    public static void glMultMatrixd(double[] m) {
        long __functionAddress = GL.getCapabilities().glMultMatrixd;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])m, (int)16);
        }
        JNI.callPV((long)__functionAddress, (double[])m);
    }

    public static void glNormal3fv(float[] v) {
        long __functionAddress = GL.getCapabilities().glNormal3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])v, (int)3);
        }
        JNI.callPV((long)__functionAddress, (float[])v);
    }

    public static void glNormal3sv(short[] v) {
        long __functionAddress = GL.getCapabilities().glNormal3sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])v, (int)3);
        }
        JNI.callPV((long)__functionAddress, (short[])v);
    }

    public static void glNormal3iv(int[] v) {
        long __functionAddress = GL.getCapabilities().glNormal3iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])v, (int)3);
        }
        JNI.callPV((long)__functionAddress, (int[])v);
    }

    public static void glNormal3dv(double[] v) {
        long __functionAddress = GL.getCapabilities().glNormal3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])v, (int)3);
        }
        JNI.callPV((long)__functionAddress, (double[])v);
    }

    public static void glNormalPointer(int type, int stride, short[] pointer) {
        long __functionAddress = GL.getCapabilities().glNormalPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)type, (int)stride, (short[])pointer);
    }

    public static void glNormalPointer(int type, int stride, int[] pointer) {
        long __functionAddress = GL.getCapabilities().glNormalPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)type, (int)stride, (int[])pointer);
    }

    public static void glNormalPointer(int type, int stride, float[] pointer) {
        long __functionAddress = GL.getCapabilities().glNormalPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)type, (int)stride, (float[])pointer);
    }

    public static void glPixelMapfv(int map, float[] values) {
        long __functionAddress = GL.getCapabilities().glPixelMapfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)map, (int)values.length, (float[])values);
    }

    public static void glPixelMapusv(int map, short[] values) {
        long __functionAddress = GL.getCapabilities().glPixelMapusv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)map, (int)values.length, (short[])values);
    }

    public static void glPixelMapuiv(int map, int[] values) {
        long __functionAddress = GL.getCapabilities().glPixelMapuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)map, (int)values.length, (int[])values);
    }

    public static void glPrioritizeTextures(int[] textures, float[] priorities) {
        long __functionAddress = GL.getCapabilities().glPrioritizeTextures;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])priorities, (int)textures.length);
        }
        JNI.callPPV((long)__functionAddress, (int)textures.length, (int[])textures, (float[])priorities);
    }

    public static void glRasterPos2iv(int[] coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos2iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])coords, (int)2);
        }
        JNI.callPV((long)__functionAddress, (int[])coords);
    }

    public static void glRasterPos2sv(short[] coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos2sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])coords, (int)2);
        }
        JNI.callPV((long)__functionAddress, (short[])coords);
    }

    public static void glRasterPos2fv(float[] coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])coords, (int)2);
        }
        JNI.callPV((long)__functionAddress, (float[])coords);
    }

    public static void glRasterPos2dv(double[] coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])coords, (int)2);
        }
        JNI.callPV((long)__functionAddress, (double[])coords);
    }

    public static void glRasterPos3iv(int[] coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos3iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])coords, (int)3);
        }
        JNI.callPV((long)__functionAddress, (int[])coords);
    }

    public static void glRasterPos3sv(short[] coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos3sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])coords, (int)3);
        }
        JNI.callPV((long)__functionAddress, (short[])coords);
    }

    public static void glRasterPos3fv(float[] coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])coords, (int)3);
        }
        JNI.callPV((long)__functionAddress, (float[])coords);
    }

    public static void glRasterPos3dv(double[] coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])coords, (int)3);
        }
        JNI.callPV((long)__functionAddress, (double[])coords);
    }

    public static void glRasterPos4iv(int[] coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos4iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])coords, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int[])coords);
    }

    public static void glRasterPos4sv(short[] coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos4sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])coords, (int)4);
        }
        JNI.callPV((long)__functionAddress, (short[])coords);
    }

    public static void glRasterPos4fv(float[] coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])coords, (int)4);
        }
        JNI.callPV((long)__functionAddress, (float[])coords);
    }

    public static void glRasterPos4dv(double[] coords) {
        long __functionAddress = GL.getCapabilities().glRasterPos4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])coords, (int)4);
        }
        JNI.callPV((long)__functionAddress, (double[])coords);
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glReadPixels;
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (short[])pixels);
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glReadPixels;
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int[])pixels);
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glReadPixels;
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (float[])pixels);
    }

    public static void glRectiv(int[] v1, int[] v2) {
        long __functionAddress = GL.getCapabilities().glRectiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])v1, (int)2);
            Checks.checkBuffer((int[])v2, (int)2);
        }
        JNI.callPPV((long)__functionAddress, (int[])v1, (int[])v2);
    }

    public static void glRectsv(short[] v1, short[] v2) {
        long __functionAddress = GL.getCapabilities().glRectsv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])v1, (int)2);
            Checks.checkBuffer((short[])v2, (int)2);
        }
        JNI.callPPV((long)__functionAddress, (short[])v1, (short[])v2);
    }

    public static void glRectfv(float[] v1, float[] v2) {
        long __functionAddress = GL.getCapabilities().glRectfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])v1, (int)2);
            Checks.checkBuffer((float[])v2, (int)2);
        }
        JNI.callPPV((long)__functionAddress, (float[])v1, (float[])v2);
    }

    public static void glRectdv(double[] v1, double[] v2) {
        long __functionAddress = GL.getCapabilities().glRectdv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])v1, (int)2);
            Checks.checkBuffer((double[])v2, (int)2);
        }
        JNI.callPPV((long)__functionAddress, (double[])v1, (double[])v2);
    }

    public static void glSelectBuffer(int[] buffer) {
        long __functionAddress = GL.getCapabilities().glSelectBuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)buffer.length, (int[])buffer);
    }

    public static void glTexCoord1fv(float[] v) {
        long __functionAddress = GL.getCapabilities().glTexCoord1fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])v, (int)1);
        }
        JNI.callPV((long)__functionAddress, (float[])v);
    }

    public static void glTexCoord1sv(short[] v) {
        long __functionAddress = GL.getCapabilities().glTexCoord1sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])v, (int)1);
        }
        JNI.callPV((long)__functionAddress, (short[])v);
    }

    public static void glTexCoord1iv(int[] v) {
        long __functionAddress = GL.getCapabilities().glTexCoord1iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])v, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int[])v);
    }

    public static void glTexCoord1dv(double[] v) {
        long __functionAddress = GL.getCapabilities().glTexCoord1dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])v, (int)1);
        }
        JNI.callPV((long)__functionAddress, (double[])v);
    }

    public static void glTexCoord2fv(float[] v) {
        long __functionAddress = GL.getCapabilities().glTexCoord2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])v, (int)2);
        }
        JNI.callPV((long)__functionAddress, (float[])v);
    }

    public static void glTexCoord2sv(short[] v) {
        long __functionAddress = GL.getCapabilities().glTexCoord2sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])v, (int)2);
        }
        JNI.callPV((long)__functionAddress, (short[])v);
    }

    public static void glTexCoord2iv(int[] v) {
        long __functionAddress = GL.getCapabilities().glTexCoord2iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])v, (int)2);
        }
        JNI.callPV((long)__functionAddress, (int[])v);
    }

    public static void glTexCoord2dv(double[] v) {
        long __functionAddress = GL.getCapabilities().glTexCoord2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])v, (int)2);
        }
        JNI.callPV((long)__functionAddress, (double[])v);
    }

    public static void glTexCoord3fv(float[] v) {
        long __functionAddress = GL.getCapabilities().glTexCoord3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])v, (int)3);
        }
        JNI.callPV((long)__functionAddress, (float[])v);
    }

    public static void glTexCoord3sv(short[] v) {
        long __functionAddress = GL.getCapabilities().glTexCoord3sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])v, (int)3);
        }
        JNI.callPV((long)__functionAddress, (short[])v);
    }

    public static void glTexCoord3iv(int[] v) {
        long __functionAddress = GL.getCapabilities().glTexCoord3iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])v, (int)3);
        }
        JNI.callPV((long)__functionAddress, (int[])v);
    }

    public static void glTexCoord3dv(double[] v) {
        long __functionAddress = GL.getCapabilities().glTexCoord3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])v, (int)3);
        }
        JNI.callPV((long)__functionAddress, (double[])v);
    }

    public static void glTexCoord4fv(float[] v) {
        long __functionAddress = GL.getCapabilities().glTexCoord4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])v, (int)4);
        }
        JNI.callPV((long)__functionAddress, (float[])v);
    }

    public static void glTexCoord4sv(short[] v) {
        long __functionAddress = GL.getCapabilities().glTexCoord4sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])v, (int)4);
        }
        JNI.callPV((long)__functionAddress, (short[])v);
    }

    public static void glTexCoord4iv(int[] v) {
        long __functionAddress = GL.getCapabilities().glTexCoord4iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])v, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int[])v);
    }

    public static void glTexCoord4dv(double[] v) {
        long __functionAddress = GL.getCapabilities().glTexCoord4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])v, (int)4);
        }
        JNI.callPV((long)__functionAddress, (double[])v);
    }

    public static void glTexCoordPointer(int size, int type, int stride, short[] pointer) {
        long __functionAddress = GL.getCapabilities().glTexCoordPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)size, (int)type, (int)stride, (short[])pointer);
    }

    public static void glTexCoordPointer(int size, int type, int stride, int[] pointer) {
        long __functionAddress = GL.getCapabilities().glTexCoordPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)size, (int)type, (int)stride, (int[])pointer);
    }

    public static void glTexCoordPointer(int size, int type, int stride, float[] pointer) {
        long __functionAddress = GL.getCapabilities().glTexCoordPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)size, (int)type, (int)stride, (float[])pointer);
    }

    public static void glTexEnviv(int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glTexEnviv;
        if (Checks.CHECKS) {
            Checks.checkBuffer((int[])params, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (int[])params);
    }

    public static void glTexEnvfv(int target, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glTexEnvfv;
        if (Checks.CHECKS) {
            Checks.checkBuffer((float[])params, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (float[])params);
    }

    public static void glTexGeniv(int coord, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glTexGeniv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)coord, (int)pname, (int[])params);
    }

    public static void glTexGenfv(int coord, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glTexGenfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])params, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)coord, (int)pname, (float[])params);
    }

    public static void glTexGendv(int coord, int pname, double[] params) {
        long __functionAddress = GL.getCapabilities().glTexGendv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])params, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)coord, (int)pname, (double[])params);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glTexImage2D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (short[])pixels);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glTexImage2D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (int[])pixels);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glTexImage2D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (float[])pixels);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glTexImage2D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (double[])pixels);
    }

    public static void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glTexImage1D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)internalformat, (int)width, (int)border, (int)format, (int)type, (short[])pixels);
    }

    public static void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glTexImage1D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)internalformat, (int)width, (int)border, (int)format, (int)type, (int[])pixels);
    }

    public static void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glTexImage1D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)internalformat, (int)width, (int)border, (int)format, (int)type, (float[])pixels);
    }

    public static void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glTexImage1D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)internalformat, (int)width, (int)border, (int)format, (int)type, (double[])pixels);
    }

    public static void glTexParameteriv(int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glTexParameteriv;
        if (Checks.CHECKS) {
            Checks.checkBuffer((int[])params, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (int[])params);
    }

    public static void glTexParameterfv(int target, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glTexParameterfv;
        if (Checks.CHECKS) {
            Checks.checkBuffer((float[])params, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (float[])params);
    }

    public static void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glTexSubImage1D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)xoffset, (int)width, (int)format, (int)type, (short[])pixels);
    }

    public static void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glTexSubImage1D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)xoffset, (int)width, (int)format, (int)type, (int[])pixels);
    }

    public static void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glTexSubImage1D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)xoffset, (int)width, (int)format, (int)type, (float[])pixels);
    }

    public static void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glTexSubImage1D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)xoffset, (int)width, (int)format, (int)type, (double[])pixels);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glTexSubImage2D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (short[])pixels);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glTexSubImage2D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (int[])pixels);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glTexSubImage2D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (float[])pixels);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glTexSubImage2D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (double[])pixels);
    }

    public static void glVertex2fv(float[] coords) {
        long __functionAddress = GL.getCapabilities().glVertex2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])coords, (int)2);
        }
        JNI.callPV((long)__functionAddress, (float[])coords);
    }

    public static void glVertex2sv(short[] coords) {
        long __functionAddress = GL.getCapabilities().glVertex2sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])coords, (int)2);
        }
        JNI.callPV((long)__functionAddress, (short[])coords);
    }

    public static void glVertex2iv(int[] coords) {
        long __functionAddress = GL.getCapabilities().glVertex2iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])coords, (int)2);
        }
        JNI.callPV((long)__functionAddress, (int[])coords);
    }

    public static void glVertex2dv(double[] coords) {
        long __functionAddress = GL.getCapabilities().glVertex2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])coords, (int)2);
        }
        JNI.callPV((long)__functionAddress, (double[])coords);
    }

    public static void glVertex3fv(float[] coords) {
        long __functionAddress = GL.getCapabilities().glVertex3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])coords, (int)3);
        }
        JNI.callPV((long)__functionAddress, (float[])coords);
    }

    public static void glVertex3sv(short[] coords) {
        long __functionAddress = GL.getCapabilities().glVertex3sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])coords, (int)3);
        }
        JNI.callPV((long)__functionAddress, (short[])coords);
    }

    public static void glVertex3iv(int[] coords) {
        long __functionAddress = GL.getCapabilities().glVertex3iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])coords, (int)3);
        }
        JNI.callPV((long)__functionAddress, (int[])coords);
    }

    public static void glVertex3dv(double[] coords) {
        long __functionAddress = GL.getCapabilities().glVertex3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])coords, (int)3);
        }
        JNI.callPV((long)__functionAddress, (double[])coords);
    }

    public static void glVertex4fv(float[] coords) {
        long __functionAddress = GL.getCapabilities().glVertex4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])coords, (int)4);
        }
        JNI.callPV((long)__functionAddress, (float[])coords);
    }

    public static void glVertex4sv(short[] coords) {
        long __functionAddress = GL.getCapabilities().glVertex4sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((short[])coords, (int)4);
        }
        JNI.callPV((long)__functionAddress, (short[])coords);
    }

    public static void glVertex4iv(int[] coords) {
        long __functionAddress = GL.getCapabilities().glVertex4iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])coords, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int[])coords);
    }

    public static void glVertex4dv(double[] coords) {
        long __functionAddress = GL.getCapabilities().glVertex4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])coords, (int)4);
        }
        JNI.callPV((long)__functionAddress, (double[])coords);
    }

    public static void glVertexPointer(int size, int type, int stride, short[] pointer) {
        long __functionAddress = GL.getCapabilities().glVertexPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)size, (int)type, (int)stride, (short[])pointer);
    }

    public static void glVertexPointer(int size, int type, int stride, int[] pointer) {
        long __functionAddress = GL.getCapabilities().glVertexPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)size, (int)type, (int)stride, (int[])pointer);
    }

    public static void glVertexPointer(int size, int type, int stride, float[] pointer) {
        long __functionAddress = GL.getCapabilities().glVertexPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)size, (int)type, (int)stride, (float[])pointer);
    }
}

