/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTFramebufferObject {
    public static final int GL_FRAMEBUFFER_EXT = 36160;
    public static final int GL_RENDERBUFFER_EXT = 36161;
    public static final int GL_STENCIL_INDEX1_EXT = 36166;
    public static final int GL_STENCIL_INDEX4_EXT = 36167;
    public static final int GL_STENCIL_INDEX8_EXT = 36168;
    public static final int GL_STENCIL_INDEX16_EXT = 36169;
    public static final int GL_RENDERBUFFER_WIDTH_EXT = 36162;
    public static final int GL_RENDERBUFFER_HEIGHT_EXT = 36163;
    public static final int GL_RENDERBUFFER_INTERNAL_FORMAT_EXT = 36164;
    public static final int GL_RENDERBUFFER_RED_SIZE_EXT = 36176;
    public static final int GL_RENDERBUFFER_GREEN_SIZE_EXT = 36177;
    public static final int GL_RENDERBUFFER_BLUE_SIZE_EXT = 36178;
    public static final int GL_RENDERBUFFER_ALPHA_SIZE_EXT = 36179;
    public static final int GL_RENDERBUFFER_DEPTH_SIZE_EXT = 36180;
    public static final int GL_RENDERBUFFER_STENCIL_SIZE_EXT = 36181;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT = 36048;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT = 36049;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT = 36050;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT = 36051;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT = 36052;
    public static final int GL_COLOR_ATTACHMENT0_EXT = 36064;
    public static final int GL_COLOR_ATTACHMENT1_EXT = 36065;
    public static final int GL_COLOR_ATTACHMENT2_EXT = 36066;
    public static final int GL_COLOR_ATTACHMENT3_EXT = 36067;
    public static final int GL_COLOR_ATTACHMENT4_EXT = 36068;
    public static final int GL_COLOR_ATTACHMENT5_EXT = 36069;
    public static final int GL_COLOR_ATTACHMENT6_EXT = 36070;
    public static final int GL_COLOR_ATTACHMENT7_EXT = 36071;
    public static final int GL_COLOR_ATTACHMENT8_EXT = 36072;
    public static final int GL_COLOR_ATTACHMENT9_EXT = 36073;
    public static final int GL_COLOR_ATTACHMENT10_EXT = 36074;
    public static final int GL_COLOR_ATTACHMENT11_EXT = 36075;
    public static final int GL_COLOR_ATTACHMENT12_EXT = 36076;
    public static final int GL_COLOR_ATTACHMENT13_EXT = 36077;
    public static final int GL_COLOR_ATTACHMENT14_EXT = 36078;
    public static final int GL_COLOR_ATTACHMENT15_EXT = 36079;
    public static final int GL_DEPTH_ATTACHMENT_EXT = 36096;
    public static final int GL_STENCIL_ATTACHMENT_EXT = 36128;
    public static final int GL_FRAMEBUFFER_COMPLETE_EXT = 36053;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT = 36054;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT = 36055;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT = 36057;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT = 36058;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT = 36059;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT = 36060;
    public static final int GL_FRAMEBUFFER_UNSUPPORTED_EXT = 36061;
    public static final int GL_FRAMEBUFFER_BINDING_EXT = 36006;
    public static final int GL_RENDERBUFFER_BINDING_EXT = 36007;
    public static final int GL_MAX_COLOR_ATTACHMENTS_EXT = 36063;
    public static final int GL_MAX_RENDERBUFFER_SIZE_EXT = 34024;
    public static final int GL_INVALID_FRAMEBUFFER_OPERATION_EXT = 1286;

    protected EXTFramebufferObject() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glIsRenderbufferEXT, caps.glBindRenderbufferEXT, caps.glDeleteRenderbuffersEXT, caps.glGenRenderbuffersEXT, caps.glRenderbufferStorageEXT, caps.glGetRenderbufferParameterivEXT, caps.glIsFramebufferEXT, caps.glBindFramebufferEXT, caps.glDeleteFramebuffersEXT, caps.glGenFramebuffersEXT, caps.glCheckFramebufferStatusEXT, caps.glFramebufferTexture1DEXT, caps.glFramebufferTexture2DEXT, caps.glFramebufferTexture3DEXT, caps.glFramebufferRenderbufferEXT, caps.glGetFramebufferAttachmentParameterivEXT, caps.glGenerateMipmapEXT});
    }

    public static boolean glIsRenderbufferEXT(int renderbuffer) {
        long __functionAddress = GL.getCapabilities().glIsRenderbufferEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress, (int)renderbuffer);
    }

    public static void glBindRenderbufferEXT(int target, int renderbuffer) {
        long __functionAddress = GL.getCapabilities().glBindRenderbufferEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)target, (int)renderbuffer);
    }

    public static void nglDeleteRenderbuffersEXT(int n, long renderbuffers) {
        long __functionAddress = GL.getCapabilities().glDeleteRenderbuffersEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)renderbuffers);
    }

    public static void glDeleteRenderbuffersEXT(IntBuffer renderbuffers) {
        EXTFramebufferObject.nglDeleteRenderbuffersEXT(renderbuffers.remaining(), MemoryUtil.memAddress((IntBuffer)renderbuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteRenderbuffersEXT(int renderbuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer renderbuffers = stack.ints(renderbuffer);
            EXTFramebufferObject.nglDeleteRenderbuffersEXT(1, MemoryUtil.memAddress((IntBuffer)renderbuffers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGenRenderbuffersEXT(int n, long renderbuffers) {
        long __functionAddress = GL.getCapabilities().glGenRenderbuffersEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)renderbuffers);
    }

    public static void glGenRenderbuffersEXT(IntBuffer renderbuffers) {
        EXTFramebufferObject.nglGenRenderbuffersEXT(renderbuffers.remaining(), MemoryUtil.memAddress((IntBuffer)renderbuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenRenderbuffersEXT() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer renderbuffers = stack.callocInt(1);
            EXTFramebufferObject.nglGenRenderbuffersEXT(1, MemoryUtil.memAddress((IntBuffer)renderbuffers));
            int n = renderbuffers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glRenderbufferStorageEXT(int target, int internalformat, int width, int height) {
        long __functionAddress = GL.getCapabilities().glRenderbufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)target, (int)internalformat, (int)width, (int)height);
    }

    public static void nglGetRenderbufferParameterivEXT(int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetRenderbufferParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (long)params);
    }

    public static void glGetRenderbufferParameterivEXT(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        EXTFramebufferObject.nglGetRenderbufferParameterivEXT(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetRenderbufferParameteriEXT(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTFramebufferObject.nglGetRenderbufferParameterivEXT(target, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean glIsFramebufferEXT(int framebuffer) {
        long __functionAddress = GL.getCapabilities().glIsFramebufferEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress, (int)framebuffer);
    }

    public static void glBindFramebufferEXT(int target, int framebuffer) {
        long __functionAddress = GL.getCapabilities().glBindFramebufferEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)target, (int)framebuffer);
    }

    public static void nglDeleteFramebuffersEXT(int n, long framebuffers) {
        long __functionAddress = GL.getCapabilities().glDeleteFramebuffersEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)framebuffers);
    }

    public static void glDeleteFramebuffersEXT(IntBuffer framebuffers) {
        EXTFramebufferObject.nglDeleteFramebuffersEXT(framebuffers.remaining(), MemoryUtil.memAddress((IntBuffer)framebuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteFramebuffersEXT(int framebuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer framebuffers = stack.ints(framebuffer);
            EXTFramebufferObject.nglDeleteFramebuffersEXT(1, MemoryUtil.memAddress((IntBuffer)framebuffers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGenFramebuffersEXT(int n, long framebuffers) {
        long __functionAddress = GL.getCapabilities().glGenFramebuffersEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)framebuffers);
    }

    public static void glGenFramebuffersEXT(IntBuffer framebuffers) {
        EXTFramebufferObject.nglGenFramebuffersEXT(framebuffers.remaining(), MemoryUtil.memAddress((IntBuffer)framebuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenFramebuffersEXT() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer framebuffers = stack.callocInt(1);
            EXTFramebufferObject.nglGenFramebuffersEXT(1, MemoryUtil.memAddress((IntBuffer)framebuffers));
            int n = framebuffers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int glCheckFramebufferStatusEXT(int target) {
        long __functionAddress = GL.getCapabilities().glCheckFramebufferStatusEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callI((long)__functionAddress, (int)target);
    }

    public static void glFramebufferTexture1DEXT(int target, int attachment, int textarget, int texture, int level) {
        long __functionAddress = GL.getCapabilities().glFramebufferTexture1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
    }

    public static void glFramebufferTexture2DEXT(int target, int attachment, int textarget, int texture, int level) {
        long __functionAddress = GL.getCapabilities().glFramebufferTexture2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
    }

    public static void glFramebufferTexture3DEXT(int target, int attachment, int textarget, int texture, int level, int zoffset) {
        long __functionAddress = GL.getCapabilities().glFramebufferTexture3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)target, (int)attachment, (int)textarget, (int)texture, (int)level, (int)zoffset);
    }

    public static void glFramebufferRenderbufferEXT(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        long __functionAddress = GL.getCapabilities().glFramebufferRenderbufferEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)target, (int)attachment, (int)renderbuffertarget, (int)renderbuffer);
    }

    public static void nglGetFramebufferAttachmentParameterivEXT(int target, int attachment, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetFramebufferAttachmentParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)attachment, (int)pname, (long)params);
    }

    public static void glGetFramebufferAttachmentParameterivEXT(int target, int attachment, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        EXTFramebufferObject.nglGetFramebufferAttachmentParameterivEXT(target, attachment, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetFramebufferAttachmentParameteriEXT(int target, int attachment, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTFramebufferObject.nglGetFramebufferAttachmentParameterivEXT(target, attachment, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGenerateMipmapEXT(int target) {
        long __functionAddress = GL.getCapabilities().glGenerateMipmapEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)target);
    }

    public static void glDeleteRenderbuffersEXT(int[] renderbuffers) {
        long __functionAddress = GL.getCapabilities().glDeleteRenderbuffersEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)renderbuffers.length, (int[])renderbuffers);
    }

    public static void glGenRenderbuffersEXT(int[] renderbuffers) {
        long __functionAddress = GL.getCapabilities().glGenRenderbuffersEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)renderbuffers.length, (int[])renderbuffers);
    }

    public static void glGetRenderbufferParameterivEXT(int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetRenderbufferParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (int[])params);
    }

    public static void glDeleteFramebuffersEXT(int[] framebuffers) {
        long __functionAddress = GL.getCapabilities().glDeleteFramebuffersEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)framebuffers.length, (int[])framebuffers);
    }

    public static void glGenFramebuffersEXT(int[] framebuffers) {
        long __functionAddress = GL.getCapabilities().glGenFramebuffersEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)framebuffers.length, (int[])framebuffers);
    }

    public static void glGetFramebufferAttachmentParameterivEXT(int target, int attachment, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetFramebufferAttachmentParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)attachment, (int)pname, (int[])params);
    }
}

