/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTDrawBuffers2 {
    protected EXTDrawBuffers2() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glColorMaskIndexedEXT, caps.glGetBooleanIndexedvEXT, caps.glGetIntegerIndexedvEXT, caps.glEnableIndexedEXT, caps.glDisableIndexedEXT, caps.glIsEnabledIndexedEXT});
    }

    public static void glColorMaskIndexedEXT(int index, boolean r, boolean g, boolean b, boolean a) {
        long __functionAddress = GL.getCapabilities().glColorMaskIndexedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)index, (boolean)r, (boolean)g, (boolean)b, (boolean)a);
    }

    public static void nglGetBooleanIndexedvEXT(int target, int index, long data) {
        long __functionAddress = GL.getCapabilities().glGetBooleanIndexedvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)index, (long)data);
    }

    public static void glGetBooleanIndexedvEXT(int target, int index, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)1);
        }
        EXTDrawBuffers2.nglGetBooleanIndexedvEXT(target, index, MemoryUtil.memAddress((ByteBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean glGetBooleanIndexedEXT(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer data = stack.calloc(1);
            EXTDrawBuffers2.nglGetBooleanIndexedvEXT(target, index, MemoryUtil.memAddress((ByteBuffer)data));
            boolean bl = data.get(0) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetIntegerIndexedvEXT(int target, int index, long data) {
        long __functionAddress = GL.getCapabilities().glGetIntegerIndexedvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)index, (long)data);
    }

    public static void glGetIntegerIndexedvEXT(int target, int index, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)1);
        }
        EXTDrawBuffers2.nglGetIntegerIndexedvEXT(target, index, MemoryUtil.memAddress((IntBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetIntegerIndexedEXT(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer data = stack.callocInt(1);
            EXTDrawBuffers2.nglGetIntegerIndexedvEXT(target, index, MemoryUtil.memAddress((IntBuffer)data));
            int n = data.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glEnableIndexedEXT(int target, int index) {
        long __functionAddress = GL.getCapabilities().glEnableIndexedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)target, (int)index);
    }

    public static void glDisableIndexedEXT(int target, int index) {
        long __functionAddress = GL.getCapabilities().glDisableIndexedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)target, (int)index);
    }

    public static boolean glIsEnabledIndexedEXT(int target, int index) {
        long __functionAddress = GL.getCapabilities().glIsEnabledIndexedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress, (int)target, (int)index);
    }

    public static void glGetIntegerIndexedvEXT(int target, int index, int[] data) {
        long __functionAddress = GL.getCapabilities().glGetIntegerIndexedvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])data, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)index, (int[])data);
    }
}

