/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBViewportArray {
    public static final int GL_MAX_VIEWPORTS = 33371;
    public static final int GL_VIEWPORT_SUBPIXEL_BITS = 33372;
    public static final int GL_VIEWPORT_BOUNDS_RANGE = 33373;
    public static final int GL_LAYER_PROVOKING_VERTEX = 33374;
    public static final int GL_VIEWPORT_INDEX_PROVOKING_VERTEX = 33375;
    public static final int GL_UNDEFINED_VERTEX = 33376;

    protected ARBViewportArray() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glViewportArrayv, caps.glViewportIndexedf, caps.glViewportIndexedfv, caps.glScissorArrayv, caps.glScissorIndexed, caps.glScissorIndexedv, caps.glDepthRangeArrayv, caps.glDepthRangeIndexed, caps.glGetFloati_v, caps.glGetDoublei_v});
    }

    public static void nglViewportArrayv(int first, int count, long v) {
        long __functionAddress = GL.getCapabilities().glViewportArrayv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)first, (int)count, (long)v);
    }

    public static void glViewportArrayv(int first, FloatBuffer v) {
        ARBViewportArray.nglViewportArrayv(first, v.remaining() >> 2, MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static void glViewportIndexedf(int index, float x, float y, float w, float h) {
        long __functionAddress = GL.getCapabilities().glViewportIndexedf;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)index, (float)x, (float)y, (float)w, (float)h);
    }

    public static void nglViewportIndexedfv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glViewportIndexedfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)index, (long)v);
    }

    public static void glViewportIndexedfv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)4);
        }
        ARBViewportArray.nglViewportIndexedfv(index, MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static void nglScissorArrayv(int first, int count, long v) {
        long __functionAddress = GL.getCapabilities().glScissorArrayv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)first, (int)count, (long)v);
    }

    public static void glScissorArrayv(int first, IntBuffer v) {
        ARBViewportArray.nglScissorArrayv(first, v.remaining() >> 2, MemoryUtil.memAddress((IntBuffer)v));
    }

    public static void glScissorIndexed(int index, int left, int bottom, int width, int height) {
        long __functionAddress = GL.getCapabilities().glScissorIndexed;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)index, (int)left, (int)bottom, (int)width, (int)height);
    }

    public static void nglScissorIndexedv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glScissorIndexedv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)index, (long)v);
    }

    public static void glScissorIndexedv(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, (int)4);
        }
        ARBViewportArray.nglScissorIndexedv(index, MemoryUtil.memAddress((IntBuffer)v));
    }

    public static void nglDepthRangeArrayv(int first, int count, long v) {
        long __functionAddress = GL.getCapabilities().glDepthRangeArrayv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)first, (int)count, (long)v);
    }

    public static void glDepthRangeArrayv(int first, DoubleBuffer v) {
        ARBViewportArray.nglDepthRangeArrayv(first, v.remaining() >> 1, MemoryUtil.memAddress((DoubleBuffer)v));
    }

    public static void glDepthRangeIndexed(int index, double zNear, double zFar) {
        long __functionAddress = GL.getCapabilities().glDepthRangeIndexed;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)index, (double)zNear, (double)zFar);
    }

    public static void nglGetFloati_v(int target, int index, long data) {
        long __functionAddress = GL.getCapabilities().glGetFloati_v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)index, (long)data);
    }

    public static void glGetFloati_v(int target, int index, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)1);
        }
        ARBViewportArray.nglGetFloati_v(target, index, MemoryUtil.memAddress((FloatBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetFloati(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer data = stack.callocFloat(1);
            ARBViewportArray.nglGetFloati_v(target, index, MemoryUtil.memAddress((FloatBuffer)data));
            float f = data.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetDoublei_v(int target, int index, long data) {
        long __functionAddress = GL.getCapabilities().glGetDoublei_v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)index, (long)data);
    }

    public static void glGetDoublei_v(int target, int index, DoubleBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)1);
        }
        ARBViewportArray.nglGetDoublei_v(target, index, MemoryUtil.memAddress((DoubleBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double glGetDoublei(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer data = stack.callocDouble(1);
            ARBViewportArray.nglGetDoublei_v(target, index, MemoryUtil.memAddress((DoubleBuffer)data));
            double d = data.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glViewportArrayv(int first, float[] v) {
        long __functionAddress = GL.getCapabilities().glViewportArrayv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)first, (int)(v.length >> 2), (float[])v);
    }

    public static void glViewportIndexedfv(int index, float[] v) {
        long __functionAddress = GL.getCapabilities().glViewportIndexedfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])v, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)index, (float[])v);
    }

    public static void glScissorArrayv(int first, int[] v) {
        long __functionAddress = GL.getCapabilities().glScissorArrayv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)first, (int)(v.length >> 2), (int[])v);
    }

    public static void glScissorIndexedv(int index, int[] v) {
        long __functionAddress = GL.getCapabilities().glScissorIndexedv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])v, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)index, (int[])v);
    }

    public static void glDepthRangeArrayv(int first, double[] v) {
        long __functionAddress = GL.getCapabilities().glDepthRangeArrayv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)first, (int)(v.length >> 1), (double[])v);
    }

    public static void glGetFloati_v(int target, int index, float[] data) {
        long __functionAddress = GL.getCapabilities().glGetFloati_v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])data, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)index, (float[])data);
    }

    public static void glGetDoublei_v(int target, int index, double[] data) {
        long __functionAddress = GL.getCapabilities().glGetDoublei_v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])data, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)index, (double[])data);
    }
}

