/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBVertexBufferObject {
    public static final int GL_ARRAY_BUFFER_ARB = 34962;
    public static final int GL_ELEMENT_ARRAY_BUFFER_ARB = 34963;
    public static final int GL_ARRAY_BUFFER_BINDING_ARB = 34964;
    public static final int GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB = 34965;
    public static final int GL_VERTEX_ARRAY_BUFFER_BINDING_ARB = 34966;
    public static final int GL_NORMAL_ARRAY_BUFFER_BINDING_ARB = 34967;
    public static final int GL_COLOR_ARRAY_BUFFER_BINDING_ARB = 34968;
    public static final int GL_INDEX_ARRAY_BUFFER_BINDING_ARB = 34969;
    public static final int GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB = 34970;
    public static final int GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB = 34971;
    public static final int GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB = 34972;
    public static final int GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB = 34973;
    public static final int GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB = 34974;
    public static final int GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB = 34975;
    public static final int GL_STREAM_DRAW_ARB = 35040;
    public static final int GL_STREAM_READ_ARB = 35041;
    public static final int GL_STREAM_COPY_ARB = 35042;
    public static final int GL_STATIC_DRAW_ARB = 35044;
    public static final int GL_STATIC_READ_ARB = 35045;
    public static final int GL_STATIC_COPY_ARB = 35046;
    public static final int GL_DYNAMIC_DRAW_ARB = 35048;
    public static final int GL_DYNAMIC_READ_ARB = 35049;
    public static final int GL_DYNAMIC_COPY_ARB = 35050;
    public static final int GL_READ_ONLY_ARB = 35000;
    public static final int GL_WRITE_ONLY_ARB = 35001;
    public static final int GL_READ_WRITE_ARB = 35002;
    public static final int GL_BUFFER_SIZE_ARB = 34660;
    public static final int GL_BUFFER_USAGE_ARB = 34661;
    public static final int GL_BUFFER_ACCESS_ARB = 35003;
    public static final int GL_BUFFER_MAPPED_ARB = 35004;
    public static final int GL_BUFFER_MAP_POINTER_ARB = 35005;

    protected ARBVertexBufferObject() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glBindBufferARB, caps.glDeleteBuffersARB, caps.glGenBuffersARB, caps.glIsBufferARB, caps.glBufferDataARB, caps.glBufferSubDataARB, caps.glGetBufferSubDataARB, caps.glMapBufferARB, caps.glUnmapBufferARB, caps.glGetBufferParameterivARB, caps.glGetBufferPointervARB});
    }

    public static void glBindBufferARB(int target, int buffer) {
        long __functionAddress = GL.getCapabilities().glBindBufferARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)target, (int)buffer);
    }

    public static void nglDeleteBuffersARB(int n, long buffers) {
        long __functionAddress = GL.getCapabilities().glDeleteBuffersARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)buffers);
    }

    public static void glDeleteBuffersARB(IntBuffer buffers) {
        ARBVertexBufferObject.nglDeleteBuffersARB(buffers.remaining(), MemoryUtil.memAddress((IntBuffer)buffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteBuffersARB(int buffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer buffers = stack.ints(buffer);
            ARBVertexBufferObject.nglDeleteBuffersARB(1, MemoryUtil.memAddress((IntBuffer)buffers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGenBuffersARB(int n, long buffers) {
        long __functionAddress = GL.getCapabilities().glGenBuffersARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)buffers);
    }

    public static void glGenBuffersARB(IntBuffer buffers) {
        ARBVertexBufferObject.nglGenBuffersARB(buffers.remaining(), MemoryUtil.memAddress((IntBuffer)buffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenBuffersARB() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer buffers = stack.callocInt(1);
            ARBVertexBufferObject.nglGenBuffersARB(1, MemoryUtil.memAddress((IntBuffer)buffers));
            int n = buffers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean glIsBufferARB(int buffer) {
        long __functionAddress = GL.getCapabilities().glIsBufferARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress, (int)buffer);
    }

    public static void nglBufferDataARB(int target, long size, long data, int usage) {
        long __functionAddress = GL.getCapabilities().glBufferDataARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)target, (long)size, (long)data, (int)usage);
    }

    public static void glBufferDataARB(int target, long size, int usage) {
        ARBVertexBufferObject.nglBufferDataARB(target, size, 0L, usage);
    }

    public static void glBufferDataARB(int target, ByteBuffer data, int usage) {
        ARBVertexBufferObject.nglBufferDataARB(target, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data), usage);
    }

    public static void glBufferDataARB(int target, ShortBuffer data, int usage) {
        ARBVertexBufferObject.nglBufferDataARB(target, data.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)data), usage);
    }

    public static void glBufferDataARB(int target, IntBuffer data, int usage) {
        ARBVertexBufferObject.nglBufferDataARB(target, data.remaining() << 2, MemoryUtil.memAddress((IntBuffer)data), usage);
    }

    public static void glBufferDataARB(int target, FloatBuffer data, int usage) {
        ARBVertexBufferObject.nglBufferDataARB(target, data.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)data), usage);
    }

    public static void glBufferDataARB(int target, DoubleBuffer data, int usage) {
        ARBVertexBufferObject.nglBufferDataARB(target, data.remaining() << 3, MemoryUtil.memAddress((DoubleBuffer)data), usage);
    }

    public static void nglBufferSubDataARB(int target, long offset, long size, long data) {
        long __functionAddress = GL.getCapabilities().glBufferSubDataARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)size, (long)data);
    }

    public static void glBufferSubDataARB(int target, long offset, ByteBuffer data) {
        ARBVertexBufferObject.nglBufferSubDataARB(target, offset, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static void glBufferSubDataARB(int target, long offset, ShortBuffer data) {
        ARBVertexBufferObject.nglBufferSubDataARB(target, offset, data.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)data));
    }

    public static void glBufferSubDataARB(int target, long offset, IntBuffer data) {
        ARBVertexBufferObject.nglBufferSubDataARB(target, offset, data.remaining() << 2, MemoryUtil.memAddress((IntBuffer)data));
    }

    public static void glBufferSubDataARB(int target, long offset, FloatBuffer data) {
        ARBVertexBufferObject.nglBufferSubDataARB(target, offset, data.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static void glBufferSubDataARB(int target, long offset, DoubleBuffer data) {
        ARBVertexBufferObject.nglBufferSubDataARB(target, offset, data.remaining() << 3, MemoryUtil.memAddress((DoubleBuffer)data));
    }

    public static void nglGetBufferSubDataARB(int target, long offset, long size, long data) {
        long __functionAddress = GL.getCapabilities().glGetBufferSubDataARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)size, (long)data);
    }

    public static void glGetBufferSubDataARB(int target, long offset, ByteBuffer data) {
        ARBVertexBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static void glGetBufferSubDataARB(int target, long offset, ShortBuffer data) {
        ARBVertexBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)data));
    }

    public static void glGetBufferSubDataARB(int target, long offset, IntBuffer data) {
        ARBVertexBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining() << 2, MemoryUtil.memAddress((IntBuffer)data));
    }

    public static void glGetBufferSubDataARB(int target, long offset, FloatBuffer data) {
        ARBVertexBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static void glGetBufferSubDataARB(int target, long offset, DoubleBuffer data) {
        ARBVertexBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining() << 3, MemoryUtil.memAddress((DoubleBuffer)data));
    }

    public static long nglMapBufferARB(int target, int access) {
        long __functionAddress = GL.getCapabilities().glMapBufferARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callP((long)__functionAddress, (int)target, (int)access);
    }

    public static ByteBuffer glMapBufferARB(int target, int access) {
        long __result = ARBVertexBufferObject.nglMapBufferARB(target, access);
        return MemoryUtil.memByteBuffer((long)__result, (int)ARBVertexBufferObject.glGetBufferParameteriARB(target, 34660));
    }

    public static ByteBuffer glMapBufferARB(int target, int access, ByteBuffer old_buffer) {
        long __result = ARBVertexBufferObject.nglMapBufferARB(target, access);
        int length = ARBVertexBufferObject.glGetBufferParameteriARB(target, 34660);
        return old_buffer == null ? MemoryUtil.memByteBuffer((long)__result, (int)length) : MemoryUtil.memSetupBuffer((ByteBuffer)old_buffer, (long)__result, (int)length);
    }

    public static ByteBuffer glMapBufferARB(int target, int access, long length, ByteBuffer old_buffer) {
        long __result = ARBVertexBufferObject.nglMapBufferARB(target, access);
        return old_buffer == null ? MemoryUtil.memByteBuffer((long)__result, (int)((int)length)) : MemoryUtil.memSetupBuffer((ByteBuffer)old_buffer, (long)__result, (int)((int)length));
    }

    public static boolean glUnmapBufferARB(int target) {
        long __functionAddress = GL.getCapabilities().glUnmapBufferARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress, (int)target);
    }

    public static void nglGetBufferParameterivARB(int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetBufferParameterivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (long)params);
    }

    public static void glGetBufferParameterivARB(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        ARBVertexBufferObject.nglGetBufferParameterivARB(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetBufferParameteriARB(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBVertexBufferObject.nglGetBufferParameterivARB(target, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetBufferPointervARB(int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetBufferPointervARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (long)params);
    }

    public static void glGetBufferPointervARB(int target, int pname, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((CustomBuffer)params, (int)1);
        }
        ARBVertexBufferObject.nglGetBufferPointervARB(target, pname, MemoryUtil.memAddress((CustomBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetBufferPointerARB(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer params = stack.callocPointer(1);
            ARBVertexBufferObject.nglGetBufferPointervARB(target, pname, MemoryUtil.memAddress((CustomBuffer)params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDeleteBuffersARB(int[] buffers) {
        long __functionAddress = GL.getCapabilities().glDeleteBuffersARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)buffers.length, (int[])buffers);
    }

    public static void glGenBuffersARB(int[] buffers) {
        long __functionAddress = GL.getCapabilities().glGenBuffersARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)buffers.length, (int[])buffers);
    }

    public static void glBufferDataARB(int target, short[] data, int usage) {
        long __functionAddress = GL.getCapabilities().glBufferDataARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)target, (long)(data.length << 1), (short[])data, (int)usage);
    }

    public static void glBufferDataARB(int target, int[] data, int usage) {
        long __functionAddress = GL.getCapabilities().glBufferDataARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)target, (long)(data.length << 2), (int[])data, (int)usage);
    }

    public static void glBufferDataARB(int target, float[] data, int usage) {
        long __functionAddress = GL.getCapabilities().glBufferDataARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)target, (long)(data.length << 2), (float[])data, (int)usage);
    }

    public static void glBufferDataARB(int target, double[] data, int usage) {
        long __functionAddress = GL.getCapabilities().glBufferDataARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)target, (long)(data.length << 3), (double[])data, (int)usage);
    }

    public static void glBufferSubDataARB(int target, long offset, short[] data) {
        long __functionAddress = GL.getCapabilities().glBufferSubDataARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 1), (short[])data);
    }

    public static void glBufferSubDataARB(int target, long offset, int[] data) {
        long __functionAddress = GL.getCapabilities().glBufferSubDataARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 2), (int[])data);
    }

    public static void glBufferSubDataARB(int target, long offset, float[] data) {
        long __functionAddress = GL.getCapabilities().glBufferSubDataARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 2), (float[])data);
    }

    public static void glBufferSubDataARB(int target, long offset, double[] data) {
        long __functionAddress = GL.getCapabilities().glBufferSubDataARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 3), (double[])data);
    }

    public static void glGetBufferSubDataARB(int target, long offset, short[] data) {
        long __functionAddress = GL.getCapabilities().glGetBufferSubDataARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 1), (short[])data);
    }

    public static void glGetBufferSubDataARB(int target, long offset, int[] data) {
        long __functionAddress = GL.getCapabilities().glGetBufferSubDataARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 2), (int[])data);
    }

    public static void glGetBufferSubDataARB(int target, long offset, float[] data) {
        long __functionAddress = GL.getCapabilities().glGetBufferSubDataARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 2), (float[])data);
    }

    public static void glGetBufferSubDataARB(int target, long offset, double[] data) {
        long __functionAddress = GL.getCapabilities().glGetBufferSubDataARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 3), (double[])data);
    }

    public static void glGetBufferParameterivARB(int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetBufferParameterivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (int[])params);
    }
}

