/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBVertexArrayObject {
    public static final int GL_VERTEX_ARRAY_BINDING = 34229;

    protected ARBVertexArrayObject() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glBindVertexArray, caps.glDeleteVertexArrays, caps.glGenVertexArrays, caps.glIsVertexArray});
    }

    public static void glBindVertexArray(int array) {
        long __functionAddress = GL.getCapabilities().glBindVertexArray;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)array);
    }

    public static void nglDeleteVertexArrays(int n, long arrays) {
        long __functionAddress = GL.getCapabilities().glDeleteVertexArrays;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)arrays);
    }

    public static void glDeleteVertexArrays(IntBuffer arrays) {
        ARBVertexArrayObject.nglDeleteVertexArrays(arrays.remaining(), MemoryUtil.memAddress((IntBuffer)arrays));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteVertexArrays(int array) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arrays = stack.ints(array);
            ARBVertexArrayObject.nglDeleteVertexArrays(1, MemoryUtil.memAddress((IntBuffer)arrays));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGenVertexArrays(int n, long arrays) {
        long __functionAddress = GL.getCapabilities().glGenVertexArrays;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)arrays);
    }

    public static void glGenVertexArrays(IntBuffer arrays) {
        ARBVertexArrayObject.nglGenVertexArrays(arrays.remaining(), MemoryUtil.memAddress((IntBuffer)arrays));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenVertexArrays() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arrays = stack.callocInt(1);
            ARBVertexArrayObject.nglGenVertexArrays(1, MemoryUtil.memAddress((IntBuffer)arrays));
            int n = arrays.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean glIsVertexArray(int array) {
        long __functionAddress = GL.getCapabilities().glIsVertexArray;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress, (int)array);
    }

    public static void glDeleteVertexArrays(int[] arrays) {
        long __functionAddress = GL.getCapabilities().glDeleteVertexArrays;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)arrays.length, (int[])arrays);
    }

    public static void glGenVertexArrays(int[] arrays) {
        long __functionAddress = GL.getCapabilities().glGenVertexArrays;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)arrays.length, (int[])arrays);
    }
}

