/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBUniformBufferObject {
    public static final int GL_UNIFORM_BUFFER = 35345;
    public static final int GL_UNIFORM_BUFFER_BINDING = 35368;
    public static final int GL_UNIFORM_BUFFER_START = 35369;
    public static final int GL_UNIFORM_BUFFER_SIZE = 35370;
    public static final int GL_MAX_VERTEX_UNIFORM_BLOCKS = 35371;
    public static final int GL_MAX_GEOMETRY_UNIFORM_BLOCKS = 35372;
    public static final int GL_MAX_FRAGMENT_UNIFORM_BLOCKS = 35373;
    public static final int GL_MAX_COMBINED_UNIFORM_BLOCKS = 35374;
    public static final int GL_MAX_UNIFORM_BUFFER_BINDINGS = 35375;
    public static final int GL_MAX_UNIFORM_BLOCK_SIZE = 35376;
    public static final int GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = 35377;
    public static final int GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = 35378;
    public static final int GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = 35379;
    public static final int GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = 35380;
    public static final int GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = 35381;
    public static final int GL_ACTIVE_UNIFORM_BLOCKS = 35382;
    public static final int GL_UNIFORM_TYPE = 35383;
    public static final int GL_UNIFORM_SIZE = 35384;
    public static final int GL_UNIFORM_NAME_LENGTH = 35385;
    public static final int GL_UNIFORM_BLOCK_INDEX = 35386;
    public static final int GL_UNIFORM_OFFSET = 35387;
    public static final int GL_UNIFORM_ARRAY_STRIDE = 35388;
    public static final int GL_UNIFORM_MATRIX_STRIDE = 35389;
    public static final int GL_UNIFORM_IS_ROW_MAJOR = 35390;
    public static final int GL_UNIFORM_BLOCK_BINDING = 35391;
    public static final int GL_UNIFORM_BLOCK_DATA_SIZE = 35392;
    public static final int GL_UNIFORM_BLOCK_NAME_LENGTH = 35393;
    public static final int GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = 35394;
    public static final int GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 35395;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 35396;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER = 35397;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 35398;
    public static final int GL_INVALID_INDEX = -1;

    protected ARBUniformBufferObject() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glGetUniformIndices, caps.glGetActiveUniformsiv, caps.glGetActiveUniformName, caps.glGetUniformBlockIndex, caps.glGetActiveUniformBlockiv, caps.glGetActiveUniformBlockName, caps.glBindBufferRange, caps.glBindBufferBase, caps.glGetIntegeri_v, caps.glUniformBlockBinding});
    }

    public static void nglGetUniformIndices(int program, int uniformCount, long uniformNames, long uniformIndices) {
        long __functionAddress = GL.getCapabilities().glGetUniformIndices;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)program, (int)uniformCount, (long)uniformNames, (long)uniformIndices);
    }

    public static void glGetUniformIndices(int program, PointerBuffer uniformNames, IntBuffer uniformIndices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformIndices, (int)uniformNames.remaining());
        }
        ARBUniformBufferObject.nglGetUniformIndices(program, uniformNames.remaining(), MemoryUtil.memAddress((CustomBuffer)uniformNames), MemoryUtil.memAddress((IntBuffer)uniformIndices));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glGetUniformIndices(int program, CharSequence[] uniformNames, IntBuffer uniformIndices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformIndices, (int)uniformNames.length);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long uniformNamesAddress = APIUtil.apiArray((MemoryStack)stack, MemoryUtil::memASCII, (CharSequence[])uniformNames);
            ARBUniformBufferObject.nglGetUniformIndices(program, uniformNames.length, uniformNamesAddress, MemoryUtil.memAddress((IntBuffer)uniformIndices));
            APIUtil.apiArrayFree((long)uniformNamesAddress, (int)uniformNames.length);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformIndices(int program, CharSequence uniformName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long uniformNamesAddress = APIUtil.apiArray((MemoryStack)stack, MemoryUtil::memASCII, (CharSequence[])new CharSequence[]{uniformName});
            IntBuffer uniformIndices = stack.callocInt(1);
            ARBUniformBufferObject.nglGetUniformIndices(program, 1, uniformNamesAddress, MemoryUtil.memAddress((IntBuffer)uniformIndices));
            APIUtil.apiArrayFree((long)uniformNamesAddress, (int)1);
            int n = uniformIndices.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveUniformsiv(int program, int uniformCount, long uniformIndices, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformsiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)program, (int)uniformCount, (long)uniformIndices, (int)pname, (long)params);
    }

    public static void glGetActiveUniformsiv(int program, IntBuffer uniformIndices, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)uniformIndices.remaining());
        }
        ARBUniformBufferObject.nglGetActiveUniformsiv(program, uniformIndices.remaining(), MemoryUtil.memAddress((IntBuffer)uniformIndices), pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetActiveUniformsi(int program, int uniformIndex, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            IntBuffer uniformIndices = stack.ints(uniformIndex);
            ARBUniformBufferObject.nglGetActiveUniformsiv(program, 1, MemoryUtil.memAddress((IntBuffer)uniformIndices), pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveUniformName(int program, int uniformIndex, int bufSize, long length, long uniformName) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)program, (int)uniformIndex, (int)bufSize, (long)length, (long)uniformName);
    }

    public static void glGetActiveUniformName(int program, int uniformIndex, IntBuffer length, ByteBuffer uniformName) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)length, (int)1);
        }
        ARBUniformBufferObject.nglGetActiveUniformName(program, uniformIndex, uniformName.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)uniformName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniformName(int program, int uniformIndex, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer uniformName = stack.malloc(bufSize);
            ARBUniformBufferObject.nglGetActiveUniformName(program, uniformIndex, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)uniformName));
            String string = MemoryUtil.memASCII((ByteBuffer)uniformName, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniformName(int program, int uniformIndex) {
        int bufSize = ARBUniformBufferObject.glGetActiveUniformsi(program, uniformIndex, 35385);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer uniformName = stack.malloc(bufSize);
            ARBUniformBufferObject.nglGetActiveUniformName(program, uniformIndex, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)uniformName));
            String string = MemoryUtil.memASCII((ByteBuffer)uniformName, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nglGetUniformBlockIndex(int program, long uniformBlockName) {
        long __functionAddress = GL.getCapabilities().glGetUniformBlockIndex;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callPI((long)__functionAddress, (int)program, (long)uniformBlockName);
    }

    public static int glGetUniformBlockIndex(int program, ByteBuffer uniformBlockName) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)uniformBlockName);
        }
        return ARBUniformBufferObject.nglGetUniformBlockIndex(program, MemoryUtil.memAddress((ByteBuffer)uniformBlockName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformBlockIndex(int program, CharSequence uniformBlockName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer uniformBlockNameEncoded = stack.ASCII(uniformBlockName);
            int n = ARBUniformBufferObject.nglGetUniformBlockIndex(program, MemoryUtil.memAddress((ByteBuffer)uniformBlockNameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformBlockiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)uniformBlockIndex, (int)pname, (long)params);
    }

    public static void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        ARBUniformBufferObject.nglGetActiveUniformBlockiv(program, uniformBlockIndex, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetActiveUniformBlocki(int program, int uniformBlockIndex, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBUniformBufferObject.nglGetActiveUniformBlockiv(program, uniformBlockIndex, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize, long length, long uniformBlockName) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformBlockName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)program, (int)uniformBlockIndex, (int)bufSize, (long)length, (long)uniformBlockName);
    }

    public static void glGetActiveUniformBlockName(int program, int uniformBlockIndex, IntBuffer length, ByteBuffer uniformBlockName) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)length, (int)1);
        }
        ARBUniformBufferObject.nglGetActiveUniformBlockName(program, uniformBlockIndex, uniformBlockName.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)uniformBlockName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer uniformBlockName = stack.malloc(bufSize);
            ARBUniformBufferObject.nglGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)uniformBlockName));
            String string = MemoryUtil.memASCII((ByteBuffer)uniformBlockName, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniformBlockName(int program, int uniformBlockIndex) {
        int bufSize = ARBUniformBufferObject.glGetActiveUniformBlocki(program, uniformBlockIndex, 35393);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer uniformBlockName = stack.malloc(bufSize);
            ARBUniformBufferObject.nglGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)uniformBlockName));
            String string = MemoryUtil.memASCII((ByteBuffer)uniformBlockName, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glBindBufferRange(int target, int index, int buffer, long offset, long size) {
        long __functionAddress = GL.getCapabilities().glBindBufferRange;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)target, (int)index, (int)buffer, (long)offset, (long)size);
    }

    public static void glBindBufferBase(int target, int index, int buffer) {
        long __functionAddress = GL.getCapabilities().glBindBufferBase;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)target, (int)index, (int)buffer);
    }

    public static void nglGetIntegeri_v(int target, int index, long data) {
        long __functionAddress = GL.getCapabilities().glGetIntegeri_v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)index, (long)data);
    }

    public static void glGetIntegeri_v(int target, int index, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)1);
        }
        ARBUniformBufferObject.nglGetIntegeri_v(target, index, MemoryUtil.memAddress((IntBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetIntegeri(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer data = stack.callocInt(1);
            ARBUniformBufferObject.nglGetIntegeri_v(target, index, MemoryUtil.memAddress((IntBuffer)data));
            int n = data.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glUniformBlockBinding(int program, int uniformBlockIndex, int uniformBlockBinding) {
        long __functionAddress = GL.getCapabilities().glUniformBlockBinding;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)uniformBlockIndex, (int)uniformBlockBinding);
    }

    public static void glGetUniformIndices(int program, PointerBuffer uniformNames, int[] uniformIndices) {
        long __functionAddress = GL.getCapabilities().glGetUniformIndices;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])uniformIndices, (int)uniformNames.remaining());
        }
        JNI.callPPV((long)__functionAddress, (int)program, (int)uniformNames.remaining(), (long)MemoryUtil.memAddress((CustomBuffer)uniformNames), (int[])uniformIndices);
    }

    public static void glGetActiveUniformsiv(int program, int[] uniformIndices, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformsiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)uniformIndices.length);
        }
        JNI.callPPV((long)__functionAddress, (int)program, (int)uniformIndices.length, (int[])uniformIndices, (int)pname, (int[])params);
    }

    public static void glGetActiveUniformName(int program, int uniformIndex, int[] length, ByteBuffer uniformName) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBufferSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)program, (int)uniformIndex, (int)uniformName.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)uniformName));
    }

    public static void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformBlockiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)uniformBlockIndex, (int)pname, (int[])params);
    }

    public static void glGetActiveUniformBlockName(int program, int uniformBlockIndex, int[] length, ByteBuffer uniformBlockName) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformBlockName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBufferSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)program, (int)uniformBlockIndex, (int)uniformBlockName.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)uniformBlockName));
    }

    public static void glGetIntegeri_v(int target, int index, int[] data) {
        long __functionAddress = GL.getCapabilities().glGetIntegeri_v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])data, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)index, (int[])data);
    }
}

