/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBSync {
    public static final int GL_MAX_SERVER_WAIT_TIMEOUT = 37137;
    public static final int GL_OBJECT_TYPE = 37138;
    public static final int GL_SYNC_CONDITION = 37139;
    public static final int GL_SYNC_STATUS = 37140;
    public static final int GL_SYNC_FLAGS = 37141;
    public static final int GL_SYNC_FENCE = 37142;
    public static final int GL_SYNC_GPU_COMMANDS_COMPLETE = 37143;
    public static final int GL_UNSIGNALED = 37144;
    public static final int GL_SIGNALED = 37145;
    public static final int GL_SYNC_FLUSH_COMMANDS_BIT = 1;
    public static final long GL_TIMEOUT_IGNORED = -1L;
    public static final int GL_ALREADY_SIGNALED = 37146;
    public static final int GL_TIMEOUT_EXPIRED = 37147;
    public static final int GL_CONDITION_SATISFIED = 37148;
    public static final int GL_WAIT_FAILED = 37149;

    protected ARBSync() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glFenceSync, caps.glIsSync, caps.glDeleteSync, caps.glClientWaitSync, caps.glWaitSync, caps.glGetInteger64v, caps.glGetSynciv});
    }

    public static long glFenceSync(int condition, int flags) {
        long __functionAddress = GL.getCapabilities().glFenceSync;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callP((long)__functionAddress, (int)condition, (int)flags);
    }

    public static boolean glIsSync(long sync) {
        long __functionAddress = GL.getCapabilities().glIsSync;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkPointer((long)sync);
        }
        return JNI.callPZ((long)__functionAddress, (long)sync);
    }

    public static void glDeleteSync(long sync) {
        long __functionAddress = GL.getCapabilities().glDeleteSync;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkPointer((long)sync);
        }
        JNI.callPV((long)__functionAddress, (long)sync);
    }

    public static int glClientWaitSync(long sync, int flags, long timeout) {
        long __functionAddress = GL.getCapabilities().glClientWaitSync;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkPointer((long)sync);
        }
        return JNI.callPJI((long)__functionAddress, (long)sync, (int)flags, (long)timeout);
    }

    public static void glWaitSync(long sync, int flags, long timeout) {
        long __functionAddress = GL.getCapabilities().glWaitSync;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkPointer((long)sync);
        }
        JNI.callPJV((long)__functionAddress, (long)sync, (int)flags, (long)timeout);
    }

    public static void nglGetInteger64v(int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetInteger64v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (long)params);
    }

    public static void glGetInteger64v(int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        ARBSync.nglGetInteger64v(pname, MemoryUtil.memAddress((LongBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetInteger64(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            ARBSync.nglGetInteger64v(pname, MemoryUtil.memAddress((LongBuffer)params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetSynciv(long sync, int pname, int bufSize, long length, long values) {
        long __functionAddress = GL.getCapabilities().glGetSynciv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkPointer((long)sync);
        }
        JNI.callPPPV((long)__functionAddress, (long)sync, (int)pname, (int)bufSize, (long)length, (long)values);
    }

    public static void glGetSynciv(long sync, int pname, IntBuffer length, IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)length, (int)1);
        }
        ARBSync.nglGetSynciv(sync, pname, values.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSynci(long sync, int pname, IntBuffer length) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)length, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer values = stack.callocInt(1);
            ARBSync.nglGetSynciv(sync, pname, 1, MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)values));
            int n = values.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGetInteger64v(int pname, long[] params) {
        long __functionAddress = GL.getCapabilities().glGetInteger64v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((long[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (long[])params);
    }

    public static void glGetSynciv(long sync, int pname, int[] length, int[] values) {
        long __functionAddress = GL.getCapabilities().glGetSynciv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkPointer((long)sync);
            Checks.checkBufferSafe((int[])length, (int)1);
        }
        JNI.callPPPV((long)__functionAddress, (long)sync, (int)pname, (int)values.length, (int[])length, (int[])values);
    }
}

