/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBSeparateShaderObjects {
    public static final int GL_VERTEX_SHADER_BIT = 1;
    public static final int GL_FRAGMENT_SHADER_BIT = 2;
    public static final int GL_GEOMETRY_SHADER_BIT = 4;
    public static final int GL_TESS_CONTROL_SHADER_BIT = 8;
    public static final int GL_TESS_EVALUATION_SHADER_BIT = 16;
    public static final int GL_ALL_SHADER_BITS = -1;
    public static final int GL_PROGRAM_SEPARABLE = 33368;
    public static final int GL_ACTIVE_PROGRAM = 33369;
    public static final int GL_PROGRAM_PIPELINE_BINDING = 33370;

    protected ARBSeparateShaderObjects() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glUseProgramStages, caps.glActiveShaderProgram, caps.glCreateShaderProgramv, caps.glBindProgramPipeline, caps.glDeleteProgramPipelines, caps.glGenProgramPipelines, caps.glIsProgramPipeline, caps.glProgramParameteri, caps.glGetProgramPipelineiv, caps.glProgramUniform1i, caps.glProgramUniform2i, caps.glProgramUniform3i, caps.glProgramUniform4i, caps.glProgramUniform1ui, caps.glProgramUniform2ui, caps.glProgramUniform3ui, caps.glProgramUniform4ui, caps.glProgramUniform1f, caps.glProgramUniform2f, caps.glProgramUniform3f, caps.glProgramUniform4f, caps.glProgramUniform1d, caps.glProgramUniform2d, caps.glProgramUniform3d, caps.glProgramUniform4d, caps.glProgramUniform1iv, caps.glProgramUniform2iv, caps.glProgramUniform3iv, caps.glProgramUniform4iv, caps.glProgramUniform1uiv, caps.glProgramUniform2uiv, caps.glProgramUniform3uiv, caps.glProgramUniform4uiv, caps.glProgramUniform1fv, caps.glProgramUniform2fv, caps.glProgramUniform3fv, caps.glProgramUniform4fv, caps.glProgramUniform1dv, caps.glProgramUniform2dv, caps.glProgramUniform3dv, caps.glProgramUniform4dv, caps.glProgramUniformMatrix2fv, caps.glProgramUniformMatrix3fv, caps.glProgramUniformMatrix4fv, caps.glProgramUniformMatrix2dv, caps.glProgramUniformMatrix3dv, caps.glProgramUniformMatrix4dv, caps.glProgramUniformMatrix2x3fv, caps.glProgramUniformMatrix3x2fv, caps.glProgramUniformMatrix2x4fv, caps.glProgramUniformMatrix4x2fv, caps.glProgramUniformMatrix3x4fv, caps.glProgramUniformMatrix4x3fv, caps.glProgramUniformMatrix2x3dv, caps.glProgramUniformMatrix3x2dv, caps.glProgramUniformMatrix2x4dv, caps.glProgramUniformMatrix4x2dv, caps.glProgramUniformMatrix3x4dv, caps.glProgramUniformMatrix4x3dv, caps.glValidateProgramPipeline, caps.glGetProgramPipelineInfoLog});
    }

    public static void glUseProgramStages(int pipeline, int stages, int program) {
        long __functionAddress = GL.getCapabilities().glUseProgramStages;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)pipeline, (int)stages, (int)program);
    }

    public static void glActiveShaderProgram(int pipeline, int program) {
        long __functionAddress = GL.getCapabilities().glActiveShaderProgram;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)pipeline, (int)program);
    }

    public static int nglCreateShaderProgramv(int type, int count, long strings) {
        long __functionAddress = GL.getCapabilities().glCreateShaderProgramv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callPI((long)__functionAddress, (int)type, (int)count, (long)strings);
    }

    public static int glCreateShaderProgramv(int type, PointerBuffer strings) {
        return ARBSeparateShaderObjects.nglCreateShaderProgramv(type, strings.remaining(), MemoryUtil.memAddress((CustomBuffer)strings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateShaderProgramv(int type, CharSequence ... strings) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringsAddress = APIUtil.apiArray((MemoryStack)stack, MemoryUtil::memUTF8, (CharSequence[])strings);
            int __result = ARBSeparateShaderObjects.nglCreateShaderProgramv(type, strings.length, stringsAddress);
            APIUtil.apiArrayFree((long)stringsAddress, (int)strings.length);
            int n = __result;
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateShaderProgramv(int type, CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringsAddress = APIUtil.apiArray((MemoryStack)stack, MemoryUtil::memUTF8, (CharSequence[])new CharSequence[]{string});
            int __result = ARBSeparateShaderObjects.nglCreateShaderProgramv(type, 1, stringsAddress);
            APIUtil.apiArrayFree((long)stringsAddress, (int)1);
            int n = __result;
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glBindProgramPipeline(int pipeline) {
        long __functionAddress = GL.getCapabilities().glBindProgramPipeline;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)pipeline);
    }

    public static void nglDeleteProgramPipelines(int n, long pipelines) {
        long __functionAddress = GL.getCapabilities().glDeleteProgramPipelines;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)pipelines);
    }

    public static void glDeleteProgramPipelines(IntBuffer pipelines) {
        ARBSeparateShaderObjects.nglDeleteProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress((IntBuffer)pipelines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteProgramPipelines(int pipeline) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer pipelines = stack.ints(pipeline);
            ARBSeparateShaderObjects.nglDeleteProgramPipelines(1, MemoryUtil.memAddress((IntBuffer)pipelines));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGenProgramPipelines(int n, long pipelines) {
        long __functionAddress = GL.getCapabilities().glGenProgramPipelines;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)pipelines);
    }

    public static void glGenProgramPipelines(IntBuffer pipelines) {
        ARBSeparateShaderObjects.nglGenProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress((IntBuffer)pipelines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenProgramPipelines() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer pipelines = stack.callocInt(1);
            ARBSeparateShaderObjects.nglGenProgramPipelines(1, MemoryUtil.memAddress((IntBuffer)pipelines));
            int n = pipelines.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean glIsProgramPipeline(int pipeline) {
        long __functionAddress = GL.getCapabilities().glIsProgramPipeline;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress, (int)pipeline);
    }

    public static void glProgramParameteri(int program, int pname, int value) {
        long __functionAddress = GL.getCapabilities().glProgramParameteri;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)pname, (int)value);
    }

    public static void nglGetProgramPipelineiv(int pipeline, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetProgramPipelineiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)pipeline, (int)pname, (long)params);
    }

    public static void glGetProgramPipelineiv(int pipeline, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        ARBSeparateShaderObjects.nglGetProgramPipelineiv(pipeline, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetProgramPipelinei(int pipeline, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBSeparateShaderObjects.nglGetProgramPipelineiv(pipeline, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glProgramUniform1i(int program, int location, int x) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (int)x);
    }

    public static void glProgramUniform2i(int program, int location, int x, int y) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (int)x, (int)y);
    }

    public static void glProgramUniform3i(int program, int location, int x, int y, int z) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (int)x, (int)y, (int)z);
    }

    public static void glProgramUniform4i(int program, int location, int x, int y, int z, int w) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (int)x, (int)y, (int)z, (int)w);
    }

    public static void glProgramUniform1ui(int program, int location, int x) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (int)x);
    }

    public static void glProgramUniform2ui(int program, int location, int x, int y) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (int)x, (int)y);
    }

    public static void glProgramUniform3ui(int program, int location, int x, int y, int z) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (int)x, (int)y, (int)z);
    }

    public static void glProgramUniform4ui(int program, int location, int x, int y, int z, int w) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (int)x, (int)y, (int)z, (int)w);
    }

    public static void glProgramUniform1f(int program, int location, float x) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (float)x);
    }

    public static void glProgramUniform2f(int program, int location, float x, float y) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (float)x, (float)y);
    }

    public static void glProgramUniform3f(int program, int location, float x, float y, float z) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (float)x, (float)y, (float)z);
    }

    public static void glProgramUniform4f(int program, int location, float x, float y, float z, float w) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (float)x, (float)y, (float)z, (float)w);
    }

    public static void glProgramUniform1d(int program, int location, double x) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (double)x);
    }

    public static void glProgramUniform2d(int program, int location, double x, double y) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (double)x, (double)y);
    }

    public static void glProgramUniform3d(int program, int location, double x, double y, double z) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (double)x, (double)y, (double)z);
    }

    public static void glProgramUniform4d(int program, int location, double x, double y, double z, double w) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (double)x, (double)y, (double)z, (double)w);
    }

    public static void nglProgramUniform1iv(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform1iv(int program, int location, IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform1iv(program, location, value.remaining(), MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void nglProgramUniform2iv(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform2iv(int program, int location, IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform2iv(program, location, value.remaining() >> 1, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void nglProgramUniform3iv(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform3iv(int program, int location, IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform3iv(program, location, value.remaining() / 3, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void nglProgramUniform4iv(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform4iv(int program, int location, IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform4iv(program, location, value.remaining() >> 2, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void nglProgramUniform1uiv(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform1uiv(int program, int location, IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform1uiv(program, location, value.remaining(), MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void nglProgramUniform2uiv(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform2uiv(int program, int location, IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform2uiv(program, location, value.remaining() >> 1, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void nglProgramUniform3uiv(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform3uiv(int program, int location, IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform3uiv(program, location, value.remaining() / 3, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void nglProgramUniform4uiv(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform4uiv(int program, int location, IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform4uiv(program, location, value.remaining() >> 2, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void nglProgramUniform1fv(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform1fv(int program, int location, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform1fv(program, location, value.remaining(), MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void nglProgramUniform2fv(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform2fv(int program, int location, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform2fv(program, location, value.remaining() >> 1, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void nglProgramUniform3fv(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform3fv(int program, int location, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform3fv(program, location, value.remaining() / 3, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void nglProgramUniform4fv(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform4fv(int program, int location, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform4fv(program, location, value.remaining() >> 2, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void nglProgramUniform1dv(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform1dv(int program, int location, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform1dv(program, location, value.remaining(), MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniform2dv(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform2dv(int program, int location, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform2dv(program, location, value.remaining() >> 1, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniform3dv(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform3dv(int program, int location, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform3dv(program, location, value.remaining() / 3, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniform4dv(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform4dv(int program, int location, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform4dv(program, location, value.remaining() >> 2, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix2fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix2fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2fv(program, location, value.remaining() >> 2, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void nglProgramUniformMatrix3fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix3fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3fv(program, location, value.remaining() / 9, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void nglProgramUniformMatrix4fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix4fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4fv(program, location, value.remaining() >> 4, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void nglProgramUniformMatrix2dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix2dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2dv(program, location, value.remaining() >> 2, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix3dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix3dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3dv(program, location, value.remaining() / 9, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix4dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix4dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4dv(program, location, value.remaining() >> 4, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix2x3fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2x3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix2x3fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2x3fv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void nglProgramUniformMatrix3x2fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3x2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix3x2fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3x2fv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void nglProgramUniformMatrix2x4fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2x4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix2x4fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2x4fv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void nglProgramUniformMatrix4x2fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4x2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix4x2fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4x2fv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void nglProgramUniformMatrix3x4fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3x4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix3x4fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3x4fv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void nglProgramUniformMatrix4x3fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4x3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix4x3fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4x3fv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void nglProgramUniformMatrix2x3dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2x3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix2x3dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2x3dv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix3x2dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3x2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix3x2dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3x2dv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix2x4dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2x4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix2x4dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2x4dv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix4x2dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4x2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix4x2dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4x2dv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix3x4dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3x4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix3x4dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3x4dv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix4x3dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4x3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix4x3dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4x3dv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void glValidateProgramPipeline(int pipeline) {
        long __functionAddress = GL.getCapabilities().glValidateProgramPipeline;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)pipeline);
    }

    public static void nglGetProgramPipelineInfoLog(int pipeline, int bufSize, long length, long infoLog) {
        long __functionAddress = GL.getCapabilities().glGetProgramPipelineInfoLog;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)pipeline, (int)bufSize, (long)length, (long)infoLog);
    }

    public static void glGetProgramPipelineInfoLog(int pipeline, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)length, (int)1);
        }
        ARBSeparateShaderObjects.nglGetProgramPipelineInfoLog(pipeline, infoLog.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetProgramPipelineInfoLog(int pipeline, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc((int)bufSize);
        try {
            IntBuffer length = stack.ints(0);
            ARBSeparateShaderObjects.nglGetProgramPipelineInfoLog(pipeline, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
            String string = MemoryUtil.memUTF8((ByteBuffer)infoLog, (int)length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree((Buffer)infoLog);
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetProgramPipelineInfoLog(int pipeline) {
        int bufSize = ARBSeparateShaderObjects.glGetProgramPipelinei(pipeline, 35716);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc((int)bufSize);
        try {
            IntBuffer length = stack.ints(0);
            ARBSeparateShaderObjects.nglGetProgramPipelineInfoLog(pipeline, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
            String string = MemoryUtil.memUTF8((ByteBuffer)infoLog, (int)length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree((Buffer)infoLog);
            stack.setPointer(stackPointer);
        }
    }

    public static void glDeleteProgramPipelines(int[] pipelines) {
        long __functionAddress = GL.getCapabilities().glDeleteProgramPipelines;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)pipelines.length, (int[])pipelines);
    }

    public static void glGenProgramPipelines(int[] pipelines) {
        long __functionAddress = GL.getCapabilities().glGenProgramPipelines;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)pipelines.length, (int[])pipelines);
    }

    public static void glGetProgramPipelineiv(int pipeline, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetProgramPipelineiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)pipeline, (int)pname, (int[])params);
    }

    public static void glProgramUniform1iv(int program, int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)value.length, (int[])value);
    }

    public static void glProgramUniform2iv(int program, int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 1), (int[])value);
    }

    public static void glProgramUniform3iv(int program, int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 3), (int[])value);
    }

    public static void glProgramUniform4iv(int program, int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 2), (int[])value);
    }

    public static void glProgramUniform1uiv(int program, int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)value.length, (int[])value);
    }

    public static void glProgramUniform2uiv(int program, int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 1), (int[])value);
    }

    public static void glProgramUniform3uiv(int program, int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 3), (int[])value);
    }

    public static void glProgramUniform4uiv(int program, int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 2), (int[])value);
    }

    public static void glProgramUniform1fv(int program, int location, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)value.length, (float[])value);
    }

    public static void glProgramUniform2fv(int program, int location, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 1), (float[])value);
    }

    public static void glProgramUniform3fv(int program, int location, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 3), (float[])value);
    }

    public static void glProgramUniform4fv(int program, int location, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 2), (float[])value);
    }

    public static void glProgramUniform1dv(int program, int location, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)value.length, (double[])value);
    }

    public static void glProgramUniform2dv(int program, int location, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 1), (double[])value);
    }

    public static void glProgramUniform3dv(int program, int location, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 3), (double[])value);
    }

    public static void glProgramUniform4dv(int program, int location, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 2), (double[])value);
    }

    public static void glProgramUniformMatrix2fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 2), (boolean)transpose, (float[])value);
    }

    public static void glProgramUniformMatrix3fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 9), (boolean)transpose, (float[])value);
    }

    public static void glProgramUniformMatrix4fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 4), (boolean)transpose, (float[])value);
    }

    public static void glProgramUniformMatrix2dv(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 2), (boolean)transpose, (double[])value);
    }

    public static void glProgramUniformMatrix3dv(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 9), (boolean)transpose, (double[])value);
    }

    public static void glProgramUniformMatrix4dv(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 4), (boolean)transpose, (double[])value);
    }

    public static void glProgramUniformMatrix2x3fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2x3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 6), (boolean)transpose, (float[])value);
    }

    public static void glProgramUniformMatrix3x2fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3x2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 6), (boolean)transpose, (float[])value);
    }

    public static void glProgramUniformMatrix2x4fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2x4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 3), (boolean)transpose, (float[])value);
    }

    public static void glProgramUniformMatrix4x2fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4x2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 3), (boolean)transpose, (float[])value);
    }

    public static void glProgramUniformMatrix3x4fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3x4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 12), (boolean)transpose, (float[])value);
    }

    public static void glProgramUniformMatrix4x3fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4x3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 12), (boolean)transpose, (float[])value);
    }

    public static void glProgramUniformMatrix2x3dv(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2x3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 6), (boolean)transpose, (double[])value);
    }

    public static void glProgramUniformMatrix3x2dv(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3x2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 6), (boolean)transpose, (double[])value);
    }

    public static void glProgramUniformMatrix2x4dv(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2x4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 3), (boolean)transpose, (double[])value);
    }

    public static void glProgramUniformMatrix4x2dv(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4x2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 3), (boolean)transpose, (double[])value);
    }

    public static void glProgramUniformMatrix3x4dv(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3x4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 12), (boolean)transpose, (double[])value);
    }

    public static void glProgramUniformMatrix4x3dv(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4x3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 12), (boolean)transpose, (double[])value);
    }

    public static void glGetProgramPipelineInfoLog(int pipeline, int[] length, ByteBuffer infoLog) {
        long __functionAddress = GL.getCapabilities().glGetProgramPipelineInfoLog;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBufferSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)pipeline, (int)infoLog.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)infoLog));
    }
}

