/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBGetProgramBinary {
    public static final int GL_PROGRAM_BINARY_RETRIEVABLE_HINT = 33367;
    public static final int GL_PROGRAM_BINARY_LENGTH = 34625;
    public static final int GL_NUM_PROGRAM_BINARY_FORMATS = 34814;
    public static final int GL_PROGRAM_BINARY_FORMATS = 34815;

    protected ARBGetProgramBinary() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glGetProgramBinary, caps.glProgramBinary, caps.glProgramParameteri});
    }

    public static void nglGetProgramBinary(int program, int bufSize, long length, long binaryFormat, long binary) {
        long __functionAddress = GL.getCapabilities().glGetProgramBinary;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)program, (int)bufSize, (long)length, (long)binaryFormat, (long)binary);
    }

    public static void glGetProgramBinary(int program, IntBuffer length, IntBuffer binaryFormat, ByteBuffer binary) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)length, (int)1);
            Checks.checkBuffer((Buffer)binaryFormat, (int)1);
        }
        ARBGetProgramBinary.nglGetProgramBinary(program, binary.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)binaryFormat), MemoryUtil.memAddress((ByteBuffer)binary));
    }

    public static void nglProgramBinary(int program, int binaryFormat, long binary, int length) {
        long __functionAddress = GL.getCapabilities().glProgramBinary;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)binaryFormat, (long)binary, (int)length);
    }

    public static void glProgramBinary(int program, int binaryFormat, ByteBuffer binary) {
        ARBGetProgramBinary.nglProgramBinary(program, binaryFormat, MemoryUtil.memAddress((ByteBuffer)binary), binary.remaining());
    }

    public static void glProgramParameteri(int program, int pname, int value) {
        long __functionAddress = GL.getCapabilities().glProgramParameteri;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)pname, (int)value);
    }

    public static void glGetProgramBinary(int program, int[] length, int[] binaryFormat, ByteBuffer binary) {
        long __functionAddress = GL.getCapabilities().glGetProgramBinary;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBufferSafe((int[])length, (int)1);
            Checks.checkBuffer((int[])binaryFormat, (int)1);
        }
        JNI.callPPPV((long)__functionAddress, (int)program, (int)binary.remaining(), (int[])length, (int[])binaryFormat, (long)MemoryUtil.memAddress((ByteBuffer)binary));
    }
}

