/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBGPUShaderFP64 {
    public static final int GL_DOUBLE_VEC2 = 36860;
    public static final int GL_DOUBLE_VEC3 = 36861;
    public static final int GL_DOUBLE_VEC4 = 36862;
    public static final int GL_DOUBLE_MAT2 = 36678;
    public static final int GL_DOUBLE_MAT3 = 36679;
    public static final int GL_DOUBLE_MAT4 = 36680;
    public static final int GL_DOUBLE_MAT2x3 = 36681;
    public static final int GL_DOUBLE_MAT2x4 = 36682;
    public static final int GL_DOUBLE_MAT3x2 = 36683;
    public static final int GL_DOUBLE_MAT3x4 = 36684;
    public static final int GL_DOUBLE_MAT4x2 = 36685;
    public static final int GL_DOUBLE_MAT4x3 = 36686;

    protected ARBGPUShaderFP64() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps, Set<String> ext) {
        return Checks.checkFunctions((long[])new long[]{caps.glUniform1d, caps.glUniform2d, caps.glUniform3d, caps.glUniform4d, caps.glUniform1dv, caps.glUniform2dv, caps.glUniform3dv, caps.glUniform4dv, caps.glUniformMatrix2dv, caps.glUniformMatrix3dv, caps.glUniformMatrix4dv, caps.glUniformMatrix2x3dv, caps.glUniformMatrix2x4dv, caps.glUniformMatrix3x2dv, caps.glUniformMatrix3x4dv, caps.glUniformMatrix4x2dv, caps.glUniformMatrix4x3dv, caps.glGetUniformdv});
    }

    public static void glUniform1d(int location, double x) {
        long __functionAddress = GL.getCapabilities().glUniform1d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)location, (double)x);
    }

    public static void glUniform2d(int location, double x, double y) {
        long __functionAddress = GL.getCapabilities().glUniform2d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)location, (double)x, (double)y);
    }

    public static void glUniform3d(int location, double x, double y, double z) {
        long __functionAddress = GL.getCapabilities().glUniform3d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)location, (double)x, (double)y, (double)z);
    }

    public static void glUniform4d(int location, double x, double y, double z, double w) {
        long __functionAddress = GL.getCapabilities().glUniform4d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)location, (double)x, (double)y, (double)z, (double)w);
    }

    public static void nglUniform1dv(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform1dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)count, (long)value);
    }

    public static void glUniform1dv(int location, DoubleBuffer value) {
        ARBGPUShaderFP64.nglUniform1dv(location, value.remaining(), MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglUniform2dv(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)count, (long)value);
    }

    public static void glUniform2dv(int location, DoubleBuffer value) {
        ARBGPUShaderFP64.nglUniform2dv(location, value.remaining() >> 1, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglUniform3dv(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)count, (long)value);
    }

    public static void glUniform3dv(int location, DoubleBuffer value) {
        ARBGPUShaderFP64.nglUniform3dv(location, value.remaining() / 3, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglUniform4dv(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)count, (long)value);
    }

    public static void glUniform4dv(int location, DoubleBuffer value) {
        ARBGPUShaderFP64.nglUniform4dv(location, value.remaining() >> 2, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglUniformMatrix2dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glUniformMatrix2dv(int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglUniformMatrix2dv(location, value.remaining() >> 2, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglUniformMatrix3dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glUniformMatrix3dv(int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglUniformMatrix3dv(location, value.remaining() / 9, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglUniformMatrix4dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glUniformMatrix4dv(int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglUniformMatrix4dv(location, value.remaining() >> 4, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglUniformMatrix2x3dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix2x3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glUniformMatrix2x3dv(int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglUniformMatrix2x3dv(location, value.remaining() / 6, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglUniformMatrix2x4dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix2x4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glUniformMatrix2x4dv(int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglUniformMatrix2x4dv(location, value.remaining() >> 3, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglUniformMatrix3x2dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix3x2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glUniformMatrix3x2dv(int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglUniformMatrix3x2dv(location, value.remaining() / 6, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglUniformMatrix3x4dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix3x4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glUniformMatrix3x4dv(int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglUniformMatrix3x4dv(location, value.remaining() / 12, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglUniformMatrix4x2dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix4x2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glUniformMatrix4x2dv(int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglUniformMatrix4x2dv(location, value.remaining() >> 3, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglUniformMatrix4x3dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix4x3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glUniformMatrix4x3dv(int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglUniformMatrix4x3dv(location, value.remaining() / 12, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglGetUniformdv(int program, int location, long params) {
        long __functionAddress = GL.getCapabilities().glGetUniformdv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (long)params);
    }

    public static void glGetUniformdv(int program, int location, DoubleBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, (int)1);
        }
        ARBGPUShaderFP64.nglGetUniformdv(program, location, MemoryUtil.memAddress((DoubleBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double glGetUniformd(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer params = stack.callocDouble(1);
            ARBGPUShaderFP64.nglGetUniformdv(program, location, MemoryUtil.memAddress((DoubleBuffer)params));
            double d = params.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glProgramUniform1dEXT(int program, int location, double x) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1dEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (double)x);
    }

    public static void glProgramUniform2dEXT(int program, int location, double x, double y) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2dEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (double)x, (double)y);
    }

    public static void glProgramUniform3dEXT(int program, int location, double x, double y, double z) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3dEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (double)x, (double)y, (double)z);
    }

    public static void glProgramUniform4dEXT(int program, int location, double x, double y, double z, double w) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4dEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)program, (int)location, (double)x, (double)y, (double)z, (double)w);
    }

    public static void nglProgramUniform1dvEXT(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform1dvEXT(int program, int location, DoubleBuffer value) {
        ARBGPUShaderFP64.nglProgramUniform1dvEXT(program, location, value.remaining(), MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniform2dvEXT(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform2dvEXT(int program, int location, DoubleBuffer value) {
        ARBGPUShaderFP64.nglProgramUniform2dvEXT(program, location, value.remaining() >> 1, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniform3dvEXT(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform3dvEXT(int program, int location, DoubleBuffer value) {
        ARBGPUShaderFP64.nglProgramUniform3dvEXT(program, location, value.remaining() / 3, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniform4dvEXT(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (long)value);
    }

    public static void glProgramUniform4dvEXT(int program, int location, DoubleBuffer value) {
        ARBGPUShaderFP64.nglProgramUniform4dvEXT(program, location, value.remaining() >> 2, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix2dvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix2dvEXT(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglProgramUniformMatrix2dvEXT(program, location, value.remaining() >> 2, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix3dvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix3dvEXT(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglProgramUniformMatrix3dvEXT(program, location, value.remaining() / 9, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix4dvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix4dvEXT(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglProgramUniformMatrix4dvEXT(program, location, value.remaining() >> 4, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix2x3dvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2x3dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix2x3dvEXT(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglProgramUniformMatrix2x3dvEXT(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix2x4dvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2x4dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix2x4dvEXT(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglProgramUniformMatrix2x4dvEXT(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix3x2dvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3x2dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix3x2dvEXT(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglProgramUniformMatrix3x2dvEXT(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix3x4dvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3x4dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix3x4dvEXT(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglProgramUniformMatrix3x4dvEXT(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix4x2dvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4x2dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix4x2dvEXT(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglProgramUniformMatrix4x2dvEXT(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nglProgramUniformMatrix4x3dvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4x3dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)count, (boolean)transpose, (long)value);
    }

    public static void glProgramUniformMatrix4x3dvEXT(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBGPUShaderFP64.nglProgramUniformMatrix4x3dvEXT(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void glUniform1dv(int location, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniform1dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)value.length, (double[])value);
    }

    public static void glUniform2dv(int location, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniform2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 1), (double[])value);
    }

    public static void glUniform3dv(int location, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniform3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length / 3), (double[])value);
    }

    public static void glUniform4dv(int location, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniform4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 2), (double[])value);
    }

    public static void glUniformMatrix2dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 2), (boolean)transpose, (double[])value);
    }

    public static void glUniformMatrix3dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length / 9), (boolean)transpose, (double[])value);
    }

    public static void glUniformMatrix4dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 4), (boolean)transpose, (double[])value);
    }

    public static void glUniformMatrix2x3dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix2x3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length / 6), (boolean)transpose, (double[])value);
    }

    public static void glUniformMatrix2x4dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix2x4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 3), (boolean)transpose, (double[])value);
    }

    public static void glUniformMatrix3x2dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix3x2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length / 6), (boolean)transpose, (double[])value);
    }

    public static void glUniformMatrix3x4dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix3x4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length / 12), (boolean)transpose, (double[])value);
    }

    public static void glUniformMatrix4x2dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix4x2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 3), (boolean)transpose, (double[])value);
    }

    public static void glUniformMatrix4x3dv(int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix4x3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length / 12), (boolean)transpose, (double[])value);
    }

    public static void glGetUniformdv(int program, int location, double[] params) {
        long __functionAddress = GL.getCapabilities().glGetUniformdv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((double[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (double[])params);
    }

    public static void glProgramUniform1dvEXT(int program, int location, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)value.length, (double[])value);
    }

    public static void glProgramUniform2dvEXT(int program, int location, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 1), (double[])value);
    }

    public static void glProgramUniform3dvEXT(int program, int location, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 3), (double[])value);
    }

    public static void glProgramUniform4dvEXT(int program, int location, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 2), (double[])value);
    }

    public static void glProgramUniformMatrix2dvEXT(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 2), (boolean)transpose, (double[])value);
    }

    public static void glProgramUniformMatrix3dvEXT(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 9), (boolean)transpose, (double[])value);
    }

    public static void glProgramUniformMatrix4dvEXT(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 4), (boolean)transpose, (double[])value);
    }

    public static void glProgramUniformMatrix2x3dvEXT(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2x3dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 6), (boolean)transpose, (double[])value);
    }

    public static void glProgramUniformMatrix2x4dvEXT(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2x4dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 3), (boolean)transpose, (double[])value);
    }

    public static void glProgramUniformMatrix3x2dvEXT(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3x2dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 6), (boolean)transpose, (double[])value);
    }

    public static void glProgramUniformMatrix3x4dvEXT(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3x4dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 12), (boolean)transpose, (double[])value);
    }

    public static void glProgramUniformMatrix4x2dvEXT(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4x2dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 3), (boolean)transpose, (double[])value);
    }

    public static void glProgramUniformMatrix4x3dvEXT(int program, int location, boolean transpose, double[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4x3dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 12), (boolean)transpose, (double[])value);
    }
}

