/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBES2Compatibility {
    public static final int GL_SHADER_COMPILER = 36346;
    public static final int GL_SHADER_BINARY_FORMATS = 36344;
    public static final int GL_NUM_SHADER_BINARY_FORMATS = 36345;
    public static final int GL_MAX_VERTEX_UNIFORM_VECTORS = 36347;
    public static final int GL_MAX_VARYING_VECTORS = 36348;
    public static final int GL_MAX_FRAGMENT_UNIFORM_VECTORS = 36349;
    public static final int GL_IMPLEMENTATION_COLOR_READ_TYPE = 35738;
    public static final int GL_IMPLEMENTATION_COLOR_READ_FORMAT = 35739;
    public static final int GL_FIXED = 5132;
    public static final int GL_LOW_FLOAT = 36336;
    public static final int GL_MEDIUM_FLOAT = 36337;
    public static final int GL_HIGH_FLOAT = 36338;
    public static final int GL_LOW_INT = 36339;
    public static final int GL_MEDIUM_INT = 36340;
    public static final int GL_HIGH_INT = 36341;
    public static final int GL_RGB565 = 36194;

    protected ARBES2Compatibility() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glReleaseShaderCompiler, caps.glShaderBinary, caps.glGetShaderPrecisionFormat, caps.glDepthRangef, caps.glClearDepthf});
    }

    public static void glReleaseShaderCompiler() {
        long __functionAddress = GL.getCapabilities().glReleaseShaderCompiler;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static void nglShaderBinary(int count, long shaders, int binaryformat, long binary, int length) {
        long __functionAddress = GL.getCapabilities().glShaderBinary;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)count, (long)shaders, (int)binaryformat, (long)binary, (int)length);
    }

    public static void glShaderBinary(IntBuffer shaders, int binaryformat, ByteBuffer binary) {
        ARBES2Compatibility.nglShaderBinary(shaders.remaining(), MemoryUtil.memAddress((IntBuffer)shaders), binaryformat, MemoryUtil.memAddress((ByteBuffer)binary), binary.remaining());
    }

    public static void nglGetShaderPrecisionFormat(int shadertype, int precisiontype, long range, long precision) {
        long __functionAddress = GL.getCapabilities().glGetShaderPrecisionFormat;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)shadertype, (int)precisiontype, (long)range, (long)precision);
    }

    public static void glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)range, (int)2);
            Checks.checkBuffer((Buffer)precision, (int)1);
        }
        ARBES2Compatibility.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress((IntBuffer)range), MemoryUtil.memAddress((IntBuffer)precision));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)range, (int)2);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer precision = stack.callocInt(1);
            ARBES2Compatibility.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress((IntBuffer)range), MemoryUtil.memAddress((IntBuffer)precision));
            int n = precision.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDepthRangef(float zNear, float zFar) {
        long __functionAddress = GL.getCapabilities().glDepthRangef;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)zNear, (float)zFar);
    }

    public static void glClearDepthf(float depth) {
        long __functionAddress = GL.getCapabilities().glClearDepthf;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (float)depth);
    }

    public static void glShaderBinary(int[] shaders, int binaryformat, ByteBuffer binary) {
        long __functionAddress = GL.getCapabilities().glShaderBinary;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)shaders.length, (int[])shaders, (int)binaryformat, (long)MemoryUtil.memAddress((ByteBuffer)binary), (int)binary.remaining());
    }

    public static void glGetShaderPrecisionFormat(int shadertype, int precisiontype, int[] range, int[] precision) {
        long __functionAddress = GL.getCapabilities().glGetShaderPrecisionFormat;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])range, (int)2);
            Checks.checkBuffer((int[])precision, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)shadertype, (int)precisiontype, (int[])range, (int[])precision);
    }
}

