/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class ARBDebugOutput {
    public static final int GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB = 33346;
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH_ARB = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES_ARB = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES_ARB = 37189;
    public static final int GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB = 33347;
    public static final int GL_DEBUG_CALLBACK_FUNCTION_ARB = 33348;
    public static final int GL_DEBUG_CALLBACK_USER_PARAM_ARB = 33349;
    public static final int GL_DEBUG_SOURCE_API_ARB = 33350;
    public static final int GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB = 33351;
    public static final int GL_DEBUG_SOURCE_SHADER_COMPILER_ARB = 33352;
    public static final int GL_DEBUG_SOURCE_THIRD_PARTY_ARB = 33353;
    public static final int GL_DEBUG_SOURCE_APPLICATION_ARB = 33354;
    public static final int GL_DEBUG_SOURCE_OTHER_ARB = 33355;
    public static final int GL_DEBUG_TYPE_ERROR_ARB = 33356;
    public static final int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB = 33357;
    public static final int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB = 33358;
    public static final int GL_DEBUG_TYPE_PORTABILITY_ARB = 33359;
    public static final int GL_DEBUG_TYPE_PERFORMANCE_ARB = 33360;
    public static final int GL_DEBUG_TYPE_OTHER_ARB = 33361;
    public static final int GL_DEBUG_SEVERITY_HIGH_ARB = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM_ARB = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW_ARB = 37192;

    protected ARBDebugOutput() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glDebugMessageControlARB, caps.glDebugMessageInsertARB, caps.glDebugMessageCallbackARB, caps.glGetDebugMessageLogARB});
    }

    public static void nglDebugMessageControlARB(int source, int type, int severity, int count, long ids, boolean enabled) {
        long __functionAddress = GL.getCapabilities().glDebugMessageControlARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)source, (int)type, (int)severity, (int)count, (long)ids, (boolean)enabled);
    }

    public static void glDebugMessageControlARB(int source, int type, int severity, IntBuffer ids, boolean enabled) {
        ARBDebugOutput.nglDebugMessageControlARB(source, type, severity, Checks.remainingSafe((Buffer)ids), MemoryUtil.memAddressSafe((IntBuffer)ids), enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageControlARB(int source, int type, int severity, int id, boolean enabled) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.ints(id);
            ARBDebugOutput.nglDebugMessageControlARB(source, type, severity, 1, MemoryUtil.memAddress((IntBuffer)ids), enabled);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDebugMessageInsertARB(int source, int type, int id, int severity, int length, long buf) {
        long __functionAddress = GL.getCapabilities().glDebugMessageInsertARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)source, (int)type, (int)id, (int)severity, (int)length, (long)buf);
    }

    public static void glDebugMessageInsertARB(int source, int type, int id, int severity, ByteBuffer buf) {
        ARBDebugOutput.nglDebugMessageInsertARB(source, type, id, severity, buf.remaining(), MemoryUtil.memAddress((ByteBuffer)buf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageInsertARB(int source, int type, int id, int severity, CharSequence buf) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer bufEncoded = stack.UTF8(buf, false);
            int bufEncodedLen = bufEncoded.capacity();
            ARBDebugOutput.nglDebugMessageInsertARB(source, type, id, severity, bufEncodedLen, MemoryUtil.memAddress((ByteBuffer)bufEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDebugMessageCallbackARB(long callback, long userParam) {
        long __functionAddress = GL.getCapabilities().glDebugMessageCallbackARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (long)callback, (long)userParam);
    }

    public static void glDebugMessageCallbackARB(GLDebugMessageARBCallbackI callback, long userParam) {
        ARBDebugOutput.nglDebugMessageCallbackARB(MemoryUtil.memAddressSafe((Pointer)callback), userParam);
    }

    public static int nglGetDebugMessageLogARB(int count, int bufSize, long sources, long types, long ids, long severities, long lengths, long messageLog) {
        long __functionAddress = GL.getCapabilities().glGetDebugMessageLogARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.callPPPPPPI((long)__functionAddress, (int)count, (int)bufSize, (long)sources, (long)types, (long)ids, (long)severities, (long)lengths, (long)messageLog);
    }

    public static int glGetDebugMessageLogARB(int count, IntBuffer sources, IntBuffer types, IntBuffer ids, IntBuffer severities, IntBuffer lengths, ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)sources, (int)count);
            Checks.checkBufferSafe((Buffer)types, (int)count);
            Checks.checkBufferSafe((Buffer)ids, (int)count);
            Checks.checkBufferSafe((Buffer)severities, (int)count);
            Checks.checkBufferSafe((Buffer)lengths, (int)count);
        }
        return ARBDebugOutput.nglGetDebugMessageLogARB(count, Checks.remainingSafe((Buffer)messageLog), MemoryUtil.memAddressSafe((IntBuffer)sources), MemoryUtil.memAddressSafe((IntBuffer)types), MemoryUtil.memAddressSafe((IntBuffer)ids), MemoryUtil.memAddressSafe((IntBuffer)severities), MemoryUtil.memAddressSafe((IntBuffer)lengths), MemoryUtil.memAddressSafe((ByteBuffer)messageLog));
    }

    public static void glDebugMessageControlARB(int source, int type, int severity, int[] ids, boolean enabled) {
        long __functionAddress = GL.getCapabilities().glDebugMessageControlARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)source, (int)type, (int)severity, (int)Checks.lengthSafe((int[])ids), (int[])ids, (boolean)enabled);
    }

    public static int glGetDebugMessageLogARB(int count, int[] sources, int[] types, int[] ids, int[] severities, int[] lengths, ByteBuffer messageLog) {
        long __functionAddress = GL.getCapabilities().glGetDebugMessageLogARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBufferSafe((int[])sources, (int)count);
            Checks.checkBufferSafe((int[])types, (int)count);
            Checks.checkBufferSafe((int[])ids, (int)count);
            Checks.checkBufferSafe((int[])severities, (int)count);
            Checks.checkBufferSafe((int[])lengths, (int)count);
        }
        return JNI.callPPPPPPI((long)__functionAddress, (int)count, (int)Checks.remainingSafe((Buffer)messageLog), (int[])sources, (int[])types, (int[])ids, (int[])severities, (int[])lengths, (long)MemoryUtil.memAddressSafe((ByteBuffer)messageLog));
    }
}

