/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class AMDPerformanceMonitor {
    public static final int GL_COUNTER_TYPE_AMD = 35776;
    public static final int GL_COUNTER_RANGE_AMD = 35777;
    public static final int GL_UNSIGNED_INT64_AMD = 35778;
    public static final int GL_PERCENTAGE_AMD = 35779;
    public static final int GL_PERFMON_RESULT_AVAILABLE_AMD = 35780;
    public static final int GL_PERFMON_RESULT_SIZE_AMD = 35781;
    public static final int GL_PERFMON_RESULT_AMD = 35782;

    protected AMDPerformanceMonitor() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glGetPerfMonitorGroupsAMD, caps.glGetPerfMonitorCountersAMD, caps.glGetPerfMonitorGroupStringAMD, caps.glGetPerfMonitorCounterStringAMD, caps.glGetPerfMonitorCounterInfoAMD, caps.glGenPerfMonitorsAMD, caps.glDeletePerfMonitorsAMD, caps.glSelectPerfMonitorCountersAMD, caps.glBeginPerfMonitorAMD, caps.glEndPerfMonitorAMD, caps.glGetPerfMonitorCounterDataAMD});
    }

    public static void nglGetPerfMonitorGroupsAMD(long numGroups, int groupsSize, long groups) {
        long __functionAddress = GL.getCapabilities().glGetPerfMonitorGroupsAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (long)numGroups, (int)groupsSize, (long)groups);
    }

    public static void glGetPerfMonitorGroupsAMD(IntBuffer numGroups, IntBuffer groups) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)numGroups, (int)1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorGroupsAMD(MemoryUtil.memAddressSafe((IntBuffer)numGroups), Checks.remainingSafe((Buffer)groups), MemoryUtil.memAddressSafe((IntBuffer)groups));
    }

    public static void nglGetPerfMonitorCountersAMD(int group, long numCounters, long maxActiveCounters, int counterSize, long counters) {
        long __functionAddress = GL.getCapabilities().glGetPerfMonitorCountersAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)group, (long)numCounters, (long)maxActiveCounters, (int)counterSize, (long)counters);
    }

    public static void glGetPerfMonitorCountersAMD(int group, IntBuffer numCounters, IntBuffer maxActiveCounters, IntBuffer counters) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)numCounters, (int)1);
            Checks.checkBuffer((Buffer)maxActiveCounters, (int)1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCountersAMD(group, MemoryUtil.memAddress((IntBuffer)numCounters), MemoryUtil.memAddress((IntBuffer)maxActiveCounters), counters.remaining(), MemoryUtil.memAddress((IntBuffer)counters));
    }

    public static void nglGetPerfMonitorGroupStringAMD(int group, int bufSize, long length, long groupString) {
        long __functionAddress = GL.getCapabilities().glGetPerfMonitorGroupStringAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)group, (int)bufSize, (long)length, (long)groupString);
    }

    public static void glGetPerfMonitorGroupStringAMD(int group, IntBuffer length, ByteBuffer groupString) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)length, (int)1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorGroupStringAMD(group, groupString.remaining(), MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)groupString));
    }

    public static void nglGetPerfMonitorCounterStringAMD(int group, int counter, int bufSize, long length, long counterString) {
        long __functionAddress = GL.getCapabilities().glGetPerfMonitorCounterStringAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)group, (int)counter, (int)bufSize, (long)length, (long)counterString);
    }

    public static void glGetPerfMonitorCounterStringAMD(int group, int counter, IntBuffer length, ByteBuffer counterString) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)length, (int)1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterStringAMD(group, counter, Checks.remainingSafe((Buffer)counterString), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddressSafe((ByteBuffer)counterString));
    }

    public static void nglGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, long data) {
        long __functionAddress = GL.getCapabilities().glGetPerfMonitorCounterInfoAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)group, (int)counter, (int)pname, (long)data);
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)4);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterInfoAMD(group, counter, pname, MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterInfoAMD(group, counter, pname, MemoryUtil.memAddress((IntBuffer)data));
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, (int)1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterInfoAMD(group, counter, pname, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static void nglGenPerfMonitorsAMD(int n, long monitors) {
        long __functionAddress = GL.getCapabilities().glGenPerfMonitorsAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)monitors);
    }

    public static void glGenPerfMonitorsAMD(IntBuffer monitors) {
        AMDPerformanceMonitor.nglGenPerfMonitorsAMD(monitors.remaining(), MemoryUtil.memAddress((IntBuffer)monitors));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenPerfMonitorsAMD() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer monitors = stack.callocInt(1);
            AMDPerformanceMonitor.nglGenPerfMonitorsAMD(1, MemoryUtil.memAddress((IntBuffer)monitors));
            int n = monitors.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDeletePerfMonitorsAMD(int n, long monitors) {
        long __functionAddress = GL.getCapabilities().glDeletePerfMonitorsAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)n, (long)monitors);
    }

    public static void glDeletePerfMonitorsAMD(IntBuffer monitors) {
        AMDPerformanceMonitor.nglDeletePerfMonitorsAMD(monitors.remaining(), MemoryUtil.memAddress((IntBuffer)monitors));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeletePerfMonitorsAMD(int monitor) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer monitors = stack.ints(monitor);
            AMDPerformanceMonitor.nglDeletePerfMonitorsAMD(1, MemoryUtil.memAddress((IntBuffer)monitors));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglSelectPerfMonitorCountersAMD(int monitor, boolean enable, int group, int numCounters, long counterList) {
        long __functionAddress = GL.getCapabilities().glSelectPerfMonitorCountersAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)monitor, (boolean)enable, (int)group, (int)numCounters, (long)counterList);
    }

    public static void glSelectPerfMonitorCountersAMD(int monitor, boolean enable, int group, IntBuffer counterList) {
        AMDPerformanceMonitor.nglSelectPerfMonitorCountersAMD(monitor, enable, group, counterList.remaining(), MemoryUtil.memAddress((IntBuffer)counterList));
    }

    public static void glBeginPerfMonitorAMD(int monitor) {
        long __functionAddress = GL.getCapabilities().glBeginPerfMonitorAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)monitor);
    }

    public static void glEndPerfMonitorAMD(int monitor) {
        long __functionAddress = GL.getCapabilities().glEndPerfMonitorAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress, (int)monitor);
    }

    public static void nglGetPerfMonitorCounterDataAMD(int monitor, int pname, int dataSize, long data, long bytesWritten) {
        long __functionAddress = GL.getCapabilities().glGetPerfMonitorCounterDataAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)monitor, (int)pname, (int)dataSize, (long)data, (long)bytesWritten);
    }

    public static void glGetPerfMonitorCounterDataAMD(int monitor, int pname, IntBuffer data, IntBuffer bytesWritten) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)bytesWritten, (int)1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterDataAMD(monitor, pname, data.remaining(), MemoryUtil.memAddress((IntBuffer)data), MemoryUtil.memAddressSafe((IntBuffer)bytesWritten));
    }

    public static void glGetPerfMonitorGroupsAMD(int[] numGroups, int[] groups) {
        long __functionAddress = GL.getCapabilities().glGetPerfMonitorGroupsAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBufferSafe((int[])numGroups, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int[])numGroups, (int)Checks.lengthSafe((int[])groups), (int[])groups);
    }

    public static void glGetPerfMonitorCountersAMD(int group, int[] numCounters, int[] maxActiveCounters, int[] counters) {
        long __functionAddress = GL.getCapabilities().glGetPerfMonitorCountersAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])numCounters, (int)1);
            Checks.checkBuffer((int[])maxActiveCounters, (int)1);
        }
        JNI.callPPPV((long)__functionAddress, (int)group, (int[])numCounters, (int[])maxActiveCounters, (int)counters.length, (int[])counters);
    }

    public static void glGetPerfMonitorGroupStringAMD(int group, int[] length, ByteBuffer groupString) {
        long __functionAddress = GL.getCapabilities().glGetPerfMonitorGroupStringAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)group, (int)groupString.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)groupString));
    }

    public static void glGetPerfMonitorCounterStringAMD(int group, int counter, int[] length, ByteBuffer counterString) {
        long __functionAddress = GL.getCapabilities().glGetPerfMonitorCounterStringAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBufferSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)group, (int)counter, (int)Checks.remainingSafe((Buffer)counterString), (int[])length, (long)MemoryUtil.memAddressSafe((ByteBuffer)counterString));
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, int[] data) {
        long __functionAddress = GL.getCapabilities().glGetPerfMonitorCounterInfoAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((int[])data, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)group, (int)counter, (int)pname, (int[])data);
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, float[] data) {
        long __functionAddress = GL.getCapabilities().glGetPerfMonitorCounterInfoAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBuffer((float[])data, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)group, (int)counter, (int)pname, (float[])data);
    }

    public static void glGenPerfMonitorsAMD(int[] monitors) {
        long __functionAddress = GL.getCapabilities().glGenPerfMonitorsAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)monitors.length, (int[])monitors);
    }

    public static void glDeletePerfMonitorsAMD(int[] monitors) {
        long __functionAddress = GL.getCapabilities().glDeletePerfMonitorsAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)monitors.length, (int[])monitors);
    }

    public static void glSelectPerfMonitorCountersAMD(int monitor, boolean enable, int group, int[] counterList) {
        long __functionAddress = GL.getCapabilities().glSelectPerfMonitorCountersAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)monitor, (boolean)enable, (int)group, (int)counterList.length, (int[])counterList);
    }

    public static void glGetPerfMonitorCounterDataAMD(int monitor, int pname, int[] data, int[] bytesWritten) {
        long __functionAddress = GL.getCapabilities().glGetPerfMonitorCounterDataAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkBufferSafe((int[])bytesWritten, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)monitor, (int)pname, (int)data.length, (int[])data, (int[])bytesWritten);
    }
}

