/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.shaded.org.cactoos.scalar;

import java.util.Comparator;
import java.util.Map;
import org.cactoos.Fallback;
import org.cactoos.Scalar;
import org.llorllale.cactoos.shaded.org.cactoos.iterable.IterableOf;
import org.llorllale.cactoos.shaded.org.cactoos.iterator.Filtered;
import org.llorllale.cactoos.shaded.org.cactoos.iterator.Sorted;
import org.llorllale.cactoos.shaded.org.cactoos.map.MapOf;
import org.llorllale.cactoos.shaded.org.cactoos.scalar.Equals;
import org.llorllale.cactoos.shaded.org.cactoos.scalar.Not;

public final class ScalarWithFallback<T>
implements Scalar<T> {
    private final Scalar<T> origin;
    private final Iterable<Fallback<T>> fallbacks;

    @SafeVarargs
    public ScalarWithFallback(Scalar<T> origin, Fallback<T> ... fbks) {
        this(origin, new IterableOf<Fallback<T>>(fbks));
    }

    public ScalarWithFallback(Scalar<T> origin, Iterable<Fallback<T>> fbks) {
        this.origin = origin;
        this.fallbacks = fbks;
    }

    @Override
    public T value() throws Exception {
        T result;
        try {
            result = this.origin.value();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            result = this.fallback(ex);
        }
        catch (Throwable ex) {
            result = this.fallback(ex);
        }
        return result;
    }

    private T fallback(Throwable exp) throws Exception {
        Sorted candidates = new Sorted(Comparator.comparing(Map.Entry::getValue), new Filtered(entry -> new Not(new Equals<Integer>(entry::getValue, () -> Integer.MIN_VALUE)).value(), new MapOf<Fallback, Integer>(fbk -> fbk, fbk -> fbk.support(exp), this.fallbacks).entrySet().iterator()));
        if (candidates.hasNext()) {
            return (T)((Fallback)candidates.next().getKey()).apply(exp);
        }
        throw new Exception("No fallback found - throw the original exception", exp);
    }
}

