/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.shaded.org.cactoos.scalar;

import org.cactoos.Func;
import org.cactoos.Scalar;
import org.llorllale.cactoos.shaded.org.cactoos.func.UncheckedFunc;
import org.llorllale.cactoos.shaded.org.cactoos.scalar.InheritanceLevel;
import org.llorllale.cactoos.shaded.org.cactoos.text.FormattedText;
import org.llorllale.cactoos.shaded.org.cactoos.text.UncheckedText;

public final class Checked<T, E extends Exception>
implements Scalar<T> {
    private final Func<Exception, E> func;
    private final Scalar<T> origin;

    public Checked(Scalar<T> scalar, Func<Exception, E> fnc) {
        this.func = fnc;
        this.origin = scalar;
    }

    @Override
    public T value() throws E {
        try {
            return this.origin.value();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw this.wrappedException(ex);
        }
        catch (Exception ex) {
            throw this.wrappedException(ex);
        }
    }

    private E wrappedException(Exception exp) {
        Exception wrapped = (Exception)new UncheckedFunc<Exception, E>(this.func).apply(exp);
        int level = new InheritanceLevel(exp.getClass(), wrapped.getClass()).value();
        String message = wrapped.getMessage().replaceFirst(new UncheckedText(new FormattedText("%s: ", exp.getClass().getName())).asString(), "");
        if (level >= 0 && message.equals(exp.getMessage())) {
            wrapped = exp;
        }
        return (E)wrapped;
    }
}

