/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.matchers;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public final class Assertion<T> {
    private final String msg;
    private final T test;
    private final Matcher<T> matcher;

    public Assertion(String msg, T test, Matcher<T> matcher) {
        this.msg = msg;
        this.test = test;
        this.matcher = matcher;
    }

    public void affirm() throws AssertionError {
        if (!this.matcher.matches(this.test)) {
            StringDescription text = new StringDescription();
            text.appendText(this.msg).appendText(String.format("%nExpected: ", new Object[0])).appendDescriptionOf(this.matcher).appendText(String.format("%n but was: ", new Object[0]));
            this.matcher.describeMismatch(this.test, (Description)text);
            throw new AssertionError((Object)text.toString());
        }
    }
}

