/*
 * Copyright (C) 2016/2022 Litote
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.litote.kmongo.id

import org.bson.types.ObjectId
import org.litote.kmongo.Id

/**
 * An [Id] containing a [ObjectId].
 */
data class WrappedObjectId<T>(val id: ObjectId) : Id<T> {

    constructor(id: String) : this(ObjectId(id))

    override fun toString(): String {
        return id.toString()
    }
}