/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.suite.commons;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.suite.api.ConfigurationParameter;
import org.junit.platform.suite.api.ExcludeClassNamePatterns;
import org.junit.platform.suite.api.ExcludeEngines;
import org.junit.platform.suite.api.ExcludePackages;
import org.junit.platform.suite.api.ExcludeTags;
import org.junit.platform.suite.api.IncludeClassNamePatterns;
import org.junit.platform.suite.api.IncludeEngines;
import org.junit.platform.suite.api.IncludePackages;
import org.junit.platform.suite.api.IncludeTags;
import org.junit.platform.suite.api.SelectClasses;
import org.junit.platform.suite.api.SelectClasspathResource;
import org.junit.platform.suite.api.SelectDirectories;
import org.junit.platform.suite.api.SelectFile;
import org.junit.platform.suite.api.SelectModules;
import org.junit.platform.suite.api.SelectPackages;
import org.junit.platform.suite.api.SelectUris;
import org.junit.platform.suite.commons.AdditionalDiscoverySelectors;

@API(status=API.Status.INTERNAL, since="1.8", consumers={"org.junit.platform.suite.engine", "org.junit.platform.runner"})
public final class SuiteLauncherDiscoveryRequestBuilder {
    private final LauncherDiscoveryRequestBuilder delegate = LauncherDiscoveryRequestBuilder.request();
    private boolean includeClassNamePatternsUsed;
    private boolean filterStandardClassNamePatterns = false;

    private SuiteLauncherDiscoveryRequestBuilder() {
    }

    public static SuiteLauncherDiscoveryRequestBuilder request() {
        return new SuiteLauncherDiscoveryRequestBuilder();
    }

    public SuiteLauncherDiscoveryRequestBuilder filterStandardClassNamePatterns(boolean filterStandardClassNamePatterns) {
        this.filterStandardClassNamePatterns = filterStandardClassNamePatterns;
        return this;
    }

    public LauncherDiscoveryRequestBuilder selectors(DiscoverySelector ... selectors) {
        return this.delegate.selectors(selectors);
    }

    public LauncherDiscoveryRequestBuilder selectors(List<? extends DiscoverySelector> selectors) {
        return this.delegate.selectors(selectors);
    }

    public LauncherDiscoveryRequestBuilder filters(Filter<?> ... filters) {
        return this.delegate.filters(filters);
    }

    public LauncherDiscoveryRequestBuilder configurationParameter(String key, String value) {
        return this.delegate.configurationParameter(key, value);
    }

    public LauncherDiscoveryRequestBuilder configurationParameters(Map<String, String> configurationParameters) {
        return this.delegate.configurationParameters(configurationParameters);
    }

    public SuiteLauncherDiscoveryRequestBuilder suite(AnnotatedElement suite) {
        Preconditions.notNull((Object)suite, (String)"Test class must not be null");
        AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)suite, ConfigurationParameter.class).forEach(configuration -> this.configurationParameter(configuration.key(), configuration.value()));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suite, ExcludeClassNamePatterns.class, ExcludeClassNamePatterns::value).flatMap(SuiteLauncherDiscoveryRequestBuilder::trimmed).map(ClassNameFilter::excludeClassNamePatterns).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suite, ExcludeEngines.class, ExcludeEngines::value).map(EngineFilter::excludeEngines).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suite, ExcludePackages.class, ExcludePackages::value).map(PackageNameFilter::excludePackageNames).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suite, ExcludeTags.class, ExcludeTags::value).map(TagFilter::excludeTags).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suite, IncludeClassNamePatterns.class, IncludeClassNamePatterns::value).flatMap(SuiteLauncherDiscoveryRequestBuilder::trimmed).map(ClassNameFilter::includeClassNamePatterns).ifPresent(filters -> {
            this.includeClassNamePatternsUsed = true;
            this.filters(new Filter[]{filters});
        });
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suite, IncludeEngines.class, IncludeEngines::value).map(EngineFilter::includeEngines).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suite, IncludePackages.class, IncludePackages::value).map(PackageNameFilter::includePackageNames).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suite, IncludeTags.class, IncludeTags::value).map(TagFilter::includeTags).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suite, SelectClasses.class, SelectClasses::value).map(AdditionalDiscoverySelectors::selectClasses).ifPresent(this::selectors);
        AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)suite, SelectClasspathResource.class).stream().map(annotation -> AdditionalDiscoverySelectors.selectClasspathResource(annotation.value(), annotation.line(), annotation.column())).forEach(xva$0 -> this.selectors((DiscoverySelector)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suite, SelectDirectories.class, SelectDirectories::value).map(AdditionalDiscoverySelectors::selectDirectories).ifPresent(this::selectors);
        AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)suite, SelectFile.class).stream().map(annotation -> AdditionalDiscoverySelectors.selectFile(annotation.value(), annotation.line(), annotation.column())).forEach(xva$0 -> this.selectors((DiscoverySelector)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suite, SelectModules.class, SelectModules::value).map(AdditionalDiscoverySelectors::selectModules).ifPresent(this::selectors);
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suite, SelectUris.class, SelectUris::value).map(AdditionalDiscoverySelectors::selectUris).ifPresent(this::selectors);
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suite, SelectPackages.class, SelectPackages::value).map(AdditionalDiscoverySelectors::selectPackages).ifPresent(this::selectors);
        return this;
    }

    public LauncherDiscoveryRequest build() {
        if (this.filterStandardClassNamePatterns && !this.includeClassNamePatternsUsed) {
            this.delegate.filters(new Filter[]{ClassNameFilter.includeClassNamePatterns((String[])new String[]{"^(Test.*|.+[.$]Test.*|.*Tests?)$"})});
        }
        return this.delegate.build();
    }

    private static <A extends Annotation, V> Optional<V[]> findAnnotationValues(AnnotatedElement element, Class<A> annotationType, Function<A, V[]> valueExtractor) {
        return AnnotationSupport.findAnnotation((AnnotatedElement)element, annotationType).map(valueExtractor).filter(values -> ((Object[])values).length > 0);
    }

    private static Optional<String[]> trimmed(String[] patterns) {
        if (patterns.length == 0) {
            return Optional.empty();
        }
        return Optional.of((String[])Arrays.stream(patterns).filter(StringUtils::isNotBlank).map(String::trim).toArray(String[]::new));
    }
}

