/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.runner;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.runner.JUnitPlatformRunnerListener;
import org.junit.platform.runner.JUnitPlatformTestTree;
import org.junit.platform.suite.api.SelectClasses;
import org.junit.platform.suite.api.SelectClasspathResource;
import org.junit.platform.suite.api.SelectDirectories;
import org.junit.platform.suite.api.SelectFile;
import org.junit.platform.suite.api.SelectModules;
import org.junit.platform.suite.api.SelectPackages;
import org.junit.platform.suite.api.SelectUris;
import org.junit.platform.suite.commons.SuiteLauncherDiscoveryRequestBuilder;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;

@API(status=API.Status.STABLE, since="1.0")
public class JUnitPlatform
extends Runner
implements Filterable {
    private static final List<Class<? extends Annotation>> IMPLICIT_SUITE_ANNOTATIONS = Arrays.asList(SelectClasses.class, SelectClasspathResource.class, SelectDirectories.class, SelectFile.class, SelectFile.class, SelectModules.class, SelectPackages.class, SelectUris.class);
    private final Class<?> testClass;
    private final Launcher launcher;
    private JUnitPlatformTestTree testTree;

    public JUnitPlatform(Class<?> testClass) {
        this(testClass, LauncherFactory.create());
    }

    JUnitPlatform(Class<?> testClass, Launcher launcher) {
        this.launcher = launcher;
        this.testClass = testClass;
        this.testTree = this.generateTestTree(this.createDiscoveryRequest());
    }

    public Description getDescription() {
        return this.testTree.getSuiteDescription();
    }

    public void run(RunNotifier notifier) {
        this.launcher.execute(this.testTree.getTestPlan(), new TestExecutionListener[]{new JUnitPlatformRunnerListener(this.testTree, notifier)});
    }

    private JUnitPlatformTestTree generateTestTree(LauncherDiscoveryRequest discoveryRequest) {
        TestPlan testPlan = this.launcher.discover(discoveryRequest);
        return new JUnitPlatformTestTree(testPlan, this.testClass);
    }

    private LauncherDiscoveryRequest createDiscoveryRequest() {
        SuiteLauncherDiscoveryRequestBuilder requestBuilder = SuiteLauncherDiscoveryRequestBuilder.request();
        boolean isSuite = this.isSuite();
        if (!isSuite) {
            requestBuilder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(this.testClass)});
        }
        return requestBuilder.filterStandardClassNamePatterns(isSuite).suite(this.testClass).build();
    }

    private boolean isSuite() {
        return IMPLICIT_SUITE_ANNOTATIONS.stream().anyMatch(annotation -> AnnotationSupport.isAnnotated(this.testClass, (Class)annotation));
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Set<TestIdentifier> filteredIdentifiers = this.testTree.getFilteredLeaves(filter);
        if (filteredIdentifiers.isEmpty()) {
            throw new NoTestsRemainException();
        }
        this.testTree = this.generateTestTree(this.createDiscoveryRequestForUniqueIds(filteredIdentifiers));
    }

    private LauncherDiscoveryRequest createDiscoveryRequestForUniqueIds(Set<TestIdentifier> testIdentifiers) {
        List selectors = testIdentifiers.stream().map(TestIdentifier::getUniqueId).map(DiscoverySelectors::selectUniqueId).collect(Collectors.toList());
        return SuiteLauncherDiscoveryRequestBuilder.request().selectors(selectors).build();
    }
}

