/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

class MutableTestExecutionSummary
implements TestExecutionSummary {
    private static final String TAB = "  ";
    private static final String DOUBLE_TAB = "    ";
    private static final int DEFAULT_MAX_STACKTRACE_LINES = 10;
    private static final String CAUSED_BY = "Caused by: ";
    private static final String SUPPRESSED = "Suppressed: ";
    private static final String CIRCULAR = "Circular reference: ";
    final AtomicLong containersFound = new AtomicLong();
    final AtomicLong containersStarted = new AtomicLong();
    final AtomicLong containersSkipped = new AtomicLong();
    final AtomicLong containersAborted = new AtomicLong();
    final AtomicLong containersSucceeded = new AtomicLong();
    final AtomicLong containersFailed = new AtomicLong();
    final AtomicLong testsFound = new AtomicLong();
    final AtomicLong testsStarted = new AtomicLong();
    final AtomicLong testsSkipped = new AtomicLong();
    final AtomicLong testsAborted = new AtomicLong();
    final AtomicLong testsSucceeded = new AtomicLong();
    final AtomicLong testsFailed = new AtomicLong();
    private final TestPlan testPlan;
    private final List<TestExecutionSummary.Failure> failures = Collections.synchronizedList(new ArrayList());
    private final long timeStarted;
    long timeFinished;

    MutableTestExecutionSummary(TestPlan testPlan) {
        this.testPlan = testPlan;
        this.containersFound.set(testPlan.countTestIdentifiers(TestIdentifier::isContainer));
        this.testsFound.set(testPlan.countTestIdentifiers(TestIdentifier::isTest));
        this.timeStarted = System.currentTimeMillis();
    }

    void addFailure(TestIdentifier testIdentifier, Throwable throwable) {
        this.failures.add(new DefaultFailure(testIdentifier, throwable));
    }

    @Override
    public long getTimeStarted() {
        return this.timeStarted;
    }

    @Override
    public long getTimeFinished() {
        return this.timeFinished;
    }

    @Override
    public long getTotalFailureCount() {
        return this.getTestsFailedCount() + this.getContainersFailedCount();
    }

    @Override
    public long getContainersFoundCount() {
        return this.containersFound.get();
    }

    @Override
    public long getContainersStartedCount() {
        return this.containersStarted.get();
    }

    @Override
    public long getContainersSkippedCount() {
        return this.containersSkipped.get();
    }

    @Override
    public long getContainersAbortedCount() {
        return this.containersAborted.get();
    }

    @Override
    public long getContainersSucceededCount() {
        return this.containersSucceeded.get();
    }

    @Override
    public long getContainersFailedCount() {
        return this.containersFailed.get();
    }

    @Override
    public long getTestsFoundCount() {
        return this.testsFound.get();
    }

    @Override
    public long getTestsStartedCount() {
        return this.testsStarted.get();
    }

    @Override
    public long getTestsSkippedCount() {
        return this.testsSkipped.get();
    }

    @Override
    public long getTestsAbortedCount() {
        return this.testsAborted.get();
    }

    @Override
    public long getTestsSucceededCount() {
        return this.testsSucceeded.get();
    }

    @Override
    public long getTestsFailedCount() {
        return this.testsFailed.get();
    }

    @Override
    public void printTo(PrintWriter writer) {
        writer.printf("%nTest run finished after %d ms%n[%10d containers found      ]%n[%10d containers skipped    ]%n[%10d containers started    ]%n[%10d containers aborted    ]%n[%10d containers successful ]%n[%10d containers failed     ]%n[%10d tests found           ]%n[%10d tests skipped         ]%n[%10d tests started         ]%n[%10d tests aborted         ]%n[%10d tests successful      ]%n[%10d tests failed          ]%n%n", this.timeFinished - this.timeStarted, this.getContainersFoundCount(), this.getContainersSkippedCount(), this.getContainersStartedCount(), this.getContainersAbortedCount(), this.getContainersSucceededCount(), this.getContainersFailedCount(), this.getTestsFoundCount(), this.getTestsSkippedCount(), this.getTestsStartedCount(), this.getTestsAbortedCount(), this.getTestsSucceededCount(), this.getTestsFailedCount());
        writer.flush();
    }

    @Override
    public void printFailuresTo(PrintWriter writer) {
        this.printFailuresTo(writer, 10);
    }

    @Override
    public void printFailuresTo(PrintWriter writer, int maxStackTraceLines) {
        Preconditions.notNull((Object)writer, (String)"PrintWriter must not be null");
        Preconditions.condition((maxStackTraceLines >= 0 ? 1 : 0) != 0, (String)"maxStackTraceLines must be a positive number");
        if (this.getTotalFailureCount() > 0L) {
            writer.printf("%nFailures (%d):%n", this.getTotalFailureCount());
            this.failures.forEach(failure -> {
                writer.printf("%s%s%n", TAB, this.describeTest(failure.getTestIdentifier()));
                this.printSource(writer, failure.getTestIdentifier());
                writer.printf("%s=> %s%n", DOUBLE_TAB, failure.getException());
                this.printStackTrace(writer, failure.getException(), maxStackTraceLines);
            });
            writer.flush();
        }
    }

    @Override
    public List<TestExecutionSummary.Failure> getFailures() {
        return Collections.unmodifiableList(this.failures);
    }

    private String describeTest(TestIdentifier testIdentifier) {
        ArrayList<String> descriptionParts = new ArrayList<String>();
        this.collectTestDescription(testIdentifier, descriptionParts);
        return String.join((CharSequence)":", descriptionParts);
    }

    private void collectTestDescription(TestIdentifier identifier, List<String> descriptionParts) {
        descriptionParts.add(0, identifier.getDisplayName());
        this.testPlan.getParent(identifier).ifPresent(parent -> this.collectTestDescription((TestIdentifier)parent, descriptionParts));
    }

    private void printSource(PrintWriter writer, TestIdentifier testIdentifier) {
        testIdentifier.getSource().ifPresent(source -> writer.printf("%s%s%n", DOUBLE_TAB, source));
    }

    private void printStackTrace(PrintWriter writer, Throwable throwable, int max) {
        if (throwable.getCause() != null || throwable.getSuppressed() != null && throwable.getSuppressed().length > 0) {
            max /= 2;
        }
        this.printStackTrace(writer, new StackTraceElement[0], throwable, "", "     ", new HashSet<Throwable>(), max);
        writer.flush();
    }

    private void printStackTrace(PrintWriter writer, StackTraceElement[] parentTrace, Throwable throwable, String caption, String indentation, Set<Throwable> seenThrowables, int max) {
        if (seenThrowables.contains(throwable)) {
            writer.printf("%s%s[%s%s]%n", indentation, TAB, CIRCULAR, throwable);
            return;
        }
        seenThrowables.add(throwable);
        StackTraceElement[] trace = throwable.getStackTrace();
        if (parentTrace != null && parentTrace.length > 0) {
            writer.printf("%s%s%s%n", indentation, caption, throwable);
        }
        int duplicates = this.numberOfCommonFrames(trace, parentTrace);
        int numDistinctFrames = trace.length - duplicates;
        int numDisplayLines = Math.min(numDistinctFrames, max);
        for (int i = 0; i < numDisplayLines; ++i) {
            writer.printf("%s%s%s%n", indentation, TAB, trace[i]);
        }
        if (trace.length > max || duplicates != 0) {
            writer.printf("%s%s%s%n", indentation, TAB, "[...]");
        }
        for (Throwable suppressed : throwable.getSuppressed()) {
            this.printStackTrace(writer, trace, suppressed, SUPPRESSED, indentation + TAB, seenThrowables, max);
        }
        if (throwable.getCause() != null) {
            this.printStackTrace(writer, trace, throwable.getCause(), CAUSED_BY, indentation, seenThrowables, max);
        }
    }

    private int numberOfCommonFrames(StackTraceElement[] currentTrace, StackTraceElement[] parentTrace) {
        int currentIndex = currentTrace.length - 1;
        for (int parentIndex = parentTrace.length - 1; currentIndex >= 0 && parentIndex >= 0 && currentTrace[currentIndex].equals(parentTrace[parentIndex]); --currentIndex, --parentIndex) {
        }
        return currentTrace.length - 1 - currentIndex;
    }

    private static class DefaultFailure
    implements TestExecutionSummary.Failure {
        private static final long serialVersionUID = 1L;
        private final TestIdentifier testIdentifier;
        private final Throwable exception;

        DefaultFailure(TestIdentifier testIdentifier, Throwable exception) {
            this.testIdentifier = testIdentifier;
            this.exception = exception;
        }

        @Override
        public TestIdentifier getTestIdentifier() {
            return this.testIdentifier;
        }

        @Override
        public Throwable getException() {
            return this.exception;
        }
    }
}

