/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.HashSet;
import java.util.function.Consumer;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.LockManager;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.NodeTestTask;

class NodeTestTaskWalker {
    private final LockManager lockManager = new LockManager();

    NodeTestTaskWalker() {
    }

    void walk(NodeTestTask<?> nodeTestTask) {
        if (nodeTestTask.getExclusiveResources().isEmpty()) {
            nodeTestTask.getChildren().forEach(this::walk);
        } else {
            HashSet<ExclusiveResource> allResources = new HashSet<ExclusiveResource>(nodeTestTask.getExclusiveResources());
            this.doForChildrenRecursively(nodeTestTask, child -> {
                allResources.addAll(child.getExclusiveResources());
                child.setForcedExecutionMode(Node.ExecutionMode.SAME_THREAD);
            });
            nodeTestTask.setResourceLock(this.lockManager.getLockForResources(allResources));
        }
    }

    private void doForChildrenRecursively(NodeTestTask<?> parent, Consumer<NodeTestTask<?>> consumer) {
        parent.getChildren().forEach(child -> {
            consumer.accept((NodeTestTask<?>)child);
            this.doForChildrenRecursively((NodeTestTask<?>)child, consumer);
        });
    }
}

