/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.BlacklistedExceptions;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.NopLock;
import org.junit.platform.engine.support.hierarchical.ResourceLock;
import org.junit.platform.engine.support.hierarchical.SingleTestExecutor;

class NodeTestTask<C extends EngineExecutionContext>
implements HierarchicalTestExecutorService.TestTask {
    private static final SingleTestExecutor singleTestExecutor = new SingleTestExecutor();
    private final List<Throwable> executionErrors = new ArrayList<Throwable>();
    private final TestDescriptor testDescriptor;
    private final EngineExecutionListener listener;
    private final HierarchicalTestExecutorService executorService;
    private final Node<C> node;
    private final Node.ExecutionMode executionMode;
    private final Set<ExclusiveResource> exclusiveResources;
    private final List<NodeTestTask<C>> children;
    private ResourceLock resourceLock = NopLock.INSTANCE;
    private Optional<Node.ExecutionMode> forcedExecutionMode = Optional.empty();
    private C parentContext;
    private C context;
    private Node.SkipResult skipResult;
    private TestExecutionResult executionResult;
    private static final Node noOpNode = new Node(){};

    NodeTestTask(TestDescriptor testDescriptor, EngineExecutionListener listener, HierarchicalTestExecutorService executorService) {
        this.testDescriptor = testDescriptor;
        this.listener = listener;
        this.executorService = executorService;
        this.node = this.asNode(testDescriptor);
        this.executionMode = this.node.getExecutionMode();
        this.exclusiveResources = this.node.getExclusiveResources();
        this.children = testDescriptor.getChildren().stream().map(descriptor -> new NodeTestTask((TestDescriptor)descriptor, listener, executorService)).collect(Collectors.toCollection(ArrayList::new));
    }

    public Set<ExclusiveResource> getExclusiveResources() {
        return this.exclusiveResources;
    }

    public List<NodeTestTask<C>> getChildren() {
        return this.children;
    }

    @Override
    public ResourceLock getResourceLock() {
        return this.resourceLock;
    }

    public void setResourceLock(ResourceLock resourceLock) {
        this.resourceLock = resourceLock;
    }

    @Override
    public Node.ExecutionMode getExecutionMode() {
        return this.forcedExecutionMode.orElse(this.executionMode);
    }

    public void setForcedExecutionMode(Node.ExecutionMode forcedExecutionMode) {
        this.forcedExecutionMode = Optional.of(forcedExecutionMode);
    }

    public void setParentContext(C parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    public void execute() {
        this.prepare();
        if (this.executionErrors.isEmpty()) {
            this.checkWhetherSkipped();
        }
        if (this.executionErrors.isEmpty() && !this.skipResult.isSkipped()) {
            this.executeRecursively();
        }
        if (this.context != null) {
            this.cleanUp();
        }
        this.reportCompletion();
    }

    private void prepare() {
        this.executeSafely(() -> {
            this.context = this.node.prepare(this.parentContext);
        });
    }

    private void checkWhetherSkipped() {
        this.executeSafely(() -> {
            this.skipResult = this.node.shouldBeSkipped(this.context);
        });
    }

    private void executeRecursively() {
        this.listener.executionStarted(this.testDescriptor);
        this.executionResult = singleTestExecutor.executeSafely(() -> {
            Throwable failure = null;
            try {
                this.context = this.node.before(this.context);
                ArrayList futures = new ArrayList();
                this.context = this.node.execute(this.context, dynamicTestDescriptor -> this.executeDynamicTest(dynamicTestDescriptor, futures));
                this.children.forEach(child -> child.setParentContext(this.context));
                this.executorService.invokeAll(this.children);
                for (Future future : futures) {
                    future.get();
                }
            }
            catch (Throwable t) {
                failure = t;
            }
            finally {
                this.executeAfter(failure);
            }
        });
    }

    private void executeDynamicTest(TestDescriptor dynamicTestDescriptor, List<Future<?>> futures) {
        this.listener.dynamicTestRegistered(dynamicTestDescriptor);
        NodeTestTask<C> nodeTestTask = new NodeTestTask<C>(dynamicTestDescriptor, this.listener, this.executorService);
        Set<ExclusiveResource> exclusiveResources = nodeTestTask.getExclusiveResources();
        if (!exclusiveResources.isEmpty()) {
            this.listener.executionStarted(dynamicTestDescriptor);
            String message = "Dynamic test descriptors must not declare exclusive resources: " + exclusiveResources;
            this.listener.executionFinished(dynamicTestDescriptor, TestExecutionResult.failed((Throwable)new JUnitException(message)));
        } else {
            nodeTestTask.setParentContext(this.context);
            futures.add(this.executorService.submit(nodeTestTask));
        }
    }

    private void executeAfter(Throwable failure) throws Throwable {
        try {
            this.node.after(this.context);
        }
        catch (Throwable t) {
            if (failure != null && failure != t) {
                failure.addSuppressed(t);
            }
            throw t;
        }
        if (failure != null) {
            throw failure;
        }
    }

    private void cleanUp() {
        this.executeSafely(() -> this.node.cleanUp(this.context));
    }

    private void reportCompletion() {
        if (this.executionResult != null) {
            this.addExecutionErrorsToTestExecutionResult();
            this.listener.executionFinished(this.testDescriptor, this.executionResult);
        } else if (this.executionErrors.isEmpty() && this.skipResult.isSkipped()) {
            this.listener.executionSkipped(this.testDescriptor, this.skipResult.getReason().orElse("<unknown>"));
        } else {
            this.listener.executionStarted(this.testDescriptor);
            this.listener.executionFinished(this.testDescriptor, this.createTestExecutionResultFromExecutionErrors());
        }
    }

    private void addExecutionErrorsToTestExecutionResult() {
        if (this.executionErrors.isEmpty()) {
            return;
        }
        if (this.executionResult.getStatus() == TestExecutionResult.Status.FAILED && this.executionResult.getThrowable().isPresent()) {
            Throwable throwable = this.executionResult.getThrowable().get();
            this.executionErrors.forEach(throwable::addSuppressed);
        } else {
            this.executionResult = this.createTestExecutionResultFromExecutionErrors();
        }
    }

    private TestExecutionResult createTestExecutionResultFromExecutionErrors() {
        Throwable throwable = this.executionErrors.get(0);
        this.executionErrors.stream().skip(1L).forEach(throwable::addSuppressed);
        return TestExecutionResult.failed(throwable);
    }

    private void executeSafely(Action action) {
        try {
            action.execute();
        }
        catch (Throwable t) {
            BlacklistedExceptions.rethrowIfBlacklisted((Throwable)t);
            this.executionErrors.add(t);
        }
    }

    private Node<C> asNode(TestDescriptor testDescriptor) {
        return testDescriptor instanceof Node ? (Node)((Object)testDescriptor) : noOpNode;
    }

    @FunctionalInterface
    private static interface Action {
        public void execute() throws Exception;
    }
}

