/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ModuleUtils;
import org.junit.platform.commons.util.PackageUtils;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

@API(status=API.Status.STABLE, since="1.0")
public interface TestEngine {
    public String getId();

    public TestDescriptor discover(EngineDiscoveryRequest var1, UniqueId var2);

    public void execute(ExecutionRequest var1);

    default public Optional<String> getGroupId() {
        return Optional.empty();
    }

    default public Optional<String> getArtifactId() {
        Optional moduleName = ModuleUtils.getModuleName(this.getClass());
        if (moduleName.isPresent()) {
            return moduleName;
        }
        return PackageUtils.getAttribute(this.getClass(), Package::getImplementationTitle);
    }

    default public Optional<String> getVersion() {
        Optional standalone = PackageUtils.getAttribute(this.getClass(), (String)("Engine-Version-" + this.getId()));
        if (standalone.isPresent()) {
            return standalone;
        }
        return Optional.of(PackageUtils.getModuleOrImplementationVersion(this.getClass()).orElse("DEVELOPMENT"));
    }
}

