/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.backtrace;

import java.util.HashSet;
import java.util.Set;
import org.jruby.internal.runtime.methods.InterpretedIRBodyMethod;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.ir.interpreter.Interpreter;

public enum FrameType {
    METHOD,
    BLOCK,
    EVAL,
    CLASS,
    MODULE,
    METACLASS,
    ROOT;

    private static final Set<String> INTERPRETED_CLASSES;

    public static boolean isInterpreterFrame(String className, String methodName) {
        if (!INTERPRETED_CLASSES.contains(className)) {
            return false;
        }
        return FrameType.getInterpreterFrame(methodName) != null;
    }

    public static FrameType getInterpreterFrame(String methodName) {
        switch (methodName) {
            case "INTERPRET_METHOD": {
                return METHOD;
            }
            case "INTERPRET_EVAL": {
                return EVAL;
            }
            case "INTERPRET_CLASS": {
                return CLASS;
            }
            case "INTERPRET_MODULE": {
                return MODULE;
            }
            case "INTERPRET_METACLASS": {
                return METACLASS;
            }
            case "INTERPRET_BLOCK": {
                return BLOCK;
            }
            case "INTERPRET_ROOT": {
                return ROOT;
            }
        }
        return null;
    }

    static {
        INTERPRETED_CLASSES = new HashSet<String>(4, 1.0f);
        INTERPRETED_CLASSES.add(Interpreter.class.getName());
        INTERPRETED_CLASSES.add(MixedModeIRMethod.class.getName());
        INTERPRETED_CLASSES.add(InterpretedIRMethod.class.getName());
        INTERPRETED_CLASSES.add(InterpretedIRBodyMethod.class.getName());
    }
}

