/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer;

import java.io.IOException;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.util.ByteList;

public class LexingCommon {
    public static final int STR_FUNC_ESCAPE = 1;
    public static final int STR_FUNC_EXPAND = 2;
    public static final int STR_FUNC_REGEXP = 4;
    public static final int STR_FUNC_QWORDS = 8;
    public static final int STR_FUNC_SYMBOL = 16;
    public static final int STR_FUNC_INDENT = 32;
    public static final int str_squote = 0;
    public static final int str_dquote = 2;
    public static final int str_xquote = 2;
    public static final int str_regexp = 7;
    public static final int str_ssym = 16;
    public static final int str_dsym = 18;
    public static final int EOF = -1;
    public static ByteList END_MARKER = new ByteList(new byte[]{95, 95, 69, 78, 68, 95, 95});
    public static ByteList BEGIN_DOC_MARKER = new ByteList(new byte[]{98, 101, 103, 105, 110});
    public static ByteList END_DOC_MARKER = new ByteList(new byte[]{101, 110, 100});
    public static ByteList CODING = new ByteList(new byte[]{99, 111, 100, 105, 110, 103});
    public static final Encoding UTF8_ENCODING = UTF8Encoding.INSTANCE;
    public static final Encoding USASCII_ENCODING = USASCIIEncoding.INSTANCE;
    public static final Encoding ASCII8BIT_ENCODING = ASCIIEncoding.INSTANCE;
    public static final int SUFFIX_R = 1;
    public static final int SUFFIX_I = 2;
    public static final int SUFFIX_ALL = 3;
    public static final String magicString = "([^\\s'\":;]+)\\s*:\\s*(\"(?:\\\\.|[^\"])*\"|[^\"\\s;]+)[\\s;]*";
    public static final Regex magicRegexp = new Regex("([^\\s'\":;]+)\\s*:\\s*(\"(?:\\\\.|[^\"])*\"|[^\"\\s;]+)[\\s;]*".getBytes(), 0, "([^\\s'\":;]+)\\s*:\\s*(\"(?:\\\\.|[^\"])*\"|[^\"\\s;]+)[\\s;]*".length(), 0, Encoding.load((String)"ASCII"));

    public static boolean isHexChar(int c) {
        return Character.isDigit(c) || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    public static boolean isOctChar(int c) {
        return 48 <= c && c <= 55;
    }

    public static int magicCommentMarker(ByteList str, int begin2) {
        int i2 = begin2;
        int len = str.length();
        block4: while (i2 < len) {
            switch (str.charAt(i2)) {
                case '-': {
                    if (i2 >= 2 && str.charAt(i2 - 1) == '*' && str.charAt(i2 - 2) == '-') {
                        return i2 + 1;
                    }
                    i2 += 2;
                    continue block4;
                }
                case '*': {
                    if (i2 + 1 >= len) {
                        return -1;
                    }
                    if (str.charAt(i2 + 1) != '-') {
                        i2 += 4;
                        continue block4;
                    }
                    if (str.charAt(i2 - 1) != '-') {
                        i2 += 2;
                        continue block4;
                    }
                    return i2 + 2;
                }
            }
            i2 += 3;
        }
        return -1;
    }

    public static ByteList parseMagicComment(Ruby runtime, ByteList magicLine) throws IOException {
        int length2 = magicLine.length();
        if (length2 <= 7) {
            return null;
        }
        int beg = LexingCommon.magicCommentMarker(magicLine, 0);
        if (beg < 0) {
            return null;
        }
        int end2 = LexingCommon.magicCommentMarker(magicLine, beg);
        if (end2 < 0) {
            return null;
        }
        length2 = end2 - beg - 3;
        int realSize = magicLine.getRealSize();
        int begin2 = magicLine.getBegin();
        Matcher matcher = magicRegexp.matcher(magicLine.getUnsafeBytes(), begin2, begin2 + realSize);
        int result2 = RubyRegexp.matcherSearch(runtime, matcher, begin2, begin2 + realSize, 0);
        if (result2 < 0) {
            return null;
        }
        int[] begs = matcher.getRegion().beg;
        int[] ends = matcher.getRegion().end;
        String name2 = magicLine.subSequence(begs[1], ends[1]).toString();
        if (!name2.contains("ccoding")) {
            return null;
        }
        return magicLine.makeShared(begs[2], ends[2] - begs[2]);
    }
}

