/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;

public class Regexp
extends ImmutableLiteral {
    public final RegexpOptions options;
    private final ByteList source;

    public Regexp(ByteList source2, RegexpOptions options2) {
        this.source = source2;
        this.options = options2;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.REGEXP;
    }

    public ByteList getSource() {
        return this.source;
    }

    public String toString() {
        return "RE:|" + this.source + "|" + this.options;
    }

    @Override
    public Object createCacheObject(ThreadContext context) {
        return IRRuntimeHelpers.newLiteralRegexp(context, this.source, this.options);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.source);
        e.encode(this.options.toEmbeddedOptions());
    }

    public static Regexp decode(IRReaderDecoder d) {
        return new Regexp(d.decodeByteList(), RegexpOptions.fromEmbeddedOptions(d.decodeInt()));
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Regexp(this);
    }
}

