/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.scorecard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.scorecard.Attribute;
import org.dmg.pmml.scorecard.Characteristic;
import org.dmg.pmml.scorecard.Characteristics;
import org.dmg.pmml.scorecard.ComplexPartialScore;
import org.dmg.pmml.scorecard.Scorecard;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.Functions;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UndefinedResultException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.VoteAggregator;
import org.jpmml.evaluator.scorecard.ComplexScorecardScore;
import org.jpmml.evaluator.scorecard.PartialScore;
import org.jpmml.evaluator.scorecard.ScorecardScore;
import org.jpmml.evaluator.scorecard.SimpleScorecardScore;
import org.jpmml.model.UnsupportedAttributeException;

public class ScorecardEvaluator
extends ModelEvaluator<Scorecard> {
    private ScorecardEvaluator() {
    }

    public ScorecardEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, Scorecard.class));
    }

    public ScorecardEvaluator(PMML pmml, Scorecard scorecard) {
        super(pmml, scorecard);
        List characteristics = scorecard.requireCharacteristics().requireCharacteristics();
        for (Characteristic characteristic : characteristics) {
            List list = characteristic.requireAttributes();
        }
    }

    @Override
    public String getSummary() {
        return "Scorecard";
    }

    @Override
    protected <V extends Number> Map<String, ?> evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        ScorecardScore result;
        Scorecard scorecard = (Scorecard)this.getModel();
        boolean useReasonCodes = scorecard.isUseReasonCodes();
        TargetField targetField = this.getTargetField();
        Value<V> value = valueFactory.newValue(scorecard.getInitialScore());
        ArrayList<PartialScore> partialScores = new ArrayList<PartialScore>();
        VoteAggregator<String, V> reasonCodePoints = null;
        if (useReasonCodes) {
            reasonCodePoints = new VoteAggregator<String, V>(valueFactory);
        }
        Characteristics characteristics = scorecard.requireCharacteristics();
        for (Characteristic characteristic : characteristics) {
            Number difference;
            PartialScore partialScore = ScorecardEvaluator.evaluateCharacteristic(characteristic, context);
            Number score = partialScore.getValue();
            value.add(score);
            partialScores.add(partialScore);
            if (!useReasonCodes) continue;
            Number baselineScore = partialScore.getBaselineScore(scorecard.getBaselineScore());
            String reasonCode = partialScore.getReasonCode();
            Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm = scorecard.getReasonCodeAlgorithm();
            switch (reasonCodeAlgorithm) {
                case POINTS_ABOVE: {
                    difference = Functions.SUBTRACT.evaluate(score, baselineScore);
                    break;
                }
                case POINTS_BELOW: {
                    difference = Functions.SUBTRACT.evaluate(baselineScore, score);
                    break;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)scorecard, (Enum)reasonCodeAlgorithm);
                }
            }
            reasonCodePoints.add(reasonCode, difference);
        }
        if (useReasonCodes) {
            result = ScorecardEvaluator.createComplexScorecardScore(targetField, value, partialScores, reasonCodePoints.sumMap());
            return TargetUtil.evaluateRegression(targetField, result);
        }
        result = ScorecardEvaluator.createSimpleScorecardScore(targetField, value, partialScores);
        return TargetUtil.evaluateRegression(targetField, result);
    }

    private static PartialScore evaluateCharacteristic(Characteristic characteristic, EvaluationContext context) {
        List attributes = characteristic.requireAttributes();
        int max = attributes.size();
        for (int i = 0; i < max; ++i) {
            Attribute attribute = (Attribute)attributes.get(i);
            Boolean status = PredicateUtil.evaluatePredicateContainer(attribute, context);
            if (status == null || !status.booleanValue()) continue;
            Number value = ScorecardEvaluator.evaluateAttribute(attribute, context);
            return new PartialScore(characteristic, attribute, value);
        }
        throw new UndefinedResultException().ensureContext((PMMLObject)characteristic);
    }

    private static Number evaluateAttribute(Attribute attribute, EvaluationContext context) {
        ComplexPartialScore complexPartialScore = attribute.getComplexPartialScore();
        if (complexPartialScore != null) {
            FieldValue value = ExpressionUtil.evaluateExpressionContainer(complexPartialScore, context);
            if (FieldValueUtil.isMissing(value)) {
                throw new UndefinedResultException().ensureContext((PMMLObject)complexPartialScore);
            }
            return value.asNumber();
        }
        Number partialScore = attribute.requirePartialScore();
        return partialScore;
    }

    private static <V extends Number> SimpleScorecardScore<V> createSimpleScorecardScore(TargetField targetField, Value<V> value, List<PartialScore> partialScores) {
        value = TargetUtil.evaluateRegressionInternal(targetField, value);
        return new SimpleScorecardScore<V>(value, partialScores);
    }

    private static <V extends Number> ComplexScorecardScore<V> createComplexScorecardScore(TargetField targetField, Value<V> value, List<PartialScore> partialScores, ValueMap<String, V> reasonCodePoints) {
        value = TargetUtil.evaluateRegressionInternal(targetField, value);
        Set entrySet = reasonCodePoints.entrySet();
        Iterator it = entrySet.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String reasonCode = (String)entry.getKey();
            Value points = (Value)entry.getValue();
            if (points.compareTo(Numbers.DOUBLE_ZERO) >= 0) continue;
            it.remove();
        }
        return new ComplexScorecardScore<V>(value, partialScores, reasonCodePoints);
    }
}

