/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.Serializable;
import org.dmg.pmml.MathContext;
import org.jpmml.evaluator.ComplexDoubleVector;
import org.jpmml.evaluator.ComplexFloatVector;
import org.jpmml.evaluator.DoubleValue;
import org.jpmml.evaluator.FloatValue;
import org.jpmml.evaluator.SimpleDoubleVector;
import org.jpmml.evaluator.SimpleFloatVector;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.Vector;

public class ValueFactoryFactory
implements Serializable {
    protected ValueFactoryFactory() {
    }

    public ValueFactory<?> newValueFactory(MathContext mathContext) {
        switch (mathContext) {
            case FLOAT: {
                return FloatValueFactory.INSTANCE;
            }
            case DOUBLE: {
                return DoubleValueFactory.INSTANCE;
            }
        }
        throw new IllegalArgumentException();
    }

    public static ValueFactoryFactory newInstance() {
        return new ValueFactoryFactory();
    }

    protected static class DoubleValueFactory
    extends ValueFactory<Double> {
        public static final DoubleValueFactory INSTANCE = new DoubleValueFactory();

        protected DoubleValueFactory() {
        }

        @Override
        public Value<Double> newValue() {
            return new DoubleValue(0.0);
        }

        @Override
        public Value<Double> newValue(Number value) {
            return new DoubleValue(value.doubleValue());
        }

        @Override
        public Value<Double> newValue(String value) {
            return new DoubleValue(Double.parseDouble(value));
        }

        @Override
        public Vector<Double> newVector(int capacity) {
            if (capacity > 0) {
                return new ComplexDoubleVector(capacity);
            }
            return new SimpleDoubleVector();
        }
    }

    protected static class FloatValueFactory
    extends ValueFactory<Float> {
        public static final FloatValueFactory INSTANCE = new FloatValueFactory();

        protected FloatValueFactory() {
        }

        @Override
        public Value<Float> newValue() {
            return new FloatValue(0.0f);
        }

        @Override
        public Value<Float> newValue(Number value) {
            return new FloatValue(value.floatValue());
        }

        @Override
        public Value<Float> newValue(String value) {
            return new FloatValue(Float.parseFloat(value));
        }

        @Override
        public Vector<Float> newVector(int capacity) {
            if (capacity > 0) {
                return new ComplexFloatVector(capacity);
            }
            return new SimpleFloatVector();
        }
    }
}

