/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collection;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.CollectionValue;
import org.jpmml.evaluator.DiscreteValue;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.ScalarValue;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;

public class CategoricalValue
extends DiscreteValue {
    private CategoricalValue() {
    }

    CategoricalValue(DataType dataType, Object value) {
        super(dataType, value);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public int compareToValue(Object value) {
        throw new EvaluationException("Categorical value cannot be used in comparison operations");
    }

    @Override
    public int compareToValue(FieldValue value) {
        throw new EvaluationException("Categorical value cannot be used in comparison operations");
    }

    public static FieldValue create(DataType dataType, Object value) {
        if (value instanceof Collection) {
            return new CollectionValue(OpType.CATEGORICAL, dataType, (Collection)value);
        }
        switch (dataType) {
            case STRING: {
                return new CategoricalString(value);
            }
            case BOOLEAN: {
                return new CategoricalBoolean(value);
            }
        }
        return new CategoricalValue(dataType, value);
    }

    private static class CategoricalBoolean
    extends CategoricalValue {
        private CategoricalBoolean() {
        }

        CategoricalBoolean(Object value) {
            super(DataType.BOOLEAN, value);
        }

        @Override
        public int compareToValue(Object value) {
            Number number;
            if (value instanceof Boolean) {
                return Boolean.compare(this.asBoolean(), (Boolean)value);
            }
            try {
                number = (Number)TypeUtil.parseOrCast(DataType.DOUBLE, value);
            }
            catch (NumberFormatException nfe) {
                throw nfe;
            }
            catch (TypeCheckException tce) {
                throw new TypeCheckException(DataType.BOOLEAN, value);
            }
            return this.asDouble().compareTo(number);
        }

        @Override
        public int compareToValue(FieldValue value) {
            if (value instanceof ScalarValue) {
                ScalarValue that = (ScalarValue)value;
                if (this.getDataType() == that.getDataType()) {
                    return Boolean.compare(this.asBoolean(), that.asBoolean());
                }
            }
            return this.compareToValue(value.getValue());
        }

        @Override
        public boolean equalsValue(Object value) {
            if (value instanceof Boolean) {
                return this.asBoolean().equals(value);
            }
            return super.equalsValue(value);
        }

        @Override
        public Boolean asBoolean() {
            return (Boolean)this.getValue();
        }
    }

    private static class CategoricalString
    extends CategoricalValue {
        private CategoricalString() {
        }

        CategoricalString(Object value) {
            super(DataType.STRING, value);
        }

        @Override
        public boolean equalsValue(Object value) {
            if (value instanceof String) {
                return this.asString().equals(value);
            }
            return super.equalsValue(value);
        }

        @Override
        public String asString() {
            return (String)this.getValue();
        }
    }
}

