/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.bin;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerIterator;
import org.joda.beans.ser.SerOptional;
import org.joda.beans.ser.SerTypeMapper;
import org.joda.beans.ser.bin.AbstractBinWriter;
import org.joda.beans.ser.bin.BeanReferences;

class JodaBeanReferencingBinWriter
extends AbstractBinWriter {
    private BeanReferences references;

    JodaBeanReferencingBinWriter(JodaBeanSer settings, OutputStream output) {
        super(settings, output);
    }

    void write(ImmutableBean bean) throws IOException {
        this.references = BeanReferences.find(bean, this.settings);
        this.output.writeArrayHeader(4);
        this.output.writeInt(2);
        this.writeClassDescriptions(this.references);
        this.writeRootBean(bean, true);
    }

    private void writeClassDescriptions(BeanReferences references) throws IOException {
        this.output.writeInt(references.getReferences().size());
        List<BeanReferences.ClassInfo> classInfos = references.getClassInfoList();
        this.output.writeMapHeader(classInfos.size());
        for (BeanReferences.ClassInfo classInfo : classInfos) {
            String className = SerTypeMapper.encodeType(classInfo.type, this.settings, null, null);
            this.output.writeString(className);
            this.output.writeArrayHeader(classInfo.metaProperties.length);
            for (MetaProperty<?> property : classInfo.metaProperties) {
                this.output.writeString(property.name());
            }
        }
    }

    @Override
    void writeBean(Bean bean, Class<?> declaredType, AbstractBinWriter.RootType rootTypeFlag) throws IOException {
        BeanReferences.Ref ref = this.references.getReferences().get(bean);
        if (ref != null) {
            if (ref.hasBeenSerialized) {
                this.output.writePositiveExtensionInt(36, ref.position);
                return;
            }
            this.output.writeMapHeader(1);
            this.output.writePositiveExtensionInt(35, ref.position);
        }
        BeanReferences.ClassInfo classInfo = this.references.getClassInfo(bean.getClass());
        MetaProperty<?>[] props = classInfo.metaProperties;
        int count = props.length;
        Object[] values = new Object[count];
        int size = 0;
        for (MetaProperty<?> prop : props) {
            Object value = SerOptional.extractValue(prop, bean);
            values[size++] = value;
        }
        if (rootTypeFlag == AbstractBinWriter.RootType.ROOT_WITH_TYPE || rootTypeFlag == AbstractBinWriter.RootType.NOT_ROOT && bean.getClass() != declaredType) {
            this.output.writeArrayHeader(size + 1);
            this.output.writePositiveExtensionInt(32, classInfo.position);
        } else {
            this.output.writeArrayHeader(size);
        }
        for (int i = 0; i < size; ++i) {
            MetaProperty<?> prop = props[i];
            Object value = values[i];
            Class<?> propType = SerOptional.extractType(prop, bean.getClass());
            if (value == null) {
                this.output.writeNil();
                continue;
            }
            if (value instanceof Bean) {
                if (this.settings.getConverter().isConvertible(value.getClass())) {
                    this.writeSimple(propType, value);
                    continue;
                }
                this.writeBean((Bean)value, propType, AbstractBinWriter.RootType.NOT_ROOT);
                continue;
            }
            SerIterator itemIterator = this.settings.getIteratorFactory().create(value, prop, bean.getClass());
            if (itemIterator != null) {
                this.writeElements(itemIterator);
                continue;
            }
            this.writeSimple(propType, value);
        }
        if (ref != null) {
            ref.sent();
        }
    }

    @Override
    void writeMetaPropertyReference(String metaTypeName) throws IOException {
        BeanReferences.Ref ref = this.references.getReferences().get(metaTypeName);
        if (ref != null) {
            if (ref.hasBeenSerialized) {
                this.output.writePositiveExtensionInt(34, ref.position);
            } else {
                this.output.writeMapHeader(1);
                this.output.writePositiveExtensionInt(35, ref.position);
                this.output.writeExtensionString(34, metaTypeName);
                ref.sent();
            }
        } else {
            this.output.writeExtensionString(34, metaTypeName);
        }
    }

    @Override
    Class<?> getAndSerializeEffectiveTypeIfRequired(Object value, Class<?> declaredType) throws IOException {
        BeanReferences.Ref ref = this.references.getReferences().get(value);
        if (ref != null && ref.hasBeenSerialized) {
            return declaredType;
        }
        Class<?> realType = value.getClass();
        Class effectiveType = declaredType;
        if (declaredType == Object.class) {
            if (realType != String.class) {
                effectiveType = this.settings.getConverter().findTypedConverter(realType).getEffectiveType();
                BeanReferences.ClassInfo classInfo = this.references.getClassInfo(effectiveType);
                this.output.writeMapHeader(1);
                this.output.writePositiveExtensionInt(33, classInfo.position);
            } else {
                effectiveType = realType;
            }
        } else if (!this.settings.getConverter().isConvertible(declaredType)) {
            effectiveType = this.settings.getConverter().findTypedConverter(realType).getEffectiveType();
            BeanReferences.ClassInfo classInfo = this.references.getClassInfo(effectiveType);
            this.output.writeMapHeader(1);
            this.output.writePositiveExtensionInt(33, classInfo.position);
        }
        return effectiveType;
    }

    @Override
    void writeObjectAsString(Object value, Class<?> effectiveType) throws IOException {
        BeanReferences.Ref ref = this.references.getReferences().get(value);
        if (ref != null && ref.hasBeenSerialized) {
            this.output.writePositiveExtensionInt(36, ref.position);
        } else {
            String converted = this.settings.getConverter().convertToString(effectiveType, value);
            if (converted == null) {
                throw new IllegalArgumentException("Unable to write because converter returned a null string: " + value);
            }
            if (ref != null) {
                this.output.writeMapHeader(1);
                this.output.writePositiveExtensionInt(35, ref.position);
                this.output.writeString(converted);
                ref.sent();
            } else {
                this.output.writeString(converted);
            }
        }
    }
}

