/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl;

import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.MetaProperty;

public class BasicBeanBuilder<T extends Bean>
implements BeanBuilder<T> {
    private final T bean;

    public BasicBeanBuilder(T bean) {
        if (bean == null) {
            throw new NullPointerException("Bean must not be null");
        }
        this.bean = bean;
    }

    protected T getTargetBean() {
        return this.bean;
    }

    @Override
    public Object get(String propertyName) {
        return this.bean.property(propertyName).get();
    }

    @Override
    public <P> P get(MetaProperty<P> metaProperty) {
        return metaProperty.get((Bean)this.bean);
    }

    @Override
    public BeanBuilder<T> set(String propertyName, Object value) {
        return this.set(this.bean.metaBean().metaProperty(propertyName), value);
    }

    @Override
    public BeanBuilder<T> set(MetaProperty<?> metaProperty, Object value) {
        metaProperty.set((Bean)this.bean, value);
        return this;
    }

    @Override
    public T build() {
        this.validate(this.bean);
        return this.bean;
    }

    protected void validate(T bean) {
    }

    public String toString() {
        return "BeanBuilder for " + this.bean.metaBean().beanName();
    }
}

