/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture;

import com.jme3.renderer.Renderer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.TextureArray;
import com.jme3.texture.TextureCubeMap;
import com.jme3.util.NativeObject;
import java.util.ArrayList;

public class FrameBuffer
extends NativeObject {
    public static final int SLOT_UNDEF = -1;
    public static final int SLOT_DEPTH = -100;
    public static final int SLOT_DEPTH_STENCIL = -101;
    private int width = 0;
    private int height = 0;
    private int samples = 1;
    private final ArrayList<RenderBuffer> colorBufs = new ArrayList();
    private RenderBuffer depthBuf = null;
    private int colorBufIndex = 0;
    private boolean srgb;

    private FrameBuffer() {
    }

    public void addColorTarget(FrameBufferBufferTarget colorBuf) {
        colorBuf.slot = this.colorBufs.size();
        this.colorBufs.add(colorBuf);
    }

    public void addColorTarget(FrameBufferTextureTarget colorBuf) {
        colorBuf.slot = this.colorBufs.size();
        this.colorBufs.add(colorBuf);
    }

    public void setDepthTarget(FrameBufferBufferTarget depthBuf) {
        if (!depthBuf.getFormat().isDepthFormat()) {
            throw new IllegalArgumentException("Depth buffer format must be depth.");
        }
        this.depthBuf = depthBuf;
        this.depthBuf.slot = this.depthBuf.getFormat().isDepthStencilFormat() ? -101 : -100;
    }

    public void setDepthTarget(FrameBufferTextureTarget depthBuf) {
        this.checkSetTexture(depthBuf.getTexture(), true);
        this.depthBuf = depthBuf;
        this.depthBuf.slot = depthBuf.getTexture().getImage().getFormat().isDepthStencilFormat() ? -101 : -100;
    }

    public int getNumColorTargets() {
        return this.colorBufs.size();
    }

    public RenderBuffer getColorTarget(int index) {
        return this.colorBufs.get(index);
    }

    public RenderBuffer getColorTarget() {
        if (this.colorBufs.isEmpty()) {
            return null;
        }
        if (this.colorBufIndex < 0 || this.colorBufIndex >= this.colorBufs.size()) {
            return this.colorBufs.get(0);
        }
        return this.colorBufs.get(this.colorBufIndex);
    }

    public RenderBuffer getDepthTarget() {
        return this.depthBuf;
    }

    public FrameBuffer(int width, int height, int samples) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("FrameBuffer must have valid size.");
        }
        this.width = width;
        this.height = height;
        this.samples = samples == 0 ? 1 : samples;
    }

    protected FrameBuffer(FrameBuffer src) {
        super(src.id);
    }

    @Deprecated
    public void setDepthBuffer(Image.Format format) {
        if (this.id != -1) {
            throw new UnsupportedOperationException("FrameBuffer already initialized.");
        }
        if (!format.isDepthFormat()) {
            throw new IllegalArgumentException("Depth buffer format must be depth.");
        }
        this.depthBuf = new RenderBuffer();
        this.depthBuf.slot = format.isDepthStencilFormat() ? -101 : -100;
        this.depthBuf.format = format;
    }

    @Deprecated
    public void setColorBuffer(Image.Format format) {
        if (this.id != -1) {
            throw new UnsupportedOperationException("FrameBuffer already initialized.");
        }
        if (format.isDepthFormat()) {
            throw new IllegalArgumentException("Color buffer format must be color/luminance.");
        }
        RenderBuffer colorBuf = new RenderBuffer();
        colorBuf.slot = 0;
        colorBuf.format = format;
        this.colorBufs.clear();
        this.colorBufs.add(colorBuf);
    }

    private void checkSetTexture(Texture tex, boolean depth) {
        Image img = tex.getImage();
        if (img == null) {
            throw new IllegalArgumentException("Texture not initialized with RTT.");
        }
        if (depth && !img.getFormat().isDepthFormat()) {
            throw new IllegalArgumentException("Texture image format must be depth.");
        }
        if (!depth && img.getFormat().isDepthFormat()) {
            throw new IllegalArgumentException("Texture image format must be color/luminance.");
        }
        if (this.width != img.getWidth() || this.height != img.getHeight()) {
            throw new IllegalArgumentException("Texture image resolution must match FB resolution");
        }
        if (this.samples != tex.getImage().getMultiSamples()) {
            throw new IllegalStateException("Texture samples must match framebuffer samples");
        }
    }

    public void setMultiTarget(boolean enabled) {
        this.colorBufIndex = enabled ? -1 : 0;
    }

    public boolean isMultiTarget() {
        return this.colorBufIndex == -1;
    }

    public void setTargetIndex(int index) {
        if (index < 0 || index >= 16) {
            throw new IllegalArgumentException("Target index must be between 0 and 16");
        }
        if (this.colorBufs.size() < index) {
            throw new IllegalArgumentException("The target at " + index + " is not set!");
        }
        this.colorBufIndex = index;
        this.setUpdateNeeded();
    }

    public int getTargetIndex() {
        return this.colorBufIndex;
    }

    @Deprecated
    public void setColorTexture(Texture2D tex) {
        this.clearColorTargets();
        this.addColorTexture(tex);
    }

    @Deprecated
    public void setColorTexture(TextureArray tex, int layer) {
        this.clearColorTargets();
        this.addColorTexture(tex, layer);
    }

    @Deprecated
    public void setColorTexture(TextureCubeMap tex, TextureCubeMap.Face face) {
        this.clearColorTargets();
        this.addColorTexture(tex, face);
    }

    public void clearColorTargets() {
        this.colorBufs.clear();
    }

    @Deprecated
    public void addColorBuffer(Image.Format format) {
        if (this.id != -1) {
            throw new UnsupportedOperationException("FrameBuffer already initialized.");
        }
        if (format.isDepthFormat()) {
            throw new IllegalArgumentException("Color buffer format must be color/luminance.");
        }
        RenderBuffer colorBuf = new RenderBuffer();
        colorBuf.slot = this.colorBufs.size();
        colorBuf.format = format;
        this.colorBufs.add(colorBuf);
    }

    @Deprecated
    public void addColorTexture(Texture2D tex) {
        if (this.id != -1) {
            throw new UnsupportedOperationException("FrameBuffer already initialized.");
        }
        Image img = tex.getImage();
        this.checkSetTexture(tex, false);
        RenderBuffer colorBuf = new RenderBuffer();
        colorBuf.slot = this.colorBufs.size();
        colorBuf.tex = tex;
        colorBuf.format = img.getFormat();
        this.colorBufs.add(colorBuf);
    }

    @Deprecated
    public void addColorTexture(TextureArray tex, int layer) {
        if (this.id != -1) {
            throw new UnsupportedOperationException("FrameBuffer already initialized.");
        }
        Image img = tex.getImage();
        this.checkSetTexture(tex, false);
        RenderBuffer colorBuf = new RenderBuffer();
        colorBuf.slot = this.colorBufs.size();
        colorBuf.tex = tex;
        colorBuf.format = img.getFormat();
        colorBuf.layer = layer;
        this.colorBufs.add(colorBuf);
    }

    @Deprecated
    public void addColorTexture(TextureCubeMap tex, TextureCubeMap.Face face) {
        if (this.id != -1) {
            throw new UnsupportedOperationException("FrameBuffer already initialized.");
        }
        Image img = tex.getImage();
        this.checkSetTexture(tex, false);
        RenderBuffer colorBuf = new RenderBuffer();
        colorBuf.slot = this.colorBufs.size();
        colorBuf.tex = tex;
        colorBuf.format = img.getFormat();
        colorBuf.face = face.ordinal();
        this.colorBufs.add(colorBuf);
    }

    @Deprecated
    public void setDepthTexture(Texture2D tex) {
        if (this.id != -1) {
            throw new UnsupportedOperationException("FrameBuffer already initialized.");
        }
        Image img = tex.getImage();
        this.checkSetTexture(tex, true);
        this.depthBuf = new RenderBuffer();
        this.depthBuf.slot = img.getFormat().isDepthStencilFormat() ? -101 : -100;
        this.depthBuf.tex = tex;
        this.depthBuf.format = img.getFormat();
    }

    @Deprecated
    public void setDepthTexture(TextureArray tex, int layer) {
        if (this.id != -1) {
            throw new UnsupportedOperationException("FrameBuffer already initialized.");
        }
        Image img = tex.getImage();
        this.checkSetTexture(tex, true);
        this.depthBuf = new RenderBuffer();
        this.depthBuf.slot = img.getFormat().isDepthStencilFormat() ? -101 : -100;
        this.depthBuf.tex = tex;
        this.depthBuf.format = img.getFormat();
        this.depthBuf.layer = layer;
    }

    @Deprecated
    public int getNumColorBuffers() {
        return this.colorBufs.size();
    }

    @Deprecated
    public RenderBuffer getColorBuffer(int index) {
        return this.colorBufs.get(index);
    }

    @Deprecated
    public RenderBuffer getColorBuffer() {
        if (this.colorBufs.isEmpty()) {
            return null;
        }
        if (this.colorBufIndex < 0 || this.colorBufIndex >= this.colorBufs.size()) {
            return this.colorBufs.get(0);
        }
        return this.colorBufs.get(this.colorBufIndex);
    }

    @Deprecated
    public RenderBuffer getDepthBuffer() {
        return this.depthBuf;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getSamples() {
        return this.samples;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String mrtStr = this.colorBufIndex >= 0 ? "" + this.colorBufIndex : "mrt";
        sb.append("FrameBuffer[format=").append(this.width).append("x").append(this.height).append("x").append(this.samples).append(", drawBuf=").append(mrtStr).append("]\n");
        if (this.depthBuf != null) {
            sb.append("Depth => ").append(this.depthBuf).append("\n");
        }
        for (RenderBuffer colorBuf : this.colorBufs) {
            sb.append("Color(").append(colorBuf.slot).append(") => ").append(colorBuf).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void resetObject() {
        this.id = -1;
        for (int i = 0; i < this.colorBufs.size(); ++i) {
            this.colorBufs.get(i).resetObject();
        }
        if (this.depthBuf != null) {
            this.depthBuf.resetObject();
        }
        this.setUpdateNeeded();
    }

    @Override
    public void deleteObject(Object rendererObject) {
        ((Renderer)rendererObject).deleteFrameBuffer(this);
    }

    @Override
    public NativeObject createDestructableClone() {
        return new FrameBuffer(this);
    }

    @Override
    public long getUniqueId() {
        return 0x300000000L | (long)this.id;
    }

    public void setSrgb(boolean srgb) {
        this.srgb = srgb;
    }

    public boolean isSrgb() {
        return this.srgb;
    }

    public static class FrameBufferTarget {
        private FrameBufferTarget() {
        }

        public static FrameBufferTextureTarget newTarget(Texture tx) {
            FrameBufferTextureTarget t = new FrameBufferTextureTarget();
            t.setTexture(tx);
            return t;
        }

        public static FrameBufferBufferTarget newTarget(Image.Format format) {
            FrameBufferBufferTarget t = new FrameBufferBufferTarget();
            t.setFormat(format);
            return t;
        }
    }

    public static class FrameBufferBufferTarget
    extends RenderBuffer {
        private FrameBufferBufferTarget() {
        }

        void setFormat(Image.Format f) {
            this.format = f;
        }
    }

    public static class FrameBufferTextureTarget
    extends RenderBuffer {
        private FrameBufferTextureTarget() {
        }

        void setTexture(Texture tx) {
            this.tex = tx;
            this.format = tx.getImage().getFormat();
        }

        void setFormat(Image.Format f) {
            this.format = f;
        }

        public FrameBufferTextureTarget layer(int i) {
            this.layer = i;
            return this;
        }

        public FrameBufferTextureTarget level(int i) {
            this.level = i;
            return this;
        }

        public FrameBufferTextureTarget face(TextureCubeMap.Face f) {
            return this.face(f.ordinal());
        }

        public FrameBufferTextureTarget face(int f) {
            this.face = f;
            return this;
        }
    }

    public static class RenderBuffer {
        Texture tex;
        Image.Format format;
        int id = -1;
        int slot = -1;
        int face = -1;
        int layer = -1;
        int level = 0;

        public int getLevel() {
            return this.level;
        }

        public Image.Format getFormat() {
            return this.format;
        }

        public Texture getTexture() {
            return this.tex;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getSlot() {
            return this.slot;
        }

        public int getFace() {
            return this.face;
        }

        public void resetObject() {
            this.id = -1;
        }

        public RenderBuffer createDestructableClone() {
            if (this.tex != null) {
                return null;
            }
            RenderBuffer destructClone = new RenderBuffer();
            destructClone.id = this.id;
            return destructClone;
        }

        public String toString() {
            if (this.tex != null) {
                return "TextureTarget[format=" + (Object)((Object)this.format) + "]";
            }
            return "BufferTarget[format=" + (Object)((Object)this.format) + "]";
        }

        public int getLayer() {
            return this.layer;
        }
    }
}

