/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shadow;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.light.SpotLight;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.shadow.AbstractShadowRenderer;
import com.jme3.shadow.ShadowUtil;
import com.jme3.util.TempVars;
import com.jme3.util.clone.Cloner;
import java.io.IOException;

public class SpotLightShadowRenderer
extends AbstractShadowRenderer {
    protected Camera shadowCam;
    protected SpotLight light;
    protected Vector3f[] points = new Vector3f[8];

    protected SpotLightShadowRenderer() {
    }

    public SpotLightShadowRenderer(AssetManager assetManager, int shadowMapSize) {
        super(assetManager, shadowMapSize, 1);
        this.init(shadowMapSize);
    }

    private void init(int shadowMapSize) {
        this.shadowCam = new Camera(shadowMapSize, shadowMapSize);
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new Vector3f();
        }
    }

    @Override
    protected void initFrustumCam() {
        Camera viewCam = this.viewPort.getCamera();
        this.frustumCam = viewCam.clone();
        this.frustumCam.setFrustum(viewCam.getFrustumNear(), this.zFarOverride, viewCam.getFrustumLeft(), viewCam.getFrustumRight(), viewCam.getFrustumTop(), viewCam.getFrustumBottom());
    }

    public SpotLight getLight() {
        return this.light;
    }

    public void setLight(SpotLight light) {
        this.light = light;
    }

    @Override
    protected void updateShadowCams(Camera viewCam) {
        if (this.light == null) {
            logger.warning("The light can't be null for a " + this.getClass().getName());
            return;
        }
        float zFar = this.zFarOverride;
        if (zFar == 0.0f) {
            zFar = viewCam.getFrustumFar();
        }
        float frustumNear = Math.max(viewCam.getFrustumNear(), 0.001f);
        ShadowUtil.updateFrustumPoints(viewCam, frustumNear, zFar, 1.0f, this.points);
        this.shadowCam.setFrustumPerspective(this.light.getSpotOuterAngle() * 57.295776f * 2.0f, 1.0f, 1.0f, this.light.getSpotRange());
        this.shadowCam.getRotation().lookAt(this.light.getDirection(), this.shadowCam.getUp());
        this.shadowCam.setLocation(this.light.getPosition());
        this.shadowCam.update();
        this.shadowCam.updateViewProjection();
    }

    @Override
    protected GeometryList getOccludersToRender(int shadowMapIndex, GeometryList shadowMapOccluders) {
        for (Spatial scene : this.viewPort.getScenes()) {
            ShadowUtil.getGeometriesInCamFrustum(scene, this.shadowCam, RenderQueue.ShadowMode.Cast, shadowMapOccluders);
        }
        return shadowMapOccluders;
    }

    @Override
    protected void getReceivers(GeometryList lightReceivers) {
        lightReceivers.clear();
        Camera[] cameras = new Camera[]{this.shadowCam};
        for (Spatial scene : this.viewPort.getScenes()) {
            ShadowUtil.getLitGeometriesInViewPort(scene, this.viewPort.getCamera(), cameras, RenderQueue.ShadowMode.Receive, lightReceivers);
        }
    }

    @Override
    protected Camera getShadowCam(int shadowMapIndex) {
        return this.shadowCam;
    }

    @Override
    protected void doDisplayFrustumDebug(int shadowMapIndex) {
        Vector3f[] points2 = (Vector3f[])this.points.clone();
        ((Node)this.viewPort.getScenes().get(0)).attachChild(this.createFrustum(this.points, shadowMapIndex));
        ShadowUtil.updateFrustumPoints2(this.shadowCam, points2);
        ((Node)this.viewPort.getScenes().get(0)).attachChild(this.createFrustum(points2, shadowMapIndex));
    }

    @Override
    protected void setMaterialParameters(Material material) {
        material.setVector3("LightPos", this.light.getPosition());
        material.setVector3("LightDir", this.light.getDirection());
    }

    @Override
    protected void clearMaterialParameters(Material material) {
        material.clearParam("LightPos");
        material.clearParam("LightDir");
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.light = cloner.clone(this.light);
        this.init((int)this.shadowMapSize);
        super.cloneFields(cloner, original);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.zFarOverride = ic.readInt("zFarOverride", 0);
        this.light = (SpotLight)ic.readSavable("light", null);
        this.fadeInfo = (Vector2f)ic.readSavable("fadeInfo", null);
        this.fadeLength = ic.readFloat("fadeLength", 0.0f);
        this.init((int)this.shadowMapSize);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.zFarOverride, "zFarOverride", 0.0f);
        oc.write(this.light, "light", null);
        oc.write(this.fadeInfo, "fadeInfo", null);
        oc.write(this.fadeLength, "fadeLength", 0.0f);
    }

    @Override
    protected boolean checkCulling(Camera viewCam) {
        Camera cam = viewCam;
        if (this.frustumCam != null) {
            cam = this.frustumCam;
            cam.setLocation(viewCam.getLocation());
            cam.setRotation(viewCam.getRotation());
        }
        TempVars vars = TempVars.get();
        boolean intersects = this.light.intersectsFrustum(cam, vars);
        vars.release();
        return intersects;
    }
}

